/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.lock;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.exception.BaseUtilsBizException;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.lock.IDistributedTaskExecutor;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class CmpDistributedLockUtils {
    private static final String QUERY_SQL = "SELECT 1 FROM T_HR_SCmpDistributedLockRecord WHERE FKey=?";
    private static final String INSET_SQL = "INSERT INTO T_HR_SCmpDistributedLockRecord (FKey,FState,FCreateTime,FCreator) values(?,?,?,?)";
    private static final String DELETE_SQL = "DELETE FROM T_HR_SCmpDistributedLockRecord WHERE FKey=?";
    private static Logger logger = Logger.getLogger(CmpDistributedLockUtils.class);

    private CmpDistributedLockUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTaskInLockBlock(Context ctx, String entranceName, String resource, IDistributedTaskExecutor distributedTaskExecutor) throws EASBizException, BOSException {
        CmpDistributedLockUtils.tryLockIfSuccess(ctx, entranceName, resource);
        try {
            distributedTaskExecutor.apply();
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, entranceName, resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean runTaskInLockBlockInSilence(Context ctx, String entranceName, String resource, IDistributedTaskExecutor distributedTaskExecutor) {
        if (!CmpDistributedLockUtils.tryLock(ctx, entranceName, resource)) {
            return false;
        }
        try {
            distributedTaskExecutor.apply();
        }
        catch (BOSException | EASBizException e) {
            logger.error((Object)e.getMessage(), e);
        }
        finally {
            CmpDistributedLockUtils.unlock(ctx, entranceName, resource);
        }
        return true;
    }

    public static boolean tryLock(Context ctx, String entranceName, String resource) {
        LockInfo lockInfo = new LockInfo(entranceName, resource);
        if (CmpDistributedLockUtils.isExistsLockInDB(ctx, lockInfo)) {
            return false;
        }
        return CmpDistributedLockUtils.saveLockInfo(ctx, lockInfo);
    }

    public static void tryLockIfSuccess(Context ctx, String entranceName, String resource) throws EASBizException {
        if (!CmpDistributedLockUtils.tryLock(ctx, entranceName, resource)) {
            throw new BaseUtilsBizException(BaseUtilsBizException.REPEAT_OPERATION);
        }
    }

    public static void unlock(Context ctx, String entranceName, String resource) {
        LockInfo lockInfo = new LockInfo(entranceName, resource);
        CmpDistributedLockUtils.deleteLockInfoByUniqueKey(ctx, lockInfo);
    }

    protected static boolean isExistsLockInDB(Context ctx, LockInfo lockInfo) {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)QUERY_SQL, (Object[])new String[]{lockInfo.getKey()});
            if (rs.next()) {
                return true;
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return false;
    }

    protected static boolean saveLockInfo(Context ctx, LockInfo lockInfo) {
        Object[] param = new Object[]{lockInfo.getKey(), lockInfo.getState(), CmpDateUtil.toSqlDate(lockInfo.getDate()), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()};
        try {
            DbUtil.execute((Context)ctx, (String)INSET_SQL, (Object[])param);
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    protected static void deleteLockInfoByUniqueKey(Context ctx, LockInfo lockInfo) {
        try {
            DbUtil.execute((Context)ctx, (String)DELETE_SQL, (Object[])new String[]{lockInfo.getKey()});
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected static class LockInfo {
        private String key;
        private String state;
        private Date date;

        protected LockInfo(String entranceName, String resource) {
            this.state = null == resource ? "" : resource;
            this.key = entranceName + "&" + DigestUtils.sha256Hex((String)this.state);
            this.date = new Date();
        }

        protected String getKey() {
            return this.key;
        }

        protected String getState() {
            return this.state;
        }

        protected Date getDate() {
            return this.date;
        }
    }
}

