/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.timepiece.dep;

import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.util.timepiece.ExternalConfigUtil;
import com.kingdee.shr.compensation.util.timepiece.dep.ExtendedPropertyWrapper;
import com.kingdee.shr.compensation.util.timepiece.dep.InheritedProperty;
import com.kingdee.shr.compensation.util.timepiece.dep.InheritedPropertyDataSourceWrapper;
import com.kingdee.shr.compensation.util.timepiece.dep.InheritedPropertyEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class InheritedPropertyWrapper {
    private static final String BASE_DATA = "BASEDATA";
    private static final String OBJECT = "OBJECT";
    private static final String STRING = "STRING";

    private InheritedPropertyWrapper() {
    }

    public static InheritedProperty getSelfDateProperty(String name, String alias) {
        InheritedProperty inheritedProperty = InheritedPropertyWrapper.getSeflProperty(name, alias);
        inheritedProperty.setType("DATE");
        inheritedProperty.setLength(8);
        inheritedProperty.setScale(8);
        inheritedProperty.setDbName("CF" + name.toUpperCase(Locale.ENGLISH));
        return inheritedProperty;
    }

    public static InheritedProperty getBaseDataProperty(String name, String entity, String entityDesc, String dbName) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(true);
        inheritedProperty.setName(name);
        inheritedProperty.setDataSourceType(BASE_DATA);
        inheritedProperty.setType(OBJECT);
        inheritedProperty.setAlias(entityDesc);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setLength(44);
        inheritedProperty.setScale(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setDbName(dbName);
        inheritedProperty.setExtendedProperties(null);
        inheritedProperty.setDataSource(InheritedPropertyDataSourceWrapper.dataSource(entity, entityDesc, entityDesc));
        return inheritedProperty;
    }

    public static InheritedProperty getSeflProperty(String name, String alias) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(true);
        inheritedProperty.setName(name);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setAlias(alias);
        inheritedProperty.setDataSource(null);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setDbName(name);
        inheritedProperty.setExtendedProperties(null);
        return inheritedProperty;
    }

    public static InheritedProperty getSelfNumberProperty(String name, String alias) {
        InheritedProperty inheritedProperty = InheritedPropertyWrapper.getSeflProperty(name, alias);
        inheritedProperty.setType("DECIMAL");
        inheritedProperty.setLength(28);
        inheritedProperty.setScale(10);
        return inheritedProperty;
    }

    public static InheritedProperty getSelfStringProperty(String name, String alias) {
        InheritedProperty inheritedProperty = InheritedPropertyWrapper.getSeflProperty(name, alias);
        inheritedProperty.setType(STRING);
        inheritedProperty.setLength(50);
        inheritedProperty.setScale(0);
        return inheritedProperty;
    }

    public static List<InheritedProperty> getDefaultProperties(Context ctx) {
        ArrayList<InheritedProperty> inheritedProperties = new ArrayList<InheritedProperty>();
        inheritedProperties.add(InheritedPropertyWrapper.id());
        inheritedProperties.add(InheritedPropertyWrapper.creator(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.createTime(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.lastUpdateUser(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.lastUpdateTime(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.cu(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.name(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.number(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.description(ctx));
        inheritedProperties.add(InheritedPropertyWrapper.simpleName(ctx));
        return inheritedProperties;
    }

    public static InheritedProperty id() {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("id");
        inheritedProperty.setAlias("ID");
        inheritedProperty.setType("BOSUUID");
        inheritedProperty.setDbName("FID");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(0);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        return inheritedProperty;
    }

    public static InheritedProperty creator(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("creator");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "creator"));
        inheritedProperty.setType(OBJECT);
        inheritedProperty.setDbName("FCreatorID");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(0);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType(BASE_DATA);
        inheritedProperty.setDataSource(InheritedPropertyDataSourceWrapper.creator(ctx));
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.setExtendedProperties(ExtendedPropertyWrapper.isInCodeList(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty createTime(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("createTime");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "createTime"));
        inheritedProperty.setType("DATE");
        inheritedProperty.setDbName("FCreateTime");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(0);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.setExtendedProperties(ExtendedPropertyWrapper.isInCodeList(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty lastUpdateUser(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("lastUpdateUser");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "lastUpdateUser"));
        inheritedProperty.setType(OBJECT);
        inheritedProperty.setDbName("FLastUpdateUserID");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(0);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType(BASE_DATA);
        inheritedProperty.setDataSource(InheritedPropertyDataSourceWrapper.creator(ctx));
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.setExtendedProperties(ExtendedPropertyWrapper.isInCodeList(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty lastUpdateTime(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("lastUpdateTime");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "lastUpdateTime"));
        inheritedProperty.setType("DATE");
        inheritedProperty.setDbName("FLastUpdateTime");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(0);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.setExtendedProperties(ExtendedPropertyWrapper.isInCodeList(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty cu(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("CU");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "cu"));
        inheritedProperty.setType(OBJECT);
        inheritedProperty.setDbName("FControlUnitID");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(0);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType(BASE_DATA);
        inheritedProperty.setDataSource(InheritedPropertyDataSourceWrapper.CU(ctx));
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.setExtendedProperties(ExtendedPropertyWrapper.isInCodeList(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty name(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("name");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "name"));
        inheritedProperty.setType(STRING);
        inheritedProperty.setDbName("FName");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(255);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(true);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.enableFieldPermission(ctx));
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.isInCode(ctx));
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.seqSegmentEnabled(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty number(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("number");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "number"));
        inheritedProperty.setType(STRING);
        inheritedProperty.setDbName("FNumber");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(80);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(true);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.enableFieldPermission(ctx));
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.isInCode(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty description(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("description");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "description"));
        inheritedProperty.setType(STRING);
        inheritedProperty.setDbName("FDescription");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(255);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(true);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.isInCode(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty simpleName(Context ctx) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(false);
        inheritedProperty.setName("simpleName");
        inheritedProperty.setAlias(ExternalConfigUtil.getResoureString(ctx, "simpleName"));
        inheritedProperty.setType(STRING);
        inheritedProperty.setDbName("FSimpleName");
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(80);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(true);
        inheritedProperty.setEnumPK(null);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setDataSource(null);
        inheritedProperty.setOwnDefined(false);
        inheritedProperty.addExtendedProperty(ExtendedPropertyWrapper.isInCode(ctx));
        return inheritedProperty;
    }

    public static InheritedProperty dataSource(Context ctx) {
        String dataSourceName = ExternalConfigUtil.getResoureString(ctx, "dataSource");
        return InheritedPropertyWrapper.enumDataProperty("com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataSource", "dataSource", dataSourceName);
    }

    public static InheritedProperty calState(Context ctx) {
        String dataSourceName = ExternalConfigUtil.getResoureString(ctx, "calState");
        return InheritedPropertyWrapper.enumDataProperty("com.kingdee.shr.compensation.app.integrate.BillEntryCalState", "calState", dataSourceName);
    }

    public static InheritedProperty enumDataProperty(String enumSource, String name, String alias) {
        InheritedProperty inheritedProperty = new InheritedProperty();
        inheritedProperty.setConfigured(true);
        inheritedProperty.setName(name);
        inheritedProperty.setAlias(alias);
        inheritedProperty.setType("ENUM");
        inheritedProperty.setDbName("CF" + Character.toUpperCase(name.charAt(0)) + name.substring(1));
        inheritedProperty.setMappingField(null);
        inheritedProperty.setLength(4);
        inheritedProperty.setScale(0);
        inheritedProperty.setPrecision(0);
        inheritedProperty.setMultiLanguage(false);
        inheritedProperty.setDataSourceType("SELF");
        inheritedProperty.setExtendedProperties(null);
        InheritedPropertyEnum propertyEnum = new InheritedPropertyEnum();
        propertyEnum.setId(enumSource);
        propertyEnum.setName(alias);
        inheritedProperty.setEnumPK(propertyEnum);
        return inheritedProperty;
    }
}

