/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.AbstractHRCmpLaborItemReportFacadeControllerBean;
import com.kingdee.shr.compensation.util.HRCmpReportUtil;
import com.kingdee.shr.compensation.util.SqlUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRCmpLaborItemReportFacadeControllerBean
extends AbstractHRCmpLaborItemReportFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger((String)"com.kingdee.shr.compensation.app.HRCmpLaborItemReportFacadeControllerBean");

    @Override
    protected Map _getCmpLaborItemReport(Context ctx, String orgId, String period) throws BOSException, EASBizException {
        HashMap<String, Map<String, Object>> cmpReportData = new HashMap<String, Map<String, Object>>();
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, null, true);
        Map<String, Object> cmpLaborItemData = this.getCmpLaborItemData(ctx, orgId, period, cmpItems);
        cmpReportData.put("cmpLaborItemData", cmpLaborItemData);
        return cmpReportData;
    }

    private Map<String, Object> getCmpLaborItemData(Context ctx, String orgId, String period, String cmpItems) {
        HashMap<String, Object> cmpLaborItemData = new HashMap<String, Object>();
        int year = HRCmpReportUtil.getYearViaPeriod(period);
        int month = HRCmpReportUtil.getMonthViaPeriod(period);
        double sumTotal = 0.0;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        HashMap<String, Integer> LaborItemIndexMap = new HashMap<String, Integer>();
        Map<String, Object> laborItem = HRCmpReportUtil.getCmpLaborItems(ctx);
        try {
            String sumLaborItemSql = HRCmpReportUtil.getSumLaborItemsByPeriodYearAndMonth(ctx, cmpItems, orgId, year, month);
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sumLaborItemSql);
            int index = 0;
            while (rowSet.next()) {
                String cmpItemId = rowSet.getString("cmpItemId");
                double total = rowSet.getDouble("total");
                sumTotal += total;
                String name = (String)((Map)laborItem.get(cmpItemId)).get("name");
                String id = (String)((Map)laborItem.get(cmpItemId)).get("id");
                HashMap<String, Object> map = new HashMap<String, Object>();
                if (LaborItemIndexMap.containsKey(name)) {
                    int idx = (Integer)LaborItemIndexMap.get(name);
                    double totalValue = (Double)((Map)list.get(idx)).get("total");
                    ((Map)list.get(idx)).put("total", total += totalValue);
                    continue;
                }
                LaborItemIndexMap.put(name, index++);
                map.put("name", name);
                map.put("total", total);
                map.put("id", id);
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        HRCmpReportUtil.getPercent(list, sumTotal);
        cmpLaborItemData.put("cmpLaborItemList", list);
        return cmpLaborItemData;
    }

    @Override
    protected Map _getCmpLaborItemOrgReport(Context ctx, String orgId, String period, String classify) throws BOSException, EASBizException {
        HashMap<String, Map<String, Object>> cmpReportData = new HashMap<String, Map<String, Object>>();
        Map<String, Object> cmpLaborItemClassifyData = this.getCmpLaborItemClassifyData(ctx, orgId, period, classify);
        cmpReportData.put("cmpLaborItemClassifyData", cmpLaborItemClassifyData);
        return cmpReportData;
    }

    private Map<String, Object> getCmpLaborItemClassifyData(Context ctx, String orgId, String period, String classify) {
        HashMap<String, Object> cmpLaborItemData = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        int year = HRCmpReportUtil.getYearViaPeriod(period);
        int month = HRCmpReportUtil.getMonthViaPeriod(period);
        double sumTotal = 0.0;
        String cmpItems = HRCmpReportUtil.getCmpItemsInvolvedLaborCost(ctx, classify, true);
        HRCmpReportUtil.getPercent(list, sumTotal += this.handleSubOrgData(ctx, cmpItems, list, orgId, year, month));
        cmpLaborItemData.put("cmpLaborItemClassifyList", list);
        return cmpLaborItemData;
    }

    private double handleCurrOrgData(Context ctx, String cmpItems, List<Map<String, Object>> list, String orgId, int year, int month) {
        double sumTotal = 0.0;
        try {
            String sumCurrOrgDataSql = HRCmpReportUtil.getSumCurrOrgDataByPeriodYearAndMonth(ctx, cmpItems, orgId, year, month);
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sumCurrOrgDataSql);
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String name = rowSet.getString("name");
                boolean isLeaf = rowSet.getBoolean("isleaf");
                boolean includeSub = !isLeaf;
                double total = rowSet.getInt("total");
                String id = rowSet.getString("id");
                sumTotal += total;
                map.put("name", name + "(" + EASResource.getString((String)"com.kingdee.shr.compensation.resource.ResourceConstant.CmpCalFacadeResource", (String)"labe5", (Locale)ctx.getLocale()) + ")");
                map.put("total", total);
                map.put("includeSub", includeSub);
                map.put("id", id);
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sumTotal;
    }

    private double handleSubOrgData(Context ctx, String cmpItems, List<Map<String, Object>> list, String orgId, int year, int month) {
        double sumTotal = 0.0;
        try {
            String sumSubOrgDataSql = HRCmpReportUtil.getSumSubOrgDataByPeriodYearAndMonth(ctx, orgId, cmpItems, year, month);
            IRowSet rowSet = SqlUtil.executeQuery(ctx, sumSubOrgDataSql);
            while (rowSet.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String name = rowSet.getString("name");
                boolean isLeaf = rowSet.getBoolean("isleaf");
                boolean includeSub = !isLeaf;
                double total = rowSet.getInt("total");
                String id = rowSet.getString("id");
                sumTotal += total;
                map.put("name", name);
                map.put("total", total);
                map.put("includeSub", includeSub);
                map.put("id", id);
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return sumTotal;
    }
}

