/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.agentIntegrate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.emp.BankInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryCollection;
import com.kingdee.shr.compensation.CmpAgentPayBillEntryInfo;
import com.kingdee.shr.compensation.CmpAgentPayBillException;
import com.kingdee.shr.compensation.CmpAgentPayBillFactory;
import com.kingdee.shr.compensation.CmpAgentPayBillInfo;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.PaymentCompany;
import com.kingdee.shr.compensation.app.agentIntegrate.AbstractCmpAgentPayBillCreating;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpAgentSource;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpBillStatusITEnum;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITPayEnum;
import com.kingdee.shr.compensation.app.agentIntegrate.CmpITType;
import com.kingdee.shr.compensation.app.agentIntegrate.IdWorker;
import com.kingdee.shr.compensation.exception.PersonCmpFacadeException;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CmpAgentPayBillMultiCurXHCreating
extends AbstractCmpAgentPayBillCreating {
    private static final Logger logger = LoggerFactory.getLogger(CmpAgentPayBillMultiCurXHCreating.class);

    @Override
    public void initSplitSchemeInfo(Context ctx, Map param) throws BOSException, EASBizException {
        super.initSplitSchemeInfo(ctx, param);
        if (this.hasCmpAgentPayBillSchemeInfo() && PaymentCompany.OptionalPayOrg.equals((Object)this.getCmpAgentPayBillSchemeInfoNotNull().getPaymentCompany())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION14);
        }
    }

    @Override
    public void create(Context ctx, Map param) throws BOSException, EASBizException {
        this.initPayBillInfo(ctx, param);
        AbstractCmpAgentPayBillCreating.EntryGroups entryGroups = this.buildPayBillEntry(ctx, param);
        if (StringUtils.isNotEmpty((CharSequence)entryGroups.getErrorMsg())) {
            throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION12, new Object[]{entryGroups.getErrorMsg()});
        }
        if (entryGroups.getCmpEntrysGroup().isEmpty()) {
            throw new PersonCmpFacadeException(PersonCmpFacadeException.CREATEFAIL);
        }
        logger.info("#########entryGroups:" + entryGroups.toString());
        for (Map.Entry<String, CmpAgentPayBillEntryCollection> entry : entryGroups.getCmpEntrysGroup().entrySet()) {
            String key = entry.getKey();
            CmpAgentPayBillInfo cmpPayBillInfo = this.buildCmpPayBill(ctx, param, entryGroups.getCmpItemGroup().get(key), entryGroups.getCurrencyGroup().get(key));
            this.fillCmpBillPayOrg(cmpPayBillInfo, key);
            this.fillSplitInfo(cmpPayBillInfo, key);
            cmpPayBillInfo.setBillNumIT(null);
            this.putPayBillSumAmount(cmpPayBillInfo, entryGroups, key);
            cmpPayBillInfo.put("entry", (Object)entry.getValue());
            logger.info("#########billId:" + cmpPayBillInfo.getId());
            logger.info("#########save bill:" + cmpPayBillInfo);
            CmpAgentPayBillFactory.getLocalInstance(ctx).save((CoreBaseInfo)cmpPayBillInfo);
        }
    }

    @Override
    protected CmpAgentPayBillInfo buildCmpPayBill(Context ctx, Map param, CmpItemInfo cmpItemInfo, String currencyId) throws EASBizException, BOSException {
        CmpAgentPayBillInfo info = super.buildCmpPayBill(ctx, param, cmpItemInfo, currencyId);
        info.setStateIT(CmpBillStatusITEnum.DISPOSE);
        return info;
    }

    @Override
    protected void buildBillMark(CmpAgentPayBillInfo info) {
        info.setITType(CmpITType.XH);
        info.setAgentSource(CmpAgentSource.MultiCur);
    }

    @Override
    protected AbstractCmpAgentPayBillCreating.EntryGroups buildPayBillEntry(Context ctx, Map param) throws BOSException, EASBizException {
        AbstractCmpAgentPayBillCreating.EntryGroups entryGroups = new AbstractCmpAgentPayBillCreating.EntryGroups();
        String calTableName = (String)param.get("calTableName");
        List listData = (List)param.get("listData");
        CmpAgentPayBillEntryInfo cmpEntryInfo = null;
        for (Map data : listData) {
            List<Object> calTableList = this.getCalTableMap().get((String)data.get(calTableName + ".id"));
            BigDecimal giveAmount = new BigDecimal(data.get("gv_cmpaccres.giveamount") == null ? "0" : data.get("gv_cmpaccres.giveamount").toString());
            if (giveAmount == null || giveAmount.compareTo(BigDecimal.ZERO) <= 0) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label12", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            PersonInfo personInfo = (PersonInfo)calTableList.get(0);
            CmpItemInfo cmpItem = this.getCalSchemeItemMap().get(data.get("gv_cmpitem.id")).getCmpItem();
            if (this.getExistPers().contains(personInfo.getId().toString() + "~" + cmpItem.getId().toString())) {
                entryGroups.setErrorMsg(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label13", (Locale)ctx.getLocale()));
                return entryGroups;
            }
            cmpEntryInfo = new CmpAgentPayBillEntryInfo();
            BOSUuid cmpAgentPayBillEntryId = BOSUuid.create((BOSObjectType)cmpEntryInfo.getBOSType());
            cmpEntryInfo.setPerson(personInfo);
            cmpEntryInfo.setPersonNum(personInfo.getNumber());
            cmpEntryInfo.setPersonName(personInfo.getName());
            cmpEntryInfo.setAmount(giveAmount);
            cmpEntryInfo.setAdminOrg((AdminOrgUnitInfo)calTableList.get(1));
            cmpEntryInfo.setCmpCalOrg((AdminOrgUnitInfo)calTableList.get(2));
            cmpEntryInfo.setHrOrgUnit((HROrgUnitInfo)calTableList.get(3));
            cmpEntryInfo.setIsSuccess(false);
            cmpEntryInfo.setUseDefault((Boolean)data.get(calTableName + ".usedefault"));
            cmpEntryInfo.setId(cmpAgentPayBillEntryId);
            cmpEntryInfo.setCmpItemName(cmpItem.getName());
            cmpEntryInfo.setCmpItem(cmpItem);
            BigDecimal amount = new BigDecimal(data.get("gv_cmpaccres.amount") == null ? "0" : data.get("gv_cmpaccres.amount").toString());
            cmpEntryInfo.setCalAmount(amount);
            BankInfo bankInfo2 = new BankInfo();
            bankInfo2.setId(BOSUuid.read((String)((String)data.get("gv_bank.id"))));
            cmpEntryInfo.setHrBank(bankInfo2);
            cmpEntryInfo.setBankName((String)data.get("gv_bank.name"));
            cmpEntryInfo.setAccountNum((String)data.get("gv_perbkrec.accountnum"));
            cmpEntryInfo.setRecProvince((String)data.get("gv_perbkrec.province"));
            cmpEntryInfo.setRecCity((String)data.get("gv_perbkrec.city"));
            String accountName = (String)data.get("gv_perbkrec.accountname");
            accountName = CmpStrUtil.isEmpty(accountName) ? (String)data.get("cmp_person.name") : accountName;
            cmpEntryInfo.setAccountName(accountName);
            cmpEntryInfo.setITPayState(CmpITPayEnum.WAITPAY);
            cmpEntryInfo.setITCode(new BigDecimal(IdWorker.idWorker.nextId()));
            AbstractCmpAgentPayBillCreating.AmountCombie ac = new AbstractCmpAgentPayBillCreating.AmountCombie(giveAmount, amount);
            String splitField = this.getSplitFieldKey(data, param, entryGroups);
            entryGroups.putCmpEntrysGroup(splitField, cmpEntryInfo);
            entryGroups.putCmpItemGroup(splitField, cmpItem);
            entryGroups.putCurrencyGroup(splitField, (String)data.get("gv_currency.id"));
            entryGroups.putSumAmountValue(splitField, ac);
        }
        return entryGroups;
    }

    @Override
    protected String getCurrencySplitInfo(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        return (String)data.get("gv_currency.name");
    }

    @Override
    protected String getOptionalPayOrgSplitKey(Map<String, Object> data, AbstractCmpAgentPayBillCreating.EntryGroups entryGroups) throws EASBizException {
        throw new CmpAgentPayBillException(CmpAgentPayBillException.EXCEPTION14);
    }
}

