/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.budget.AbstractBudgetManageFacadeControllerBean;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class BudgetManageFacadeControllerBean
extends AbstractBudgetManageFacadeControllerBean {
    @Override
    protected void _deleteBudgetManageData(Context ctx, String schemeId, Set param) throws BOSException, EASBizException {
        ArrayList<String> sqlLists = new ArrayList<String>();
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String idSql = cmpInSql.createInSqlBaseOnFId(ctx, param);
        String sql = "delete from T_HR_SBudgetManage where fid in " + idSql;
        sqlLists.add(sql);
        sql = "delete from T_HR_SSubBudgetManage where FBudgetMangeID in " + idSql;
        sqlLists.add(sql);
        sql = "delete from T_HR_SCmpStandingBook where FBudgetManageID in " + idSql;
        sqlLists.add(sql);
        sql = "delete from T_HR_SubCmpStandingBook where FSubBudgetQueryID in (select fid from T_HR_SSubBudgetQuery where FBudgetManageID in " + idSql + ")";
        sqlLists.add(sql);
        sql = "delete from T_HR_SSubBudgetQuery where FBudgetManageID in " + idSql;
        sqlLists.add(sql);
        sql = "delete from T_HR_SCmpUsedAmount where FBudgetManageID in " + idSql;
        sqlLists.add(sql);
        CmpSQLUtil.executeBatchSql(ctx, sqlLists.toArray());
        cmpInSql.release(ctx);
    }

    @Override
    protected int _updateManageState(Context ctx, int operateState, boolean isIncludeSub, List idsList, String schemeId) throws BOSException, EASBizException {
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String idSql = cmpInSql.createInSqlBaseOnFId(ctx, idsList);
        String sql = "update T_HR_SBudgetManage set FState = " + operateState + " where fid in " + idSql;
        CmpSQLUtil.execute(ctx, sql);
        if (isIncludeSub) {
            try {
                int updatedCount = this.enableIncludeSub(ctx, operateState, idSql, schemeId);
                return idsList.size() + updatedCount;
            }
            catch (SQLException e) {
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        return idsList.size();
    }

    @Override
    protected String _updateSingleManageState(Context ctx, int operateState, String budgetManageId, String budgetSchemeId) throws BOSException {
        return this.disableSub(ctx, operateState, budgetManageId, budgetSchemeId);
    }

    protected String disableSub(Context ctx, int operateState, String budgetManageId, String budgetSchemeId) throws BOSException {
        Map<String, String> map = this.getLongNumberAndCostType(ctx, budgetManageId);
        String longNumber = map.get("longNumber");
        String adminSQL = "select orgAdmin.fid, orgAdmin.fLongNumber from t_org_admin orgAdmin where fLongNumber != ? and exists (select FAdminOrgUnitID from T_HR_SBudgetManage manage where manage.FAdminOrgUnitID = orgAdmin.fid and manage.FBudgetSchemeID = ?)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)adminSQL, (Object[])new Object[]{longNumber, budgetSchemeId});
        HashSet<String> subAdmin = new HashSet<String>();
        try {
            while (rs.next()) {
                String subLongNumber = rs.getString("fLongNumber");
                if (!subLongNumber.startsWith(longNumber + "!")) continue;
                subAdmin.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (subAdmin.isEmpty()) {
            String sql = "update T_HR_SBudgetManage set FState = " + operateState + " where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{budgetManageId});
            return null;
        }
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        String subAdminSql = cmpInSql.createInSqlBaseOnFId(ctx, subAdmin);
        String costType = map.get("costType");
        Object[] param = new Object[]{costType, budgetSchemeId};
        String errMsg = this.checkBudgetAdjustInProcess(ctx, subAdminSql, param);
        if (StringUtils.isEmpty((String)errMsg)) {
            String sql = "update T_HR_SBudgetManage set FState = " + operateState + " where fid = ?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{budgetManageId});
            String whereSql = " where FAdminOrgUnitID in " + subAdminSql + " and FCostTypeID = ? and FBudgetSchemeID = ?";
            sql = "update T_HR_SBudgetManage set FState = " + operateState + whereSql;
            DbUtil.execute((Context)ctx, (String)sql, (Object[])param);
        }
        return errMsg;
    }

    protected String checkBudgetAdjustInProcess(Context ctx, String subAdminSql, Object[] param) throws BOSException {
        String lan = LocaleUtils.getShortCode((Context)ctx);
        String budgetAdjSQL = "select orgUnit.FName_" + lan + " adminOrgUnit from T_HR_SBudgetAdjustEntry entry inner join T_HR_SBudgetAdjustBill bill on entry.FBillID = bill.fid inner join t_org_admin orgUnit on entry.FAdminOrgUnitID = orgUnit.fid where entry.FAdminOrgUnitID in " + subAdminSql + " and entry.FCostTypeID = ? and bill.FBudgetSchemeID = ? and bill.fBillState in (" + 1 + ", " + 2 + ")";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)budgetAdjSQL, (Object[])param);
            String adminOrgUnit = null;
            while (rs.next()) {
                adminOrgUnit = rs.getString("adminOrgUnit");
            }
            if (!StringUtils.isEmpty(adminOrgUnit)) {
                String errMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.BudgetManageResource", (String)"label58", (Locale)ctx.getLocale());
                return MessageFormat.format(errMsg, adminOrgUnit);
            }
            return null;
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
    }

    protected int enableIncludeSub(Context ctx, int operateState, String idSql, String schemeId) throws BOSException, SQLException {
        Map<String, Object> map = this.getManageAdminLongNumberAndCostType(ctx, idSql);
        CmpInSql cmpInSql = CmpInSqlFactory.getInstance();
        Set longNumberSet = (Set)map.get("longNumber");
        String numberSql = cmpInSql.createInSqlBaseOnFId(ctx, longNumberSet);
        String sql = "select orgAdmin.fid, orgAdmin.fLongNumber from t_org_admin orgAdmin where fLongNumber not in " + numberSql + " and exists (select FAdminOrgUnitID from T_HR_SBudgetManage manage where manage.FAdminOrgUnitID = orgAdmin.fid and manage.FBudgetSchemeID = ?)";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
        HashSet<String> subAdmin = new HashSet<String>();
        while (rs.next()) {
            String subLongNumber = rs.getString("fLongNumber");
            for (String longNumber : longNumberSet) {
                if (!subLongNumber.contains(longNumber + "!")) continue;
                subAdmin.add(rs.getString("fid"));
            }
        }
        if (subAdmin.isEmpty()) {
            return 0;
        }
        String subAdminSql = cmpInSql.createInSqlBaseOnFId(ctx, subAdmin);
        Set costTypeSet = (Set)map.get("costType");
        String costTypeSql = cmpInSql.createInSqlBaseOnFId(ctx, costTypeSet);
        String whereSql = " where fid not in " + idSql + " and FAdminOrgUnitID in " + subAdminSql + " and FCostTypeID in " + costTypeSql + " and FBudgetSchemeID = ?";
        sql = "select count(1) as num from T_HR_SBudgetManage " + whereSql;
        rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
        int size = 0;
        if (rs.next()) {
            size = rs.getInt("num");
        }
        sql = "update T_HR_SBudgetManage set FState = " + operateState + whereSql;
        DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{schemeId});
        return size;
    }

    protected Map<String, String> getLongNumberAndCostType(Context ctx, String budgetManageId) throws BOSException {
        String sql = "select orgAdmin.fLongNumber, manage.FCostTypeID from T_HR_SBudgetManage manage left join t_org_admin orgAdmin on orgAdmin.fid = manage.FAdminOrgUnitID where manage.fid = ?";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{budgetManageId});
            HashMap<String, String> map = new HashMap<String, String>();
            while (rs.next()) {
                map.put("longNumber", rs.getString("fLongNumber"));
                map.put("costType", rs.getString("FCostTypeID"));
            }
            return map;
        }
        catch (BOSException | SQLException e) {
            throw new BOSException(e);
        }
    }

    protected Map<String, Object> getManageAdminLongNumberAndCostType(Context ctx, String idSql) throws BOSException, SQLException {
        HashSet<String> longNumberSet = new HashSet<String>();
        HashSet<String> costTypeSet = new HashSet<String>();
        String sql = "select orgAdmin.fLongNumber, manage.FCostTypeID from T_HR_SBudgetManage manage left join t_org_admin orgAdmin on orgAdmin.fid = manage.FAdminOrgUnitID where manage.fid in " + idSql;
        IRowSet rs = CmpSQLUtil.executeQuery(ctx, sql);
        while (rs.next()) {
            longNumberSet.add(rs.getString("fLongNumber"));
            costTypeSet.add(rs.getString("FCostTypeID"));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("longNumber", longNumberSet);
        map.put("costType", costTypeSet);
        return map;
    }
}

