/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.compensation.app.budget.AbstractBudgetSchemeTableRelControllerBean;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeTableRelCollection;
import com.kingdee.shr.compensation.app.budget.BudgetSchemeTableRelInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BudgetSchemeTableRelControllerBean
extends AbstractBudgetSchemeTableRelControllerBean {
    private static final Logger LOG = Logger.getLogger(BudgetSchemeTableRelControllerBean.class);

    @Override
    protected void _transferData(Context ctx) throws BOSException {
        BudgetSchemeTableRelCollection dynamicTables = this.getBudgetSchemeTableRelCollection(ctx);
        HashSet<String> budgetManageTables = new HashSet<String>();
        HashSet<String> subBudgetManageTables = new HashSet<String>();
        HashSet<String> budgetManageQueryTables = new HashSet<String>();
        HashSet<String> stdBookTables = new HashSet<String>();
        HashSet<String> subStdBookTables = new HashSet<String>();
        for (int i = 0; i < dynamicTables.size(); ++i) {
            String subStandingBookTbName;
            String standingBookTbName;
            String subBudgetQueryTbName;
            String subBudgetManageTbName;
            BudgetSchemeTableRelInfo info = dynamicTables.get(i);
            String budgetManageTbName = info.getBudgetManageTbName();
            if (!budgetManageTables.contains(budgetManageTbName)) {
                budgetManageTables.add(budgetManageTbName);
                this.transferData(ctx, budgetManageTbName, "84812771", "T_HR_SBudgetManage");
                this.updateBudgetManageFields(ctx);
            }
            if (!subBudgetManageTables.contains(subBudgetManageTbName = info.getSubBudgetManageTbName())) {
                subBudgetManageTables.add(subBudgetManageTbName);
                this.transferData(ctx, subBudgetManageTbName, "82CD7FA3", "T_HR_SSubBudgetManage");
            }
            if (!budgetManageQueryTables.contains(subBudgetQueryTbName = info.getSubBudgetQueryTbName())) {
                budgetManageQueryTables.add(subBudgetQueryTbName);
                this.transferData(ctx, subBudgetQueryTbName, "3E47F6CA", "T_HR_SSubBudgetQuery");
            }
            if (!stdBookTables.contains(standingBookTbName = info.getStandingBookTbName())) {
                stdBookTables.add(standingBookTbName);
                this.transferData(ctx, standingBookTbName, "8B07DDF4", "T_HR_SCmpStandingBook");
            }
            if (subStdBookTables.contains(subStandingBookTbName = info.getSubStandingBookTbName())) continue;
            subStdBookTables.add(subStandingBookTbName);
            this.transferData(ctx, subStandingBookTbName, "81534082", "T_HR_SubCmpStandingBook");
        }
    }

    protected void transferData(Context ctx, String budgetManageTbName, String bosType, String tableName) throws BOSException {
        if (null == budgetManageTbName) {
            return;
        }
        try {
            String sql = "select * from " + budgetManageTbName;
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            IRowSetMetaData metaData = rowSet.getRowSetMetaData();
            boolean flag = true;
            while (rowSet.next()) {
                Object[] row = new Object[metaData.getColumnCount()];
                for (int j = 1; j <= metaData.getColumnCount(); ++j) {
                    Object val;
                    String columnName = metaData.getColumnName(j);
                    row[j - 1] = val = rowSet.getObject(columnName);
                    if (!flag) continue;
                    columns.add(columnName);
                }
                values.add(row);
                flag = false;
            }
            if (!values.isEmpty()) {
                String taxDeclareBakSQL = this.genInsertSQL(tableName, columns);
                DbUtil.executeBatch((Context)ctx, (String)taxDeclareBakSQL, values);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"transferData error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void updateBudgetManageFields(Context ctx) throws BOSException {
        String updateSql = "update t_hr_sbudgetmanage set FDataVersion= 0 where FDataVersion is null";
        DbUtil.execute((Context)ctx, (String)updateSql);
    }

    protected String genInsertSQL(String tableName, List<String> columns) {
        StringBuilder fieldStr = new StringBuilder();
        StringBuilder valueStr = new StringBuilder();
        for (String column : columns) {
            if (fieldStr.length() > 0) {
                fieldStr.append(",");
                valueStr.append(",");
            }
            fieldStr.append(column);
            valueStr.append("?");
        }
        return "insert into " + tableName + "(" + fieldStr + ") values (" + valueStr + ")";
    }
}

