/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.budget.budgetadjust;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.compensation.app.budget.CmpBudgetSchemeInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.AbstractBudgetAdjustFacadeControllerBean;
import com.kingdee.shr.compensation.app.budget.budgetadjust.BudgetAdjustBillInfo;
import com.kingdee.shr.compensation.app.budget.budgetadjust.SubBudgetAdjustEntryCollection;
import com.kingdee.shr.compensation.budget.budgetadjust.bean.BudgetPeriodMapInfo;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustCalculateHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustEntryHelper;
import com.kingdee.shr.compensation.budget.budgetadjust.impl.BudgetAdjustService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BudgetAdjustFacadeControllerBean
extends AbstractBudgetAdjustFacadeControllerBean {
    private static final Logger logger = Logger.getLogger(BudgetAdjustFacadeControllerBean.class);

    @Override
    protected boolean _deleteEntryAndSubEntryData(Context ctx, String billId, Map param) throws BOSException, EASBizException {
        boolean isAll;
        if (StringUtils.isEmpty((CharSequence)billId)) {
            return true;
        }
        String entryIds = param.get("entryIds") == null ? "" : param.get("entryIds").toString();
        boolean bl = isAll = param.get("isAll") == null ? false : (Boolean)param.get("isAll");
        if (isAll) {
            String delEntrySql = "delete from t_hr_sBudgetAdjustEntry where fbillId = ?";
            String delSubEntrySql = "delete from t_hr_sSubBudgetAdjustEntry where FBillID = ?";
            DbUtil.execute((Context)ctx, (String)delEntrySql, (Object[])new Object[]{billId});
            DbUtil.execute((Context)ctx, (String)delSubEntrySql, (Object[])new Object[]{billId});
        } else {
            String[] entryArr = entryIds.split(",");
            ArrayList<Object[]> delEntryParam = new ArrayList<Object[]>();
            for (int i = 0; i < entryArr.length; ++i) {
                if (StringUtils.isEmpty((CharSequence)entryArr[i])) continue;
                delEntryParam.add(new Object[]{entryArr[i], billId});
            }
            String delEntrySql = "delete from t_hr_sBudgetAdjustEntry where fid = ? and fbillId = ?";
            String delSubEntrySql = "delete from t_hr_sSubBudgetAdjustEntry where fyearBudgetEntryid = ? and FBillID = ?";
            if (delEntryParam.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)delEntrySql, delEntryParam);
                DbUtil.executeBatch((Context)ctx, (String)delSubEntrySql, delEntryParam);
            }
        }
        return true;
    }

    @Override
    protected boolean _validateAndCalculate(Context ctx, Map param) throws BOSException, EASBizException {
        BudgetAdjustBillInfo billInfo = (BudgetAdjustBillInfo)param.get("model");
        if (billInfo.getId() == null || billInfo.getBudgetScheme() == null || billInfo.getBudgetScheme().getId() == null) {
            return false;
        }
        String budgetSchemeId = billInfo.getBudgetScheme().getId().toString();
        String billId = billInfo.getId().toString();
        try {
            BudgetAdjustCalculateHelper helper = new BudgetAdjustCalculateHelper(ctx, budgetSchemeId, "select fid from T_HR_SBudgetAdjustEntry where FBillId = '" + billId + "'");
            helper.assembleOuterData(billId);
            helper.calculate();
            BudgetAdjustService service = new BudgetAdjustService();
            CmpBudgetSchemeInfo schemeInfo = service.getSchemeInfo(ctx, budgetSchemeId);
            BudgetPeriodMapInfo subItemMap = service.getSubItemMapByScheme(ctx, schemeInfo);
            List<String> periodColNames = subItemMap.getColNameList();
            List<String> periodFields = subItemMap.getFieldNameList();
            Map<String, Object> subBudgetAssignMap = service.getSubBudgetAssign(ctx, budgetSchemeId);
            BudgetAdjustEntryHelper entryHelper = new BudgetAdjustEntryHelper(ctx, billId, schemeInfo, null);
            SubBudgetAdjustEntryCollection subEntryCalData = helper.getAssignDefaultAfterUpdateSubEntryData(billId, schemeInfo, periodColNames, periodFields, subBudgetAssignMap);
            entryHelper.saveSubEntryData(subEntryCalData);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

