/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.shr.baseconfig.StructureConfigInfo;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.CalSchemeItemCollection;
import com.kingdee.shr.compensation.CalSchemeItemFactory;
import com.kingdee.shr.compensation.CalSchemeItemInfo;
import com.kingdee.shr.compensation.CmpCalTableFactory;
import com.kingdee.shr.compensation.CmpCalTableInfo;
import com.kingdee.shr.compensation.CmpItemCollection;
import com.kingdee.shr.compensation.CmpItemDataDot;
import com.kingdee.shr.compensation.CmpItemDataType;
import com.kingdee.shr.compensation.CmpItemFactory;
import com.kingdee.shr.compensation.CmpItemInfo;
import com.kingdee.shr.compensation.app.formula.SalaryCalExecutor;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunMgr;
import com.kingdee.shr.compensation.app.formula.SalaryCalFunction;
import com.kingdee.shr.compensation.app.formula.common.CommonMethod;
import com.kingdee.shr.compensation.app.formula.common.FunctionTools;
import com.kingdee.shr.compensation.app.formula.data.ColumnAttributes;
import com.kingdee.shr.compensation.app.formula.data.DAFactory;
import com.kingdee.shr.compensation.app.formula.data.DataAccess;
import com.kingdee.shr.compensation.app.formula.data.DataRow;
import com.kingdee.shr.compensation.app.formula.data.DataSet;
import com.kingdee.shr.compensation.app.formula.data.DataTable;
import com.kingdee.shr.compensation.app.formula.data.DataTypes;
import com.kingdee.shr.compensation.app.formula.data.SQLGenerate;
import com.kingdee.shr.compensation.app.formula.data.Tools;
import com.kingdee.shr.compensation.currency.CurrencyUtil;
import com.kingdee.shr.compensation.exception.SalaryException;
import com.kingdee.shr.compensation.helper.CalSchemeBizHelper;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.FunUtils;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.shr.ml.util.NumberTransfer;
import com.kingdee.shr.validaterule.formula.ISalaryCalculator;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.RamUsageEstimator;
import org.json.JSONArray;
import org.json.JSONObject;

public class SalaryCalculator
implements ISalaryCalculator {
    private int precision = 2;
    private String mainTableName = "T_HR_SCmpCalTable";
    private String mainTableAlias = "cmp_CTB";
    private final String uid;
    private Context ctx;
    private String schemeID;
    private String tempTable;
    private String condition;
    private String calFormulas;
    private String calFromDate;
    private String calToDate;
    private String month;
    private int status = 0;
    private double finishedPer = 0.0;
    private String calMessage = "";
    private boolean isDataSecret = false;
    private FunUtils util = null;
    private String filterSql;
    private CalSchemeInfo schemeInfo;
    private boolean stopCal = false;

    public SalaryCalculator() {
        if (this.util == null) {
            this.util = new FunUtils();
        }
        this.uid = CommonMethod.getRandomGUID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        String info = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label0", (Locale)this.ctx.getLocale());
        try {
            boolean isValidate;
            CalSchemeInfo calScheme = this.getSchemeInfo();
            if (calScheme == null) {
                calScheme = CalSchemeBizHelper.getCalSchemeInfo(this.ctx, this.schemeID);
            }
            if (!(isValidate = CalSchemeBizHelper.checkCalSchemeLegal(calScheme))) {
                throw new RuntimeException(CalSchemeBizHelper.getCalValidateMessage(this.ctx));
            }
            this.setStatus(1);
            IRowSet da = this.searchSchemeFormulas(false, calScheme.getLanType().getValue());
            if (this.isStopCal() && (da == null || da.size() == 0)) {
                return;
            }
            Map<String, String> assTable = this.combineTableItems(da);
            RamUsageEstimator.shallowSizeOf(assTable);
            SalaryCalFunction calObj = this.initCalInstance(da, calScheme.getLanType().getValue());
            calObj.setType("cal");
            DataSet dataSet = this.initCalData(da, assTable);
            Set secColSet = this.initSecureCol();
            Map<String, Object> editedItems = this.initEditedItems();
            Map<String, Object> changeIndex = this.execCalculate(calScheme, calObj, dataSet, secColSet, editedItems);
            this.saveCalResult(calScheme, changeIndex);
            this.finishedPer = 99.0;
            this.setStatus(2);
            if (!this.isStopCal()) {
                throw new SalaryException(SalaryException.CALCOMPLETED);
            }
        }
        catch (Exception e) {
            if (this.isStopCal()) {
                throw e;
            }
            if (e instanceof NullPointerException || e instanceof RuntimeException) {
                e.printStackTrace();
            }
            info = e instanceof NullPointerException ? EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label1", (Locale)this.ctx.getLocale()) : e.getMessage();
        }
        finally {
            this.calMessage = info;
            this.destroyed();
        }
    }

    private Map<String, String> combineTableItems(IRowSet da) throws Exception {
        if (this.finishedPer < 10.0) {
            this.finishedPer = 10.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label2", (Locale)this.ctx.getLocale());
        }
        HashMap<String, String> assTable = new HashMap<String, String>();
        String[] item = null;
        String[] items = null;
        String clm = null;
        String listItems = null;
        while (da.next()) {
            listItems = da.getString("FListItem");
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                if (item[1].startsWith("TEMP")) continue;
                String columns = "";
                String tableKey = "";
                if (item.length > 3) {
                    tableKey = item[1] + "~" + item[3];
                    if (assTable.containsKey(tableKey)) {
                        columns = (String)assTable.get(tableKey) + ",";
                        if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                        columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                        assTable.put(tableKey, columns);
                        continue;
                    }
                    columns = item[1] + "." + item[2];
                    assTable.put(tableKey, columns);
                    continue;
                }
                if (assTable.containsKey(item[1])) {
                    columns = (String)assTable.get(item[1]) + ",";
                    if (columns.indexOf(clm = item[1] + "." + item[2] + ",") != -1) continue;
                    columns = columns.substring(0, columns.length() - 1) + ", " + clm.substring(0, clm.length() - 1);
                    assTable.put(item[1], columns);
                    continue;
                }
                columns = item[1] + "." + item[2];
                assTable.put(item[1], columns);
            }
        }
        if (assTable.keySet().isEmpty()) {
            this.status = 4;
            throw new SalaryException(SalaryException.NOCAL);
        }
        return assTable;
    }

    public void destroyed() {
        this.util = null;
        if (this.getTempTable() != null) {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(this.getTempTable());
        }
    }

    public Map<String, Object> execCalculate(CalSchemeInfo calScheme, SalaryCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) throws Exception {
        if (this.finishedPer < 40.0) {
            this.finishedPer = 40.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label3", (Locale)this.ctx.getLocale());
        }
        HashMap<String, Object> changeSqlMap = new HashMap();
        calObj.setCalDate(this.month);
        calObj.setSchemeID(this.schemeID);
        calObj.setPrecision(this.precision);
        calObj.setCalScheme(calScheme);
        calObj.setMainTableRowFilter(this.condition);
        if (null != calScheme.getCurrency()) {
            Date ruleEffdt = CurrencyUtil.getEffdtByExchangeRule(calScheme.getExchangeRule(), calScheme.getBeginDate(), calScheme.getEndDate());
            ExchangeRateCollection coll = CurrencyUtil.getTargetExchangeRate(this.ctx, calScheme.getExchangeTable().getId().toString(), calScheme.getCurrency().getId().toString(), ruleEffdt);
            HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
            for (int i = 0; i < coll.size(); ++i) {
                ExchangeRateInfo exchangeRateInfo = coll.get(i);
                map.put(exchangeRateInfo.getSourceCurrency().getId().toString(), exchangeRateInfo.getConvertRate());
            }
            calObj.setCurrencyMap(map);
            if (null != calScheme.getCurrency()) {
                calObj.setCurrency(true);
            }
        }
        changeSqlMap = this.calSalaryBySubThread(calScheme, calObj, dataSet, secColSet, editedItems);
        return changeSqlMap;
    }

    public Map<String, Object> calSalaryBySubThread(CalSchemeInfo calScheme, SalaryCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) throws EASBizException {
        Map<String, Object> changeSqlMap = new HashMap<String, Object>();
        SalaryCalExecutor mainSc = this.doExecute(calScheme, calObj, dataSet, secColSet, editedItems);
        if (mainSc.isExecuteFinished()) {
            String name = mainSc.getName();
            if (mainSc.getChangeSqlList() != null) {
                System.out.println("---------------" + mainSc.getName() + ":" + mainSc.getChangeSqlList().size());
                changeSqlMap = mainSc.getChangeSqlList();
            }
            System.out.println("Thread name : " + name + " isExecuteFinished");
        }
        return changeSqlMap;
    }

    private SalaryCalExecutor doExecute(CalSchemeInfo calScheme, SalaryCalFunction calObj, DataSet dataSet, Set secColSet, Map<String, Object> editedItems) {
        SalaryCalExecutor sc = new SalaryCalExecutor(this.precision, this.mainTableName, this.ctx, this.calMessage, this.isDataSecret, calScheme, calObj, dataSet, secColSet, editedItems);
        Runnable getFinishPer = () -> {
            do {
                this.finishedPer = 40.0 + sc.getExt_finishedPer();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } while (!sc.isExecuteFinished());
            String name = sc.getName();
            System.out.println("Thread name : " + name + " isExecuteFinished");
        };
        new Thread(getFinishPer).start();
        sc.setName("Thread1");
        sc.run();
        return sc;
    }

    public String getCalMessage() {
        return this.calMessage;
    }

    public double getFinishedPer() {
        if (this.finishedPer >= 99.0) {
            this.finishedPer = 99.0;
        }
        return this.finishedPer;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTempTable() {
        return this.tempTable;
    }

    public String getUID() {
        return this.uid;
    }

    public DataSet initCalData(IRowSet da, Map<String, String> assTable) throws Exception {
        if (this.finishedPer < 20.0) {
            this.finishedPer = 20.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label4", (Locale)this.ctx.getLocale());
        }
        DataSet dataSet = new DataSet();
        Iterator<String> iter = assTable.keySet().iterator();
        DataAccess DAC = DAFactory.getDataAccess();
        SQLGenerate sqlgen = new SQLGenerate();
        sqlgen.fromTime = this.calFromDate;
        sqlgen.toTime = this.calToDate;
        sqlgen.isShowCodeText = false;
        Hashtable<String, String> socPayTempDatas = dataSet.getSocPayTempDatas();
        String sq = null;
        DataTable dt = null;
        int pre = assTable.size() / 5 + 1;
        int index = 0;
        String tempSql = this.buildDataSetSql(assTable);
        try {
            DataTable baseDt = DAC.getDataForDataTable(this.ctx, tempSql);
            while (iter.hasNext()) {
                String tableName = iter.next();
                if (index % pre == 0) {
                    this.finishedPer += 1.0;
                    this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label5", (Locale)this.ctx.getLocale()) + tableName;
                }
                ++index;
                dt = new DataTable();
                dt.tablename = tableName;
                dt.columns = baseDt.columns;
                dt.datas = baseDt.datas;
                dt.datasIndexMap = baseDt.datasIndexMap;
                dt.emptyrow = baseDt.emptyrow;
                dataSet.addTable(dt);
            }
        }
        catch (Exception e) {
            this.status = 4;
            throw new SalaryException(SalaryException.QUERYFAIL, e);
        }
        assTable.clear();
        da.beforeFirst();
        String listItems = null;
        String[] item = null;
        String[] items = null;
        StringBuffer sb = new StringBuffer();
        if (this.finishedPer < 25.0) {
            this.finishedPer = 25.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label6", (Locale)this.ctx.getLocale());
        }
        while (da.next()) {
            listItems = da.getString("FListTable");
            if (listItems == null || "".equals(listItems)) continue;
            items = listItems.split(";");
            for (int loop = 0; loop < items.length; ++loop) {
                item = items[loop].split("~");
                String id = "'" + item[1] + "'";
                if (sb.indexOf(id) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
        }
        if (this.finishedPer < 26.0) {
            this.finishedPer = 26.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label7", (Locale)this.ctx.getLocale());
        }
        if (sb.length() > 0) {
            sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
            sb.append(")");
            dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
            DataRow[] rows = dt.getAllRows();
            StringBuffer tableName = new StringBuffer();
            for (index = 0; index < rows.length; ++index) {
                sb.delete(0, sb.length());
                sb.append(rows[index].getString("FSqls"));
                if (sb.toString().toUpperCase(Locale.ENGLISH).indexOf("WHERE") == -1) {
                    int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                    sb.insert(insertIndex, " WHERE 1 = 1 ");
                }
                tableName.delete(0, tableName.length());
                int i = sb.toString().toUpperCase(Locale.ENGLISH).indexOf("FROM ") + 5;
                while (sb.charAt(i) != ' ' && sb.charAt(i) != '\r' && sb.charAt(i) != '\t') {
                    tableName.append(sb.charAt(i));
                    ++i;
                }
                sb.insert(sb.toString().toUpperCase(Locale.ENGLISH).indexOf("WHERE") + 6, " (" + this.condition + ") AND ");
                sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodFrom"), "@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodFrom"), "@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodTo"), "@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodTo"), "@MONTHTO"));
                sb.delete(0, sb.length());
                try {
                    String tempTableName = rows[index].getString("FDefine");
                    DataTable dt1 = DAC.getDataTable(sq, tempTableName);
                    if (dt1 == null) continue;
                    dataSet.addTable(dt1);
                    this.saveSocPayTempInfo(dt1, tempTableName, socPayTempDatas);
                    continue;
                }
                catch (Exception e) {
                    this.status = 4;
                    throw new SalaryException(SalaryException.QUERYTEMPFAIL, e);
                }
            }
        }
        if (dataSet.tableCount() == 0 || !dataSet.isExistedTable(this.mainTableName)) {
            this.status = 4;
            throw new SalaryException(SalaryException.NOCALDATA);
        }
        return dataSet;
    }

    private String buildDataSetSql(Map<String, String> assTable) throws Exception {
        String filterStr = this.condition.replace("t_hr_scmpcaltable.fid", "cmp_CTB.id").replace("t_hr_scmpcaltable.FCalState", "cmp_CTB.calState");
        FilterInfo filter = new FilterInfo(filterStr);
        SqlParam sqlParam = new SqlParam();
        CalSchemeInfo calSchemeInfo = this.getSchemeInfo();
        if (this.getSchemeInfo() == null) {
            calSchemeInfo = CalSchemeBizHelper.getCalSchemeInfo(this.ctx, this.schemeID);
        }
        Date endDate = calSchemeInfo.getEndDate();
        Map<String, String> selectMapping = this.buildSelector(assTable);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setScheme("002");
        sqlParam.setFilterDate(endDate);
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = FilterUtil.getSql((Context)this.ctx, (SqlParam)sqlParam);
        String replaceCondition = "\"CMP_CTB\".FPersonID=\"CMP_PERSON\".FhistoryRelateID AND (\"CMP_CTB\".FEndDate>=\"CMP_PERSON\".FEFFDT and \"CMP_CTB\".FEndDate<=\"CMP_PERSON\".FLEFFDT)";
        if (sql.indexOf(replaceCondition) > 0) {
            StringBuffer targetCondition = new StringBuffer();
            int periodYear = calSchemeInfo.getPeriodYear();
            int periodMonth = calSchemeInfo.getPeriodMonth();
            String endDateStr = CmpDateUtil.toKSqlDate(endDate);
            targetCondition.append(" \"CMP_CTB\".FPeriodYear = ").append(periodYear);
            targetCondition.append(" AND \"CMP_CTB\".FPeriodMonth = ").append(periodMonth);
            targetCondition.append(" AND \"CMP_CTB\".FPersonID=\"CMP_PERSON\".FhistoryRelateID ");
            targetCondition.append(" AND (").append(endDateStr).append(" >= \"CMP_PERSON\".FEFFDT ");
            targetCondition.append(" AND ").append(endDateStr).append(" <=\"CMP_PERSON\".FLEFFDT) ");
            sql = sql.replace(replaceCondition, targetCondition.toString());
        }
        return sql;
    }

    private Map<String, String> buildSelector(Map<String, String> assTable) throws BOSException {
        HashMap<String, String> selectMapping = new HashMap<String, String>();
        selectMapping.put("cmp_CTB.id", "fid");
        selectMapping.put("cmp_CTB.person", "FPERSONID");
        Set<Map.Entry<String, String>> entrySet = assTable.entrySet();
        Iterator<Map.Entry<String, String>> it = entrySet.iterator();
        String tableName = "";
        String field = "";
        String strucNum = "";
        String entityName = "";
        String tableField = "";
        String columns = "";
        String column = "";
        String[] tableArr = null;
        String[] columnArr = null;
        StructureConfigInfo structureInfo = null;
        Map<String, StructureConfigInfo> structMap = FunUtils.getCmp002StructureMap(this.ctx);
        Map<String, PropertyInfo> properties = null;
        Map.Entry<String, String> next = null;
        while (it.hasNext()) {
            next = it.next();
            tableArr = next.getKey().split("~");
            tableName = tableArr[0];
            if ("T_HR_SCmpCalTable".equals(tableName)) {
                columns = assTable.get(tableName);
                columnArr = columns.split(",");
                for (int i = 0; i < columnArr.length; ++i) {
                    column = this.mainTableAlias + "." + columnArr[i].split("\\.")[1];
                    selectMapping.put(column, column);
                }
                continue;
            }
            strucNum = tableArr[1];
            structureInfo = structMap.get(strucNum);
            if (structureInfo == null) continue;
            entityName = structureInfo.getEntityName();
            properties = FunUtils.getProperties(this.ctx, entityName);
            field = next.getValue();
            String[] singleField = field.split(",");
            for (int i = 0; i < singleField.length; ++i) {
                field = singleField[i];
                tableField = field.split("\\.")[1];
                field = properties.get(tableField).getName();
                if (selectMapping.containsKey(strucNum + "." + field)) continue;
                selectMapping.put(strucNum + "." + field, strucNum + "." + tableField);
            }
        }
        return selectMapping;
    }

    private void saveSocPayTempInfo(DataTable dt1, String tempTableName, Hashtable<String, String> socPayTempDatas) {
        if (dt1.datas != null && dt1.datas.size() > 0 && CmpStrUtil.isNotEmpty(tempTableName) && tempTableName.toUpperCase(Locale.ENGLISH).startsWith("TEMP_SSOCPAY")) {
            if (tempTableName.toUpperCase(Locale.ENGLISH).equals("TEMP_SSOCPAYS_SUM")) {
                return;
            }
            List<DataRow> datas = dt1.datas;
            int size = datas.size();
            for (int i = 0; i < size; ++i) {
                DataRow dataRow = datas.get(i);
                List<Object> rowData = dataRow.getDatarow();
                String calId = (String)rowData.get(0);
                String socRecordId = (String)rowData.get(1);
                socPayTempDatas.put(calId, socRecordId);
            }
        }
    }

    public SalaryCalFunction initCalInstance(IRowSet da, String lanType) throws EASBizException {
        if (this.finishedPer < 15.0) {
            this.finishedPer = 15.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label8", (Locale)this.ctx.getLocale());
        }
        SalaryCalFunction calObj = null;
        try {
            calObj = SalaryCalFunMgr.getInstance(da, lanType);
        }
        catch (Exception e) {
            this.status = 4;
            throw new RuntimeException(e.getMessage());
        }
        if (calObj == null) {
            this.status = 4;
            throw new SalaryException(SalaryException.FORMULAERROR);
        }
        return calObj;
    }

    public Set initSecureCol() {
        if (this.finishedPer < 30.0) {
            this.finishedPer = 30.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label9", (Locale)this.ctx.getLocale());
        }
        if (!this.isDataSecret) {
            return new HashSet();
        }
        String sql = "select id, fieldSn, dataType where state = 1";
        CmpItemCollection cmpItemColl = null;
        try {
            cmpItemColl = CmpItemFactory.getLocalInstance(this.ctx).getCmpItemCollection(sql);
        }
        catch (BOSException e) {
            this.status = 4;
            throw new RuntimeException(e.getMessage());
        }
        CmpItemInfo cmpItemInfo = null;
        CmpItemDataType dataType = null;
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < cmpItemColl.size(); ++i) {
            cmpItemInfo = cmpItemColl.get(i);
            dataType = cmpItemInfo.getDataType();
            if (CmpItemDataType.NUMBER.getValue() != dataType.getValue()) continue;
            set.add("S" + cmpItemInfo.getFieldSn());
        }
        return set;
    }

    private Map<String, Object> initEditedItems() {
        if (this.finishedPer < 35.0) {
            this.finishedPer = 35.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label10", (Locale)this.ctx.getLocale());
        }
        HashMap<String, Object> EditedItems = new HashMap<String, Object>();
        StringBuffer sql = new StringBuffer();
        sql.append("select * from t_hr_scalresultedited");
        sql.append(" where fcmpcaltableid in(");
        sql.append(this.filterSql);
        sql.append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, Object> EditedItem = new HashMap<String, Object>();
                String cmpCalTableId = null;
                IRowSetMetaData metaData = rowSet.getRowSetMetaData();
                for (int i = 1; i < metaData.getColumnCount() + 1; ++i) {
                    Object value;
                    String columnName = metaData.getColumnName(i);
                    if (columnName.equalsIgnoreCase("fcmpcaltableid")) {
                        cmpCalTableId = (String)rowSet.getObject(columnName);
                        continue;
                    }
                    if (!columnName.matches("[sS]\\d{1,}") || (value = rowSet.getObject(columnName)) == null || value.toString().trim().length() <= 0) continue;
                    EditedItem.put(columnName.toUpperCase(Locale.ENGLISH) + "_edited", value);
                }
                EditedItems.put(cmpCalTableId, EditedItem);
            }
        }
        catch (Exception e) {
            this.status = 4;
            throw new RuntimeException(e.getMessage());
        }
        return EditedItems;
    }

    public void saveCalResult(CalSchemeInfo calScheme, Map<String, Object> changeSqlMap) throws Exception {
        List budgetChangeList;
        Map submitDataStateMap;
        List submitRelyList;
        String errMsg;
        String space = "";
        if ("l1".equals(this.ctx.getLocale().getLanguage())) {
            space = " ";
        }
        String string = errMsg = changeSqlMap.get("errMsg") == null ? "" : changeSqlMap.get("errMsg").toString();
        if (!"".equals(errMsg)) {
            this.status = 4;
            throw new RuntimeException(errMsg);
        }
        ArrayList changeSqlList = (ArrayList)changeSqlMap.get("changeSqlList");
        int changeSize = changeSqlList.size();
        if (changeSqlMap.get("socPayTempDatas") != null) {
            Map socPayTempDatas = (Map)changeSqlMap.get("socPayTempDatas");
            this.saveSocPersonRecord(socPayTempDatas);
        }
        if (changeSqlMap.get("socRecordMap") != null) {
            Map socRecordMap = (Map)changeSqlMap.get("socRecordMap");
            this.saveSocPersonRecord(socRecordMap);
        }
        if ((submitRelyList = (List)changeSqlMap.get("submitRelyList")) != null) {
            this.saveSubmitRelyData(submitRelyList, calScheme);
        }
        if ((submitDataStateMap = (Map)changeSqlMap.get("submitDataStateMap")).size() > 0) {
            this.updateSubmitDataState(submitDataStateMap);
        }
        if (!this.isStopCal()) {
            Map stopCalReferMap = (Map)changeSqlMap.get("stopCalReferMap");
            this.updataStopCalReferData(calScheme, stopCalReferMap);
        }
        if ((budgetChangeList = (List)changeSqlMap.get("budgetChangeList")).size() > 0) {
            this.updateBudgetExecState(budgetChangeList);
        }
        if (changeSize == 0) {
            if (this.isStopCal()) {
                return;
            }
            this.status = 3;
            throw new SalaryException(SalaryException.NOCHANGE);
        }
        if (this.finishedPer <= 90.0) {
            this.finishedPer = 90.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label11", (Locale)this.ctx.getLocale()) + space + NumberTransfer.format((Context)this.ctx, (int)0, (String)"round", (Object)changeSize);
        }
        try {
            DataAccess DAC = DAFactory.getDataAccess();
            DAC.executeBatch(changeSqlList);
            if (this.finishedPer < 98.0) {
                this.finishedPer = 98.0;
                this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label12", (Locale)this.ctx.getLocale());
            }
        }
        catch (Exception e) {
            this.status = 3;
            System.out.println("saveCalResult Sql:" + changeSqlList);
            throw new SalaryException(SalaryException.SAVEERROR);
        }
    }

    private void updateBudgetExecState(List<String> budgetChangeList) {
        try {
            CmpInSql<String> inSql = CmpInSqlFactory.getInstance();
            String filterSql = inSql.createInSqlBaseOnFId(this.ctx, budgetChangeList);
            String updateSql = "update T_HR_CalSchemeVeriResult set FExecuteStatus = 2 where FExecuteStatus = 1 and FCmpCalTableID in " + filterSql;
            DbUtil.execute((Context)this.ctx, (String)updateSql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void updataStopCalReferData(CalSchemeInfo calScheme, Map<String, Set<String>> stopCalReferMap) {
        StringBuffer clearSql = new StringBuffer();
        clearSql.append("update t_hr_scmpstopcal set FGrantSchemeID = null,FGrantPeriodYear = null,FGrantPeriodMonth = null,FGrantCalTime = null,FGrantState = 0");
        clearSql.append(",FCalTableID = null where FGrantSchemeID = '").append(calScheme.getId()).append("'");
        clearSql.append(" and FGrantPeriodYear = ").append(calScheme.getPeriodYear());
        clearSql.append(" and FGrantPeriodMonth = ").append(calScheme.getPeriodMonth());
        clearSql.append(" and FGrantCalTime = ").append(calScheme.getCalTime());
        clearSql.append(" and FGrantState = 1");
        clearSql.append(" and fpersonid in (select FPERSONID from t_hr_scmpcaltable where fid in (").append(this.filterSql).append("))");
        clearSql.append(" and Fid not in (select stopcal.fid from t_hr_scmpstopcal stopcal ");
        clearSql.append(" inner join t_hr_scmpcaltable caltable on stopcal.FGrantSchemeID = caltable.FCALSCHEMEID and stopcal.FGrantPeriodYear = caltable.FPERIODYEAR ");
        clearSql.append(" and stopcal.FGrantPeriodMonth = caltable.FPERIODMONTH and stopcal.FGrantCalTime = caltable.FCALTIME and stopcal.fpersonid = caltable.FPERSONID ");
        clearSql.append(" where caltable.fid in (").append(this.filterSql).append(") and caltable.FisNotNeedCal = 1)");
        StringBuffer sql = new StringBuffer();
        sql.append("update t_hr_scmpstopcal set FGrantSchemeID = '").append(calScheme.getId()).append("'");
        sql.append(",FGrantPeriodYear = ").append(calScheme.getPeriodYear());
        sql.append(",FGrantPeriodMonth = ").append(calScheme.getPeriodMonth());
        sql.append(",FGrantCalTime = ").append(calScheme.getCalTime());
        sql.append(",FGrantState = 1");
        sql.append(",FCalTableID = ? where fid = ?");
        ArrayList<Object[]> listParams = new ArrayList<Object[]>();
        if (stopCalReferMap != null && stopCalReferMap.size() > 0) {
            for (Map.Entry<String, Set<String>> entry : stopCalReferMap.entrySet()) {
                String calId = entry.getKey();
                for (String s : entry.getValue()) {
                    Object[] param = new Object[]{calId, s};
                    listParams.add(param);
                }
            }
        }
        try {
            DbUtil.execute((Context)this.ctx, (String)clearSql.toString());
            DbUtil.executeBatch((Context)this.ctx, (String)sql.toString(), listParams);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private void saveSubmitRelyData(List<Object[]> submitRelyList, CalSchemeInfo calScheme) throws BOSException {
        StringBuilder str = new StringBuilder();
        str.append(" DELETE FROM T_HR_SSUBMITRELYCALTABLE RELY WHERE EXISTS (");
        str.append(" SELECT 1 FROM T_HR_SCMPCALTABLE CALTABLE WHERE CALTABLE.FID IN (").append(this.filterSql).append(") ");
        str.append(" AND CALTABLE.FCALSTATE IN (1,2,3,4,5,6,7) AND CALTABLE.FCALSCHEMEID = RELY.FCALSCHEMEID ");
        str.append(" AND CALTABLE.FPERIODYEAR = RELY.FPERIODYEAR ");
        str.append(" AND CALTABLE.FPERIODMONTH = RELY.FPERIODMONTH ");
        str.append(" AND CALTABLE.FCALTIME = RELY.FCALTIME ");
        str.append(" AND CALTABLE.FPERSONID = RELY.FPERSONID )");
        try {
            DbUtil.execute((Context)this.ctx, (String)str.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (submitRelyList != null && submitRelyList.size() > 0) {
            str = new StringBuilder();
            str.append(" INSERT INTO T_HR_SSUBMITRELYCALTABLE(");
            str.append(" FID, FSUBMITMONEY, FCALSCHEMEID, FCALTABLEID, FCALITEMID, ");
            str.append(" FPERIODYEAR, FPERIODMONTH, FCALTIME, FSUBMITTABLEID, FSUBMITDATATABLE, ");
            str.append(" FSUBMITITEMID, FSUBMITITEMTABLE,FCALMONEY,FIsBasic,FNumber,FPersonID) ");
            str.append(" values(?, ?, ?, ?, ?, ");
            str.append(" ?, ?, ?, ?, ?, ");
            str.append(" ?, ?, ?,?, ?, ?) ");
            try {
                CmpSQLUtil.executeBatchNoAutoCommit(this.ctx, str.toString(), submitRelyList);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateSubmitDataState(Map<String, Set<String>> submitDataMap) throws BOSException {
        StringBuilder str = new StringBuilder();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        for (Map.Entry<String, Set<String>> entry : submitDataMap.entrySet()) {
            str = new StringBuilder();
            paramList = new ArrayList();
            String tableName = entry.getKey();
            str.append(" UPDATE ").append(tableName);
            str.append(" SET FISCAL = ").append(20);
            str.append(" WHERE FID = ? ");
            for (String id : entry.getValue()) {
                paramList.add(new Object[]{id});
            }
            DbUtil.executeBatch((Context)this.ctx, (String)str.toString(), paramList);
        }
    }

    private void saveSocPersonRecord(Map<String, Object> socRecordMap) throws EASBizException {
        String updateSql = "update t_hr_scmpcaltable set FSocPersonRecordID=? where fid=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        Object[] params = null;
        Set<Map.Entry<String, Object>> entrySet = socRecordMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String calId = entry.getKey();
            String socRecordId = (String)entry.getValue();
            params = new Object[]{socRecordId, calId};
            paramsList.add(params);
        }
        try {
            CmpSQLUtil.executeBatchAndReturn(this.ctx, updateSql, paramsList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SalaryException(SalaryException.SAVEHEADERROR);
        }
    }

    public IRowSet searchSchemeFormulas(boolean isSimulation, String lanType) throws Exception {
        if (this.finishedPer < 5.0) {
            this.finishedPer = 5.0;
            this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"label13", (Locale)this.ctx.getLocale());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT FID, FNAME_" + lanType + ", FEXPRESS, FLISTITEM, FLISTFUNC, FLISTVAR, FLISTTABLE,FCALITEM, FSORTSN");
        sb.append(" FROM T_HR_SCALFORMULA WHERE FCALSCHEMEID='" + this.schemeID + "'");
        if (!StringUtils.isEmpty((String)this.calFormulas)) {
            sb.append(" AND FID IN (");
            sb.append(this.calFormulas);
            sb.append(")");
        }
        if (!isSimulation) {
            sb.append(" AND FIsCal=1");
        }
        sb.append(" ORDER BY FSortSn");
        IRowSet da = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
        if (!(this.isStopCal() || da != null && da.size() != 0)) {
            this.status = 3;
            throw new SalaryException(SalaryException.NODEFINCAL);
        }
        return da;
    }

    @Deprecated
    private StringBuffer assembleHisFormulaQuerySql(boolean isSimulation, String lanType) {
        CalSchemeInfo calSchemeInfo = this.getSchemeInfo();
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT cfSnap.FID, cfSnap.FNAME_" + lanType + ", cfSnap.FEXPRESS, cfSnap.FLISTITEM, cfSnap.FLISTFUNC,");
        sb.append(" cfSnap.FLISTVAR, cfSnap.FLISTTABLE,cfSnap.FCALITEM, cfSnap.FSORTSN");
        sb.append(" FROM T_HR_SCALFORMULASNAP cfSnap ");
        sb.append(" inner join T_HR_SCALSCHEMESNAP csSnap on cfSnap.FCALSCHEMSNAPID = csSnap.FID ");
        sb.append(" WHERE csSnap.FCALSCHEMEID='").append(this.schemeID).append("'");
        sb.append(" AND csSnap.FPeriodYear = ").append(calSchemeInfo.getPeriodYear());
        sb.append(" AND csSnap.FPeriodMonth = ").append(calSchemeInfo.getPeriodMonth());
        sb.append(" AND csSnap.FCalTime = ").append(calSchemeInfo.getCalTime());
        if (!isSimulation) {
            sb.append(" AND cfSnap.FIsCal=1");
        }
        sb.append(" ORDER BY cfSnap.FSortSn");
        return sb;
    }

    public void setCalFormulas(String calFormulas) {
        this.calFormulas = calFormulas;
    }

    public void setCalFromDate(String calFromDate) {
        this.calFromDate = calFromDate;
    }

    public void setCalMessage(String calMessage) {
        this.calMessage = EASResource.getString((String)"com.kingdee.shr.compensation.resource.SalaryCalculatResource", (String)"init", (Locale)this.ctx.getLocale());
    }

    public void setCalToDate(String calToDate) {
        this.calToDate = calToDate;
    }

    public void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }

    public void setMainTableRowFilter(String condition) {
        this.condition = condition;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public void setPrecision(int v) {
        this.precision = v;
    }

    public void setSchemeID(String schemeID) {
        this.schemeID = schemeID;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTempTable(String tempTable) {
        this.tempTable = tempTable;
    }

    public JSONArray testExecute(Context ctx, String execPersonId, String calSchemeId, String formulaId, JSONArray calData) throws Exception {
        CmpItemDataType dataType;
        String errMsg;
        JSONObject data;
        int i;
        this.ctx = ctx;
        Tools.getInstance().setCtx(ctx);
        this.schemeID = calSchemeId;
        this.calFormulas = "'" + formulaId + "'";
        CalSchemeInfo calScheme = CalSchemeFactory.getLocalInstance(ctx).getCalSchemeInfo("select * where id = '" + calSchemeId + "'");
        if (calScheme == null || calScheme.getBeginDate() == null || calScheme.getEndDate() == null || calScheme.getPeriodYear() == 0 || calScheme.getPeriodMonth() == 0 || calScheme.getCalTime() == 0) {
            throw new SalaryException(SalaryException.INCOMPLETEINFORMATION);
        }
        this.calFromDate = FunUtils.getDateStr(calScheme.getBeginDate());
        this.calToDate = FunUtils.getDateStr(calScheme.getEndDate());
        IRowSet da = this.searchSchemeFormulas(true, calScheme.getLanType().getValue());
        String l = calScheme.getLanType().getValue();
        SalaryCalFunction calObj = this.initCalInstance(da, calScheme.getLanType().getValue());
        int colIndex = 0;
        DataSet dataSet = new DataSet();
        HashSet<String> calItem = new HashSet<String>();
        ArrayList<ColumnAttributes> columns = new ArrayList<ColumnAttributes>();
        ArrayList<Object> row = new ArrayList<Object>();
        ColumnAttributes columnAttributes = new ColumnAttributes();
        columnAttributes.setIndex(colIndex++);
        columnAttributes.setName("FID");
        columnAttributes.setType(DataTypes.STRING);
        columns.add(columnAttributes);
        row.add(execPersonId);
        columnAttributes = new ColumnAttributes();
        columnAttributes.setIndex(colIndex++);
        columnAttributes.setName("FPERSONID");
        columnAttributes.setType(DataTypes.STRING);
        columns.add(columnAttributes);
        CmpCalTableInfo cmpCalTableInfo = CmpCalTableFactory.getLocalInstance(ctx).getCmpCalTableInfo((IObjectPK)new ObjectUuidPK(execPersonId));
        row.add(cmpCalTableInfo.getPerson().getId().toString());
        for (i = 0; i < calData.length(); ++i) {
            data = calData.getJSONObject(i);
            if (!data.has("fieldSn")) continue;
            columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(colIndex++);
            columnAttributes.setName(data.getString("fieldSn"));
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                columnAttributes.setType(DataTypes.STRING);
                row.add(data.getString("value"));
            } else {
                columnAttributes.setType(DataTypes.FLOAT);
                row.add(data.getDouble("value"));
            }
            columns.add(columnAttributes);
            if (!data.has("isCal")) continue;
            calItem.add(data.getString("fieldSn"));
        }
        for (i = 0; i < calData.length(); ++i) {
            data = calData.getJSONObject(i);
            if (!data.has("varset")) continue;
            columnAttributes = new ColumnAttributes();
            columnAttributes.setIndex(colIndex++);
            columnAttributes.setName(data.getString("varset"));
            columnAttributes.setVar(true);
            if (data.has("isNum") && "N".equals(data.get("isNum"))) {
                columnAttributes.setType(DataTypes.STRING);
                row.add(data.getString("value"));
            } else {
                columnAttributes.setType(DataTypes.FLOAT);
                row.add(data.getDouble("value"));
            }
            columns.add(columnAttributes);
            if (!data.has("isCal")) continue;
            calItem.add(data.getString("varset"));
        }
        DataRow dataRow = new DataRow();
        dataRow.setDatarow(row);
        dataRow.columns = columns;
        DataTable mainTable = new DataTable();
        mainTable.addRow(dataRow, execPersonId);
        mainTable.tablename = this.mainTableName;
        mainTable.columns = columns;
        dataSet.addTable(mainTable);
        String infoset = null;
        HashSet<String> tableSet = new HashSet<String>();
        for (int i2 = 0; i2 < calData.length(); ++i2) {
            if (!calData.getJSONObject(i2).has("infoset")) continue;
            infoset = calData.getJSONObject(i2).getString("infoset");
            tableSet.add(infoset.split("\\.")[0]);
        }
        if (!tableSet.isEmpty()) {
            for (String tableName : tableSet) {
                colIndex = 0;
                columns = new ArrayList();
                row = new ArrayList();
                columnAttributes = new ColumnAttributes();
                columnAttributes.setIndex(colIndex++);
                columnAttributes.setName("FID");
                columnAttributes.setType(DataTypes.STRING);
                columns.add(columnAttributes);
                row.add(execPersonId);
                for (int i3 = 0; i3 < calData.length(); ++i3) {
                    JSONObject data2 = calData.getJSONObject(i3);
                    String string = infoset = data2.has("infoset") ? data2.getString("infoset") : "";
                    if (StringUtils.isEmpty((String)infoset) || !tableName.equals(infoset.split("\\.")[0])) continue;
                    columnAttributes = new ColumnAttributes();
                    columnAttributes.setIndex(colIndex++);
                    columnAttributes.setName(infoset.split("\\.")[1]);
                    columnAttributes.setType(DataTypes.STRING);
                    columns.add(columnAttributes);
                    row.add(data2.getString("value"));
                }
                dataRow = new DataRow();
                dataRow.setDatarow(row);
                dataRow.columns = columns;
                DataTable infoTable = new DataTable();
                infoTable.addRow(dataRow, execPersonId);
                infoTable.tablename = tableName;
                infoTable.columns = columns;
                dataSet.addTable(infoTable);
            }
        }
        DataAccess DAC = DAFactory.getDataAccess();
        SQLGenerate sqlgen = new SQLGenerate();
        sqlgen.fromTime = this.calFromDate;
        sqlgen.toTime = this.calToDate;
        sqlgen.isShowCodeText = false;
        String sq = null;
        DataTable dt = null;
        String listtable = null;
        String[] tableitem = null;
        String[] tables = null;
        StringBuffer sb = new StringBuffer();
        da.beforeFirst();
        while (da.next()) {
            listtable = da.getString("FListTable");
            if (listtable == null || "".equals(listtable)) continue;
            tables = listtable.split(";");
            for (int loop = 0; loop < tables.length; ++loop) {
                tableitem = tables[loop].split("~");
                String id = "'" + tableitem[1] + "'";
                if (sb.indexOf(id) != -1) continue;
                if (sb.length() > 0) {
                    sb.append(",");
                }
                sb.append(id);
            }
        }
        if (sb.length() > 0) {
            sb.insert(0, "SELECT FDefine, FSqls, FPeriodFrom, FPeriodTo FROM T_HR_SFormulaTmpTable WHERE fid IN (");
            sb.append(")");
            dt = DAC.getDataTable(sb.toString(), "T_HR_SFormulaTmpTable");
            DataRow[] rows = dt.getAllRows();
            StringBuffer tableName = new StringBuffer();
            for (int index = 0; index < rows.length; ++index) {
                sb.delete(0, sb.length());
                sb.append(rows[index].getString("FSqls"));
                if (sb.toString().toUpperCase(Locale.ENGLISH).indexOf("WHERE") == -1) {
                    int insertIndex = sb.indexOf("GROUP BY") > -1 ? sb.indexOf("GROUP BY") : (sb.indexOf("ORDER BY") > -1 ? sb.indexOf("ORDER BY") : sb.length());
                    sb.insert(insertIndex, " WHERE 1 = 1 ");
                }
                tableName.delete(0, tableName.length());
                int i4 = sb.toString().toUpperCase(Locale.ENGLISH).indexOf("FROM ") + 5;
                while (sb.charAt(i4) != ' ' && sb.charAt(i4) != '\r' && sb.charAt(i4) != '\t') {
                    tableName.append(sb.charAt(i4));
                    ++i4;
                }
                String testcondition = " T_HR_SCmpCalTable.FID = '" + execPersonId + "'";
                sb.insert(sb.toString().toUpperCase(Locale.ENGLISH).indexOf("WHERE") + 6, " (" + testcondition + ") AND ");
                sq = sb.toString().replaceAll("@YEARFROM", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodFrom"), "@YEARFROM")).replaceAll("@MONTHFROM", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodFrom"), "@MONTHFROM")).replaceAll("@YEARTO", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodTo"), "@YEARTO")).replaceAll("@MONTHTO", FunctionTools.adustStringDate(this.calToDate, rows[index].getInt("FPeriodTo"), "@MONTHTO"));
                sb.delete(0, sb.length());
                try {
                    DataTable dt1 = DAC.getDataTable(sq, rows[index].getString("FDefine"));
                    if (dt1 == null) continue;
                    dataSet.addTable(dt1);
                    continue;
                }
                catch (Exception e) {
                    throw new SalaryException(SalaryException.EXCUTEFAIL, new Object[]{sq});
                }
            }
        }
        Map<Object, Object> valueMap = new HashMap();
        Map<String, Object> editedItems = this.initEditedItems();
        calObj.setType("test");
        valueMap = this.execCalculate(calScheme, calObj, dataSet, new HashSet(), editedItems);
        String string = errMsg = valueMap.get("errMsg") == null ? "" : valueMap.get("errMsg").toString();
        if (!"".equals(errMsg)) {
            this.status = 4;
            throw new RuntimeException(errMsg);
        }
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, CmpItemDataType> dataTypeMap = new HashMap<String, CmpItemDataType>();
        CmpItemCollection cmpItemCollection = new CmpItemCollection();
        String oql = "select id,name,number,cmpItem.id,cmpItem.name,cmpItem.number,cmpItem.fieldSn,cmpItem.dataDot,cmpItem.dataType,cmpItem.adminOrgUnit.id,cmpItem.adminOrgUnit.name,cmpItem.adminOrgUnit.number,cmpItem.adminOrgUnit.longNumber where calScheme.id = '" + calSchemeId + "' order by sortSn,cmpItem.number";
        CalSchemeItemCollection calSchemeItemcoll = CalSchemeItemFactory.getLocalInstance(ctx).getCalSchemeItemCollection(oql);
        for (int i5 = 0; i5 < calSchemeItemcoll.size(); ++i5) {
            CalSchemeItemInfo calSchemeItemInfo = calSchemeItemcoll.get(i5);
            CmpItemInfo cmpItem = calSchemeItemInfo.getCmpItem();
            cmpItemCollection.add(cmpItem);
        }
        String fieldName = "";
        for (int j = 0; j < cmpItemCollection.size(); ++j) {
            CmpItemInfo cmpItemInfo = cmpItemCollection.get(j);
            CmpItemDataDot dataDot = cmpItemInfo.getDataDot();
            dataType = cmpItemInfo.getDataType();
            int fieldSn = cmpItemInfo.getFieldSn();
            if (fieldSn <= 0) continue;
            fieldName = "s" + fieldSn + "";
            dataDotMap.put(fieldName, dataDot);
            dataTypeMap.put(fieldName, dataType);
        }
        JSONArray result = new JSONArray();
        Map<String, Object> paramMap = calObj.getParamMap();
        if (paramMap.size() > 0) {
            for (String key : calItem) {
                JSONObject cal = new JSONObject();
                cal.put("fieldSn", (Object)key);
                Object v = paramMap.get(("T_HR_SCMPCALTABLE_" + key).toUpperCase(Locale.ENGLISH));
                dataType = (CmpItemDataType)((Object)dataTypeMap.get(key.toLowerCase(Locale.ENGLISH)));
                if (dataType.getValue() == 0) {
                    int pre = ((CmpItemDataDot)((Object)dataDotMap.get(key.toLowerCase(Locale.ENGLISH)))).getValue();
                    v = FunctionTools.getRound(pre, FunUtils.toDouble(v));
                }
                cal.put("value", v);
                result.put((Object)cal);
            }
        }
        return result;
    }

    public String getFilterSql() {
        return this.filterSql;
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }

    public CalSchemeInfo getSchemeInfo() {
        return this.schemeInfo;
    }

    public void setSchemeInfo(CalSchemeInfo schemeInfo) {
        this.schemeInfo = schemeInfo;
    }

    public boolean isStopCal() {
        return this.stopCal;
    }

    public void setStopCal(boolean stopCal) {
        this.stopCal = stopCal;
    }
}

