/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.data;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class DBHelper {
    static Logger logger = Logger.getLogger(DBHelper.class);

    public static void closeResultSet(ResultSet rs) {
        if (rs == null) {
            return;
        }
        try {
            rs.close();
            rs = null;
        }
        catch (SQLException ex) {
            logger.error((Object)"CLOSE_RECORDSET_FAILED_MSG", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeResultSet(ResultSet rs, boolean recursive) {
        if (recursive) {
            Statement stmt = null;
            Connection conn = null;
            try {
                stmt = rs.getStatement();
                if (stmt != null) {
                    conn = stmt.getConnection();
                }
                DBHelper.closeResultSet(rs);
                rs = null;
                DBHelper.closeStatement(stmt);
                stmt = null;
                DBHelper.closeConnection(conn);
                conn = null;
            }
            catch (Exception ex) {
                logger.error((Object)"CLOSE_RECORDSET_FAILED_MSG", (Throwable)ex);
            }
            finally {
                try {
                    DBHelper.closeResultSet(rs);
                }
                catch (Exception exception) {}
                try {
                    DBHelper.closeStatement(stmt);
                }
                catch (Exception exception) {}
                try {
                    DBHelper.closeConnection(conn);
                }
                catch (Exception exception) {}
            }
        } else {
            DBHelper.closeResultSet(rs);
        }
    }

    public static void closeStatement(Statement stmt) {
        if (stmt == null) {
            return;
        }
        try {
            stmt.close();
            stmt = null;
        }
        catch (SQLException ex) {
            logger.error((Object)"CLOSE_STATEMENT_FAILED_MSG", (Throwable)ex);
        }
    }

    public static void closeConnection(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
            conn = null;
        }
        catch (SQLException ex) {
            logger.error((Object)"CLOSE_CONNECTION_FAILED_MSG", (Throwable)ex);
            throw new RuntimeException("CLOSE_CONNECTION_FAILED_MSG " + ex, ex);
        }
    }
}

