/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.v2.base.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.SqlParam;
import com.kingdee.eas.hr.base.app.filter.FilterUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.shr.validaterule.util.EntityUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SubmitSchemeBillBusinessDataCommon
extends CalculatorBusinessDataCommon {
    private static Logger logger = Logger.getLogger(SubmitSchemeBillBusinessDataCommon.class);
    private static String FuncDefine = "FunGetDataStagTableData(";

    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        this.initItemForTimePieceScheme(initCalData);
        return super.initCalData(initCalData);
    }

    protected void initItemForTimePieceScheme(InitCalData initCalData) {
        String schemeID = initCalData.getSchemeID();
        String checkSql = "select FIsHasOutData from  T_HR_STimePieceScheme where FSubmitSchemeID = ?";
        boolean isHasOutData = false;
        boolean isTimepieceScheme = false;
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)initCalData.getCtx(), (String)checkSql, (Object[])new Object[]{schemeID});
            while (rowSet.next()) {
                isHasOutData = rowSet.getBoolean("FIsHasOutData");
                isTimepieceScheme = true;
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"Check TimepieceScheme failed ", e);
        }
        if (!isTimepieceScheme) {
            return;
        }
        Map assTable = initCalData.getAssTable();
        if (!assTable.isEmpty()) {
            String mainTable = initCalData.getMainTable();
            String mainTableAlias = initCalData.getMainTableAlias();
            String assTableK = mainTable + "~" + mainTableAlias;
            String assTableV = (String)assTable.get(assTableK);
            String effectDate = assTableK + ".FEffectDate";
            assTable.put(assTableK, null == assTableV ? effectDate : assTableV + "," + effectDate);
        }
        this.initItemForDataTableFunc(initCalData);
        if (isHasOutData) {
            this.initItemForExtData(initCalData);
        }
    }

    protected void initItemForDataTableFunc(InitCalData initCalData) {
        BaseFormulaCollection calFormulaColl = initCalData.getCalFormulaColl();
        HashSet dataTableSet = Sets.newHashSet();
        for (int i = 0; i < calFormulaColl.size(); ++i) {
            BaseFormulaInfo baseFormulaInfo = calFormulaColl.get(i);
            String express = baseFormulaInfo.getExpress();
            if (!express.contains(FuncDefine)) continue;
            this.getDataTableNumberSet(express, dataTableSet);
        }
        if (dataTableSet.isEmpty()) {
            return;
        }
        Map assTable = initCalData.getAssTable();
        Map allCnSnMap = initCalData.getAllCnSnMap();
        Map fieldSnAndId = (Map)allCnSnMap.get("fieldSnAndId");
        StringBuilder queryDataTableFieldSql = new StringBuilder();
        queryDataTableFieldSql.append("SELECT distinct c.FIELDSN ");
        queryDataTableFieldSql.append("FROM T_HR_SDataStagTableHis a ");
        queryDataTableFieldSql.append("inner join T_HR_SDSTableMatchFieldHis b on b.FDATATABLEID = a.FID  ");
        queryDataTableFieldSql.append("inner join T_HR_SCalSubmitItem c on b.FieldNum = c.FID  ");
        queryDataTableFieldSql.append("inner join T_HR_SCalSubmitSchemeItem  d on d.FCalSubmitItemID = b.FieldNum  ");
        queryDataTableFieldSql.append("where  ");
        queryDataTableFieldSql.append("d.FCalSubmitSchemeID = ? ");
        queryDataTableFieldSql.append("and a.FNUMBER in (");
        Iterator iterator = dataTableSet.iterator();
        ArrayList param = Lists.newArrayList();
        param.add(initCalData.getSchemeID());
        int index = 0;
        while (iterator.hasNext()) {
            queryDataTableFieldSql.append(index++ == 0 ? "" : ",").append("?");
            param.add(iterator.next());
        }
        queryDataTableFieldSql.append(")");
        String mainTable = initCalData.getMainTable();
        Context ctx = initCalData.getCtx();
        String mainTableV = (String)assTable.get(mainTable);
        mainTableV = null == mainTableV ? "" : mainTableV;
        StringBuilder queryField = new StringBuilder(mainTableV);
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryDataTableFieldSql.toString(), (Object[])param.toArray());
            HashSet needQueryItemSet = Sets.newHashSet();
            while (rowSet.next()) {
                int fieldsn = rowSet.getInt("FIELDSN");
                String dbName = "S" + fieldsn;
                if (!fieldSnAndId.containsKey(dbName) || needQueryItemSet.contains(dbName)) continue;
                needQueryItemSet.add(dbName);
                queryField.append(",").append(mainTable).append(".").append(dbName);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"", e);
        }
        assTable.put(mainTable, queryField.toString());
    }

    protected void getDataTableNumberSet(String express, Set<String> tableSet) {
        int lastIndexOf = express.lastIndexOf(FuncDefine);
        if (lastIndexOf > 0) {
            String funExpress = express.substring(lastIndexOf + FuncDefine.length());
            String tempExpress = express.substring(0, lastIndexOf);
            String[] split = funExpress.split(",");
            String dataTableNumber = split[0].trim().replace("\"", "");
            tableSet.add(dataTableNumber);
            this.getDataTableNumberSet(tempExpress, tableSet);
        }
    }

    protected void initItemForExtData(InitCalData initCalData) {
        String schemeId = initCalData.getSchemeID();
        StringBuilder querySql = new StringBuilder();
        querySql.append(" select ");
        querySql.append(" e.FSIMPLENAME,E.FQUERYFIELDID,E.FDBNAME,E.FISITEM,H.FCLIENTNUMBER ,G.FNUMBER ,H.FENTITYNAME, ");
        querySql.append(" j.FIELDSN  ");
        querySql.append(" from T_HR_SCalSubmitScheme a ");
        querySql.append(" inner join T_HR_STimePieceScheme b on a.FID = b.FSubmitSchemeID ");
        querySql.append(" inner join T_HR_SchemeOutDataConfig c on b.fid = c.FtimepieceSchemeid ");
        querySql.append(" inner join T_HR_SchemeODConfigDimension d on c.fid = d.fschemeOutDataConfigid ");
        querySql.append(" inner join T_HR_SExtDataConfigEntry e on d.fdimensionid = e.fid ");
        querySql.append(" left join T_HR_QueryConfigField f on e.FQUERYFIELDID = f.fid ");
        querySql.append(" left join T_HR_StructureConfigColumns g on f.FFactFieldID = g.fid ");
        querySql.append(" left join T_HR_StructureConfig h on g.FSTRUCTURECONFIGID  = h.FID ");
        querySql.append(" left join T_HR_SCalSubmitItem j on j.FID = e.FQUERYFIELDID ");
        querySql.append(" where a.fid = ? ");
        querySql.append(" order by e.findex ");
        Context ctx = initCalData.getCtx();
        try {
            Map allCnSnMap = initCalData.getAllCnSnMap();
            Map fieldSnAndId = (Map)allCnSnMap.get("fieldSnAndId");
            Map assTable = initCalData.getAssTable();
            String mainTable = initCalData.getMainTable();
            String mainTableV = (String)assTable.get(mainTable);
            mainTableV = null == mainTableV ? "" : mainTableV;
            StringBuilder itemField = new StringBuilder(mainTableV);
            String localeString = LocaleUtils.getShortCode((Context)ctx).toUpperCase(Locale.ENGLISH);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql.toString(), (Object[])new Object[]{schemeId});
            while (rowSet.next()) {
                String tableValue;
                boolean isItem = rowSet.getBoolean("FISITEM");
                if (isItem) {
                    int submitItemSn = rowSet.getInt("FIELDSN");
                    String dbName = "S" + submitItemSn;
                    if (!fieldSnAndId.containsKey(dbName)) continue;
                    itemField.append(",").append(mainTable).append(".").append(dbName);
                    continue;
                }
                String clientNumber = rowSet.getString("FCLIENTNUMBER");
                String fieldName = rowSet.getString("FNUMBER");
                String entityName = rowSet.getString("FENTITYNAME");
                String entityTableName = EntityUtil.getEntityTableName((Context)ctx, (String)entityName);
                PropertyInfo propertyInfo = EntityUtil.getPropertyInfo((Context)ctx, (String)entityName, (String)fieldName);
                ColumnInfo mappingField = propertyInfo.getMappingField();
                String dbName = mappingField.getName();
                boolean multilingual = mappingField.isMultilingual();
                String tableKey = entityTableName + "~" + clientNumber;
                String fidValue = entityTableName + ".FID";
                String string = tableValue = assTable.containsKey(tableKey) ? (String)assTable.get(tableKey) : fidValue;
                if (multilingual) {
                    dbName = dbName + "_" + localeString;
                }
                if (tableValue.indexOf(fidValue) < 0) {
                    tableValue = tableValue + "," + fidValue;
                }
                String[] tableValueArr = tableValue.split(",");
                ArrayList tableValueList = Lists.newArrayList();
                for (String perField : tableValueArr) {
                    tableValueList.add(perField.trim());
                }
                String tempName = entityTableName + "." + dbName;
                if (tableValueList.indexOf(tempName) < 0) {
                    tableValue = tableValue + "," + tempName;
                }
                assTable.put(tableKey, tableValue);
            }
            assTable.put(mainTable, itemField.toString());
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"query TimepieceScheme Matching dimensions failed  ", e);
        }
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        FilterInfo filter = new FilterInfo("CMP_SMT002.id in (" + initCalData.getCondition() + ")");
        SqlParam sqlParam = new SqlParam();
        Map selectMapping = this.buildSelector(initCalData);
        sqlParam.setSelectMapping(selectMapping);
        sqlParam.setFilterInfo(filter);
        sqlParam.setSortStr("CMP_SMT002.id");
        sqlParam.setScheme(initCalData.getConfigNum());
        sqlParam.setFilterDate(initCalData.getEndDate());
        sqlParam.setHistoryMode(true);
        sqlParam.setIgnoreNowDateFilter(true);
        String sql = FilterUtil.getSql((Context)initCalData.getCtx(), (SqlParam)sqlParam);
        sql = sql.replace("T_HR_SCHEMEBILLENTRY", initCalData.getMainTable().toUpperCase(Locale.ENGLISH));
        return sql;
    }

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        String language = this.getCurrentLanguageBySchemeLocal(ctx, schemeID);
        String sql = "SELECT ITEM.FID ITEMID,ITEM.FNAME_" + language + " ITEMNAME,ITEM.FNUMBER ITEMNUMBER,  ITEM.FIELDSN,ITEM.FDATADOT,ITEM.FDATATYPE,ITEM.FDATALENGTH,F7.FTABLE  FROM  T_HR_SCalSubmitItem ITEM  LEFT JOIN T_HR_SCalSchemeItemForF7 F7 on ITEM.FFilterField = F7.FID  WHERE FSTATE = 1 ORDER BY FIELDSN";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<String> sn = new ArrayList<String>();
        ArrayList<String> cn = new ArrayList<String>();
        HashMap<String, CmpItemDataDot> dataDotMap = new HashMap<String, CmpItemDataDot>();
        HashMap<String, Integer> dataTypeMap = new HashMap<String, Integer>();
        HashMap<String, Map> f7TypeMap = new HashMap<String, Map>();
        ArrayList<String> dateTypeList = new ArrayList<String>();
        HashMap<String, String> idItemMap = new HashMap<String, String>();
        HashMap<String, Integer> strItemLenMap = new HashMap<String, Integer>();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)rs.getInt("FDATADOT"));
                Integer dataType = rs.getInt("FDATATYPE");
                String name = rs.getString("ITEMNAME");
                int fieldSn = rs.getInt("FIELDSN");
                String f7TableName = rs.getString("FTABLE");
                if (fieldSn <= 0) continue;
                String fieldName = "s" + fieldSn;
                sn.add(fieldName);
                cn.add(name);
                dataDotMap.put(fieldName, dataDot);
                dataTypeMap.put(fieldName, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldName, rs.getInt("FDATALENGTH"));
                }
                if (dataType == 3 && !StringUtils.isEmpty((String)f7TableName)) {
                    f7TypeMap.put(fieldName, this.getF7TableValue(ctx, language, f7TableName));
                }
                if (dataType == 2) {
                    dateTypeList.add(fieldName);
                }
                idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), rs.getString("ITEMID"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        sn.add("forwarncontent");
        cn.add(EASResource.getString((String)"com.kingdee.shr.validaterule.resource.BaseStrResource", (String)"warnContent", (Locale)ctx.getLocale()));
        dataTypeMap.put("forwarncontent", 1);
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        res.put("f7TypeMap", f7TypeMap);
        res.put("dateTypeList", dateTypeList);
        return res;
    }
}

