/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.formula.v2.base.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigEntry;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigInfo;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.StructureInfo;
import com.kingdee.shr.validaterule.BaseFormulaCollection;
import com.kingdee.shr.validaterule.BaseFormulaInfo;
import com.kingdee.shr.validaterule.CmpItemDataDot;
import com.kingdee.shr.validaterule.formula.base.data.DataSet;
import com.kingdee.shr.validaterule.formula.base.impl.CalculatorBusinessDataCommon;
import com.kingdee.shr.validaterule.formula.base.vo.InitCalData;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TimepieceExtDataBusinessData
extends CalculatorBusinessDataCommon {
    private static Logger logger = Logger.getLogger(TimepieceExtDataBusinessData.class);
    private static String FuncDefine = "FunGetDataStagTableData(";

    public DataSet initCalData(InitCalData initCalData) throws EASBizException {
        this.initItemForDataTableFunc(initCalData);
        return super.initCalData(initCalData);
    }

    protected String buildDataSetSql(InitCalData initCalData) throws Exception {
        StringBuilder querySql = new StringBuilder("SELECT ");
        String selectorSql = this.buildSelectorSql(initCalData);
        String fromSql = this.buildFromSql(initCalData);
        String whereSql = this.buildWhereSql(initCalData);
        querySql.append("\r\n").append(selectorSql).append("\r\n");
        querySql.append(" FROM ").append("\r\n");
        querySql.append(fromSql).append("\r\n");
        querySql.append(" WHERE ").append("\r\n");
        querySql.append(whereSql);
        String dataSetSql = querySql.toString();
        dataSetSql = this.afterBuildDataSetSql(initCalData, dataSetSql);
        return dataSetSql;
    }

    protected String buildSelectorSql(InitCalData initCalData) throws Exception {
        Map<String, String> selectors = this.buildSelector(initCalData);
        StringBuilder selectorSql = new StringBuilder();
        String mainTableAlias = initCalData.getMainTableAlias();
        selectors.forEach((alias, dbName) -> {
            String[] aliasArr = alias.split("\\.");
            String dbNameAlias = aliasArr[1];
            String[] dbNameArr = dbName.split("\\.");
            String tableAlias = dbNameArr.length > 1 ? dbNameArr[0] : mainTableAlias;
            String realDbName = dbNameArr.length > 1 ? dbNameArr[1] : dbNameArr[0];
            selectorSql.append(",").append("\"").append(tableAlias).append("\"").append(".").append(realDbName);
            selectorSql.append(" AS ").append("\"");
            if (tableAlias.equals(mainTableAlias) && "FID".equals(realDbName)) {
                selectorSql.append(realDbName);
            } else {
                selectorSql.append(mainTableAlias).append(".").append(dbNameAlias);
            }
            selectorSql.append("\"");
        });
        return selectorSql.toString().replaceFirst(",", "");
    }

    protected String buildFromSql(InitCalData initCalData) {
        String mainTable = initCalData.getMainTable();
        String mainTableAlias = initCalData.getMainTableAlias();
        ConfigInfo extDataConfig = (ConfigInfo)initCalData.getOuterData();
        Map<String, StructureInfo> structureMap = extDataConfig.getStructureMap();
        StringBuilder fromSql = new StringBuilder();
        fromSql.append(mainTable).append(" AS ").append("\"").append(mainTableAlias).append("\"").append("\r\n");
        structureMap.forEach((structureNumber, structureInfo) -> {
            String structureInfoDbName = structureInfo.getDbName();
            fromSql.append(" LEFT JOIN ").append(structureInfo.getTableName());
            fromSql.append(" AS ").append("\"").append(structureInfoDbName).append("\"");
            fromSql.append(" ON ").append("\"").append(mainTableAlias).append("\"").append(".CF").append(structureInfoDbName).append("ID");
            fromSql.append(" = ").append("\"").append(structureInfoDbName).append("\"").append(".").append("FID");
        });
        return fromSql.toString();
    }

    protected String buildWhereSql(InitCalData initCalData) {
        return initCalData.getCondition();
    }

    protected Map<String, String> buildSelector(InitCalData initCalData) throws BOSException {
        Map assTable = initCalData.getAssTable();
        String columns = (String)assTable.get(initCalData.getMainTable());
        String[] columnsArr = columns.split(",");
        ConfigInfo extDataConfig = (ConfigInfo)initCalData.getOuterData();
        HashMap selectMapping = Maps.newHashMap();
        Map allCnSnMap = initCalData.getAllCnSnMap();
        List sn = (List)allCnSnMap.get("sn");
        List cn = (List)allCnSnMap.get("cn");
        String mainTableAlias = initCalData.getMainTableAlias();
        selectMapping.put(mainTableAlias + ".ID", "FID");
        selectMapping.put(mainTableAlias + ".effectDate", "CFEFFECTDATE");
        for (String columnStr : columnsArr) {
            String columnName;
            ConfigEntry entry;
            String dbName;
            String realColumnStr = (columnStr = columnStr.trim()).substring(columnStr.indexOf(".") + 1).toLowerCase(Locale.ENGLISH);
            if (realColumnStr.equalsIgnoreCase("effectDate")) continue;
            if (realColumnStr.startsWith("cf")) {
                realColumnStr = realColumnStr.substring(2);
            }
            if ((dbName = (entry = extDataConfig.getEntry(columnName = (String)cn.get(sn.indexOf(realColumnStr)))).getDbName()).startsWith("CF")) {
                String tableAlias = dbName.substring(2, dbName.length() - 2);
                String structureColDbName = entry.getStructureColDbName();
                selectMapping.put(mainTableAlias + "." + realColumnStr, tableAlias + "." + structureColDbName);
                continue;
            }
            selectMapping.put(mainTableAlias + "." + dbName, dbName);
        }
        return selectMapping;
    }

    protected void initItemForDataTableFunc(InitCalData initCalData) {
        BaseFormulaCollection calFormulaColl = initCalData.getCalFormulaColl();
        HashSet dataTableSet = Sets.newHashSet();
        for (int i = 0; i < calFormulaColl.size(); ++i) {
            BaseFormulaInfo baseFormulaInfo = calFormulaColl.get(i);
            String express = baseFormulaInfo.getExpress();
            if (!express.contains(FuncDefine)) continue;
            this.getDataTableNumberSet(express, dataTableSet);
        }
        if (dataTableSet.isEmpty()) {
            return;
        }
        Map assTable = initCalData.getAssTable();
        Map allCnSnMap = initCalData.getAllCnSnMap();
        Map fieldSnAndId = (Map)allCnSnMap.get("fieldSnAndId");
        StringBuilder queryDataTableFieldSql = new StringBuilder();
        queryDataTableFieldSql.append("SELECT distinct d.FDBName ");
        queryDataTableFieldSql.append("FROM T_HR_SDataStagTableHis a ");
        queryDataTableFieldSql.append("inner join T_HR_SDSTableMatchFieldHis b on b.FDATATABLEID = a.FID  ");
        queryDataTableFieldSql.append("inner join T_HR_SCalSubmitItem c on b.FieldNum = c.FID  ");
        queryDataTableFieldSql.append("inner join T_HR_SExtDataConfigEntry d on c.FID = d.FQUERYFIELDID  ");
        queryDataTableFieldSql.append("inner join T_HR_SExtDataConfig e on d.FBillId = e.fid  ");
        queryDataTableFieldSql.append("where e.fid = ? and a.FNUMBER in (");
        Iterator iterator = dataTableSet.iterator();
        ArrayList params = Lists.newArrayList();
        params.add(initCalData.getSchemeID());
        int index = 0;
        while (iterator.hasNext()) {
            queryDataTableFieldSql.append(index == 0 ? "" : ",").append("?");
            params.add(iterator.next());
            ++index;
        }
        queryDataTableFieldSql.append(")");
        String mainTable = initCalData.getMainTable();
        Context ctx = initCalData.getCtx();
        String mainTableV = (String)assTable.get(mainTable);
        mainTableV = null == mainTableV ? "" : mainTableV;
        StringBuilder queryField = new StringBuilder(mainTableV);
        assTable.put(mainTable + "~" + initCalData.getMainTableAlias(), mainTable + "~" + initCalData.getMainTableAlias() + ".FEffectDate");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)queryDataTableFieldSql.toString(), (Object[])params.toArray());
            HashSet needQueryItemSet = Sets.newHashSet();
            while (rowSet.next()) {
                String dbName = rowSet.getString("FDBName");
                if (!fieldSnAndId.containsKey(dbName) || needQueryItemSet.contains(dbName)) continue;
                needQueryItemSet.add(dbName);
                queryField.append(",").append(mainTable).append(".").append(dbName);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)"", e);
        }
        assTable.put(mainTable, queryField.toString());
    }

    protected void getDataTableNumberSet(String express, Set<String> tableSet) {
        int lastIndexOf = express.lastIndexOf(FuncDefine);
        if (lastIndexOf > 0) {
            String funExpress = express.substring(lastIndexOf + FuncDefine.length());
            String tempExpress = express.substring(0, lastIndexOf);
            String[] split = funExpress.split(",");
            String dataTableNumber = split[0].trim().replace("\"", "");
            tableSet.add(dataTableNumber);
            this.getDataTableNumberSet(tempExpress, tableSet);
        }
    }

    public Map<String, Object> getAllCnSnMap(Context ctx, String schemeID) throws BOSException {
        String querySql = "SELECT entry.fid,entry.fdatatype,entry.FSimpleName,entry.fdbname,scc.FNUMBER  \nFROM T_HR_SExtDataConfig config\ninner join T_HR_SExtDataConfigEntry entry on config.fid = entry.fbillId\nleft join T_HR_QueryConfigField QCF on entry.FQUERYFIELDID = QCF.FID\nleft join T_HR_StructureConfigColumns SCC on QCF.FFACTFIELDID = SCC.FID\nwhere config.fid = ?\norder by entry.findex";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{schemeID});
        ArrayList sn = Lists.newArrayList();
        ArrayList cn = Lists.newArrayList();
        HashMap dataDotMap = Maps.newHashMap();
        HashMap dataTypeMap = Maps.newHashMap();
        HashMap idItemMap = Maps.newHashMap();
        HashMap strItemLenMap = Maps.newHashMap();
        try {
            while (rs.next()) {
                CmpItemDataDot dataDot = CmpItemDataDot.getEnum((int)2);
                Integer dataType = rs.getInt("fdatatype");
                String name = rs.getString("FSimpleName");
                String fieldName = rs.getString("fdbname");
                String fnumber = rs.getString("FNUMBER");
                if (!StringUtils.isEmpty((String)fnumber)) {
                    fieldName = fieldName + "_" + fnumber;
                    fieldName = fieldName.substring(2);
                }
                fieldName = fieldName.toLowerCase(Locale.ENGLISH);
                sn.add(fieldName);
                cn.add(name);
                dataDotMap.put(fieldName, dataDot);
                dataTypeMap.put(fieldName, dataType);
                if (dataType == 1) {
                    strItemLenMap.put(fieldName, 50);
                }
                idItemMap.put(fieldName.toUpperCase(Locale.ENGLISH), rs.getString("fid"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("sn", sn);
        res.put("cn", cn);
        res.put("dataDotMap", dataDotMap);
        res.put("dataTypeMap", dataTypeMap);
        res.put("fieldSnAndId", idItemMap);
        res.put("strLengthMap", strItemLenMap);
        return res;
    }
}

