/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.dao;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CalSubmitItemDAO {
    public static final String SCHEME_TYPE = "scheme";
    public static final String ITEM_TYPE = "item";
    private static Logger logger = Logger.getLogger(CalSubmitItemDAO.class);

    public static Set<String> getSubmitItemPresetIds(Context ctx) {
        HashSet<String> idSet = new HashSet<String>();
        String sql = " SELECT FID FROM T_HR_SCalSubmitItem where FIsSysPreset=1 ";
        IRowSet iRowSet = null;
        try {
            iRowSet = CmpSQLUtil.executeQuery(ctx, sql);
            if (iRowSet != null) {
                while (iRowSet.next()) {
                    idSet.add(iRowSet.getString("FID"));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }

    public static Set<String> getSubmitItemIdsByState(Context ctx, BaseItemStateEnum stateEnum) {
        HashSet<String> idSet = new HashSet<String>();
        String sql = " SELECT FID FROM T_HR_SCalSubmitItem where FState=" + stateEnum.getValue();
        IRowSet iRowSet = null;
        try {
            iRowSet = CmpSQLUtil.executeQuery(ctx, sql);
            if (iRowSet != null) {
                while (iRowSet.next()) {
                    idSet.add(iRowSet.getString("FID"));
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return idSet;
    }

    public static Map<String, Object> getReferenceItemInfo(String billIdWithComm, Context ctx) {
        String billInSql = CmpStrUtil.buildInSql(billIdWithComm);
        String l = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        StringBuffer checkSqlBuf = new StringBuffer();
        checkSqlBuf.append(" SELECT css.FCalSubmitItemID as ITEMID, ssi.Fname_").append(l).append(" as ITEMNAME, ss.Fname_").append(l).append(" as SBNAME ");
        checkSqlBuf.append(" FROM T_HR_SCalSubmitSchemeItem css ");
        checkSqlBuf.append(" inner join T_HR_ScalsubmitScheme ss on ss.Fid=css.FCalSubmitSchemeID ");
        checkSqlBuf.append(" inner join T_HR_SCalSubmitItem ssi on ssi.fid=css.FCalSubmitItemID ");
        checkSqlBuf.append(" where css.FCalSubmitItemID in ");
        checkSqlBuf.append(billInSql);
        checkSqlBuf.append(" order by  css.FCalSubmitItemID,css.FCalSubmitSchemeID ");
        IRowSet iRowSet = null;
        try {
            iRowSet = CmpSQLUtil.executeQuery(ctx, checkSqlBuf.toString());
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        HashMap<String, Object> itemMap = new HashMap<String, Object>();
        HashMap<String, String> itemInfoMap = null;
        if (iRowSet != null) {
            try {
                while (iRowSet.next()) {
                    String itemId = iRowSet.getString("ITEMID");
                    String itemName = iRowSet.getString("ITEMNAME");
                    String sbName = iRowSet.getString("SBNAME");
                    itemInfoMap = (HashMap<String, String>)itemMap.get(itemId);
                    if (itemInfoMap == null) {
                        itemInfoMap = new HashMap<String, String>();
                        itemInfoMap.put("ITEMNAME", itemName);
                        itemInfoMap.put("SCHEMENAME", sbName);
                        itemMap.put(itemId, itemInfoMap);
                        continue;
                    }
                    String schemeNames = (String)itemInfoMap.get("SCHEMENAME");
                    itemInfoMap.put("SCHEMENAME", schemeNames + "\u3001" + sbName);
                    itemMap.put(itemId, itemInfoMap);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                e.printStackTrace();
            }
        }
        return itemMap;
    }

    public static Set<String> getAdjReferenceSubmitScheme(Context ctx) throws SQLException, BOSException {
        return CalSubmitItemDAO.getReferenceAdjSubmitInfo(ctx, SCHEME_TYPE);
    }

    public static Set<String> getAdjReferenceSubmitItem(Context ctx) throws SQLException, BOSException {
        return CalSubmitItemDAO.getReferenceAdjSubmitInfo(ctx, ITEM_TYPE);
    }

    private static Set<String> getReferenceAdjSubmitInfo(Context ctx, String type) throws BOSException, SQLException {
        HashSet<String> schemeIdSet = new HashSet<String>();
        HashSet<String> itemIdSet = new HashSet<String>();
        String sql = "SELECT FSUBMITSCHEME,FSUBMITITEMID FROM T_HR_SSubmitItemMappingScheme";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rowSet.next()) {
            String schemeId = rowSet.getString("FSUBMITSCHEME");
            String itemId = rowSet.getString("FSUBMITITEMID");
            if (!StringUtils.isEmpty((String)schemeId)) {
                schemeIdSet.add(schemeId);
            }
            if (StringUtils.isEmpty((String)itemId)) continue;
            itemIdSet.add(itemId);
        }
        if (SCHEME_TYPE.equals(type)) {
            return schemeIdSet;
        }
        if (ITEM_TYPE.equals(type)) {
            return itemIdSet;
        }
        return itemIdSet;
    }

    public static Map<String, List<String>> getExtDataConfigReferenceSubmitItem(Context ctx) {
        HashMap itemIdMap = Maps.newHashMap();
        String l = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        String sql = "SELECT \nentry.FQueryFieldID ITEMID, config.FNAME_" + l + " CONFIGNAME FROM T_HR_SExtDataConfigEntry entry\ninner join T_HR_SExtDataConfig config on entry.FBillID = config.fid\nwhere entry.fisitem = 1";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String configName;
                String itemId = rowSet.getString("ITEMID");
                if (StringUtils.isEmpty((String)itemId)) continue;
                List configNames = null;
                configNames = itemIdMap.containsKey(itemId) ? (List)itemIdMap.get(itemId) : Lists.newArrayList();
                if (configNames.contains(configName = rowSet.getString("CONFIGNAME"))) continue;
                configNames.add(configName);
                itemIdMap.put(itemId, configNames);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return itemIdMap;
    }

    public static Map<String, List<String>> getStagTableReferenceSubmitItem(Context ctx) {
        HashMap itemIdMap = Maps.newHashMap();
        String l = LocaleUtils.getShortCode((Locale)ctx.getLocale());
        String sql = "SELECT \nentry.FIELDNUM ITEMID,t.FNAME_" + l + " CONFIGNAME FROM T_HR_SDSTableMatchField entry\ninner join T_HR_SDataStagTable t on entry.FDATATABLEID = t.FID \nwhere entry.FISITEM = 1 ";
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rowSet.next()) {
                String configName;
                String itemId = rowSet.getString("ITEMID");
                if (StringUtils.isEmpty((String)itemId)) continue;
                List configNames = null;
                configNames = itemIdMap.containsKey(itemId) ? (List)itemIdMap.get(itemId) : Lists.newArrayList();
                if (configNames.contains(configName = rowSet.getString("CONFIGNAME"))) continue;
                configNames.add(configName);
                itemIdMap.put(itemId, configNames);
            }
        }
        catch (BOSException | SQLException e) {
            logger.error((Object)e.getMessage(), e);
        }
        return itemIdMap;
    }
}

