/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.integrate.multiinspire;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.HRBillStateEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryCollection;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillEntryInfo;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillFactory;
import com.kingdee.shr.compensation.app.integrate.BatchSubmitShemeBillInfo;
import com.kingdee.shr.compensation.app.integrate.SubmitBillEntryExchangeInfoFacadeFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.AbstractBatchSubmitEntryExtControllerBean;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookFactory;
import com.kingdee.shr.compensation.app.integrate.multiinspire.StandingBookInfo;
import com.kingdee.shr.compensation.util.integrate.CmpIntegrateEntryHelper;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class BatchSubmitEntryExtControllerBean
extends AbstractBatchSubmitEntryExtControllerBean {
    private static final long serialVersionUID = -7655911660011997699L;
    private final SimpleDateFormat sdf_yyyy_MM_dd = new SimpleDateFormat("yyyy-MM-dd");
    private static final String DECLARED_AMOUNT_FIELD = "S1";
    private static Set<HRBillStateEnum> allowedState = Sets.newHashSet((Object[])new HRBillStateEnum[]{HRBillStateEnum.SUBMITED, HRBillStateEnum.AUDITED, HRBillStateEnum.SAVED});

    @Override
    protected void _convertExchangeRateAndUpdateEntryExt(Context ctx, String billId, List stateList) throws EASBizException, BOSException {
        boolean isPassed = false;
        for (HRBillStateEnum state : stateList) {
            isPassed |= allowedState.contains(state);
        }
        if (!isPassed) {
            return;
        }
        String oqlTemplate = "select costBearOrg,costType,budgetYear,submitScheme,submitScheme.exchangeTable where id = '%s'";
        BatchSubmitShemeBillInfo billInfo = BatchSubmitShemeBillFactory.getLocalInstance(ctx).getBatchSubmitShemeBillInfo(String.format(oqlTemplate, billId));
        StandingBookInfo standingBookInfo = StandingBookFactory.getLocalInstance(ctx).getStandingBookInfoByBillInfo(billInfo);
        String targetCurrencyId = standingBookInfo.getLimitManagement().getCurrency().getId().toString();
        String exchangeTableId = billInfo.getSubmitScheme().getExchangeTable().getId().toString();
        BatchSubmitShemeBillEntryCollection entryCols = this.getEntryCollectionForExchangeRate(ctx, billId);
        for (HRBillStateEnum state : stateList) {
            if (HRBillStateEnum.SUBMITED.equals((Object)state)) {
                this.resaveClearedEntryExt(ctx, entryCols);
                this.updateDeclaredAmountInfo(ctx, entryCols, targetCurrencyId, exchangeTableId);
                continue;
            }
            if (HRBillStateEnum.AUDITED.equals((Object)state)) {
                this.updateBookKeepAmountInfo(ctx, entryCols, targetCurrencyId, exchangeTableId);
                continue;
            }
            if (!HRBillStateEnum.SAVED.equals((Object)state)) continue;
            this.emptyEntryExt(ctx, entryCols);
        }
    }

    protected synchronized void resaveClearedEntryExt(Context ctx, BatchSubmitShemeBillEntryCollection entryCols) throws EASBizException, BOSException {
        if (entryCols.isEmpty()) {
            return;
        }
        String deleteSql = "DELETE FROM T_HR_SBatchSubmitEntryExt entryExt WHERE EXISTS (SELECT 1 FROM %s entry WHERE entryExt.FBatchSumitEntryId = entry.FID AND entry.FBillId = '%s')";
        String billId = entryCols.get(0).getBill().getId().toString();
        String tableName = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameByBillId(ctx, billId);
        deleteSql = String.format(deleteSql, tableName, billId);
        DbUtil.execute((Context)ctx, (String)deleteSql);
        String insertSql = "INSERT INTO T_HR_SBatchSubmitEntryExt(Fid, FBatchSumitEntryId) values(?,?)";
        ArrayList paramList = Lists.newArrayList();
        for (int i = 0; i < entryCols.size(); ++i) {
            Object[] param = new Object[]{BOSUuid.create((String)"AC059973").toString(), entryCols.get(i).getId().toString()};
            paramList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)insertSql, (List)paramList);
    }

    protected void updateDeclaredAmountInfo(Context ctx, BatchSubmitShemeBillEntryCollection entryCols, String targetCurrencyId, String exchangeTableId) throws BOSException, EASBizException {
        String sqlTemplate = "UPDATE T_HR_SBatchSubmitEntryExt SET FDecExcRate=?,FDecCnvAmount=? WHERE FBatchSumitEntryId=?";
        this.updateEntryExtAmountInfo(ctx, entryCols, sqlTemplate, targetCurrencyId, exchangeTableId);
    }

    protected void updateBookKeepAmountInfo(Context ctx, BatchSubmitShemeBillEntryCollection entryCols, String targetCurrencyId, String exchangeTableId) throws EASBizException, BOSException {
        String sqlTemplate = "UPDATE T_HR_SBatchSubmitEntryExt SET FBookkeepExcRate=?,FBookkeepCnvAmount=? WHERE FBatchSumitEntryId=?";
        this.updateEntryExtAmountInfo(ctx, entryCols, sqlTemplate, targetCurrencyId, exchangeTableId);
    }

    protected void updateEntryExtAmountInfo(Context ctx, BatchSubmitShemeBillEntryCollection entryCols, String sqlTemplate, String targetCurrencyId, String exchangeTableId) throws BOSException, EASBizException {
        ArrayList paramList = Lists.newArrayList();
        HashMap convertRateCache = Maps.newHashMap();
        for (int i = 0; i < entryCols.size(); ++i) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryCols.get(i);
            BigDecimal decAmount = entryInfo.getBigDecimal(DECLARED_AMOUNT_FIELD);
            String sourceCurrencyId = null != entryInfo.getCurrency().getId() ? entryInfo.getCurrency().getId().toString() : null;
            String cacheKey = this.sdf_yyyy_MM_dd.format(this.getExchangeDate(entryInfo)) + ":" + sourceCurrencyId + ":" + targetCurrencyId;
            ExchangeRateInfo exchangeRateInfo = (ExchangeRateInfo)convertRateCache.get(cacheKey);
            if (null == exchangeRateInfo) {
                exchangeRateInfo = SubmitBillEntryExchangeInfoFacadeFactory.getLocalInstance(ctx).getExchangeRateInfo(entryInfo, targetCurrencyId, exchangeTableId);
                convertRateCache.put(cacheKey, exchangeRateInfo);
            }
            BigDecimal exchangeRate = exchangeRateInfo.getConvertRate();
            BigDecimal exchangeAmount = decAmount.multiply(exchangeRate);
            exchangeAmount = exchangeAmount.setScale(2, 4);
            Object[] param = new Object[]{exchangeRate, exchangeAmount, entryInfo.getId().toString()};
            paramList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sqlTemplate, (List)paramList);
    }

    protected BatchSubmitShemeBillEntryCollection getEntryCollectionForExchangeRate(Context ctx, String billID) throws BOSException, EASBizException {
        BatchSubmitShemeBillEntryCollection entryCols = new BatchSubmitShemeBillEntryCollection();
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getEntryInfoForExchangeRateSql(ctx, billID));
            BatchSubmitShemeBillInfo bill = new BatchSubmitShemeBillInfo();
            bill.setId(BOSUuid.read((String)billID));
            while (rs.next()) {
                BatchSubmitShemeBillEntryInfo entry = new BatchSubmitShemeBillEntryInfo();
                entry.setId(BOSUuid.read((String)rs.getString("Fid")));
                entry.put(DECLARED_AMOUNT_FIELD, new BigDecimal(rs.getString(DECLARED_AMOUNT_FIELD)));
                entry.setEffectDate(rs.getDate("FEffectDate"));
                CurrencyInfo currencyInfo = new CurrencyInfo();
                currencyInfo.setId(BOSUuid.read((String)rs.getString("FCurrencyID")));
                entry.setCurrency(currencyInfo);
                entry.setBill(bill);
                entryCols.add(entry);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return entryCols;
    }

    protected String getEntryInfoForExchangeRateSql(Context ctx, String billID) throws EASBizException, BOSException {
        ArrayList selectorList = Lists.newArrayList();
        selectorList.add("Fid");
        selectorList.add(DECLARED_AMOUNT_FIELD);
        selectorList.add("FEffectDate");
        selectorList.add("FCurrencyID");
        this.afterAssembleSelector(selectorList);
        String dynamicEntryTableName = CmpIntegrateEntryHelper.getIntegrateDynamicEntryTableNameByBillId(ctx, billID);
        String sqlTemplate = "SELECT %s FROM %s WHERE FBillId = '%s'";
        return String.format(sqlTemplate, StringUtils.join((Object[])selectorList.toArray(), (String)","), dynamicEntryTableName, billID);
    }

    protected void afterAssembleSelector(List<String> selectorList) {
    }

    protected void emptyEntryExt(Context ctx, BatchSubmitShemeBillEntryCollection entryCols) throws BOSException {
        String sqlTemplate = "UPDATE T_HR_SBatchSubmitEntryExt SET FDecExcRate=?,FDecCnvAmount=?,FBookkeepExcRate=?,FBookkeepCnvAmount=? WHERE FBatchSumitEntryId=?";
        ArrayList paramList = Lists.newArrayList();
        for (int i = 0; i < entryCols.size(); ++i) {
            BatchSubmitShemeBillEntryInfo entryInfo = entryCols.get(i);
            Object[] param = new Object[]{null, null, null, null, entryInfo.getId().toString()};
            paramList.add(param);
        }
        DbUtil.executeBatch((Context)ctx, (String)sqlTemplate, (List)paramList);
    }

    protected Date getExchangeDate(BatchSubmitShemeBillEntryInfo billEntryInfo) {
        return new Date();
    }
}

