/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.intelligent;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.CmpIntelSaveException;
import com.kingdee.shr.compensation.app.intelligent.AbstractCmpIntelligentFacadeControllerBean;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelCatalogInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryCollection;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelEntryInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterDataFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelFilterDataInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleFactory;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelRuleInfo;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelEntry;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelFilterData;
import com.kingdee.shr.compensation.app.intelligent.ICmpIntelRule;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgCollection;
import com.kingdee.shr.compensation.app.intelligent.optimization.CmpIntelEntryAdminOrgInfo;
import com.kingdee.shr.compensation.intelligent.constant.CmpIntelConstant;
import com.kingdee.shr.compensation.intelligent.dto.MatchEntry;
import com.kingdee.shr.compensation.intelligent.dto.SmartMatchSet;
import com.kingdee.shr.compensation.intelligent.dto.json.CmpItelJsonBean;
import com.kingdee.shr.compensation.intelligent.dto.json.Scheme;
import com.kingdee.shr.compensation.intelligent.resolve.CmpIntelligentResolve;
import com.kingdee.shr.compensation.intelligent.util.CmpIntelligentUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.util.LocaleUtils;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class CmpIntelligentFacadeControllerBean
extends AbstractCmpIntelligentFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.intelligent.CmpIntelligentFacadeControllerBean");

    @Override
    protected void _saveFilterData(Context ctx, Map param) throws BOSException, EASBizException {
        String catalogNumber = MapUtils.getString((Map)param, (Object)"catalogNumber");
        String jsonStr = MapUtils.getString((Map)param, (Object)"jsonStr");
        if (CmpIntelConstant.catalogNumberClassMap.containsKey(catalogNumber)) {
            try {
                Class<?> clazz = Class.forName(CmpIntelConstant.catalogNumberClassMap.get(catalogNumber));
                Method method = clazz.getMethod("saveFilterCondition", Context.class, String.class);
                method.invoke(clazz.newInstance(), ctx, jsonStr);
            }
            catch (Exception e) {
                logger.error((Object)("saveFilterData error: " + e.getMessage()), (Throwable)e);
                e.printStackTrace();
            }
            return;
        }
        CmpIntelligentResolve cmpIntelligentResolve = CmpIntelligentResolve.getInstance();
        SmartMatchSet matchSet = cmpIntelligentResolve.getMatchSet(jsonStr);
        String ruleId = matchSet.getRuleId();
        Map<String, String> catalogMap = CmpIntelligentUtil.getCmpIntelCatalogMap(ctx);
        if (CmpStrUtil.isEmpty(catalogNumber)) {
            throw new CmpIntelSaveException(CmpIntelSaveException.CATALOG_NOTNULL);
        }
        String catalogId = catalogMap.get(catalogNumber);
        List<MatchEntry> entryList = matchSet.getEntry();
        CmpIntelligentUtil.delOldData(ctx, ruleId, catalogId);
        CmpIntelFilterDataInfo filterDataInfo = new CmpIntelFilterDataInfo();
        CmpIntelEntryInfo cmpIntelEntryInfo = new CmpIntelEntryInfo();
        BOSObjectType bosType = cmpIntelEntryInfo.getBOSType();
        String entryId = "";
        String filterData = "";
        int priority = 0;
        long now = System.currentTimeMillis();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CmpIntelRuleInfo ruleInfo = new CmpIntelRuleInfo();
        ruleInfo.setId(BOSUuid.read((String)ruleId));
        CmpIntelCatalogInfo catalogInfo = new CmpIntelCatalogInfo();
        catalogInfo.setId(BOSUuid.read((String)catalogId));
        CmpIntelEntryInfo entryInfo = null;
        CoreBaseCollection filterDataColl = new CoreBaseCollection();
        CoreBaseCollection entryColl = new CoreBaseCollection();
        Gson gson = new Gson();
        String originStr = "";
        String targetStr = "";
        int size = entryList.size();
        for (int i = 0; i < size; ++i) {
            MatchEntry matchEntrys = entryList.get(i);
            entryId = matchEntrys.getEntryId();
            Map<String, Object> origin = matchEntrys.getOrigin();
            Map<String, Object> target = matchEntrys.getTarget();
            originStr = gson.toJson(origin);
            targetStr = gson.toJson(target);
            if (originStr.equalsIgnoreCase("null")) {
                originStr = "{}";
            }
            if (targetStr.equalsIgnoreCase("null")) {
                targetStr = "{}";
            }
            filterData = "{\"entryId\":\"" + entryId + "\",\"" + "origin" + "\":" + originStr + ",\"" + "target" + "\":" + targetStr + "}";
            priority = i + 1;
            if (CmpStrUtil.isEmpty(entryId)) {
                entryId = BOSUuid.create((BOSObjectType)bosType).toString();
            }
            entryInfo = new CmpIntelEntryInfo();
            entryInfo.setId(BOSUuid.read((String)entryId));
            entryInfo.setCmpIntelRule(ruleInfo);
            entryInfo.setCmpIntelCatalog(catalogInfo);
            entryInfo.setData(CmpIntelligentUtil.uriDecode(filterData));
            entryInfo.setIndex(priority);
            entryInfo.setLastUpdateUser(userInfo);
            entryInfo.setLastUpdateTime(new Timestamp(now));
            entryInfo.setCreator(userInfo);
            entryInfo.setCreateTime(new Timestamp(now));
            CoreBaseCollection coll = this.assembleFilterDataColl(ctx, matchEntrys, filterDataInfo, entryInfo);
            filterDataColl.addCollection(coll);
            entryColl.add((CoreBaseInfo)entryInfo);
        }
        ICmpIntelFilterData cmpIntelFilterData = CmpIntelFilterDataFactory.getLocalInstance(ctx);
        cmpIntelFilterData.saveBatchData(filterDataColl);
        ICmpIntelEntry cmpIntelEntry = CmpIntelEntryFactory.getLocalInstance(ctx);
        cmpIntelEntry.saveBatchData(entryColl);
    }

    private CoreBaseCollection assembleFilterDataColl(Context ctx, MatchEntry matchEntry, CmpIntelFilterDataInfo filterDataInfo, CmpIntelEntryInfo entryInfo) {
        String filterData;
        String keyWord;
        Map<String, Object> originMap = matchEntry.getOrigin();
        Map<String, Object> tagetMap = matchEntry.getOrigin();
        CoreBaseCollection coll = new CoreBaseCollection();
        long now = System.currentTimeMillis();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        for (Map.Entry<String, Object> originEntry : originMap.entrySet()) {
            filterDataInfo = new CmpIntelFilterDataInfo();
            keyWord = originEntry.getKey();
            filterData = originEntry.getValue() + "";
            filterDataInfo.setCmpIntelEntry(entryInfo);
            filterDataInfo.setData(CmpIntelligentUtil.uriDecode(filterData));
            filterDataInfo.setKeyword(keyWord);
            filterDataInfo.setIsOrigin(true);
            filterDataInfo.setLastUpdateUser(userInfo);
            filterDataInfo.setLastUpdateTime(new Timestamp(now));
            filterDataInfo.setCreator(userInfo);
            filterDataInfo.setCreateTime(new Timestamp(now));
            coll.add((CoreBaseInfo)filterDataInfo);
        }
        for (Map.Entry<String, Object> targetEntry : tagetMap.entrySet()) {
            filterDataInfo = new CmpIntelFilterDataInfo();
            keyWord = targetEntry.getKey();
            filterData = targetEntry.getValue() + "";
            filterDataInfo.setCmpIntelEntry(entryInfo);
            filterDataInfo.setData(CmpIntelligentUtil.uriDecode(filterData));
            filterDataInfo.setKeyword(keyWord);
            filterDataInfo.setIsOrigin(false);
            filterDataInfo.setLastUpdateUser(userInfo);
            filterDataInfo.setLastUpdateTime(new Timestamp(now));
            filterDataInfo.setCreator(userInfo);
            filterDataInfo.setCreateTime(new Timestamp(now));
            coll.add((CoreBaseInfo)filterDataInfo);
        }
        return coll;
    }

    @Override
    protected String _copy(Context ctx, String ruleId) throws BOSException, EASBizException {
        CmpIntelRuleInfo newRuleInfo = new CmpIntelRuleInfo();
        BOSUuid newRuleId = BOSUuid.create((BOSObjectType)newRuleInfo.getBOSType());
        newRuleInfo.setId(newRuleId);
        newRuleInfo = this.copyIntelRule(ctx, ruleId, newRuleInfo);
        this.copyIntelEntry(ctx, ruleId, newRuleInfo);
        return newRuleId.toString();
    }

    private CmpIntelRuleInfo copyIntelRule(Context ctx, String ruleId, CmpIntelRuleInfo newRuleInfo) throws BOSException, EASBizException {
        ICmpIntelRule cmpIntelRule = CmpIntelRuleFactory.getLocalInstance(ctx);
        String oql = "where id='" + ruleId + "'";
        CmpIntelRuleInfo ruleInfo = cmpIntelRule.getCmpIntelRuleInfo(oql);
        SimpleDateFormat sdf = new SimpleDateFormat("ddHHmmss");
        String random = sdf.format(new Date());
        String newNumber = ruleInfo.getNumber() + "_copy" + random;
        newRuleInfo.setRemark(ruleInfo.getRemark());
        newRuleInfo.setHrOrgUnit(ruleInfo.getHrOrgUnit());
        long now = System.currentTimeMillis();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        newRuleInfo.setNumber(newNumber);
        newRuleInfo.setName(ruleInfo.getName(LocaleUtils.locale_L1) + "_copy" + random, LocaleUtils.locale_L1);
        newRuleInfo.setName(ruleInfo.getName(LocaleUtils.locale_L2) + "_copy" + random, LocaleUtils.locale_L2);
        newRuleInfo.setName(ruleInfo.getName(LocaleUtils.locale_L3) + "_copy" + random, LocaleUtils.locale_L3);
        newRuleInfo.setLastUpdateUser(userInfo);
        newRuleInfo.setLastUpdateTime(new Timestamp(now));
        newRuleInfo.setCreator(userInfo);
        newRuleInfo.setCreateTime(new Timestamp(now));
        newRuleInfo.setState(StateEnum.DISABLE);
        newRuleInfo.setSourceType(ruleInfo.getSourceType());
        newRuleInfo.setEffectDate(ruleInfo.getEffectDate());
        newRuleInfo.setIfUseDefault(ruleInfo.isIfUseDefault());
        cmpIntelRule.save((CoreBaseInfo)newRuleInfo);
        return newRuleInfo;
    }

    private void copyIntelEntry(Context ctx, String ruleId, CmpIntelRuleInfo newRuleInfo) throws BOSException, EASBizException {
        ICmpIntelEntry cmpIntelEntry = CmpIntelEntryFactory.getLocalInstance(ctx);
        String oql = "select cmpIntelCatalog,index,data ,orgEntry.* where cmpIntelRule.id='" + ruleId + "'";
        CmpIntelEntryCollection coll = cmpIntelEntry.getCmpIntelEntryCollection(oql);
        CoreBaseCollection newColl = new CoreBaseCollection();
        long now = System.currentTimeMillis();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        CmpIntelEntryInfo oldEntryInfo = null;
        CmpIntelEntryInfo newEntryInfo = null;
        try {
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                oldEntryInfo = coll.get(i);
                newEntryInfo = new CmpIntelEntryInfo();
                newEntryInfo.setId(BOSUuid.create((BOSObjectType)newEntryInfo.getBOSType()));
                newEntryInfo.setCmpIntelCatalog(oldEntryInfo.getCmpIntelCatalog());
                newEntryInfo.setIndex(oldEntryInfo.getIndex());
                newEntryInfo.setData(this.verifySystemDefault(ctx, ruleId, oldEntryInfo));
                newEntryInfo.setCmpIntelRule(newRuleInfo);
                newEntryInfo.setLastUpdateUser(userInfo);
                newEntryInfo.setLastUpdateTime(new Timestamp(now));
                newEntryInfo.setCreator(userInfo);
                newEntryInfo.setCreateTime(new Timestamp(now));
                CmpIntelEntryAdminOrgCollection orgColl = new CmpIntelEntryAdminOrgCollection();
                for (int j = 0; j < oldEntryInfo.getOrgEntry().size(); ++j) {
                    CmpIntelEntryAdminOrgInfo infoOrg = oldEntryInfo.getOrgEntry().get(j);
                    infoOrg.setId(null);
                    orgColl.add(infoOrg);
                }
                newEntryInfo.put("orgEntry", (Object)orgColl);
                newColl.add((CoreBaseInfo)newEntryInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cmpIntelEntry.saveBatchData(newColl);
    }

    private String verifySystemDefault(Context ctx, String ruleId, CmpIntelEntryInfo oldEntryInfo) {
        if (!"yDLYDGZ+V0Slq6DGyQXiQiHb9QU=".equals(ruleId) && !"RVXG0Vy+Xk+bQ8ldK4lAESHb9QU=".equals(ruleId)) {
            return oldEntryInfo.getData();
        }
        if (oldEntryInfo == null || oldEntryInfo.getCmpIntelCatalog() == null || oldEntryInfo.getCmpIntelCatalog().getId() == null) {
            return oldEntryInfo.getData();
        }
        String cataLogId = oldEntryInfo.getCmpIntelCatalog().getId().toString();
        if ("zAOYO3uW+E+4twZ3xNBPrgB4WXA=".equals(cataLogId) || "UF3MyIHT8EaBGOoGPuo7GwB4WXA=".equals(cataLogId)) {
            return this.verifyScheme(oldEntryInfo.getData());
        }
        return oldEntryInfo.getData();
    }

    private String verifyScheme(String data) {
        CmpItelJsonBean bean = CmpIntelligentUtil.getJsonObj(data, new CmpItelJsonBean());
        if (bean == null || CollectionUtils.isEmpty(bean.getScheme())) {
            return data;
        }
        bean.setScheme(new ArrayList<Scheme>());
        return CmpIntelligentUtil.changeObjToJson(bean);
    }

    @Override
    protected void _deleteDirtyData(Context ctx, String ruleId) throws BOSException {
        if (StringUtils.isBlank((CharSequence)ruleId)) {
            return;
        }
        String deleteEntryAdminOrgSql = " delete FROM T_HR_SCmpIntelEntryAdminOrg where FCMPINTELENTRYID  in (SELECT Fid FROM T_HR_ScmpIntelEntry where FCMPINTELRULEID = ? )";
        String deleteEntrySql = " delete FROM T_HR_ScmpIntelEntry where FCMPINTELRULEID = ? ";
        String deleteRuleSql = " delete FROM T_HR_ScmpIntelRule where FID = ? ";
        try {
            DbUtil.execute((Context)ctx, (String)deleteEntryAdminOrgSql, (Object[])new Object[]{ruleId});
            DbUtil.execute((Context)ctx, (String)deleteEntrySql, (Object[])new Object[]{ruleId});
            DbUtil.execute((Context)ctx, (String)deleteRuleSql, (Object[])new Object[]{ruleId});
        }
        catch (BOSException e) {
            logger.error((Object)"CmpIntelligentFacadeControllerBean_deleteDirtyData error: ", (Throwable)e);
            throw e;
        }
    }
}

