/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.taxCal;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.compensation.app.incomeTax.ITaxPersonReportFacade;
import com.kingdee.shr.compensation.app.incomeTax.TaxPersonReportFacadeFactory;
import com.kingdee.shr.compensation.app.tax.IsAllowedQuoted;
import com.kingdee.shr.compensation.app.tax.base.TaxItemCollection;
import com.kingdee.shr.compensation.app.tax.base.TaxItemInfo;
import com.kingdee.shr.compensation.app.taxCal.AbstractTaxCalForJSFacadeControllerBean;
import com.kingdee.shr.compensation.app.taxCal.ITaxCalTask;
import com.kingdee.shr.compensation.app.taxCal.ITaxServiceTaskFacade;
import com.kingdee.shr.compensation.app.taxCal.ITaxSpeAddDedReportFacade;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelRecordFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelRecordInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalDelTypeEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCatalogEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskCollection;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskInfo;
import com.kingdee.shr.compensation.app.taxCal.TaxCalTaskStateEnum;
import com.kingdee.shr.compensation.app.taxCal.TaxServiceTaskFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.TaxSpeAddDedReportFacadeFactory;
import com.kingdee.shr.compensation.app.taxCal.vo.TaxCalBasicVO;
import com.kingdee.shr.compensation.tax.task.ITaxTaskService;
import com.kingdee.shr.compensation.tax.task.TaskServiceFactory;
import com.kingdee.shr.compensation.tax.task.impl.TaxCalService;
import com.kingdee.shr.compensation.taxCal.util.TaxItemUtil;
import com.kingdee.shr.compensation.util.CmpDateUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.CmpTaxUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxCalForJSFacadeControllerBean
extends AbstractTaxCalForJSFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(TaxCalForJSFacadeControllerBean.class);
    private Map<String, String> taskMap;
    protected Map<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>();
    private List<String> sumTaxList;
    private List<String> allTaxItemList;
    private static final int FIXED_PARA_COUNT = 13;
    private String userId;
    private boolean isDelete = false;
    private boolean isFbSubmit;

    @Override
    protected String _submitInitData(Context ctx, String initIds, String relayTaskID, TaxCalTaskCatalogEnum taskCatalog) throws BOSException {
        if (StringUtils.isEmpty((String)initIds) || "''".equals(initIds)) {
            return null;
        }
        this.isFbSubmit = taskCatalog == TaxCalTaskCatalogEnum.FbUpload;
        this.initUserID(ctx, relayTaskID);
        this.updateAcceptId(ctx, initIds);
        this.initTaxItem(ctx);
        String taskId = this.createTask(ctx, initIds, taskCatalog);
        this.updateLastTaskDetail(ctx, initIds);
        String insertSql = this.getInsertTaskDetailSql();
        List<Object[]> paramsList = this.getParamListData(ctx, initIds);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        if (!this.isFbSubmit) {
            this.updateTaxCalInitData(ctx, initIds);
        }
        return taskId;
    }

    @Override
    protected String _beforeDeleteLast(Context ctx, String initIds, String taxUnitId) throws BOSException {
        this.isDelete = false;
        this.taskMap = new HashMap<String, String>();
        String taskId = BOSUuid.create((BOSObjectType)new TaxCalTaskInfo().getBOSType()).toString();
        this.taskMap.put(taxUnitId, taskId);
        this.initTaxItem(ctx);
        this.updateLastTaskDetail(ctx, initIds);
        String insertSql = this.getInsertTaskDetailSql();
        List<Object[]> paramsList = this.getParamListData(ctx, initIds);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        return taskId;
    }

    private void initUserID(Context ctx, String relayTaskId) {
        this.userId = HRFilterUtils.getCurrentUserId((Context)ctx);
        if (("00000000-0000-0000-0000-00000000000013B7DE7F".equals(this.userId) || "256c221a-0106-1000-e000-10d7c0a813f413B7DE7F".equals(this.userId)) && !StringUtils.isEmpty((String)relayTaskId)) {
            String getCreatorSQL = " select top 1 FCreatorID from T_HR_STAXCALTASK where fid = '" + relayTaskId + "'";
            try {
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)getCreatorSQL);
                if (rowSet.next()) {
                    this.userId = rowSet.getString("FCreatorID");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void updateLastTaskDetail(Context ctx, String initIds) throws BOSException {
        String str = " UPDATE T_HR_STAXCALTASKDETAIL A01 SET FDATASTATE = 30 WHERE EXISTS (SELECT 1 FROM T_HR_STAXCALINITDETAIL A02  WHERE FID IN (" + initIds + ") AND A01.FCMPCALTABLEID = A02.FCMPCALTABLEID AND A01.fIncomeItemId = A02.fIncomeItemId)    AND A01.FDATASTATE = " + 10;
        DbUtil.execute((Context)ctx, (String)str);
    }

    @Override
    protected void _deleteCalData(Context ctx, String initIds, TaxCalDelTypeEnum oprType) throws BOSException {
        if (StringUtils.isEmpty((String)initIds) || "''".equals(initIds)) {
            return;
        }
        this.isDelete = true;
        this.initUserID(ctx, null);
        this.updateAcceptId(ctx, initIds);
        this.createDelTask(ctx, initIds, oprType);
        this.initTaxItem(ctx);
        String insertSql = this.getInsertTaskDetailSql();
        List<Object[]> paramsList = this.getParamListData(ctx, initIds);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        this.updateTaxCalInitData(ctx, initIds);
    }

    @Override
    protected void _executeNextTask(Context ctx, String relayTaskID) {
        if (StringUtils.isEmpty((String)relayTaskID)) {
            return;
        }
        try {
            ITaxCalTask taxCalTask = TaxCalTaskFactory.getLocalInstance(ctx);
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("accept_id");
            selectors.add("state");
            selectors.add("catalog");
            selectors.add("requestParam.id");
            selectors.add("requestParam.paramContent");
            selectors.add("taxUnit.id");
            selectors.add("taxUnit.isAutoDeduct");
            TaxCalTaskInfo relayTask = taxCalTask.getTaxCalTaskInfo((IObjectPK)new ObjectUuidPK(relayTaskID), selectors);
            TaxCalTaskStateEnum relayTaskState = relayTask.getState();
            String oql = "select id,number,period,state,taxUnit.id,taxUnit.name,relayTask,catalog,creator.id where relayTask = '" + relayTaskID + "'";
            TaxCalTaskCollection taxCalTaskCollection = taxCalTask.getTaxCalTaskCollection(oql);
            if (null == taxCalTaskCollection || taxCalTaskCollection.isEmpty()) {
                return;
            }
            for (int i = 0; i < taxCalTaskCollection.size(); ++i) {
                TaxCalTaskInfo taxCalTaskInfo = taxCalTaskCollection.get(i);
                String taskID = taxCalTaskInfo.getId().toString();
                TaxCalTaskCatalogEnum catalog = taxCalTaskInfo.getCatalog();
                if (TaxCalTaskStateEnum.RUNNING == relayTaskState) {
                    return;
                }
                if (TaxCalTaskCatalogEnum.TaxCal == catalog || TaxCalTaskCatalogEnum.TaxCalDelete == catalog) {
                    if (TaxCalTaskStateEnum.FAIDED == relayTaskState) {
                        TaxCalService taxCalService = new TaxCalService();
                        taxCalService.onFailure(ctx, taxCalTaskInfo, "");
                        continue;
                    }
                    if (TaxCalTaskStateEnum.FINISHED != relayTaskState) continue;
                    String acceptId = "";
                    IsAllowedQuoted isAutoDeduct = relayTask.getTaxUnit().getIsAutoDeduct();
                    if (TaxCalTaskCatalogEnum.TaxSpeAddtionalDedReport == relayTask.getCatalog() && 1 == isAutoDeduct.getValue()) {
                        String reportParam = relayTask.getRequestParam().getParamContent();
                        HashMap paramMap = JSONUtils.convertJsonToObject((Context)ctx, (String)reportParam);
                        if (paramMap.containsKey("accept_id")) {
                            acceptId = (String)paramMap.get("accept_id");
                        }
                    } else {
                        acceptId = relayTask.getAccept_id();
                    }
                    StringBuilder updateSQL = new StringBuilder();
                    updateSQL.append(" update T_HR_STAXCALINITDETAIL ");
                    updateSQL.append(" set FACCEPTID = '").append(acceptId).append("'");
                    updateSQL.append(" WHERE  FCMPCALTABLEID in ( ");
                    updateSQL.append(" SELECT FCMPCALTABLEID FROM T_HR_STaxcalTaskDetail ");
                    updateSQL.append(" WHERE  FCALTASKID = '").append(taskID).append("'");
                    updateSQL.append(" AND  (FACCEPTID is null or FACCEPTID = ''))");
                    DbUtil.execute((Context)ctx, (String)updateSQL.toString());
                    updateSQL = new StringBuilder();
                    updateSQL.append(" update T_HR_STAXCALTASKDETAIL ");
                    updateSQL.append(" set FACCEPTID = '").append(acceptId).append("'");
                    updateSQL.append(" WHERE  FCALTASKID = '").append(taskID).append("'");
                    updateSQL.append(" AND  (FACCEPTID is null or FACCEPTID = '')");
                    DbUtil.execute((Context)ctx, (String)updateSQL.toString());
                    SelectorItemCollection selector = new SelectorItemCollection();
                    selector.add("id");
                    selector.add("state");
                    taxCalTaskInfo.setState(TaxCalTaskStateEnum.WAITTING);
                    taxCalTask.updatePartial(taxCalTaskInfo, selector);
                    continue;
                }
                ITaxTaskService taxTaskService = TaskServiceFactory.getInstance(catalog);
                if (TaxCalTaskStateEnum.FAIDED == relayTaskState) {
                    taxTaskService.onFailure(ctx, taxCalTaskInfo, "");
                    continue;
                }
                if (TaxCalTaskStateEnum.FINISHED != relayTaskState) continue;
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("state");
                taxCalTaskInfo.setState(TaxCalTaskStateEnum.WAITTING);
                taxCalTask.updatePartial(taxCalTaskInfo, selector);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void updateAcceptId(Context ctx, String initIds) throws BOSException {
        String str = " update T_HR_STAXCALINITDETAIL detail set FAcceptId = ( select FAcceptId from T_HR_STaxPersonRecordEntry entry  where detail.FTaxUnitId = entry.FTaxUnitId and detail.FPersonId = entry.FPersonId)  where fid in (" + initIds + ") ";
        DbUtil.execute((Context)ctx, (String)str);
    }

    private void updateTaxCalInitData(Context ctx, String initIds) throws BOSException {
        String sql = "UPDATE T_HR_STAXCALINITDETAIL SET FSTATE = 30 WHERE FID IN (" + initIds + ")  ";
        DbUtil.execute((Context)ctx, (String)sql);
    }

    private void initTaxItem(Context ctx) {
        this.allTaxItemList = new ArrayList<String>();
        this.sumTaxList = new ArrayList<String>();
        TaxItemCollection itemColl = TaxItemUtil.getAllTaxItem(ctx, false);
        for (int i = 0; i < itemColl.size(); ++i) {
            TaxItemInfo info = itemColl.get(i);
            this.allTaxItemList.add("T" + info.getFieldSn());
            boolean isSum = info.isIsSum();
            if (!isSum) continue;
            this.sumTaxList.add("T" + info.getFieldSn());
        }
    }

    private void combineRowData(IRowSet rowSet) {
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        String key = null;
        try {
            key = this.getPersonKey(rowSet.getString("FTAXUNITID"), rowSet.getString("FINCOMEITEMID"), rowSet.getString("FPERSONID"));
            if (this.dataMap.containsKey(key)) {
                return;
            }
            for (String taxItem : this.sumTaxList) {
                rowMap.put(taxItem, rowSet.getBigDecimal(taxItem));
            }
            rowMap.put("FCMPCALTABLEID", rowSet.getString("FCMPCALTABLEID"));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.dataMap.put(key, rowMap);
    }

    private void getSubmittedData(Context ctx, String initIds) throws BOSException {
        if (null == this.sumTaxList || this.sumTaxList.isEmpty()) {
            return;
        }
        StringBuilder str = new StringBuilder();
        for (String taxItem : this.sumTaxList) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append("SUMDATA.").append(taxItem);
        }
        String sumItems = str.toString();
        str = new StringBuilder();
        str.append(" SELECT SUMDATA.FPERSONID, SUMDATA.FTAXUNITID, SUMDATA.FINCOMEITEMID,SUMDATA.FCMPCALTABLEID, ").append(sumItems);
        str.append(" FROM T_HR_STAXCALTASKDETAIL SUMDATA ");
        str.append(" INNER JOIN T_HR_STAXCALINITDETAIL INIT ON SUMDATA.FCMPCALTABLEID = INIT.FCMPCALTABLEID and SUMDATA.fIncomeItemId = INIT.fIncomeItemId AND INIT.FSTATE = 40 ");
        str.append(" INNER JOIN T_HR_STAXINCOMEITEM INCOMEITEM ON SUMDATA.FINCOMEITEMID =  INCOMEITEM.FID ");
        str.append(" WHERE EXISTS( ");
        str.append(" SELECT 1 FROM T_HR_STAXCALINITDETAIL DETAIL ");
        str.append(" WHERE DETAIL.FID IN (").append(initIds).append(") ");
        str.append(" AND INIT.FPERSONID = DETAIL.FPERSONID AND INIT.FTAXUNITID = DETAIL.FTAXUNITID ");
        str.append(" AND INIT.FINCOMEITEMID = DETAIL.FINCOMEITEMID AND INIT.FPERIODBEGIN = DETAIL.FPERIODBEGIN) ");
        str.append(" AND SUMDATA.FDATASTATE = ").append(10);
        str.append(" AND INCOMEITEM.FTAXCALMETHOD = ").append(10);
        str.append(" ORDER BY SUMDATA.FPERSONID, SUMDATA.FTAXUNITID, SUMDATA.FINCOMEITEMID, SUMDATA.FCREATETIME DESC ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                this.combineRowData(rowSet);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private void createDelTask(Context ctx, String initIds, TaxCalDelTypeEnum oprType) throws BOSException {
        this.taskMap = new HashMap<String, String>();
        String str = " SELECT t.fCmpCalTableId, t.fTaxUnitId, t.fPeriodBegin, t.fIncomeItemId, e.FAcceptId from T_HR_STaxCalInitDetail t left join T_HR_STaxPersonRecordEntry e  on t.fPersonId = e.fPersonId and t.fTaxUnitId = e.fTaxUnitId where t.fid IN (" + initIds + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        if (rowSet.size() < 1) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label31", (Locale)ctx.getLocale()));
        }
        HashMap taxUnitGroups = new HashMap();
        try {
            while (rowSet.next()) {
                String taxUnitId = rowSet.getString("fTaxUnitId");
                ArrayList<TaxCalBasicVO> calcList = (ArrayList<TaxCalBasicVO>)taxUnitGroups.get(taxUnitId);
                if (null == calcList) {
                    calcList = new ArrayList<TaxCalBasicVO>();
                    taxUnitGroups.put(taxUnitId, calcList);
                }
                TaxCalBasicVO vo = new TaxCalBasicVO();
                vo.setCmpTableId(rowSet.getString("fCmpCalTableId"));
                vo.setPeriodBegin(rowSet.getDate("fPeriodBegin"));
                vo.setTaxUnitId(rowSet.getString("fTaxUnitId"));
                vo.setIncomeItemId(rowSet.getString("fIncomeItemId"));
                vo.setAcceptId(rowSet.getString("FAcceptId"));
                calcList.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        for (Map.Entry group : taxUnitGroups.entrySet()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            String taxUnitId = (String)group.getKey();
            List list = (List)group.getValue();
            this.addDeleteTask(ctx, oprType, paramMap, taxUnitId, list);
        }
    }

    private String addDeleteTask(Context ctx, TaxCalDelTypeEnum oprType, Map<String, Object> paramMap, String taxUnitId, List<TaxCalBasicVO> list) throws BOSException {
        String yearMonth = CmpDateUtil.getDateStr(list.get(0).getPeriodBegin(), "yyyy-MM");
        paramMap.put("TAXUNITID", taxUnitId);
        paramMap.put("PERIOD", yearMonth);
        paramMap.put("creator", this.userId);
        paramMap.put("accept_id", list.get(0).getAcceptId());
        String id = TaxServiceTaskFacadeFactory.getLocalInstance(ctx).addTask(TaxCalTaskCatalogEnum.TaxCalDelete, paramMap).toString();
        this.taskMap.put(taxUnitId, id);
        this.createTaxCalDelRecords(ctx, id, this.userId, oprType);
        return id;
    }

    private void createTaxCalDelRecords(Context ctx, String taskId, String userId, TaxCalDelTypeEnum oprType) throws BOSException {
        Timestamp createTime = new Timestamp(System.currentTimeMillis());
        UserInfo creator = new UserInfo();
        creator.setId(BOSUuid.read((String)userId));
        TaxCalDelRecordInfo info = new TaxCalDelRecordInfo();
        info.setId(BOSUuid.create((BOSObjectType)info.getBOSType()));
        info.setTaskId(taskId);
        info.setOprType(oprType);
        info.setCreateTime(createTime);
        info.setLastUpdateTime(createTime);
        info.setLastUpdateUser(creator);
        info.setCreator(creator);
        try {
            TaxCalDelRecordFactory.getLocalInstance(ctx).save((CoreBaseInfo)info);
        }
        catch (EASBizException e) {
            logger.error((Object)"Saving Batch TaxCalDelRecords error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String createTask(Context ctx, String initIds, TaxCalTaskCatalogEnum catalog) throws BOSException {
        this.taskMap = new HashMap<String, String>();
        String str = " SELECT t.fid initId, t.fTaxUnitId, t.fPeriodBegin, t.fIncomeItemId, e.FAcceptId, e.fid entryId, e.FSubmitStatus, c.fid configId  from T_HR_STaxCalInitDetail t left join T_HR_STaxCalConfigDetail c on t.FCmpCalTableId = c.FCmpCalTableId and t.FIncomeItemId = c.FIncomeItemId left join T_HR_STaxPersonRecordEntry e on t.fPersonId = e.fPersonId and t.fTaxUnitId = e.fTaxUnitId where t.fid IN (" + initIds + ")";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str);
        if (rowSet.size() < 1) {
            throw new BOSException(EASResource.getString((String)"com.kingdee.shr.compensation.resource.TaxCalBaseResource", (String)"label31", (Locale)ctx.getLocale()));
        }
        HashMap taxUnitGroups = new HashMap();
        try {
            while (rowSet.next()) {
                String taxUnitId = rowSet.getString("fTaxUnitId");
                ArrayList<TaxCalBasicVO> calcList = (ArrayList<TaxCalBasicVO>)taxUnitGroups.get(taxUnitId);
                if (null == calcList) {
                    calcList = new ArrayList<TaxCalBasicVO>();
                    taxUnitGroups.put(taxUnitId, calcList);
                }
                TaxCalBasicVO vo = new TaxCalBasicVO();
                vo.setPeriodBegin(rowSet.getDate("fPeriodBegin"));
                vo.setInitId(rowSet.getString("initId"));
                vo.setTaxUnitId(rowSet.getString("fTaxUnitId"));
                vo.setIncomeItemId(rowSet.getString("fIncomeItemId"));
                vo.setAcceptId(rowSet.getString("FAcceptId"));
                vo.setSubmitStatus(rowSet.getString("FSubmitStatus"));
                vo.setEntryId(rowSet.getString("entryId"));
                vo.setConfigId(rowSet.getString("configId"));
                calcList.add(vo);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
        ITaxPersonReportFacade taxPersonReport = TaxPersonReportFacadeFactory.getLocalInstance(ctx);
        ITaxSpeAddDedReportFacade taxSpeAddDedReportFacade = TaxSpeAddDedReportFacadeFactory.getLocalInstance(ctx);
        ITaxServiceTaskFacade taxServiceTask = TaxServiceTaskFacadeFactory.getLocalInstance(ctx);
        String taskId = null;
        for (Map.Entry group : taxUnitGroups.entrySet()) {
            List<String> lwbcList;
            List relayTaskIDList;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            String taxUnitId = (String)group.getKey();
            List list = (List)group.getValue();
            String yearMonth = CmpDateUtil.getDateStr(((TaxCalBasicVO)list.get(0)).getPeriodBegin(), "yyyy-MM");
            paramMap.put("TAXUNITID", taxUnitId);
            paramMap.put("PERIOD", yearMonth);
            paramMap.put("creator", this.userId);
            StringBuilder notReportedPersons = new StringBuilder();
            this.initPersons(list, notReportedPersons);
            if (notReportedPersons.length() == 0) {
                paramMap.put("accept_id", ((TaxCalBasicVO)list.get(0)).getAcceptId());
            } else if (!this.isFbSubmit && null != (relayTaskIDList = taxPersonReport.report(notReportedPersons.toString(), yearMonth, null)) && relayTaskIDList.size() == 1) {
                IObjectPK relayTaskID = (IObjectPK)relayTaskIDList.get(0);
                paramMap.put("RELAYTASK", relayTaskID.toString());
            }
            String taxSpeAddDedEntryIds = this.getTaxSpeAddDedEntryIds(list);
            if (TaxCalTaskCatalogEnum.TaxCal == catalog && taxSpeAddDedEntryIds.length() > 0) {
                paramMap.put("TaxPersonRecordEntryIDS", taxSpeAddDedEntryIds);
                List relayTaskIDList2 = taxSpeAddDedReportFacade.report(paramMap);
                if (null != relayTaskIDList2 && relayTaskIDList2.size() == 1) {
                    IObjectPK relayTaskID = (IObjectPK)relayTaskIDList2.get(0);
                    paramMap.put("RELAYTASK", relayTaskID.toString());
                }
            }
            if (this.havingConfigDetail(list) && !(lwbcList = this.getDeleteData(list)).isEmpty()) {
                String deleteTaskId = this.addDeleteTask(ctx, TaxCalDelTypeEnum.DEL_LWBC, paramMap, taxUnitId, list);
                String insertSql = this.getInsertTaskDetailSql();
                List<Object[]> paramsList = this.getLwbcListData(ctx, deleteTaskId, lwbcList);
                DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
                if (!this.isFbSubmit) {
                    this.updateTaxCalInitData(ctx, CmpStrUtil.convertListToString(lwbcList));
                }
                paramMap.put("RELAYTASK", deleteTaskId);
            }
            String id = taxServiceTask.addTask(catalog, paramMap).toString();
            this.taskMap.put(taxUnitId, id);
            taskId = id;
        }
        return taskId;
    }

    protected List<String> getDeleteData(List<TaxCalBasicVO> list) {
        ArrayList<String> lwbcList = new ArrayList<String>();
        for (TaxCalBasicVO vo : list) {
            if (!CmpTaxUtil.accIncomeItems.contains(vo.getIncomeItemId()) || StringUtils.isEmpty((String)vo.getConfigId())) continue;
            lwbcList.add(vo.getInitId());
        }
        return lwbcList;
    }

    protected boolean havingConfigDetail(List<TaxCalBasicVO> list) {
        for (TaxCalBasicVO vo : list) {
            if (StringUtils.isEmpty((String)vo.getConfigId())) continue;
            return true;
        }
        return false;
    }

    private String getTaxSpeAddDedEntryIds(List<TaxCalBasicVO> list) {
        StringBuilder entryIds = new StringBuilder();
        for (TaxCalBasicVO vo : list) {
            if (!"8r0AAABCg2PDiOoP".equals(vo.getIncomeItemId())) continue;
            if (entryIds.length() > 0) {
                entryIds.append(",");
            }
            entryIds.append("'").append(vo.getEntryId()).append("'");
        }
        return entryIds.toString();
    }

    private void initPersons(List<TaxCalBasicVO> list, StringBuilder notReported) {
        for (TaxCalBasicVO vo : list) {
            if (!this.isNotSubmittedPerson(vo)) continue;
            if (notReported.length() > 0) {
                notReported.append(",");
            }
            notReported.append("'").append(vo.getEntryId()).append("'");
        }
    }

    private boolean isNotSubmittedPerson(TaxCalBasicVO vo) {
        return "0".equals(vo.getSubmitStatus()) || "3".equals(vo.getSubmitStatus());
    }

    private List<Object[]> getParamListData(Context ctx, String initIds) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        StringBuilder str = new StringBuilder();
        for (String s : this.allTaxItemList) {
            str.append(",").append(s);
        }
        String taxItem = str.toString();
        if (!this.isDelete) {
            this.getSubmittedData(ctx, initIds);
        }
        HashSet<String> personSet = new HashSet<String>();
        str = new StringBuilder();
        str.append(" SELECT FCMPCALTABLEID, FPERSONID, FTAXUNITID, FPERIODBEGIN, FPERIODEND, ");
        str.append(" FINCOMEITEMID,FID,fAcceptId ").append(taxItem);
        str.append(" FROM T_HR_STAXCALINITDETAIL ");
        str.append(" WHERE FID IN (").append(initIds).append(")");
        str.append(" ORDER BY FTAXUNITID, FINCOMEITEMID, FPERSONID, FCREATETIME ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String personId;
                String incomeItemId;
                String taxUnitId = rowSet.getString("FTAXUNITID");
                String personKey = this.getPersonKey(taxUnitId, incomeItemId = rowSet.getString("FINCOMEITEMID"), personId = rowSet.getString("FPERSONID"));
                if (personSet.contains(personKey)) continue;
                personSet.add(personKey);
                String taskId = this.taskMap.get(taxUnitId);
                Object[] param = this.sumLastData(rowSet, personKey, taskId);
                paramsList.add(param);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        return paramsList;
    }

    private List<Object[]> getLwbcListData(Context ctx, String taskId, List<String> lwbcList) throws BOSException {
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        StringBuilder str = new StringBuilder();
        for (String s : this.allTaxItemList) {
            str.append(",").append(s);
        }
        String taxItem = str.toString();
        HashSet<String> personSet = new HashSet<String>();
        str = new StringBuilder();
        str.append(" SELECT FCMPCALTABLEID, FPERSONID, FTAXUNITID, FPERIODBEGIN, FPERIODEND, ");
        str.append(" FINCOMEITEMID,FID,fAcceptId ").append(taxItem);
        str.append(" FROM T_HR_STAXCALINITDETAIL ");
        str.append(" WHERE FID IN (").append(CmpStrUtil.convertListToString(lwbcList)).append(")");
        str.append(" ORDER BY FTAXUNITID, FINCOMEITEMID, FPERSONID, FCREATETIME ");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        try {
            while (rowSet.next()) {
                String personId;
                String incomeItemId;
                String taxUnitId = rowSet.getString("FTAXUNITID");
                String personKey = this.getPersonKey(taxUnitId, incomeItemId = rowSet.getString("FINCOMEITEMID"), personId = rowSet.getString("FPERSONID"));
                if (personSet.contains(personKey)) continue;
                personSet.add(personKey);
                Object[] param = new Object[13 + this.allTaxItemList.size()];
                param[0] = BOSUuid.create((String)"01CB8082").toString();
                param[1] = taskId;
                param[2] = rowSet.getString("FCMPCALTABLEID");
                param[3] = rowSet.getString("FCMPCALTABLEID");
                param[4] = rowSet.getString("FPERSONID");
                param[5] = rowSet.getString("FTAXUNITID");
                param[6] = rowSet.getDate("FPERIODBEGIN");
                param[7] = rowSet.getDate("FPERIODEND");
                param[8] = rowSet.getString("FINCOMEITEMID");
                param[9] = rowSet.getString("fAcceptId");
                param[10] = this.userId;
                param[11] = this.userId;
                param[12] = 20;
                for (String item : this.allTaxItemList) {
                    int index = this.allTaxItemList.indexOf(item);
                    param[13 + index] = rowSet.getObject(item);
                }
                paramsList.add(param);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getLwbcListData error: ", (Throwable)e);
        }
        return paramsList;
    }

    private String getPersonKey(String taxUnitId, String incomeItemId, String personId) {
        return taxUnitId + "_" + incomeItemId + "_" + personId;
    }

    private String getInsertTaskDetailSql() {
        StringBuilder str = new StringBuilder();
        StringBuilder itemStr = new StringBuilder();
        for (String s : this.allTaxItemList) {
            str.append(s).append(",");
            itemStr.append(",?");
        }
        String taxItems = str.substring(0, str.length() - 1);
        str = new StringBuilder();
        str.append(" INSERT INTO T_HR_STAXCALTASKDETAIL(FID, FCALTASKID, FRELAYID, FCMPCALTABLEID, FPERSONID, ");
        str.append(" FTAXUNITID, FPERIODBEGIN, FPERIODEND, FINCOMEITEMID, FACCEPTID, ");
        str.append(" FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME,FDataState, ").append(taxItems);
        str.append(" )");
        str.append(" values(?, ?, ?, ?, ?, ");
        str.append(" ?, ?, ?, ?, ?, ");
        str.append(" ?, now(), ?, now(), ? ");
        str.append((CharSequence)itemStr);
        str.append(")");
        return str.toString();
    }

    private Object[] sumLastData(IRowSet rowSet, String personKey, String taskId) throws SQLException {
        Map<Object, Object> rowMap = new HashMap();
        if (this.dataMap.containsKey(personKey)) {
            rowMap = this.dataMap.get(personKey);
            for (String taxItem : this.sumTaxList) {
                BigDecimal detail = null == rowSet.getBigDecimal(taxItem) ? BigDecimal.ZERO : rowSet.getBigDecimal(taxItem);
                BigDecimal sum = null == rowMap.get(taxItem) ? BigDecimal.ZERO : (BigDecimal)rowMap.get(taxItem);
                rowMap.put(taxItem, detail.add(sum));
            }
        }
        Object[] param = new Object[13 + this.allTaxItemList.size()];
        param[0] = BOSUuid.create((String)"01CB8082").toString();
        param[1] = taskId;
        param[2] = rowMap.get("FCMPCALTABLEID");
        param[3] = rowSet.getString("FCMPCALTABLEID");
        param[4] = rowSet.getString("FPERSONID");
        param[5] = rowSet.getString("FTAXUNITID");
        param[6] = rowSet.getDate("FPERIODBEGIN");
        param[7] = rowSet.getDate("FPERIODEND");
        param[8] = rowSet.getString("FINCOMEITEMID");
        param[9] = rowSet.getString("fAcceptId");
        param[10] = this.userId;
        param[11] = this.userId;
        param[12] = this.isDelete ? 20 : 10;
        for (String item : this.allTaxItemList) {
            int index = this.allTaxItemList.indexOf(item);
            param[13 + index] = rowMap.containsKey(item) ? rowMap.get(item) : rowSet.getObject(item);
        }
        return param;
    }

    @Override
    protected void _deleteTaxData(Context ctx, String initIds, Enum cataLog) throws BOSException {
        if (StringUtils.isEmpty((String)initIds) || "''".equals(initIds)) {
            return;
        }
        this.isDelete = true;
        this.initUserID(ctx, null);
        this.updateAcceptId(ctx, initIds);
        this.createTask(ctx, initIds, (TaxCalTaskCatalogEnum)cataLog);
        this.initTaxItem(ctx);
        String insertSql = this.getInsertTaskDetailSql();
        List<Object[]> paramsList = this.getParamListData(ctx, initIds);
        DbUtil.executeBatch((Context)ctx, (String)insertSql, paramsList);
        this.updateTaxCalInitData(ctx, initIds);
    }
}

