/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.externaldata;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.StateEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.compensation.app.timepiece.externaldata.AbstractExternalDataConfigControllerBean;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigInfo;
import com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataException;
import com.kingdee.shr.validaterule.exception.DataStagTableException;
import com.kingdee.shr.validaterule.util.EntityUtil;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ExternalDataConfigControllerBean
extends AbstractExternalDataConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.externaldata.ExternalDataConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameNumber(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    protected void checkNameNumber(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this._checkNameBlank(ctx, model);
        this._checkNameDup(ctx, model);
        this._checkNumberBlank(ctx, model);
        this._checkNumberDup(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        String id = pk.toString();
        this.checkState(ctx, id, StateEnum.DISABLE);
        this.checkQuoted(ctx, id);
        super._delete(ctx, pk);
    }

    @Override
    protected void _enable(Context ctx, String id) throws BOSException, EASBizException {
        this.checkEntry(ctx, id);
        this.checkState(ctx, id, StateEnum.DISABLE);
        this.doState(ctx, id, StateEnum.ENABLE);
    }

    @Override
    protected void _disable(Context ctx, String id) throws BOSException, EASBizException {
        this.checkState(ctx, id, StateEnum.ENABLE);
        this.doState(ctx, id, StateEnum.DISABLE);
    }

    private void doState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        ExternalDataConfigInfo updateModel = new ExternalDataConfigInfo();
        updateModel.setId(BOSUuid.read((String)id));
        updateModel.setState(state);
        updateModel.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        updateModel.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("state");
        selector.add("lastUpdateUser");
        selector.add("lastUpdateTime");
        this.updatePartial(ctx, updateModel, selector);
    }

    protected void checkState(Context ctx, String id, StateEnum state) throws BOSException, EASBizException {
        if (!this._exists(ctx, "where id='" + id + "' and state = " + state.getValue())) {
            throw new DataStagTableException(DataStagTableException.SELECTSTATEDATA, new Object[]{state.getAlias()});
        }
    }

    protected void checkQuoted(Context ctx, String id) throws BOSException, EASBizException {
        this.checkQuotedByDailyScheme(ctx, id);
        this.checkHashExtData(ctx, id);
    }

    protected void checkHashExtData(Context ctx, String id) throws BOSException, EASBizException {
        ExternalDataConfigInfo info = this.getExternalDataConfigInfo(ctx, "select id,entity where id ='" + id + "'");
        String entity = info.getEntity();
        if (StringUtils.isEmpty((CharSequence)entity)) {
            return;
        }
        String entityTableName = EntityUtil.getEntityTableName((Context)ctx, (String)entity);
        String sql = "select top 1 fid from " + entityTableName;
        boolean hasData = false;
        try {
            hasData = DbUtil.executeQuery((Context)ctx, (String)sql).next();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        if (hasData) {
            throw new ExternalDataException(ExternalDataException.HASEXTDATA);
        }
    }

    protected void checkQuotedByDailyScheme(Context ctx, String id) throws BOSException, EASBizException {
        String querySql = " SELECT  cs.fname_" + LocaleUtils.getShortCode((Context)ctx) + " name  FROM  T_HR_SchemeOutDataConfig  c  inner join T_HR_STimepieceScheme s on c.FtimepieceSchemeid = s.fid  inner join T_HR_SCalSubmitScheme cs on s.FSubmitSchemeID = cs.fid  where c.FexternalDataConfigId = ? ";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)querySql, (Object[])new Object[]{id});
        HashSet quotedSet = Sets.newHashSet();
        try {
            while (rowSet.next()) {
                String name = rowSet.getString("name");
                quotedSet.add(name);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"query externaldataconfig quoted by scheme failed ", (Throwable)e);
        }
        if (quotedSet.size() > 0) {
            int index = 0;
            StringBuilder name = new StringBuilder();
            Iterator iterator = quotedSet.iterator();
            while (iterator.hasNext() && ++index <= 3) {
                name.append((String)iterator.next());
                if (index >= 3) continue;
                name.append(",");
            }
            if (quotedSet.size() > 3) {
                throw new ExternalDataException(ExternalDataException.QUOTEDDAILYSCHEMEMORE3, new Object[]{name.toString(), quotedSet.size()});
            }
            throw new ExternalDataException(ExternalDataException.QUOTEDDAILYSCHEME, new Object[]{name.toString()});
        }
    }

    protected void checkEntry(Context ctx, String id) throws BOSException, EASBizException {
        ExternalDataConfigInfo dataConfigInfo = this.getExternalDataConfigInfo(ctx, "select id,entry.id where id = '" + id + "'");
        if (dataConfigInfo.getEntry().isEmpty()) {
            throw new ExternalDataException(ExternalDataException.NOENTRY);
        }
    }
}

