/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.externaldata.vo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.shr.compensation.app.timepiece.externaldata.InputType;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.ConfigEntry;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.StructureColumn;
import com.kingdee.shr.compensation.app.timepiece.externaldata.vo.StructureInfo;
import com.kingdee.util.StringUtils;
import java.util.List;
import java.util.Map;

public class ConfigInfo {
    private String configId;
    private String scheme;
    private String entity;
    private int entityEnableStatus = 0;
    private Map<String, StructureInfo> structureMap = Maps.newHashMap();
    private Map<String, CoreBaseInfo> baseDataIdMapper = Maps.newHashMap();
    private List<ConfigEntry> entries = Lists.newArrayList();
    private Map<String, Integer> fieldNames = Maps.newHashMap();
    private List<String> requiredFields = Lists.newArrayList();
    private List<String> dbNames = Lists.newArrayList();

    public void addEntry(ConfigEntry entry) {
        String dbName;
        StructureInfo structureInfo;
        String structureNumber;
        this.entries.add(entry);
        this.fieldNames.put(entry.getName(), this.entries.size() - 1);
        if (entry.getInputType() == InputType.MANUAL_IMPORT && entry.isRequired()) {
            this.requiredFields.add(entry.getName());
        }
        if (StringUtils.isEmpty((String)(structureNumber = entry.getStructureNumber()))) {
            return;
        }
        String structureColumnNumber = entry.getStructureColumnNumber();
        if (this.structureMap.containsKey(structureNumber)) {
            structureInfo = this.structureMap.get(structureNumber);
        } else {
            structureInfo = new StructureInfo();
            structureInfo.setNumber(structureNumber);
            String structureEntity = entry.getStructureEntity();
            structureInfo.setEntity(structureEntity);
            dbName = entry.getDbName();
            structureInfo.setDbName(dbName.substring(2, dbName.length() - 2));
            structureInfo.setTableName(entry.getStructureEntityTable());
        }
        StructureColumn column = new StructureColumn(structureColumnNumber, entry.getName());
        if (entry.isEnum()) {
            column.setEnum(true);
            column.setEnumSource(entry.getEnumSource());
        }
        column.setDbName(entry.getStructureColDbName());
        structureInfo.addColumn(column);
        this.structureMap.put(structureNumber, structureInfo);
        dbName = entry.getDbName();
        if (!this.dbNames.contains(dbName)) {
            this.dbNames.add(dbName);
        }
    }

    public ConfigEntry getEntry(String fieldName) {
        if (!this.has(fieldName)) {
            return null;
        }
        Integer integer = this.fieldNames.get(fieldName);
        return this.entries.get(integer);
    }

    public boolean has(String fieldName) {
        return this.fieldNames.containsKey(fieldName);
    }

    public boolean isFormulaEntry(String fieldName) {
        if (!this.has(fieldName)) {
            return false;
        }
        ConfigEntry entry = this.getEntry(fieldName);
        InputType inputType = entry.getInputType();
        return InputType.CUSTOM_FORMULA == inputType;
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }

    public List<ConfigEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<ConfigEntry> entries) {
        this.entries = entries;
    }

    public List<String> getRequiredFields() {
        return this.requiredFields;
    }

    public Map<String, StructureInfo> getStructureMap() {
        return this.structureMap;
    }

    public Map<String, CoreBaseInfo> getBaseDataIdMapper() {
        return this.baseDataIdMapper;
    }

    public int getEntityEnableStatus() {
        return this.entityEnableStatus;
    }

    public void setEntityEnableStatus(int entityEnableStatus) {
    }

    public List<String> getDbNames() {
        return this.dbNames;
    }
}

