/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.timepiece.schemeconfig;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemCollection;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemFactory;
import com.kingdee.shr.compensation.app.integrate.CalSubmitItemInfo;
import com.kingdee.shr.compensation.app.timepiece.TimepieceException;
import com.kingdee.shr.compensation.app.timepiece.scheme.TimepieceSchemeInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.AbstractSumItemConfigControllerBean;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.AccValType;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.DimensionType;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDataSourceCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDataSourceInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDimensionCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDimensionFactory;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumDimensionInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigEntryCollection;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigEntryInfo;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigFactory;
import com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigInfo;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.log4j.Logger;

public class SumItemConfigControllerBean
extends AbstractSumItemConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.app.timepiece.schemeconfig.SumItemConfigControllerBean");

    @Override
    protected String _saveSumItemConfig(Context ctx, Map param) throws BOSException, EASBizException {
        String config;
        String deleteRowId = MapUtils.getString((Map)param, (Object)"deleteRowId");
        String timepieceSchemeId = MapUtils.getString((Map)param, (Object)"timepieceSchemeId");
        CoreBaseCollection sumItemConfigCollection = this.buildSumItemConfigCollection(ctx, timepieceSchemeId, config = MapUtils.getString((Map)param, (Object)"config"));
        if (!sumItemConfigCollection.isEmpty()) {
            this.beforeSave(ctx, sumItemConfigCollection);
            SumItemConfigFactory.getLocalInstance(ctx).saveBatchData(sumItemConfigCollection);
        }
        this.deleteRowByConfigId(ctx, deleteRowId);
        return null;
    }

    protected CoreBaseCollection buildSumItemConfigCollection(Context ctx, String timepieceSchemeId, String config) throws BOSException {
        CoreBaseCollection sumItemConfigCollection = new CoreBaseCollection();
        if (StringUtils.isEmpty((String)config)) {
            logger.info((Object)"method : buildSumItemConfigCollection ,config is empty!");
            return sumItemConfigCollection;
        }
        JSONArray elementJSONArray = JSONArray.parseArray((String)config);
        for (int index = 0; index < elementJSONArray.size(); ++index) {
            JSONObject elementJSON = elementJSONArray.getJSONObject(index);
            if (!this.validateJSON(elementJSON)) continue;
            sumItemConfigCollection.add((CoreBaseInfo)this.assembleSumItemConfigInfo(ctx, timepieceSchemeId, elementJSON, index));
        }
        return sumItemConfigCollection;
    }

    protected boolean validateJSON(JSONObject elementJSON) {
        if (!elementJSON.containsKey((Object)"sumDataSource") || elementJSON.getJSONArray("sumDataSource").isEmpty()) {
            logger.error((Object)("elementJSON : " + elementJSON.toJSONString() + " sumDataSource is empty!"));
            return false;
        }
        if (!elementJSON.containsKey((Object)"sumDimension") || elementJSON.getJSONArray("sumDimension").isEmpty()) {
            logger.error((Object)("elementJSON : " + elementJSON.toJSONString() + " sumDimension is empty!"));
            return false;
        }
        if (!elementJSON.containsKey((Object)"entry") || elementJSON.getJSONArray("entry").isEmpty()) {
            logger.error((Object)("elementJSON : " + elementJSON.toJSONString() + " entry is empty!"));
            return false;
        }
        return true;
    }

    protected SumItemConfigInfo assembleSumItemConfigInfo(Context ctx, String timepieceSchemeId, JSONObject elementJSON, int index) throws BOSException {
        String configId = elementJSON.getString("configId");
        SumItemConfigInfo sumItemConfigInfo = new SumItemConfigInfo();
        BOSObjectType bosType = sumItemConfigInfo.getBOSType();
        if (!StringUtils.isEmpty((String)configId)) {
            sumItemConfigInfo.setId(BOSUuid.read((String)configId));
        } else {
            sumItemConfigInfo.setId(BOSUuid.create((BOSObjectType)bosType));
        }
        sumItemConfigInfo.setIndex(index);
        TimepieceSchemeInfo timepieceSchemeInfo = new TimepieceSchemeInfo();
        timepieceSchemeInfo.setId(BOSUuid.read((String)timepieceSchemeId));
        sumItemConfigInfo.setTimepieceScheme(timepieceSchemeInfo);
        this.assembleRelationAttr(ctx, elementJSON, sumItemConfigInfo);
        return sumItemConfigInfo;
    }

    protected void assembleRelationAttr(Context ctx, JSONObject elementJSON, SumItemConfigInfo sumItemConfigInfo) throws BOSException {
        JSONArray sumDataSource = elementJSON.getJSONArray("sumDataSource");
        JSONArray sumDimension = elementJSON.getJSONArray("sumDimension");
        JSONArray entry = elementJSON.getJSONArray("entry");
        SumDataSourceCollection sumDataSourceCollection = new SumDataSourceCollection();
        for (int i = 0; i < sumDataSource.size(); ++i) {
            JSONObject jsonObject = sumDataSource.getJSONObject(i);
            SumDataSourceInfo sumDataSourceInfo = new SumDataSourceInfo();
            TimepieceSchemeInfo timepieceSchemeInfo = new TimepieceSchemeInfo();
            timepieceSchemeInfo.setId(BOSUuid.read((String)jsonObject.getString("id")));
            sumDataSourceInfo.setTimepieceScheme(timepieceSchemeInfo);
            sumDataSourceInfo.setSumItemConfig(sumItemConfigInfo);
            sumDataSourceCollection.add(sumDataSourceInfo);
        }
        sumItemConfigInfo.put("sumDataSource", (Object)sumDataSourceCollection);
        Map<String, String> dbSumDimension = this.queryDbSumDimension(ctx, sumItemConfigInfo.getId().toString());
        SumDimensionCollection sumDimensionCollection = new SumDimensionCollection();
        for (int i = 0; i < sumDimension.size(); ++i) {
            JSONObject jsonObject = sumDimension.getJSONObject(i);
            SumDimensionInfo sumDimensionInfo = new SumDimensionInfo();
            sumDimensionInfo.setSumItemConfig(sumItemConfigInfo);
            sumDimensionInfo.setDimensionId(jsonObject.getString("dimensionId"));
            sumDimensionInfo.setDimensionType(DimensionType.getEnum(jsonObject.getInteger("dimensionType")));
            if (!StringUtils.isEmpty((String)dbSumDimension.get(jsonObject.getString("dimensionId")))) {
                sumDimensionInfo.setId(BOSUuid.read((String)dbSumDimension.get(jsonObject.getString("dimensionId"))));
            }
            sumDimensionCollection.add(sumDimensionInfo);
        }
        sumItemConfigInfo.put("sumDimension", (Object)sumDimensionCollection);
        SumItemConfigEntryCollection sumItemConfigEntryCollection = new SumItemConfigEntryCollection();
        for (int i = 0; i < entry.size(); ++i) {
            JSONObject jsonObject = entry.getJSONObject(i);
            SumItemConfigEntryInfo sumItemConfigEntryInfo = new SumItemConfigEntryInfo();
            CalSubmitItemInfo sumItem = new CalSubmitItemInfo();
            sumItem.setId(BOSUuid.read((String)jsonObject.getJSONObject("sumItem").getString("id")));
            CalSubmitItemInfo accSubmitItemVal = new CalSubmitItemInfo();
            accSubmitItemVal.setId(BOSUuid.read((String)jsonObject.getJSONObject("accSubmitItemVal").getString("id")));
            sumItemConfigEntryInfo.setSumItemConfig(sumItemConfigInfo);
            sumItemConfigEntryInfo.setSumItem(sumItem);
            sumItemConfigEntryInfo.setAccSubmitItemVal(accSubmitItemVal);
            sumItemConfigEntryInfo.setAccValType(AccValType.getEnum(jsonObject.getInteger("accValType")));
            if (!StringUtils.isEmpty((String)jsonObject.getString("id"))) {
                sumItemConfigEntryInfo.setId(BOSUuid.read((String)jsonObject.getString("id")));
            }
            sumItemConfigEntryCollection.add(sumItemConfigEntryInfo);
        }
        sumItemConfigInfo.put("entry", (Object)sumItemConfigEntryCollection);
    }

    protected Map<String, String> queryDbSumDimension(Context ctx, String sumItemConfigId) throws BOSException {
        HashMap dbSumDimension = Maps.newHashMap();
        SumDimensionCollection sumDimensionCollection = SumDimensionFactory.getLocalInstance(ctx).getSumDimensionCollection("where sumItemConfig.id = '" + sumItemConfigId + "'");
        for (int i = 0; i < sumDimensionCollection.size(); ++i) {
            SumDimensionInfo sumDimensionInfo = sumDimensionCollection.get(i);
            dbSumDimension.put(sumDimensionInfo.getDimensionId(), sumDimensionInfo.getId().toString());
        }
        return dbSumDimension;
    }

    protected void beforeSave(Context ctx, CoreBaseCollection sumItemConfigCollection) throws BOSException, EASBizException {
        for (int i = 0; i < sumItemConfigCollection.size(); ++i) {
            SumItemConfigInfo sumItemConfigInfo = (SumItemConfigInfo)sumItemConfigCollection.get(i);
            List<String> relSubmitItemList = this.querySumDataSourceRelItems(ctx, sumItemConfigInfo.getSumDataSource());
            this.beforeVerify(ctx, relSubmitItemList, sumItemConfigInfo);
        }
    }

    protected void beforeVerify(Context ctx, List<String> relSubmitItemList, SumItemConfigInfo sumItemConfigInfo) throws EASBizException, BOSException {
        this.verifyDimension(ctx, relSubmitItemList, sumItemConfigInfo.getSumDimension());
        this.verifyAccSubmitItemVal(ctx, relSubmitItemList, sumItemConfigInfo.getEntry());
    }

    protected void verifyDimension(Context ctx, List<String> relSubmitItemList, SumDimensionCollection sumDimensions) throws EASBizException, BOSException {
        Set<Object> errData = Sets.newHashSet();
        for (int i = 0; i < sumDimensions.size(); ++i) {
            SumDimensionInfo sumDimensionInfo = sumDimensions.get(i);
            if (sumDimensionInfo.getDimensionType() == DimensionType.STRUCT || relSubmitItemList.contains(sumDimensionInfo.getDimensionId())) continue;
            errData.add(sumDimensionInfo.getDimensionId());
        }
        if (!errData.isEmpty()) {
            Map<String, String> itemId2NameMap = this.querySubmitItem(ctx, errData);
            errData = errData.stream().map(itemId2NameMap::get).collect(Collectors.toSet());
            throw new TimepieceException(TimepieceException.ITEMNOTMATCH1, new String[]{CmpStrUtil.join(errData, ",", null)});
        }
    }

    protected void verifyAccSubmitItemVal(Context ctx, List<String> relSubmitItemList, SumItemConfigEntryCollection entries) throws EASBizException, BOSException {
        Set<Object> errData = Sets.newHashSet();
        for (int i = 0; i < entries.size(); ++i) {
            SumItemConfigEntryInfo sumItemConfigEntryInfo = entries.get(i);
            String submitItemId = sumItemConfigEntryInfo.getAccSubmitItemVal().getId().toString();
            if (relSubmitItemList.contains(submitItemId)) continue;
            errData.add(submitItemId);
        }
        if (!errData.isEmpty()) {
            Map<String, String> itemId2NameMap = this.querySubmitItem(ctx, errData);
            errData = errData.stream().map(itemId2NameMap::get).collect(Collectors.toSet());
            throw new TimepieceException(TimepieceException.ITEMNOTMATCH2, new String[]{CmpStrUtil.join(errData, ",", null)});
        }
    }

    protected List<String> querySumDataSourceRelItems(Context ctx, SumDataSourceCollection sumDataSource) throws BOSException {
        ArrayList relSubmitItemList = Lists.newArrayList();
        ArrayList sumDataSourceIds = Lists.newArrayList();
        for (int i = 0; i < sumDataSource.size(); ++i) {
            sumDataSourceIds.add(sumDataSource.get(i).getTimepieceScheme().getId().toString());
        }
        try {
            String conditionSql = "select FSubmitSchemeID from T_HR_STimepieceScheme where fid in (" + CmpStrUtil.convertListToString(sumDataSourceIds) + ")";
            String queryItemSql = "select distinct FCalSubmitItemID from T_HR_SCalSubmitSchemeItem where FCalSubmitSchemeID in (" + conditionSql + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)queryItemSql);
            while (rs.next()) {
                relSubmitItemList.add(rs.getString("FCalSubmitItemID"));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return relSubmitItemList;
    }

    protected Map<String, String> querySubmitItem(Context ctx, Set<String> errData) throws BOSException {
        HashMap id2NameMap = Maps.newHashMap();
        CalSubmitItemCollection calSubmitItemCollection = CalSubmitItemFactory.getLocalInstance(ctx).getCalSubmitItemCollection("select id, name where id in (" + CmpStrUtil.convertSetToSqlString(errData) + ")");
        for (int i = 0; i < calSubmitItemCollection.size(); ++i) {
            CalSubmitItemInfo calSubmitItemInfo = calSubmitItemCollection.get(i);
            id2NameMap.put(calSubmitItemInfo.getId().toString(), calSubmitItemInfo.getName());
        }
        return id2NameMap;
    }

    protected void deleteRowByConfigId(Context ctx, String deleteRowId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)deleteRowId)) {
            return;
        }
        String[] ids = deleteRowId.split(",");
        CmpInSql<String> instance = CmpInSqlFactory.getInstance();
        String createInSqlBaseOnFId = instance.createInSqlBaseOnFId(ctx, Arrays.asList(ids));
        SumItemConfigFactory.getLocalInstance(ctx).delete("where id in " + createInSqlBaseOnFId);
        instance.release(ctx);
    }
}

