/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.app.v2.notice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.BaseItemException;
import com.kingdee.shr.base.syssetting.BaseItemStateEnum;
import com.kingdee.shr.base.syssetting.ISHRBasicItem;
import com.kingdee.shr.base.syssetting.SHRBaseItemInfo;
import com.kingdee.shr.base.syssetting.SHRBasicItemFactory;
import com.kingdee.shr.base.syssetting.SHRBasicItemInfo;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBasicItemUtil;
import com.kingdee.shr.baseconfig.QueryConfigFieldCollection;
import com.kingdee.shr.baseconfig.QueryConfigFieldFactory;
import com.kingdee.shr.baseconfig.QueryConfigFieldInfo;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemCollection;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemFactory;
import com.kingdee.shr.cmpdesign.app.v2.base.AdjustSalaryItemInfo;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryCollection;
import com.kingdee.shr.cmpdesign.app.v2.notice.AdjustSalaryNoticeEntryFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.INoticeTemplateField;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateFieldFactory;
import com.kingdee.shr.cmpdesign.app.v2.notice.NoticeTemplateFieldInfo;
import com.kingdee.shr.compensation.app.v2.notice.AbstractAdjustSalaryNoticeTemplateControllerBean;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateCollection;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateFactory;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateHISFactory;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateHISInfo;
import com.kingdee.shr.compensation.app.v2.notice.AdjustSalaryNoticeTemplateInfo;
import com.kingdee.shr.compensation.record.util.NoticeHelper;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.compensation.util.pdf.StyleExtractor;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;

public class AdjustSalaryNoticeTemplateControllerBean
extends AbstractAdjustSalaryNoticeTemplateControllerBean {
    private static final Logger LOG = Logger.getLogger(AdjustSalaryNoticeTemplateControllerBean.class);

    @Override
    public IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        AdjustSalaryNoticeTemplateInfo info = (AdjustSalaryNoticeTemplateInfo)model;
        CoreBaseCollection fields = this.convertBeforeSaving(ctx, info);
        AdjustSalaryNoticeTemplateHISInfo his = this.initTemplateHis(info);
        info.setHistoryRelate(his);
        IObjectPK pk = super._addnew(ctx, model);
        this.saveTemplateFields(ctx, fields, his);
        AdjustSalaryNoticeTemplateHISFactory.getLocalInstance(ctx).addnew(his);
        return pk;
    }

    private AdjustSalaryNoticeTemplateHISInfo initTemplateHis(AdjustSalaryNoticeTemplateInfo info) throws BOSException {
        AdjustSalaryNoticeTemplateHISInfo his = new AdjustSalaryNoticeTemplateHISInfo();
        try {
            BeanUtils.copyProperties((Object)his, (Object)info);
            his.setId(BOSUuid.create((BOSObjectType)his.getBOSType()));
            his.setNumber(info.getNumber() + "-" + System.currentTimeMillis());
            his.setHistoryRelate(info);
            return his;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error((Object)"copyProperties error: ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void _verifyData(Context ctx, IObjectValue shrBaseItem) throws BOSException, EASBizException {
        SHRBaseItemInfo newModel = (SHRBaseItemInfo)shrBaseItem;
        SHRBasicItemInfo shrBasicItemInfo = SysSettingSHRBasicItemUtil.getSHRBasicItemInfoByEntityName((Context)ctx, (String)BaseMetaDataUtil.getEntityObjectInfo((Context)ctx, (BOSObjectType)this.getBOSType()).getFullName());
        ISHRBasicItem iSHRBasicItem = SHRBasicItemFactory.getLocalInstance((Context)ctx);
        if (null == shrBasicItemInfo) {
            throw new BaseItemException(BaseItemException.BASEITEM_CTRLSTRA_NOT_MAINTAIN);
        }
        SHRBaseItemInfo oldModel = null;
        boolean existsPolicy = false;
        boolean existsCreate = false;
        if (StringUtils.isEmpty((String)shrBasicItemInfo.getRealEntityName())) {
            this._checkNumberDup(ctx, shrBaseItem);
            if (StringUtils.isEmpty((String)newModel.getName())) {
                throw new BaseItemException(BaseItemException.BASEITEM_ENTITY_NAME_NULL);
            }
            if (this.isVerifyNameDump()) {
                this._checkNameDup(ctx, shrBaseItem);
            }
        }
        if (null == newModel.getUsePolicy()) {
            throw new BaseItemException(BaseItemException.CTRLSTRA_NOT_NULL);
        }
        if (null == newModel.getShrBasicItem() || null == newModel.getShrBasicItem().getId()) {
            newModel.setShrBasicItem(shrBasicItemInfo);
        }
        if (null == newModel.getState()) {
            newModel.setState(BaseItemStateEnum.NEW);
        }
        if (null == newModel.getHrOrgUnit() || null == newModel.getHrOrgUnit().getId()) {
            throw new BaseItemException(BaseItemException.CREATEORG_ID_NOT_NULL);
        }
        if (null != newModel.getId()) {
            boolean isCopy;
            oldModel = this.getSHRBaseItemInfo(ctx, (IObjectPK)new ObjectUuidPK(newModel.getId()), this.getBaseItemInfoSelector());
            boolean bl = isCopy = shrBaseItem.get("flag") != null && "copy".equalsIgnoreCase(shrBaseItem.get("flag").toString());
            if (!newModel.getHrOrgUnit().getId().equals((Object)oldModel.getHrOrgUnit().getId()) && !isCopy) {
                throw new BaseItemException(BaseItemException.ORG_NOT_MATCH, new Object[]{newModel.getNumber()});
            }
        }
        if (StringUtils.isEmpty((String)newModel.getHrOrgUnit().getName())) {
            HROrgUnitInfo info = HROrgUnitFactory.getLocalInstance((Context)ctx).getHROrgUnitInfo((IObjectPK)new ObjectUuidPK(newModel.getHrOrgUnit().getId()));
            newModel.getHrOrgUnit().setName(info.getName());
        }
        if (!(existsPolicy = iSHRBasicItem.verifiUsePolicyCreated(newModel.getShrBasicItem().getId().toString(), newModel.getUsePolicy()))) {
            throw new BaseItemException(BaseItemException.PERMSSION_DENY_MAINTAIN, new Object[]{newModel.getUsePolicy().getAlias()});
        }
        existsCreate = iSHRBasicItem.verifiHROrgIsCreationById(newModel.getHrOrgUnit().getId().toString(), newModel.getShrBasicItem().getId().toString());
        if (!existsCreate) {
            throw new BaseItemException(BaseItemException.BIZORG_NO_ACCESS);
        }
    }

    private SelectorItemCollection getBaseItemInfoSelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("hrOrgUnit.id"));
        return selector;
    }

    private void saveTemplateFields(Context ctx, CoreBaseCollection fields, AdjustSalaryNoticeTemplateHISInfo his) throws BOSException, EASBizException {
        INoticeTemplateField iNoticeTemplateField = NoticeTemplateFieldFactory.getLocalInstance((Context)ctx);
        if (null == fields) {
            return;
        }
        for (int i = 0; i < fields.size(); ++i) {
            NoticeTemplateFieldInfo info = (NoticeTemplateFieldInfo)fields.get(i);
            info.setTemplate(his);
        }
        iNoticeTemplateField.saveBatchData(fields);
    }

    @Override
    public void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        AdjustSalaryNoticeTemplateInfo info = (AdjustSalaryNoticeTemplateInfo)model;
        CoreBaseCollection fields = this.convertBeforeSaving(ctx, info);
        AdjustSalaryNoticeTemplateHISInfo his = this.initTemplateHis(info);
        info.setHistoryRelate(his);
        super._update(ctx, pk, model);
        this.saveTemplateFields(ctx, fields, his);
        AdjustSalaryNoticeTemplateHISFactory.getLocalInstance(ctx).addnew(his);
        this.resetTemplate(ctx, pk.toString(), his.getId().toString());
    }

    private void resetTemplate(Context ctx, String templateId, String historyRelateId) throws BOSException {
        String oql = "select id  where template.historyRelate.id = '" + templateId + "' and sendState in (" + 0 + "," + -1 + "," + 2 + ") and adjEntryState != " + 3 + " and isRemove != 1";
        AdjustSalaryNoticeEntryCollection collection = AdjustSalaryNoticeEntryFactory.getLocalInstance((Context)ctx).getAdjustSalaryNoticeEntryCollection(oql);
        ArrayList updateParams = Lists.newArrayList();
        for (int i = 0; i < collection.size(); ++i) {
            Object[] param = new Object[]{historyRelateId, collection.get(i).getId().toString()};
            updateParams.add(param);
        }
        if (!updateParams.isEmpty()) {
            String updateSQL = "update T_HR_SAdjustSalaryNoticeEntry set FTemplateId = ?, FNoticeTitle = null, FHtmlContent = null, FPdfAttachmentId = '' where fid = ?";
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, (List)updateParams);
        }
    }

    protected CoreBaseCollection convertBeforeSaving(Context ctx, AdjustSalaryNoticeTemplateInfo model) throws BOSException, EASBizException {
        String fieldContent;
        String field;
        String htmlContent = model.getHtmlContent();
        htmlContent = this.beforeConverting(htmlContent);
        String title = model.getBosTitle();
        title = title.replace("##", "~~");
        LOG.debug((Object)("convertBeforeSaving, htmlContent = " + htmlContent));
        Pattern fieldPattern = Pattern.compile("#(.+?)#");
        Matcher fieldMatcher = fieldPattern.matcher(htmlContent);
        ArrayList<String> fieldNames = new ArrayList<String>();
        HashMap infoSetNameFormatMap = Maps.newHashMap();
        while (fieldMatcher.find()) {
            field = fieldMatcher.group();
            if (field.startsWith("##")) continue;
            fieldContent = field.replace("#", "");
            if (!fieldContent.contains(",")) {
                fieldNames.add(fieldContent);
                continue;
            }
            String[] contents = fieldContent.split(",");
            fieldNames.add(contents[0]);
            infoSetNameFormatMap.put(contents[0], contents[1].trim());
        }
        fieldMatcher = fieldPattern.matcher(title);
        while (fieldMatcher.find()) {
            field = fieldMatcher.group();
            fieldContent = field.replace("#", "");
            fieldNames.add(fieldContent);
        }
        if (fieldNames.isEmpty()) {
            return null;
        }
        String oql = "select name, fieldSn, id where name in (" + CmpStrUtil.convertListToString(fieldNames) + ")";
        AdjustSalaryItemCollection adjustSalaryItemCollection = AdjustSalaryItemFactory.getLocalInstance((Context)ctx).getAdjustSalaryItemCollection(oql);
        CoreBaseCollection fields = new CoreBaseCollection();
        for (int i = 0; i < adjustSalaryItemCollection.size(); ++i) {
            AdjustSalaryItemInfo column = adjustSalaryItemCollection.get(i);
            String name = column.getName();
            String columnId = column.getId().toString();
            if (infoSetNameFormatMap.containsKey(name)) {
                String format = (String)infoSetNameFormatMap.get(name);
                name = name + "," + format;
                columnId = columnId + "," + format;
            }
            String source = "#" + name + "#";
            String target = "#" + columnId + "#";
            htmlContent = htmlContent.replace(source, target);
            title = title.replace(source, target);
            NoticeTemplateFieldInfo templateFieldInfo = new NoticeTemplateFieldInfo();
            templateFieldInfo.setId(BOSUuid.create((BOSObjectType)templateFieldInfo.getBOSType()));
            templateFieldInfo.setAdjustItem(column);
            templateFieldInfo.setFieldNum((String)infoSetNameFormatMap.get(column.getName()));
            fields.add((CoreBaseInfo)templateFieldInfo);
            fieldNames.remove(name);
        }
        if (!fieldNames.isEmpty()) {
            oql = "select id, alias, factField.number, factField.id where alias in (" + CmpStrUtil.convertListToString(fieldNames) + ")  and parent.scheme.number ='006_CMP_ADJ' and parent.id not in ('8r0AAAANXew+uK4f') and (parent.parent.id not in ('8r0AAAANXew+uK4f') or parent.parent.id is null)";
            QueryConfigFieldCollection columns = QueryConfigFieldFactory.getLocalInstance((Context)ctx).getQueryConfigFieldCollection(oql);
            this.checkRepeatedFieldName(columns);
            for (int i = 0; i < columns.size(); ++i) {
                QueryConfigFieldInfo column = columns.get(i);
                String name = column.getAlias();
                String columnId = column.getId().toString();
                if (infoSetNameFormatMap.containsKey(name)) {
                    String format = (String)infoSetNameFormatMap.get(name);
                    name = name + "," + format;
                    columnId = columnId + "," + format;
                }
                String source = "#" + name + "#";
                String target = "#" + columnId + "#";
                htmlContent = htmlContent.replace(source, target);
                title = title.replace(source, target);
                NoticeTemplateFieldInfo templateFieldInfo = new NoticeTemplateFieldInfo();
                templateFieldInfo.setId(BOSUuid.create((BOSObjectType)templateFieldInfo.getBOSType()));
                templateFieldInfo.setStructureColumn(column.getFactField());
                templateFieldInfo.setQueryConfigField(column);
                templateFieldInfo.setFieldNum((String)infoSetNameFormatMap.get(column.getAlias()));
                fields.add((CoreBaseInfo)templateFieldInfo);
            }
        }
        htmlContent = htmlContent.replace("~~", "##");
        title = title.replace("~~", "##");
        model.setHtmlContent(htmlContent);
        model.setBosTitle(title);
        LOG.debug((Object)("convertBeforeSaving, htmlContent1 = " + htmlContent));
        return fields;
    }

    protected String beforeConverting(String htmlContent) {
        htmlContent = htmlContent.replace("##", "~~");
        String hexReg = "#([A-Fa-f0-9]{6});";
        Pattern hexPattern = Pattern.compile(hexReg);
        Matcher matcher = hexPattern.matcher(htmlContent);
        while (matcher.find()) {
            String hexColor = matcher.group();
            int[] rgb = StyleExtractor.hex2RGB(hexColor.substring(0, hexColor.length() - 1));
            String rgbColor = "rgb(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + ");";
            htmlContent = htmlContent.replace(hexColor, rgbColor);
        }
        return htmlContent;
    }

    protected void checkRepeatedFieldName(QueryConfigFieldCollection columns) throws EASBizException {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        HashSet repeatedNames = Sets.newHashSet();
        for (int i = 0; i < columns.size(); ++i) {
            QueryConfigFieldInfo column = columns.get(i);
            String name = column.getAlias();
            String id = column.getId().toString();
            if (!nameMap.containsKey(name)) {
                nameMap.put(name, id);
                continue;
            }
            String existedID = (String)nameMap.get(name);
            if (existedID.equals(id)) continue;
            repeatedNames.add(name);
        }
        if (!repeatedNames.isEmpty()) {
            String label = "02";
            String errMsg = EASResource.getString((String)"com.kingdee.shr.cmpdesign.resource.AdjustSalaryNoticeResource", (String)label);
            errMsg = errMsg + String.join((CharSequence)", ", repeatedNames);
            throw new EASBizException(new NumericExceptionSubItem(label, errMsg));
        }
    }

    @Override
    protected IObjectPK[] _delete(Context ctx, String oql) throws BOSException, EASBizException {
        String selectOql = "select id " + oql;
        AdjustSalaryNoticeTemplateCollection templateCol = AdjustSalaryNoticeTemplateFactory.getLocalInstance(ctx).getAdjustSalaryNoticeTemplateCollection(selectOql);
        HashSet<String> templateIdSet = new HashSet<String>();
        for (int i = 0; i < templateCol.size(); ++i) {
            AdjustSalaryNoticeTemplateInfo templateInfo = templateCol.get(i);
            templateIdSet.add(templateInfo.getId().toString());
        }
        NoticeHelper.updateEntryTemplate(ctx, CmpStrUtil.convertSetToStringNew(templateIdSet));
        return super._delete(ctx, oql);
    }
}

