/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.helper;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.shr.compensation.CalSchemeCollection;
import com.kingdee.shr.compensation.CalSchemeFactory;
import com.kingdee.shr.compensation.CalSchemeInfo;
import com.kingdee.shr.compensation.ICalScheme;
import com.kingdee.shr.compensation.cache.impl.CalSchemeCacheServiceHelper;
import com.kingdee.shr.compensation.helper.CalSchemeBizUtil;
import com.kingdee.shr.compensation.resource.CmpResourceUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public final class CalSchemeBizHelper {
    private static Logger logger = Logger.getLogger(CalSchemeBizHelper.class);

    private CalSchemeBizHelper() {
    }

    public static CalSchemeInfo getCalSchemeInfo(Context ctx, String schemeId) {
        CalSchemeInfo info = CalSchemeCacheServiceHelper.getInfo(ctx, schemeId);
        if (null == info) {
            info = CalSchemeBizUtil.getCalSchemeInfo(ctx, schemeId);
        }
        return info;
    }

    public static Map<String, CalSchemeInfo> getCalSchemeMap(Context ctx, String filter) {
        HashMap<String, CalSchemeInfo> map = new HashMap<String, CalSchemeInfo>();
        try {
            ICalScheme calScheme = CalSchemeFactory.getLocalInstance(ctx);
            String oql = "select id, name,state,cmpPeriodType,taxUnit.id,hrOrgUnit.id,periodYear,periodMonth,calTime,beginDate,endDate,currency.id,exchangeTable.id,exchangeRule";
            if (CmpStrUtil.isNotEmpty(filter)) {
                oql = oql + " where " + filter;
            }
            CalSchemeCollection coll = calScheme.getCalSchemeCollection(oql);
            String id = "";
            CalSchemeInfo calSchemeInfo = null;
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                calSchemeInfo = coll.get(i);
                id = calSchemeInfo.getId().toString();
                map.put(id, calSchemeInfo);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return map;
    }

    public static boolean checkCalSchemeLegal(CalSchemeInfo calSchemeInfo) {
        return calSchemeInfo != null && calSchemeInfo.getBeginDate() != null && calSchemeInfo.getEndDate() != null && calSchemeInfo.getPeriodYear() != 0 && calSchemeInfo.getPeriodMonth() != 0 && calSchemeInfo.getCalTime() != 0;
    }

    public static String getCalValidateMessage(Context ctx) {
        return CmpResourceUtil.getMessageFromResource(ctx, "com.kingdee.shr.compensation.CmpCalSchemeResource", "CHECK_CAL_LEGAL");
    }
}

