/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.intelligent.confirm;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.qing.util.MapUtils;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelMatchDataInfo;
import com.kingdee.shr.compensation.app.intelligent.CmpIntelState;
import com.kingdee.shr.compensation.intelligent.confirm.AbstractCmpIntelConfirm;
import com.kingdee.shr.compensation.intelligent.dto.CmpIntelMatchDataRecordData;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.record.validator.RecordValidator;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.util.db.CmpInSql;
import com.kingdee.shr.compensation.util.db.CmpInSqlFactory;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.log4j.Logger;
import org.springframework.util.CollectionUtils;

public class AdjPersonDecreaseConfirm
extends AbstractCmpIntelConfirm {
    private static final String TMP_FID_FIELD_BASE_ON = "FPersonId";
    private static final String TMP_TABLE_SCMPCALTABLE = "T_HR_SAdjustPersonRecord";
    private final Logger logger = Logger.getLogger(AdjPersonDecreaseConfirm.class);

    @Override
    public Map<String, Object> confirm() throws EASBizException, BOSException {
        HashMap confirmMap = Maps.newHashMap();
        List<CmpIntelMatchDataInfo> matchDatas = this.getMatchDataInfos();
        HashSet<String> personIdSet = new HashSet<String>();
        HashSet<String> matchDataIdSet = new HashSet<String>();
        List<CmpIntelMatchDataRecordData> recordDataList = this.getCmpIntelMatchDataRecordData(matchDatas, personIdSet);
        Map<String, String> personHrAndRecordIdMap = this.getPersonHrAndRecordIdMap(personIdSet);
        this.setRecordId(personHrAndRecordIdMap, recordDataList);
        Map<Date, String> loseDateAndRecordIdsMap = this.getLoseDateAndRecordIdsMap(recordDataList);
        if (!MapUtils.isEmpty(loseDateAndRecordIdsMap)) {
            Map<String, Date> recordIdAndHandleDateMap;
            List<RocordValidatorInfo> infoList = this.recordValidator(loseDateAndRecordIdsMap);
            if (!CollectionUtils.isEmpty(infoList)) {
                this.setValidatorMsg(recordDataList, infoList);
            }
            if (!MapUtils.isEmpty(recordIdAndHandleDateMap = this.getRecordIdAndHandleDateMap(recordDataList, matchDataIdSet))) {
                AbstractRecord record = RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.ADJ);
                record.loseRecords(this.ctx, recordIdAndHandleDateMap);
                this.changeState(matchDataIdSet);
            }
        }
        String errorMsg = this.getErrorMsg(recordDataList);
        int successSize = matchDataIdSet.size();
        confirmMap.put("successSize", successSize);
        confirmMap.put("errorMsg", errorMsg);
        return confirmMap;
    }

    private String getErrorMsg(List<CmpIntelMatchDataRecordData> recordDataList) {
        String msg = "";
        for (CmpIntelMatchDataRecordData data : recordDataList) {
            if (data.isValidatorFlag()) continue;
            msg = data.getMsg();
            break;
        }
        if (StringUtils.isNotBlank((CharSequence)msg) && msg.contains("\u3002")) {
            int index = msg.indexOf("\u3002");
            msg = msg.substring(0, index + 1);
        }
        return msg;
    }

    private void setRecordId(Map<String, String> personHrAndRecordIdMap, List<CmpIntelMatchDataRecordData> recordDataList) {
        String msg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label83", (Locale)this.ctx.getLocale());
        for (CmpIntelMatchDataRecordData data : recordDataList) {
            if (data == null || !data.isValidatorFlag()) continue;
            if (personHrAndRecordIdMap.containsKey(data.getKey())) {
                data.setRecordId(personHrAndRecordIdMap.get(data.getKey()));
                continue;
            }
            data.setValidatorFlag(false);
            data.setMsg(msg);
        }
    }

    private void setValidatorMsg(List<CmpIntelMatchDataRecordData> recordDataList, List<RocordValidatorInfo> infoList) {
        block0: for (RocordValidatorInfo info : infoList) {
            for (CmpIntelMatchDataRecordData data : recordDataList) {
                if (info == null || info.getCode() == null || !info.getCode().equals(data.getRecordId())) continue;
                String errorMsg = info.getMsg();
                data.setValidatorFlag(false);
                data.setMsg(errorMsg);
                continue block0;
            }
        }
    }

    private List<RocordValidatorInfo> recordValidator(Map<Date, String> loseDateAndRecordIdsMap) throws BOSException {
        Iterator<Map.Entry<Date, String>> it = loseDateAndRecordIdsMap.entrySet().iterator();
        ArrayList infoList = Lists.newArrayList();
        RecordValidator validator = RecordInstanceFactory.getRecordValidatorInstance(RecordInstanceFactory.CATEGORY.ADJ);
        while (it.hasNext()) {
            Map.Entry<Date, String> map = it.next();
            Date loseDate = map.getKey();
            String recordIds = map.getValue();
            if (StringUtils.isEmpty((CharSequence)recordIds)) continue;
            try {
                List<RocordValidatorInfo> list = validator.loseRecord(this.ctx, recordIds, loseDate);
                if (CollectionUtils.isEmpty(list)) continue;
                infoList.addAll(list);
            }
            catch (BOSException e) {
                this.logger.error((Object)"adj recordValidator:", (Throwable)e);
                throw e;
            }
        }
        return infoList;
    }

    private Map<Date, String> getLoseDateAndRecordIdsMap(List<CmpIntelMatchDataRecordData> recordDataList) {
        HashMap loseDateAndRecordIdsmap = Maps.newHashMap();
        for (CmpIntelMatchDataRecordData data : recordDataList) {
            if (data == null || !data.isValidatorFlag()) continue;
            String recordId = data.getRecordId();
            Date loseDate = data.getHandleDate();
            if (loseDateAndRecordIdsmap.containsKey(loseDate)) {
                String recordIds = (String)loseDateAndRecordIdsmap.get(loseDate);
                recordIds = recordIds + ',' + recordId;
                loseDateAndRecordIdsmap.put(loseDate, recordIds);
                continue;
            }
            loseDateAndRecordIdsmap.put(loseDate, recordId);
        }
        return loseDateAndRecordIdsmap;
    }

    private List<CmpIntelMatchDataRecordData> getCmpIntelMatchDataRecordData(List<CmpIntelMatchDataInfo> matchDatas, Set<String> personIdSet) {
        ArrayList recordDataList = Lists.newArrayList();
        int size = matchDatas.size();
        for (int i = 0; i < size; ++i) {
            CmpIntelMatchDataInfo matchDataInfo = matchDatas.get(i);
            CmpIntelState state = matchDataInfo.getState();
            CmpIntelMatchDataRecordData data = new CmpIntelMatchDataRecordData();
            String personId = matchDataInfo.getPerson().getId().toString();
            String hrOrgId = matchDataInfo.getHrOrgUnit().getId().toString();
            Date handleDate = matchDataInfo.getHandleDate();
            String key = personId + "_" + hrOrgId;
            data.setCmpIntelMatchDataId(matchDataInfo.getId().toString());
            data.setHandleDate(handleDate);
            data.setHrOrgId(hrOrgId);
            data.setPersonId(personId);
            data.setKey(key);
            if (CmpIntelState.CONFIRMED.equals((Object)state)) {
                String errorMsg = EASResource.getString((String)"com.kingdee.shr.compensation.resource.CompMultiLanResource", (String)"label25", (Locale)this.ctx.getLocale());
                data.setValidatorFlag(false);
                data.setMsg(errorMsg);
            } else {
                data.setValidatorFlag(true);
                personIdSet.add(personId);
            }
            recordDataList.add(data);
        }
        return recordDataList;
    }

    private Map<String, Date> getRecordIdAndHandleDateMap(List<CmpIntelMatchDataRecordData> recordDataList, Set<String> matchDataIdSet) {
        HashMap recordIdAndHandleDateMap = Maps.newHashMap();
        for (CmpIntelMatchDataRecordData data : recordDataList) {
            if (!data.isValidatorFlag()) continue;
            recordIdAndHandleDateMap.put(data.getRecordId(), data.getHandleDate());
            matchDataIdSet.add(data.getCmpIntelMatchDataId());
        }
        return recordIdAndHandleDateMap;
    }

    private Map<String, String> getPersonHrAndRecordIdMap(Set<String> personIdSet) throws BOSException {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(personIdSet)) {
            return map;
        }
        CmpInSql<String> cmpInSql = CmpInSqlFactory.getInstance();
        String personIds = cmpInSql.createInSql(this.ctx, personIdSet, TMP_TABLE_SCMPCALTABLE, TMP_FID_FIELD_BASE_ON);
        String sql = " SELECT Fid,FPERSONID ,FHRORGUNITID ,FEFFECTDATE,FLEFFECTDATE FROM T_HR_SAdjustPersonRecord where FPERSONID in " + personIds;
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        try {
            while (rs.next()) {
                String fid = rs.getString("Fid");
                String personId = rs.getString("FPERSONID");
                String hrOrgId = rs.getString("FHRORGUNITID");
                String key = personId + "_" + hrOrgId;
                map.put(key, fid);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)"getPersonHrAndRecordIdMap : ", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

