/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.record;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.bizmanage.BizManageState;
import com.kingdee.shr.base.bizmanage.DataSource;
import com.kingdee.shr.base.bizmanage.ItemState;
import com.kingdee.shr.base.bizmanage.PersonBURelationFactory;
import com.kingdee.shr.base.bizmanage.PersonBURelationInfo;
import com.kingdee.shr.base.bizmanage.util.BatchPromptsInfo;
import com.kingdee.shr.base.bizmanage.util.SHRBizManageHelpUtil;
import com.kingdee.shr.compensation.record.PersonBizManageImp;
import com.kingdee.shr.compensation.record.assemble.RecordUtil;
import com.kingdee.shr.compensation.record.dto.RecordDataInfo;
import com.kingdee.shr.compensation.record.factory.AbstractEmpOrgRelation;
import com.kingdee.shr.compensation.record.factory.AbstractRecord;
import com.kingdee.shr.compensation.record.operate.RecordOperateInterface;
import com.kingdee.shr.compensation.record.util.RecordInstanceFactory;
import com.kingdee.shr.compensation.record.validator.RecordValidator;
import com.kingdee.shr.compensation.record.validator.RocordValidatorInfo;
import com.kingdee.shr.compensation.sql.record.SocRecordSQL;
import com.kingdee.shr.compensation.util.CmpSQLUtil;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class SocPBManageImpl
extends PersonBizManageImp {
    private RecordValidator validator = RecordInstanceFactory.getRecordValidatorInstance(RecordInstanceFactory.CATEGORY.SOC);
    private AbstractEmpOrgRelation socORelation = RecordInstanceFactory.getRelationInstance(RecordInstanceFactory.CATEGORY.SOC);
    private RecordOperateInterface operate = RecordInstanceFactory.getRecordOperateInstance(RecordInstanceFactory.CATEGORY.SOC);

    public Map batchEnablePersonBizManage(Context ctx, List<String> list) throws BOSException, EASBizException {
        if ((list = this.beforeBatchEnablePersonBizManage(ctx, list)).size() == 0) {
            return null;
        }
        this.operate.enablePBURelation(ctx, list);
        return null;
    }

    public IObjectPK[] batchAddNewPersonBizManage(Context ctx, List<PersonBURelationInfo> list) throws BOSException, EASBizException {
        CoreBaseCollection coll = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> listObjectPK = new ArrayList<ObjectUuidPK>();
        for (PersonBURelationInfo info : list) {
            String hrOrgUnitID;
            String bizManageTypeID;
            String personID;
            String empOrgRelationID = info.getEmpOrgRelation().getId().toString();
            if (!SocPBManageImpl.checkPersonBURelationExist((Context)ctx, (String)empOrgRelationID, (String)(personID = info.getPerson().getId().toString()), (String)(bizManageTypeID = info.getBizManageType().getId().toString()), (String)(hrOrgUnitID = info.getHrOrgUnit().getId().toString()), (String)"0,1")) {
                info.setState(BizManageState.New);
                info.setItemState(ItemState.unsubmit);
                boolean isDefault = SHRBizManageHelpUtil.isPerosnBuRelationDefault((Context)ctx, (String)info.getBizManageType().getId().toString(), (String)info.getEmpOrgRelation().getId().toString(), (String)info.getHrOrgUnit().getId().toString());
                info.setUseDefault(isDefault);
                if (info.getDataSource() == null) {
                    info.setDataSource(DataSource.ChangeOperation);
                }
                coll.add((CoreBaseInfo)info);
                continue;
            }
            String sql = "SELECT FID FROM T_HR_PersonBURelation WHERE FEmpOrgRelationID = '" + empOrgRelationID + "' AND FPERSONID = '" + personID + "' AND FBizManageTypeID = '" + bizManageTypeID + "' AND FHrOrgUnitID = '" + hrOrgUnitID + "' AND FState IN (0, 1)";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                while (executeQuery.next()) {
                    String id = executeQuery.getString("fid");
                    ObjectUuidPK objectPK = new ObjectUuidPK(id);
                    listObjectPK.add(objectPK);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        Object[] objectPkArr = PersonBURelationFactory.getLocalInstance((Context)ctx).addnewBatchData(coll);
        listObjectPK.addAll(Arrays.asList((Object[])objectPkArr));
        return listObjectPK.toArray(new IObjectPK[listObjectPK.size()]);
    }

    public List<BatchPromptsInfo> checkBeforeDeletePersonBizManageByPersonId(Context ctx, List<String> personIdList, String bizManageTypeId, boolean isEmpInitDelete) throws BOSException, EASBizException {
        ArrayList<BatchPromptsInfo> list = new ArrayList<BatchPromptsInfo>();
        int size = personIdList.size();
        for (int i = 0; i < size; ++i) {
            RecordDataInfo info = this.validator.deletePerson(ctx, personIdList.get(i));
            if (null == info || CmpStrUtil.isEmpty(info.getPersonId())) continue;
            BatchPromptsInfo param = new BatchPromptsInfo();
            param.setDomain(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label14", (Locale)ctx.getLocale()));
            param.setModules(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label15", (Locale)ctx.getLocale()));
            param.setPersonId(info.getPersonId());
            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.CmpCalLockResource", (String)"label16", (Locale)ctx.getLocale()));
            param.setDesc(info.getMsg());
            list.add(param);
        }
        return list;
    }

    public Map deletePersonBizManageByPersonId(Context ctx, List<String> personIdList, String bizManageTypeId, boolean isEmpInitDelete) throws BOSException, EASBizException {
        String personIds = CmpStrUtil.convertListToString(personIdList);
        String recordIdSql = "select fid from t_hr_ssocpersonrecord where FPersonId in (" + personIds + ")";
        AbstractRecord cmpRecord = RecordInstanceFactory.getRecordInstance(RecordInstanceFactory.CATEGORY.SOC);
        cmpRecord.deleteRecords(ctx, recordIdSql, true);
        super.deletePersonBizManageByPersonId(ctx, personIdList, bizManageTypeId, isEmpInitDelete);
        return null;
    }

    @Override
    public List<BatchPromptsInfo> checkRecoverEmpOrgRelation(Context ctx, List<String> empRelaIdList) throws BOSException, EASBizException {
        ArrayList<BatchPromptsInfo> list = new ArrayList<BatchPromptsInfo>();
        int size = empRelaIdList.size();
        for (int i = 0; i < size; ++i) {
            RocordValidatorInfo info = this.validator.deleteEmpRelation(ctx, empRelaIdList.get(i));
            if (null == info || null == info.getCode()) continue;
            BatchPromptsInfo param = new BatchPromptsInfo();
            param.setDomain(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label10", (Locale)ctx.getLocale()));
            param.setModules(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label8", (Locale)ctx.getLocale()));
            param.setPersonId(info.getCode());
            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label11", (Locale)ctx.getLocale()));
            param.setDesc(info.getMsg());
            list.add(param);
        }
        return list;
    }

    @Override
    public Map<String, String> recoverEmpOrgRelation(Context ctx, List<String> empRelaIdList) throws BOSException, EASBizException {
        for (int i = 0; i < empRelaIdList.size(); ++i) {
            String sql = SocRecordSQL.updateSocPayEmpState(1, empRelaIdList.get(i));
            CmpSQLUtil.execute(ctx, sql);
            this.socORelation.undoRelations(ctx, empRelaIdList.get(i));
        }
        return super.recoverEmpOrgRelation(ctx, empRelaIdList);
    }

    public List<BatchPromptsInfo> checkBeforeEnrollErrorModifyPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        empRelaIdList = this.getRecoverEmpOrgRelation(ctx, empRelaIdList);
        ArrayList<BatchPromptsInfo> list = new ArrayList<BatchPromptsInfo>();
        int size = empRelaIdList.size();
        for (int i = 0; i < size; ++i) {
            RocordValidatorInfo info = this.validator.deleteEmpRelation(ctx, empRelaIdList.get(i));
            if (null == info || null == info.getCode()) continue;
            BatchPromptsInfo param = new BatchPromptsInfo();
            param.setDomain(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label10", (Locale)ctx.getLocale()));
            param.setModules(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label8", (Locale)ctx.getLocale()));
            param.setPersonId(info.getCode());
            param.setOperation(EASResource.getString((String)"com.kingdee.shr.compensation.resource.MessageResource", (String)"label11", (Locale)ctx.getLocale()));
            param.setDesc(info.getMsg());
            list.add(param);
        }
        return list;
    }

    public Map<String, String> enrollErrorModifyPersonBizManageByBURelaDataId(Context ctx, List<String> empRelaIdList, List<String> personBURelaIdList, String bizManageTypeId) throws BOSException, EASBizException {
        String empIds = CmpStrUtil.convertListToString(empRelaIdList);
        String empSql = SocRecordSQL.getPBUIdByEmpORelation(empIds);
        IRowSet empRowSet = CmpSQLUtil.executeQuery(ctx, empSql);
        try {
            while (empRowSet.next()) {
                String empId = empRowSet.getString("FEmpOrgRelationID");
                String pbuId = "'" + empRowSet.getString("FPersonBURelId") + "'";
                String sql = SocRecordSQL.updateSocPayEmpState(1, empId);
                CmpSQLUtil.execute(ctx, sql);
                RecordUtil.updatePBUState(ctx, pbuId, 2, false);
                sql = SocRecordSQL.updateModifyEmp(empId);
                CmpSQLUtil.execute(ctx, sql);
            }
        }
        catch (SQLException e1) {
            e1.printStackTrace();
        }
        return null;
    }
}

