/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.secret;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.hr.util.HRParamUtil;
import com.kingdee.shr.compensation.exception.SecretException;
import com.kingdee.shr.compensation.secret.Resource;
import com.kingdee.shr.compensation.secret.Secret;
import com.kingdee.shr.compensation.secret.SecretFactory;
import java.io.InputStream;
import java.math.BigDecimal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecretUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.compensation.secret.SecretUtil");
    private static Secret secretObj = null;

    public static BigDecimal decode(Context ctx, BigDecimal decodeSource, String key) throws Exception {
        secretObj = SecretUtil.getSecretObj(ctx);
        return secretObj.decode(decodeSource, key);
    }

    public static double decode(Context ctx, double value, String key) throws Exception {
        return SecretUtil.decode(ctx, new BigDecimal(Double.toString(value)), key).doubleValue();
    }

    public static BigDecimal encode(Context ctx, BigDecimal encodeSource, String key) throws Exception {
        secretObj = SecretUtil.getSecretObj(ctx);
        return secretObj.encode(encodeSource, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Secret getSecretObj(Context ctx) throws Exception {
        InputStream resource = null;
        try {
            if (secretObj != null) {
                Secret secret = secretObj;
                return secret;
            }
            boolean isDataSecret = HRParamUtil.getParamOfHR((Context)ctx, (String)"hr_cmp_019", null);
            if (!isDataSecret) {
                throw new SecretException(SecretException.VALUEISNO);
            }
            DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            dFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            resource = new Resource().getResource();
            Document doc = builder.parse(resource);
            NodeList nl = doc.getElementsByTagName("className");
            Node classNode = nl.item(0).getFirstChild();
            String cName = classNode.getNodeValue();
            Class<?> c = Class.forName(cName);
            SecretFactory secretFactory = (SecretFactory)c.newInstance();
            if (secretFactory != null) {
                secretObj = secretFactory.getInstance();
            }
            Secret secret = secretObj;
            return secret;
        }
        catch (Exception e) {
            Class<?> c = Class.forName("com.kingdee.shr.compensation.secret.NoSecretFactory");
            Secret secret = secretObj = ((SecretFactory)c.newInstance()).getInstance();
            return secret;
        }
        finally {
            if (null != resource) {
                try {
                    resource.close();
                }
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                }
            }
        }
    }
}

