/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.tax.service;

import com.alibaba.fastjson.JSON;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.compensation.app.tax.TaxOptimizeCollection;
import com.kingdee.shr.compensation.app.tax.TaxOptimizeFactory;
import com.kingdee.shr.compensation.app.tax.TaxOptimizeInfo;
import com.kingdee.shr.compensation.tax.TaxExceptionEnum;
import com.kingdee.shr.compensation.tax.TaxUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxOptimizeService {
    private static Logger logger = Logger.getLogger(TaxOptimizeService.class);

    public String getSchemeList(Context ctx) throws Exception {
        ArrayList list = new ArrayList();
        String personId = TaxUtil.getPersonId(ctx);
        if (StringUtils.isEmpty((String)personId)) {
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getCode(), TaxExceptionEnum.BILL_KEY_INVALID.getMessage());
        }
        String ksql = " select id,state,taxYear,person.number,person.name,taxUnit.number,taxUnit.name,taxUnit.taxNumber where person.id = '" + personId + "' order by taxYear desc, state asc ";
        TaxOptimizeCollection coll = TaxOptimizeFactory.getLocalInstance(ctx).getTaxOptimizeCollection(ksql);
        TaxOptimizeInfo taxInfo = null;
        if (null != coll && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                taxInfo = coll.get(i);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("id", taxInfo.getId().toString());
                map.put("state", taxInfo.getState().getValue());
                map.put("taxYear", taxInfo.getTaxYear());
                map.put("personName", taxInfo.getPerson().getName());
                map.put("personNumber", taxInfo.getPerson().getNumber());
                map.put("taxUnitName", null == taxInfo.getTaxUnit() ? null : taxInfo.getTaxUnit().getName());
                map.put("taxUnitNumber", null == taxInfo.getTaxUnit() ? null : taxInfo.getTaxUnit().getNumber());
                map.put("taxNumber", null == taxInfo.getTaxUnit() ? null : taxInfo.getTaxUnit().getTaxNumber());
                list.add(map);
            }
        }
        return TaxUtil.success(ctx, list);
    }

    public String getSchemeDetail(Context ctx, String billId) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String ctxPersonId = TaxUtil.getPersonId(ctx);
        if (StringUtils.isEmpty((String)ctxPersonId) || StringUtils.isEmpty((String)billId)) {
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getCode(), TaxExceptionEnum.BILL_KEY_INVALID.getMessage());
        }
        String ksql = "select id,state,taxYear,person.number,person.name,taxUnit.number,taxUnit.name,taxUnit.taxNumber, annualBonus,taxIncome,taxScheme, taxBonus,bonusToPay,taxSum,salarySumImp,speSumImp,socSumImp,fundSumImp,basicSumImp,salarySumConf,speSumConf,socSumConf,fundSumConf,basicSumConf,otherIncome,laborIncome,remuneration,royalties,otherDeduction,fundTax where id = '" + billId + "' and person = '" + ctxPersonId + "'";
        TaxOptimizeCollection coll = TaxOptimizeFactory.getLocalInstance(ctx).getTaxOptimizeCollection(ksql);
        TaxOptimizeInfo taxInfo = null;
        if (null != coll && coll.size() > 0) {
            taxInfo = coll.get(0);
            String personId = null == taxInfo.getPerson() ? null : taxInfo.getPerson().getId().toString();
            map.put("id", taxInfo.getId().toString());
            map.put("state", null == taxInfo.getState() ? null : Integer.valueOf(taxInfo.getState().getValue()));
            map.put("taxYear", taxInfo.getTaxYear());
            map.put("personId", personId);
            map.put("personName", null == taxInfo.getPerson() ? null : taxInfo.getPerson().getName());
            map.put("personNumber", null == taxInfo.getPerson() ? null : taxInfo.getPerson().getNumber());
            map.put("taxUnitName", null == taxInfo.getTaxUnit() ? null : taxInfo.getTaxUnit().getName());
            map.put("taxUnitNumber", null == taxInfo.getTaxUnit() ? null : taxInfo.getTaxUnit().getNumber());
            map.put("taxNumber", null == taxInfo.getTaxUnit() ? null : taxInfo.getTaxUnit().getTaxNumber());
            map.put("annualBonus", null == taxInfo.getAnnualBonus() ? null : Double.valueOf(taxInfo.getAnnualBonus().doubleValue()));
            map.put("taxIncome", null == taxInfo.getTaxIncome() ? null : Double.valueOf(taxInfo.getTaxIncome().doubleValue()));
            map.put("taxScheme", null == taxInfo.getTaxScheme() ? null : taxInfo.getTaxScheme().getValue());
            map.put("taxBonus", null == taxInfo.getTaxBonus() ? null : Double.valueOf(taxInfo.getTaxBonus().doubleValue()));
            map.put("bonusToPay", null == taxInfo.getBonusToPay() ? null : Double.valueOf(taxInfo.getBonusToPay().doubleValue()));
            map.put("taxSum", null == taxInfo.getTaxSum() ? null : Double.valueOf(taxInfo.getTaxSum().doubleValue()));
            map.put("salarySumImp", null == taxInfo.getSalarySumImp() ? null : Double.valueOf(taxInfo.getSalarySumImp().doubleValue()));
            map.put("speSumImp", null == taxInfo.getSpeSumImp() ? null : Double.valueOf(taxInfo.getSpeSumImp().doubleValue()));
            map.put("socSumImp", null == taxInfo.getSocSumImp() ? null : Double.valueOf(taxInfo.getSocSumImp().doubleValue()));
            map.put("fundSumImp", null == taxInfo.getFundSumImp() ? null : Double.valueOf(taxInfo.getFundSumImp().doubleValue()));
            map.put("basicSumImp", null == taxInfo.getBasicSumImp() ? null : Double.valueOf(taxInfo.getBasicSumImp().doubleValue()));
            map.put("salarySumConf", null == taxInfo.getSalarySumConf() ? null : Double.valueOf(taxInfo.getSalarySumConf().doubleValue()));
            map.put("speSumConf", null == taxInfo.getSpeSumConf() ? null : Double.valueOf(taxInfo.getSpeSumConf().doubleValue()));
            map.put("socSumConf", null == taxInfo.getSocSumConf() ? null : Double.valueOf(taxInfo.getSocSumConf().doubleValue()));
            map.put("fundSumConf", null == taxInfo.getFundSumConf() ? null : Double.valueOf(taxInfo.getFundSumConf().doubleValue()));
            map.put("basicSumConf", null == taxInfo.getBasicSumConf() ? null : Double.valueOf(taxInfo.getBasicSumConf().doubleValue()));
            map.put("otherIncome", null == taxInfo.getOtherIncome() ? null : Double.valueOf(taxInfo.getOtherIncome().doubleValue()));
            map.put("laborIncome", null == taxInfo.getLaborIncome() ? null : Double.valueOf(taxInfo.getLaborIncome().doubleValue()));
            map.put("remuneration", null == taxInfo.getRemuneration() ? null : Double.valueOf(taxInfo.getRemuneration().doubleValue()));
            map.put("royalties", null == taxInfo.getRoyalties() ? null : Double.valueOf(taxInfo.getRoyalties().doubleValue()));
            map.put("otherDeduction", null == taxInfo.getOtherDeduction() ? null : Double.valueOf(taxInfo.getOtherDeduction().doubleValue()));
            map.put("fundTax", null == taxInfo.getFundTax() ? null : Double.valueOf(taxInfo.getFundTax().doubleValue()));
        }
        return TaxUtil.success(ctx, map);
    }

    public String saveInfo(Context ctx, String jsonParam) throws Exception {
        Map map = (Map)JSON.parse((String)jsonParam);
        if (map.get("id") == null || StringUtils.isEmpty((String)map.get("id").toString())) {
            return TaxUtil.error(ctx, TaxExceptionEnum.BILL_KEY_INVALID.getCode(), TaxExceptionEnum.BILL_KEY_INVALID.getMessage());
        }
        String billId = map.get("id").toString();
        BigDecimal taxIncome = null;
        String taxScheme = "1";
        BigDecimal taxBonus = null;
        BigDecimal bonusToPay = null;
        BigDecimal taxSum = null;
        BigDecimal salarySumConf = null;
        BigDecimal speSumConf = null;
        BigDecimal socSumConf = null;
        BigDecimal fundSumConf = null;
        BigDecimal basicSumConf = null;
        BigDecimal otherIncome = null;
        BigDecimal laborIncome = null;
        BigDecimal remuneration = null;
        BigDecimal royalties = null;
        BigDecimal otherDeduction = null;
        BigDecimal fundTax = null;
        try {
            taxIncome = this.getRealValue4Save(map.get("taxIncome"));
            taxScheme = null == map.get("taxScheme") ? "1" : map.get("taxScheme").toString();
            taxBonus = this.getRealValue4Save(map.get("taxBonus"));
            bonusToPay = this.getRealValue4Save(map.get("bonusToPay"));
            taxSum = this.getRealValue4Save(map.get("taxSum"));
            salarySumConf = this.getRealValue4Save(map.get("salarySumConf"));
            speSumConf = this.getRealValue4Save(map.get("speSumConf"));
            socSumConf = this.getRealValue4Save(map.get("socSumConf"));
            fundSumConf = this.getRealValue4Save(map.get("fundSumConf"));
            basicSumConf = this.getRealValue4Save(map.get("basicSumConf"));
            otherIncome = this.getRealValue4Save(map.get("otherIncome"));
            laborIncome = this.getRealValue4Save(map.get("laborIncome"));
            remuneration = this.getRealValue4Save(map.get("remuneration"));
            royalties = this.getRealValue4Save(map.get("royalties"));
            otherDeduction = this.getRealValue4Save(map.get("otherDeduction"));
            fundTax = this.getRealValue4Save(map.get("fundTax"));
        }
        catch (Exception e1) {
            logger.error((Object)e1.getMessage(), (Throwable)e1);
            TaxUtil.error(ctx, TaxExceptionEnum.INVALID_DATA.getCode(), TaxExceptionEnum.INVALID_DATA.getMessage());
            throw e1;
        }
        StringBuffer sqlBuf = new StringBuffer();
        sqlBuf.append("update T_HR_STaxOptimize set ");
        sqlBuf.append("FState=1, ").append("FTaxIncome=").append(taxIncome).append(", ").append("FTaxScheme='").append(taxScheme).append("', ").append("FTaxBonus=").append(taxBonus).append(", ").append("FBonusToPay=").append(bonusToPay).append(", ").append("FTaxSum=").append(taxSum).append(", ").append("FSalarySumConf=").append(salarySumConf).append(", ").append("FSpeSumConf=").append(speSumConf).append(", ").append("FSocSumConf=").append(socSumConf).append(", ").append("FundSumConf=").append(fundSumConf).append(", ").append("FBasicSumConf=").append(basicSumConf).append(", ").append("FOtherIncome=").append(otherIncome).append(", ").append("FLaborIncome=").append(laborIncome).append(", ").append("FRemuneration=").append(remuneration).append(", ").append("FRoyalties=").append(royalties).append(", ").append("FOtherDeduction=").append(otherDeduction).append(", ").append("FundTax=").append(fundTax).append(" ");
        sqlBuf.append("where FID='" + billId + "'");
        try {
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            TaxUtil.error(ctx, TaxExceptionEnum.UPDATE_ERROR.getCode(), TaxExceptionEnum.UPDATE_ERROR.getMessage());
            throw e;
        }
        return TaxUtil.success(ctx, billId);
    }

    private BigDecimal getRealValue4Save(Object value) throws Exception {
        String realValue = null == value ? null : value.toString();
        String string = realValue = StringUtils.isEmpty((String)realValue) ? null : realValue;
        if (null == realValue) {
            return null;
        }
        BigDecimal result = new BigDecimal(realValue);
        return result;
    }
}

