/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.compensation.util.pdf;

import com.kingdee.shr.compensation.util.pdf.Html2PdfConverter;
import com.kingdee.shr.compensation.util.pdf.StyleExtractor;
import com.lowagie.text.Cell;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Table;
import com.lowagie.text.alignment.HorizontalAlignment;
import com.lowagie.text.alignment.VerticalAlignment;
import com.lowagie.text.pdf.BaseFont;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PdfTableHelper {
    protected Html2PdfConverter html2PdfConverter;
    public static final String tdTag = "<td*?([\\s\\S]*?)>";
    public static final String tdReg = "<td*?([\\s\\S]*?)>([\\s\\S]*?)</td>";
    public static final String thTag = "<th*?([\\s\\S]*?)>";
    public static final String thReg = "<th*?([\\s\\S]*?)>([\\s\\S]*?)</th>";
    public static final String trReg = "<tr*?([\\s\\S]*?)>([\\s\\S]*?)</tr>";
    public static final String tableTag = "<table*?([\\s\\S]*?)>";
    public static final Pattern tdRegPattern = Pattern.compile("<td*?([\\s\\S]*?)>([\\s\\S]*?)</td>");
    public static final Pattern tdTagPattern = Pattern.compile("<td*?([\\s\\S]*?)>");
    public static final Pattern thTagPattern = Pattern.compile("<th*?([\\s\\S]*?)>");
    public static final Pattern thRegPattern = Pattern.compile("<th*?([\\s\\S]*?)>([\\s\\S]*?)</th>");
    public static final Pattern trRegPattern = Pattern.compile("<tr*?([\\s\\S]*?)>([\\s\\S]*?)</tr>");
    public static final Pattern tableTagPattern = Pattern.compile("<table*?([\\s\\S]*?)>");
    public static final Pattern paragraphPattern = Html2PdfConverter.paragraphPattern;

    public PdfTableHelper(Html2PdfConverter html2PdfConverter) {
        this.html2PdfConverter = html2PdfConverter;
    }

    public Table createTable(String tableHtml) throws IOException {
        ArrayList rowList = new ArrayList();
        Matcher rowMatcher = trRegPattern.matcher(tableHtml);
        while (rowMatcher.find()) {
            String row = rowMatcher.group();
            int rowIndex = row.indexOf("<tr");
            Matcher columnMatcher = (row = row.substring(rowIndex)).contains("<th") ? thRegPattern.matcher(row) : tdRegPattern.matcher(row);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (columnMatcher.find()) {
                String cellHtml = columnMatcher.group(0);
                int tdIndex = cellHtml.contains("<td") ? cellHtml.indexOf("<td") : cellHtml.indexOf("<th");
                cellHtml = cellHtml.substring(tdIndex);
                arrayList.add(cellHtml);
            }
            rowList.add(arrayList);
        }
        Table table = new Table(((List)rowList.get(0)).size());
        Matcher tableTagMatch = tableTagPattern.matcher(tableHtml);
        if (tableTagMatch.find()) {
            this.addTableStyle(table, tableTagMatch.group(0));
        }
        for (List list : rowList) {
            for (String column : list) {
                String tag = "";
                String cellContent = "";
                if (column.contains("<td")) {
                    Matcher tdTagMatcher = tdTagPattern.matcher(column);
                    if (tdTagMatcher.find()) {
                        tag = tdTagMatcher.group(0);
                    }
                    cellContent = column.substring(column.indexOf(tag), column.indexOf("</td>"));
                } else {
                    Matcher thTagMatcher = thTagPattern.matcher(column);
                    if (thTagMatcher.find()) {
                        tag = thTagMatcher.group(0);
                    }
                    cellContent = column.substring(column.indexOf(tag), column.indexOf("</th>"));
                }
                Cell cell = this.createCellAndAddStyle(tag);
                Matcher pMatcher = paragraphPattern.matcher(cellContent);
                boolean flag = true;
                while (pMatcher.find()) {
                    flag = false;
                    String paragraph = pMatcher.group(0);
                    int pIdx = paragraph.indexOf("<p");
                    paragraph = paragraph.substring(pIdx);
                    ArrayList<String> tagPairs = new ArrayList<String>();
                    Matcher innerTagMatcher = Html2PdfConverter.tagPattern.matcher(paragraph);
                    while (innerTagMatcher.find()) {
                        String contentTag = innerTagMatcher.group();
                        if ("<br/>".equalsIgnoreCase(contentTag)) continue;
                        tagPairs.add(contentTag);
                    }
                    Paragraph para = this.html2PdfConverter.resolveAndRender(paragraph, tagPairs, null);
                    if (para.getAlignment() == 1) {
                        cell.setHorizontalAlignment(HorizontalAlignment.CENTER);
                    } else if (para.getAlignment() == 0) {
                        cell.setHorizontalAlignment(HorizontalAlignment.LEFT);
                    } else if (para.getAlignment() == 2) {
                        cell.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                    }
                    cell.setVerticalAlignment(VerticalAlignment.CENTER);
                    cell.add((Element)para);
                }
                if (flag) {
                    BaseFont baseFont = this.html2PdfConverter.getBaseFont("");
                    Font font = new Font(baseFont);
                    cell.add((Element)new Paragraph(cellContent, font));
                }
                table.addCell(cell);
            }
        }
        return table;
    }

    protected Cell createCellAndAddStyle(String tdTag) {
        String[] strArr;
        Cell cell = new Cell();
        if (tdTag.contains("style")) {
            String[] styleDetails;
            Matcher styleMatch = StyleExtractor.stylePattern.matcher(tdTag);
            String styleAttr = "";
            if (styleMatch.find()) {
                styleAttr = styleMatch.group();
            }
            String[] styleArr = styleAttr.split("=");
            String styles = styleArr[1].replace("\"", "").trim();
            block18: for (String styleDetail : styleDetails = styles.split(";")) {
                String[] styleContents = styleDetail.split(":");
                String key = styleContents[0].trim();
                String val = styleContents[1].trim();
                switch (key) {
                    case "border": {
                        String[] borderAttrs = val.split(" ");
                        cell.setBorderWidth(Float.parseFloat(borderAttrs[0].replace("px", "")));
                        continue block18;
                    }
                    case "border-top": {
                        String[] borderAttrs;
                        if (!val.contains("none")) {
                            borderAttrs = val.split(" ");
                            cell.setBorderWidthTop(Float.parseFloat(borderAttrs[0].replace("px", "")));
                            continue block18;
                        }
                    }
                    case "border-right": {
                        String[] borderAttrs;
                        if (!val.contains("none")) {
                            borderAttrs = val.split(" ");
                            cell.setBorderWidthRight(Float.parseFloat(borderAttrs[0].replace("px", "")));
                            continue block18;
                        }
                    }
                    case "border-bottom": {
                        String[] borderAttrs;
                        if (!val.contains("none")) {
                            borderAttrs = val.split(" ");
                            cell.setBorderWidthBottom(Float.parseFloat(borderAttrs[0].replace("px", "")));
                            continue block18;
                        }
                    }
                    case "border-left": {
                        String[] borderAttrs;
                        if (!val.contains("none")) {
                            borderAttrs = val.split(" ");
                            cell.setBorderWidthLeft(Float.parseFloat(borderAttrs[0].replace("px", "")));
                            continue block18;
                        }
                    }
                    case "padding": {
                        cell.setUseBorderPadding(true);
                        continue block18;
                    }
                    case "background": {
                        String[] rgb = StyleExtractor.getRGBArr(val);
                        cell.setBackgroundColor(new Color(Integer.parseInt(rgb[0].trim()), Integer.parseInt(rgb[1].trim()), Integer.parseInt(rgb[2].trim())));
                    }
                }
            }
            tdTag = tdTag.replace(styleAttr, "");
        }
        for (String str : strArr = tdTag.split(" ")) {
            if (str.contains("valign")) {
                String[] valignArr = str.split("=");
                String valign = valignArr[1].replace("\"", "").replace(">", "").trim();
                if ("top".equalsIgnoreCase(valign)) {
                    cell.setVerticalAlignment(VerticalAlignment.TOP);
                    continue;
                }
                if ("bottom".equalsIgnoreCase(valign)) {
                    cell.setVerticalAlignment(VerticalAlignment.BOTTOM);
                    continue;
                }
                if ("left".equalsIgnoreCase(valign)) {
                    cell.setHorizontalAlignment(HorizontalAlignment.LEFT);
                    continue;
                }
                if ("right".equalsIgnoreCase(valign)) {
                    cell.setHorizontalAlignment(HorizontalAlignment.RIGHT);
                    continue;
                }
                if (!"center".equalsIgnoreCase(valign)) continue;
                cell.setHorizontalAlignment(HorizontalAlignment.CENTER);
                cell.setVerticalAlignment(VerticalAlignment.CENTER);
                continue;
            }
            if (!str.contains("width")) continue;
            String[] widthArr = str.split("=");
            String width = widthArr[1].replace("\"", "").replace(">", "").trim();
            cell.setWidth(Float.parseFloat(width));
        }
        return cell;
    }

    protected void addTableStyle(Table table, String content) {
        String[] strArr;
        for (String str : strArr = content.split(" ")) {
            if (str.contains("cellspacing")) {
                String[] cellSpacingArr = str.split("=");
                String cellSpacing = cellSpacingArr[1].replace("\"", "").replace(">", "");
                table.setSpacing(Float.parseFloat(cellSpacing));
                continue;
            }
            if (str.contains("cellpadding")) {
                String[] cellPaddingArr = str.split("=");
                String cellPadding = cellPaddingArr[1].replace("\"", "").replace(">", "");
                table.setPadding(Float.parseFloat(cellPadding));
                continue;
            }
            if (!str.contains("width")) continue;
            String[] widthArr = str.split("=");
            String width = widthArr[1].replace("\"", "").replace(">", "");
            table.setWidth(Float.parseFloat(width));
        }
    }
}

