/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.db.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.domain.db.AbstractDBSourceJDBCAdapter;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.DBSource;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.data.model.vo.FolderNode;
import java.sql.Connection;
import java.sql.SQLException;

public class DB2SourceJDBCAdapter
extends AbstractDBSourceJDBCAdapter {
    public static final String URL_TEMPLATE = "jdbc:db2://%s:%s/%s:currentSchema=%s;retrieveMessagesFromServerOnGetMessage=true;";
    public static final String DRIVER = "com.ibm.db2.jcc.DB2Driver";

    private DB2SourceJDBCAdapter() {
    }

    public static AbstractDBSourceJDBCAdapter newInstance() {
        return new DB2SourceJDBCAdapter();
    }

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        FolderNode root = new FolderNode();
        DBSource dataBase = (DBSource)source;
        String sql = "select name from sysibm.systables where  type='T' or type='V'";
        this.queryTableLeafNodes(ctx, root, dataBase, sql, null);
        return root;
    }

    @Override
    public String getJDBCUrl(DBSource dataBase) {
        return String.format(URL_TEMPLATE, dataBase.getDbAddress(), dataBase.getDbPort(), dataBase.getDbName(), dataBase.getSchema());
    }

    @Override
    public String getDriverClassName() {
        return DRIVER;
    }

    @Override
    protected void setConnectionAttribute(DBSource dataBase, Connection connection) throws SQLException {
        connection.setReadOnly(true);
        connection.setAutoCommit(true);
    }
}

