/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.imp;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.view.IBriefViewTreeNode;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SubSystemUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.base.syssetting.util.SysSettingSHRBaseItemUtil;
import com.kingdee.shr.common.util.CloseUtil;
import com.kingdee.shr.data.domain.imp.AbstractMetaSourceDomain;
import com.kingdee.shr.data.domain.util.DataTypeUtil;
import com.kingdee.shr.data.model.designtime.AbstractSource;
import com.kingdee.shr.data.model.designtime.source.MetaSource;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.data.model.runtime.EntityField;
import com.kingdee.shr.data.model.runtime.FieldParam;
import com.kingdee.shr.data.model.runtime.Item;
import com.kingdee.shr.data.model.vo.AbstractNode;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.util.DataSetUtils;
import com.kingdee.util.StringUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntitySourceDomain
extends AbstractMetaSourceDomain {
    private static Logger logger = Logger.getLogger(EntitySourceDomain.class);
    private static final String NAME = "name";

    @Override
    public AbstractNode getUsableEntities(Context ctx, AbstractSource source) throws BOSException, EASBizException {
        IBriefViewTreeNode rootNode;
        String key = DataplatformCacheHelper.getRealKey(ctx, "DATAPLATFORM_DATASET_ENTITY_TREE");
        AbstractNode rootMetaNode = (AbstractNode)DataplatformCacheHelper.get(ctx, 4, key);
        if (rootMetaNode == null && null != (rootMetaNode = this.convertToShrNode(rootNode = this.getEntityTreeRootNode(ctx), MetaSource.MetaType.SHREntity.name()))) {
            DataplatformCacheHelper.set(ctx, 4, key, rootMetaNode);
        }
        return rootMetaNode;
    }

    @Override
    public Map<String, Object> getEntityPeer(Context ctx, String entityName) throws BOSException, EASBizException {
        HashMap<String, Object> entityInfoMap = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)entityName)) {
            EntityObjectInfo entityInfo = null;
            try {
                entityInfo = BaseMetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)entityName);
                if (entityInfo != null) {
                    entityInfoMap.put("entityName", entityInfo.getAlias(ctx.getLocale()));
                    entityInfoMap.put(NAME, entityInfo.getName());
                    entityInfoMap.put("description", entityInfo.getDescription());
                    entityInfoMap.put("fullName", entityInfo.getFullName());
                }
                List<EntityField> entityPropertyInfo = this.getEntityPropertyInfo(ctx, entityName);
                entityInfoMap.put("fields", entityPropertyInfo);
            }
            catch (Exception e) {
                entityInfoMap = null;
            }
        }
        return entityInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Item> getDataByField(Context ctx, AbstractSource source, FieldParam field) throws BOSException, EASBizException {
        ArrayList<Item> list = new ArrayList<Item>();
        String dataType = field.getDataType();
        if (DataType.ENUM.name().equalsIgnoreCase(dataType)) {
            EntitySourceDomain.getSelectEnumData(ctx, list, field.getTableName());
            if (list.isEmpty()) {
                throw new DataSetException(DataSetException.ERROR_CLASSNAME_ENUM_EXCEPTION);
            }
            return list;
        }
        if (DataType.BOOLEAN.name().equalsIgnoreCase(dataType)) {
            Map<String, String> map = DataSetUtils.getBooleanData(ctx);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Item item = new Item();
                item.setAlias(entry.getValue());
                item.setValue(entry.getKey());
                list.add(item);
            }
            return list;
        }
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)this.getMakeSql(ctx, field));
            while (rs.next()) {
                if (null == rs.getObject(1)) continue;
                Item item = new Item();
                item.setAlias(null != rs.getObject(1) ? rs.getObject(1).toString() : "");
                item.setValue(null != rs.getObject(2) ? rs.getObject(2) : null);
                list.add(item);
            }
        }
        catch (SQLException e) {
            block9: {
                try {
                    if (e.getMessage().indexOf("Invalid column index") > -1) break block9;
                    throw new BOSException(e.getMessage(), (Throwable)e);
                }
                catch (Throwable throwable) {
                    CloseUtil.close(rs);
                    throw throwable;
                }
            }
            CloseUtil.close((ResultSet)rs);
        }
        CloseUtil.close((ResultSet)rs);
        return list;
    }

    private String getMakeSql(Context ctx, FieldParam field) throws BOSException, EASBizException {
        String sql = "";
        IDataProvider exec = null;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setIngorePreOrders(true);
        boolean isDisplayName = field.getTableName().indexOf(";") != -1;
        String[] tts = null;
        String tableName = field.getTableName();
        if (isDisplayName) {
            tts = field.getTableName().split(";");
            tableName = tts[0];
        }
        if (BaseMetaDataUtil.isEntityNonExists((Context)ctx, (String)tableName)) {
            throw new DataSetException(DataSetException.ERROR_CLASSNAME_ENTITY_EXCEPTION);
        }
        SelectorItemCollection coll = new SelectorItemCollection();
        String displayname = NAME;
        if (isDisplayName && null != tts && !StringUtils.isEmpty((String)tts[1])) {
            boolean isKeyValue;
            boolean bl = isKeyValue = tts[1].indexOf("=") != -1;
            if (isKeyValue) {
                String[] dds = tts[1].split("=");
                if (!StringUtils.isEmpty((String)dds[1])) {
                    displayname = dds[1];
                } else if (!StringUtils.isEmpty((String)field.getField())) {
                    displayname = field.getField();
                }
            } else if (!StringUtils.isEmpty((String)field.getField())) {
                displayname = field.getField();
            }
        } else if (!StringUtils.isEmpty((String)field.getField())) {
            displayname = field.getField();
        }
        coll.add(displayname);
        if (DataType.F7.name().equalsIgnoreCase(field.getDataType())) {
            coll.add("id");
            entityViewInfo.setFilter(this.getFilterInfoByHrOrAdmainOrg(ctx, tableName, field.getPermItem()));
        }
        try {
            if (SysSettingSHRBaseItemUtil.isSHRBaseItem((Context)ctx, (String)tableName) && !StringUtils.isEmpty((String)field.getQuery())) {
                coll = new SelectorItemCollection();
                coll.add(MessageFormat.format("BaseInfo.{0}", displayname));
                coll.add("BaseInfo.id");
                entityViewInfo.setSelector(coll);
                entityViewInfo.setFilter(this.getFilterInfoByBasicItem(ctx, tableName, field.getPermItem()));
                String query = field.getQuery();
                exec = this.getQueryExecutor(ctx, entityViewInfo, query);
            } else {
                exec = super.getMetaExecutor(ctx, tableName);
                PropertyInfo propertyInfo = BaseMetaDataUtil.getPropertyInfo((Context)ctx, (String)tableName, (String)displayname);
                if (null == propertyInfo && DataType.F7.name().equalsIgnoreCase(field.getDataType())) {
                    coll = new SelectorItemCollection();
                    coll.add("id");
                }
                entityViewInfo.setSelector(coll);
                exec.setObjectView(entityViewInfo);
            }
            sql = exec.getSQL().replace("SELECT", "SELECT DISTINCT");
        }
        catch (BOSException e) {
            logger.error((Object)("EntitySourceDomain.getMakeSql : " + sql));
        }
        return sql;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, EntityViewInfo entityViewInfo, String query) {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)MetaDataPK.create((String)query));
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        return exec;
    }

    private List<EntityField> getEntityPropertyInfo(Context ctx, String entityName) throws EASBizException {
        ArrayList<EntityField> propertylist = new ArrayList<EntityField>();
        Map properties = BaseMetaDataUtil.getProperties((Context)ctx, (String)entityName);
        if (properties.size() <= 0) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("{0}:{1}", "entityName", entityName)});
        }
        for (Map.Entry entry : properties.entrySet()) {
            EntityField field = new EntityField();
            String key = (String)entry.getKey();
            PropertyInfo propertyInfo = (PropertyInfo)entry.getValue();
            if (null == propertyInfo || null == propertyInfo.getMappingField()) continue;
            DataType dataType = null;
            DataType.DataTypeTran dataTypeTran = null;
            if (propertyInfo instanceof LinkPropertyInfo) {
                LinkPropertyInfo linkProp = (LinkPropertyInfo)propertyInfo;
                RelationshipInfo relationship = linkProp.getRelationship();
                EntityObjectInfo supplierObject = relationship.getSupplierObject();
                field.setSource(supplierObject.getFullName());
                dataType = DataType.F7;
            }
            if (propertyInfo instanceof OwnPropertyInfo) {
                OwnPropertyInfo ownProp = (OwnPropertyInfo)propertyInfo;
                dataType = EntitySourceDomain.toDataType(ownProp.getDataType().getName());
                if (DataType.ENUM.name().equalsIgnoreCase(ownProp.getDataType().getName())) {
                    dataTypeTran = DataTypeUtil.parseDataTypeTran(EntitySourceDomain.toEnumType(ownProp.getMetaDataRef()));
                    field.setSource(ownProp.getMetaDataRef());
                }
            }
            if (!DataType.ENUM.equals((Object)dataType)) {
                dataTypeTran = DataTypeUtil.parseDataTypeTran(dataType);
            }
            field.setName(key);
            field.setDisplayName(this.getAlias(propertyInfo));
            field.setDescription(this.getDescription(propertyInfo));
            field.setDataType(dataType);
            field.setDataTypeTran(dataTypeTran);
            propertylist.add(field);
        }
        return propertylist;
    }

    private Map<String, String> getDescription(PropertyInfo propertyInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> mul = DataSetUtils.getSupportLangue();
        for (int i = 0; i < mul.size(); ++i) {
            map.put(mul.get(i), propertyInfo.getDescription(new Locale(mul.get(i))));
        }
        return map;
    }

    private Map<String, String> getAlias(PropertyInfo propertyInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> mul = DataSetUtils.getSupportLangue();
        for (int i = 0; i < mul.size(); ++i) {
            map.put(mul.get(i), propertyInfo.getAlias(new Locale(mul.get(i))));
        }
        return map;
    }

    private FilterInfo getFilterInfoByBasicItem(Context ctx, String tableName, String permItem) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if (SysSettingSHRBaseItemUtil.isSHRBaseItem((Context)ctx, (String)tableName)) {
            filter.getFilterItems().add(new FilterItemInfo("BaseInfo.state", (Object)1, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("state", (Object)100, CompareType.EQUALS));
            FilterInfo filter0 = new FilterInfo();
            filter0.getFilterItems().add(new FilterItemInfo("id", (Object)permItem));
            filter0.getFilterItems().add(new FilterItemInfo("orgRelation", (Object)16));
            if (PermItemFactory.getLocalInstance((Context)ctx).exists(filter0)) {
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                String compareValue = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)user.getId().toString(), (String)permItem);
                filter.getFilterItems().add(new FilterItemInfo("hrOrgUse.id", (Object)compareValue, CompareType.INNER));
            }
        } else {
            return null;
        }
        return filter;
    }

    private FilterInfo getFilterInfoByHrOrAdmainOrg(Context ctx, String tableName, String permItem) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        if ("com.kingdee.eas.basedata.org.app.HROrgUnit".equals(tableName)) {
            FilterInfo filter0 = new FilterInfo();
            filter0.getFilterItems().add(new FilterItemInfo("id", (Object)permItem));
            filter0.getFilterItems().add(new FilterItemInfo("orgRelation", (Object)16));
            if (PermItemFactory.getLocalInstance((Context)ctx).exists(filter0)) {
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                String compareValue = SHRUserOrgPermissionApi.getUserHROrgRangeInSQL((Context)ctx, (String)user.getId().toString(), (String)permItem);
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)compareValue, CompareType.INNER));
            }
        } else if ("com.kingdee.eas.basedata.org.app.AdminOrgUnit".equals(tableName)) {
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            String compareValue = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)user.getId().toString(), (String)permItem);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)compareValue, CompareType.INNER));
        } else {
            return null;
        }
        return filter;
    }

    private IBriefViewTreeNode getEntityTreeRootNode(Context ctx) {
        return SubSystemUtils.getSubSystemByName((Context)ctx, (String)"com_kingdee_eas_base_subsystemEntity", (BOSObjectType[])new BOSObjectType[]{MetaDataTypeList.ENTITY});
    }
}

