/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.data.domain.service;

import com.kingdee.bos.BOSException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;

public class JDBCConnectionPool {
    private static GenericKeyedObjectPool pool;

    public static Connection getConnectionFromPool(JDBCModel jdbcModel) throws BOSException {
        try {
            return (Connection)pool.borrowObject((Object)jdbcModel);
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
    }

    public static Connection createConnection(JDBCModel jdbcModel) throws SQLException {
        String driverClassName;
        String connectUrl = jdbcModel.getConnectUrl();
        Properties info = new Properties();
        String userName = jdbcModel.getUserName();
        String password = jdbcModel.getPassword();
        if (userName != null) {
            info.put("user", userName);
        }
        if (password != null) {
            info.put("password", password);
        }
        if (jdbcModel.getProperties() != null) {
            info.putAll(jdbcModel.getProperties());
        }
        if ((driverClassName = jdbcModel.getDriverClassName()) != null) {
            try {
                Class.forName(driverClassName);
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage(), e);
            }
        }
        Driver driver = DriverManager.getDriver(connectUrl);
        return driver.connect(connectUrl, info);
    }

    static {
        GenericKeyedObjectPool.Config config = new GenericKeyedObjectPool.Config();
        config.maxActive = Integer.MAX_VALUE;
        config.maxIdle = 15;
        config.maxWait = 1000L;
        config.minEvictableIdleTimeMillis = 30000L;
        config.timeBetweenEvictionRunsMillis = 10000L;
        config.numTestsPerEvictionRun = Integer.MAX_VALUE;
        pool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new ConnectionKeyedPoolableObjectFactory(), config);
    }

    public static class JDBCModel {
        private Integer hashCode;
        private String connectUrl;
        private String driverClassName;
        private String userName;
        private String password;
        private Map<String, String> properties;

        public JDBCModel(String driverClassName, String connectUrl, String userName, String password) {
            this.driverClassName = driverClassName;
            this.connectUrl = connectUrl;
            this.userName = userName;
            this.password = password;
        }

        public String getDriverClassName() {
            return this.driverClassName;
        }

        public String getConnectUrl() {
            return this.connectUrl;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public int hashCode() {
            if (this.hashCode == null) {
                this.hashCode = 0;
                this.hashCode = this.hashCode * 31 + (this.driverClassName == null ? "" : this.driverClassName).hashCode();
                this.hashCode = this.hashCode * 31 + (this.connectUrl == null ? "" : this.connectUrl).hashCode();
                this.hashCode = this.hashCode * 31 + (this.userName == null ? "" : this.userName).hashCode();
                this.hashCode = this.hashCode * 31 + (this.password == null ? "" : this.password).hashCode();
            }
            return this.hashCode;
        }

        public boolean equals(Object another) {
            if (!(another instanceof JDBCModel)) {
                return false;
            }
            JDBCModel anotherJDBCModel = (JDBCModel)another;
            if (!this.equal(this.driverClassName, anotherJDBCModel.getDriverClassName())) {
                return false;
            }
            if (!this.equal(this.connectUrl, anotherJDBCModel.getConnectUrl())) {
                return false;
            }
            if (!this.equal(this.userName, anotherJDBCModel.getUserName())) {
                return false;
            }
            return this.equal(this.password, anotherJDBCModel.getPassword());
        }

        private boolean equal(Object member, Object anotherMember) {
            return !(member == null ? anotherMember != null : !member.equals(anotherMember));
        }
    }

    private static class ConnectionKeyedPoolableObjectFactory
    extends BaseKeyedPoolableObjectFactory {
        private ConnectionKeyedPoolableObjectFactory() {
        }

        public Object makeObject(Object jdbcModel) throws Exception {
            Connection connection;
            try {
                connection = JDBCConnectionPool.createConnection((JDBCModel)jdbcModel);
            }
            catch (SQLException e) {
                return new JDBCPooledConnection((JDBCModel)jdbcModel, e);
            }
            return new JDBCPooledConnection((JDBCModel)jdbcModel, connection);
        }
    }

    public static class JDBCPooledConnection
    implements Connection {
        private JDBCModel jdbcModel;
        private Connection rawConnection;
        private SQLException exception;

        public JDBCPooledConnection(JDBCModel jdbcModel, SQLException exception) {
            this.jdbcModel = jdbcModel;
            this.exception = exception;
        }

        public JDBCPooledConnection(JDBCModel jdbcModel, Connection connection) {
            this.jdbcModel = jdbcModel;
            this.rawConnection = connection;
        }

        public Connection getRawConnection() {
            return this.rawConnection;
        }

        private void throwSQLExceptionIfExist() throws SQLException {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.isWrapperFor(iface);
        }

        @Override
        public Statement createStatement() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.rollback();
        }

        @Override
        public void close() throws SQLException {
            try {
                pool.returnObject((Object)this.jdbcModel, (Object)this);
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage(), e);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            if (this.exception != null) {
                throw new SQLClientInfoException();
            }
            this.rawConnection.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            if (this.exception != null) {
                throw new SQLClientInfoException();
            }
            this.rawConnection.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.throwSQLExceptionIfExist();
            this.rawConnection.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            this.throwSQLExceptionIfExist();
            return this.rawConnection.getNetworkTimeout();
        }
    }
}

