/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.sql;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.util.BaseMetaDataUtil;
import com.kingdee.shr.dataplatform.AggregationEnum;
import com.kingdee.shr.dataplatform.VariableConfigException;
import com.kingdee.shr.dataset.model.BizObjectItem;
import com.kingdee.shr.dataset.model.SQLFieldMappingItem;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.model.VariableItem;
import com.kingdee.shr.dataset.service.sql.SqlParsingService;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EntitySqlParsingService
extends SqlParsingService {
    protected static Logger logger = Logger.getLogger(EntitySqlParsingService.class);
    private Map<String, EntityObjectInfo> idMap = new HashMap<String, EntityObjectInfo>();

    private EntityObjectInfo getEntityObjectInfo(Context ctx, BizObjectItem bizObjectItem) {
        if (this.idMap.containsKey(bizObjectItem.getId())) {
            return this.idMap.get(bizObjectItem.getId());
        }
        EntityObjectInfo entityObjectInfo = BaseMetaDataUtil.getEntityObjectByEntityName((Context)ctx, (String)bizObjectItem.getNumber());
        this.idMap.put(bizObjectItem.getId(), entityObjectInfo);
        return entityObjectInfo;
    }

    @Override
    protected String getTableName(Context ctx, BizObjectItem bizObjectItem) {
        return this.getEntityObjectInfo(ctx, bizObjectItem).getTable().getName();
    }

    @Override
    protected String getField(String propertyName, String tableAlias) {
        PropertyInfo p = this.getPropertyInfo(propertyName, tableAlias);
        String fieldName = p.getMappingField().getName();
        if (p instanceof OwnPropertyInfo && ((OwnPropertyInfo)p).isMultilingual()) {
            return MessageFormat.format("{0}.{1}_{2}", tableAlias, fieldName, "{@i18n_langue}");
        }
        return MessageFormat.format("{0}.{1}", tableAlias, fieldName);
    }

    @Override
    protected String getFieldSourceRef(String propertyName, String tableAlias) {
        PropertyInfo p = this.getPropertyInfo(propertyName, tableAlias);
        if (p instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)((OwnPropertyInfo)p).getDataType())) {
            return ((OwnPropertyInfo)p).getMetaDataRef();
        }
        return "";
    }

    private PropertyInfo getPropertyInfo(String propertyName, String tableAlias) {
        EntityObjectInfo entityObjectInfo = this.idMap.get(tableAlias);
        return entityObjectInfo.getPropertyByNameRuntime(propertyName);
    }

    @Override
    protected void setSQLFieldMappingItemRefSource(SelectorItem selector, SQLFieldMappingItem item) {
        PropertyInfo p = this.getPropertyInfo(selector.getPhysicsName(), selector.getTableId());
        if (p instanceof OwnPropertyInfo && DataType.ENUM.equals((Object)((OwnPropertyInfo)p).getDataType())) {
            item.setRefSource(((OwnPropertyInfo)p).getMetaDataRef());
        }
    }

    @Override
    protected SQLFieldMappingItem assembleSQLFieldMappingItem(String field, String fieldAlias, SelectorItem selector) {
        SQLFieldMappingItem item = super.assembleSQLFieldMappingItem(field, fieldAlias, selector);
        if (!selector.isCalculateField()) {
            PropertyInfo p = this.getPropertyInfo(selector.getPhysicsName(), selector.getTableId());
            if (p instanceof OwnPropertyInfo) {
                item.setDataType(((OwnPropertyInfo)p).getDataType().getName());
            } else if (p instanceof LinkPropertyInfo) {
                item.setDataType(DataType.BOSUUID.getName());
            }
        }
        return item;
    }

    @Override
    protected void setMeasureDataType(SelectorItem selector, SQLFieldMappingItem item, AggregationEnum aggregationEnum) {
        if (null == aggregationEnum) {
            return;
        }
        if (AggregationEnum.count_distinct.equals((Object)aggregationEnum) || AggregationEnum.count.equals((Object)aggregationEnum)) {
            item.setDataType(DataType.INTEGER.getName());
            item.setShowDataType(DataType.INTEGER.getName());
        }
    }

    @Override
    protected void checkVariable(VariableItem vi) throws BOSException, EASBizException {
        if (70 == vi.getType()) {
            throw new VariableConfigException(VariableConfigException.NOT_SUPPORT);
        }
    }
}

