/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.common.util.StringUtils;
import com.kingdee.shr.dataplatform.VariableConfigException;
import com.kingdee.shr.dataplatform.VariableConfigInfo;
import com.kingdee.shr.dataplatform.app.AbstractVariableConfigControllerBean;
import com.kingdee.shr.dataplatform.cache.DataplatformCacheHelper;
import com.kingdee.shr.dataset.util.DataSetUtils;
import org.apache.log4j.Logger;

public class VariableConfigControllerBean
extends AbstractVariableConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.VariableConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        VariableConfigInfo info = (VariableConfigInfo)model;
        this._checkNumberDup(ctx, model);
        DataSetUtils.checkNumberRule(info.getNumber());
        this.checkClz((IObjectValue)info);
        IObjectPK pk = super._save(ctx, (IObjectValue)info);
        DataplatformCacheHelper.remove(ctx, 1, info.getNumber());
        return pk;
    }

    private void checkClz(IObjectValue model) throws EASBizException {
        VariableConfigInfo variableConfigInfo = (VariableConfigInfo)model;
        String clz = variableConfigInfo.getClz();
        if (StringUtils.isEmpty((CharSequence)clz)) {
            throw new VariableConfigException(VariableConfigException.PARAMS_EXCEPTION, new Object[]{"clz is null"});
        }
        try {
            Class.forName(clz).newInstance();
        }
        catch (Exception e) {
            throw new VariableConfigException(VariableConfigException.PARAMS_EXCEPTION, new Object[]{"clz is not Instance :" + clz});
        }
    }

    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (null == pk) {
            return;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("isPreset"));
        VariableConfigInfo info = this.getVariableConfigInfo(ctx, pk, selector);
        if (info.isIsPreset()) {
            throw new VariableConfigException(VariableConfigException.CHECK_PRESET);
        }
        super._delete(ctx, pk);
        DataplatformCacheHelper.remove(ctx, 1, info.getNumber());
    }
}

