/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataplatform.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.ListQuerySchemeTypeEnum;
import com.kingdee.shr.dataplatform.CardConfigFactory;
import com.kingdee.shr.dataplatform.PageConfigException;
import com.kingdee.shr.dataplatform.PageConfigFactory;
import com.kingdee.shr.dataplatform.PageConfigInfo;
import com.kingdee.shr.dataplatform.WorkPFSolutionFactory;
import com.kingdee.shr.dataplatform.WorkPFSolutionInfo;
import com.kingdee.shr.dataplatform.app.AbstractWorkPFSolutionControllerBean;
import com.kingdee.shr.dataplatform.util.WorkPFSolutionUtils;
import com.kingdee.shr.pageset.util.PageSetUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class WorkPFSolutionControllerBean
extends AbstractWorkPFSolutionControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.dataplatform.app.WorkPFSolutionControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        WorkPFSolutionInfo workPFSolutionInfo = (WorkPFSolutionInfo)model;
        boolean isProductionMode = (Boolean)workPFSolutionInfo.get("isProductionMode");
        if (isProductionMode && workPFSolutionInfo.isIsPreset()) {
            throw new PageConfigException(PageConfigException.PRESET_SOLUTION_NOT_SAVE);
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        PageConfigInfo pageConfigInfo = null;
        if (null == workPFSolutionInfo.getWorkplatform() || null == workPFSolutionInfo.getWorkplatform().getId()) {
            throw new PageConfigException(PageConfigException.WORKPLATFORM_ID_NOTNULL);
        }
        String workplatfromId = workPFSolutionInfo.getWorkplatform().getId().toString();
        WorkPFSolutionUtils.checkWorkplatformIDSetSolution(ctx, workplatfromId);
        String pageId = WorkPFSolutionUtils.getPageIdByUipk(ctx, workplatfromId);
        CoreBaseCollection coll = new CoreBaseCollection();
        pageConfigInfo = PageConfigFactory.getLocalInstance(ctx).getPageConfigInfo((IObjectPK)new ObjectUuidPK(pageId));
        pageConfigInfo.setExtend(null);
        if (ListQuerySchemeTypeEnum.SYSTEM.equals((Object)workPFSolutionInfo.getType())) {
            workPFSolutionInfo.setUser(null);
        } else {
            workPFSolutionInfo.setUser(user);
        }
        if (!WorkPFSolutionFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(workPFSolutionInfo.getId())) && ListQuerySchemeTypeEnum.USER.equals((Object)workPFSolutionInfo.getType()) && this.checkSizeByUser(ctx, user.getId().toString())) {
            throw new PageConfigException(PageConfigException.SOLUTION_MAX_SAVE);
        }
        PageSetUtils.getCards(ctx, workPFSolutionInfo, pageConfigInfo, workPFSolutionInfo.getContent(), coll, true);
        if (!StringUtils.isEmpty((String)pageConfigInfo.getExtend())) {
            workPFSolutionInfo.setContent(pageConfigInfo.getExtend());
        }
        IObjectPK pk = super._save(ctx, (IObjectValue)workPFSolutionInfo);
        workPFSolutionInfo.setId(BOSUuid.read((String)pk.toString()));
        if (workPFSolutionInfo.isIsDefault()) {
            this.updateIsDefaultFalse(ctx, pk.toString(), workplatfromId, workPFSolutionInfo.getType().getValue());
        }
        CardConfigFactory.getLocalInstance(ctx).saveBatchDataByPage((IObjectCollection)coll, (IObjectValue)workPFSolutionInfo);
        return pk;
    }

    private boolean checkSizeByUser(Context ctx, String userId) throws BOSException {
        boolean isMaxSize = false;
        String count = "SELECT COUNT(FID) cc FROM T_SHR_WorkPFSolution WHERE FUserId = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)count, (Object[])new Object[]{userId});
        try {
            while (rs.next()) {
                if (rs.getLong("cc") < 20L) continue;
                isMaxSize = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return isMaxSize;
    }

    private void updateIsDefaultTrue(Context ctx, String solutionId, String workplatfromId, int type) throws BOSException {
        String updateTrue = null;
        if (1 == type) {
            updateTrue = "UPDATE T_SHR_WorkPFSolution SET FIsDefault = 1 WHERE FWorkplatformID =? AND FID = ? AND  FIsDefault = 0 AND FType = 1";
            DbUtil.execute((Context)ctx, (String)updateTrue, (Object[])new Object[]{workplatfromId, solutionId});
        } else {
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            updateTrue = "UPDATE T_SHR_WorkPFSolution SET FIsDefault = 1 WHERE FWorkplatformID =? AND FID = ?  AND FUserID =? AND FIsDefault = 0 AND FType = 2";
            DbUtil.execute((Context)ctx, (String)updateTrue, (Object[])new Object[]{workplatfromId, solutionId, user.getId().toString()});
        }
    }

    private void updateIsDefaultFalse(Context ctx, String solutionId, String workplatfromId, int type) throws BOSException {
        String updateFalse = null;
        if (1 == type) {
            updateFalse = "UPDATE T_SHR_WorkPFSolution SET FIsDefault = 0 WHERE FWorkplatformID =? AND FID <> ? AND  FIsDefault = 1 AND FType = 1";
            DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{workplatfromId, solutionId});
        } else {
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            updateFalse = "UPDATE T_SHR_WorkPFSolution SET FIsDefault = 0 WHERE FWorkplatformID =? AND FID <> ?  AND FUserID =? AND FIsDefault = 1 AND FType = 2";
            DbUtil.execute((Context)ctx, (String)updateFalse, (Object[])new Object[]{workplatfromId, solutionId, user.getId().toString()});
        }
    }

    @Override
    protected void _deleteById(Context ctx, String id, boolean isUserState) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("type"));
        WorkPFSolutionInfo workPFSolutionInfo = this.getWorkPFSolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (1 == workPFSolutionInfo.getType().getValue() && isUserState) {
            throw new PageConfigException(PageConfigException.PRESET_SOLUTION_NOT_DELETE);
        }
        this._delete(ctx, (IObjectPK)new ObjectUuidPK(id));
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("isPreSet", (Object)true));
        if (this._exists(ctx, filter)) {
            throw new PageConfigException(PageConfigException.SOLUTION_NOT_DELETE_SOLUTION);
        }
        this.deleteReferCard(ctx, pk);
        super._delete(ctx, pk);
    }

    private void deleteReferCard(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solution.id", (Object)pk.toString()));
        CardConfigFactory.getLocalInstance(ctx).delete(filterInfo);
    }

    @Override
    protected void _setDefault(Context ctx, String id, boolean isUserState) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            throw new PageConfigException(PageConfigException.WORKPLAT_SOLUTIONID_ISNOTNULL);
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("workplatform.id"));
        selector.add(new SelectorItemInfo("type"));
        WorkPFSolutionInfo workPFSolutionInfo = this.getWorkPFSolutionInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        this.updateIsDefaultTrue(ctx, id, workPFSolutionInfo.getWorkplatform().getId().toString(), workPFSolutionInfo.getType().getValue());
        if (isUserState && 1 == workPFSolutionInfo.getType().getValue()) {
            throw new PageConfigException(PageConfigException.NOT_SET_SYSTEM_ON_USERSTATE);
        }
        this.updateIsDefaultFalse(ctx, id, workPFSolutionInfo.getWorkplatform().getId().toString(), workPFSolutionInfo.getType().getValue());
    }
}

