/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service;

import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.card.service.CardService;
import com.kingdee.shr.dataplatform.DataplatformException;
import com.kingdee.shr.dataset.service.DataQueryService;
import com.kingdee.shr.dataset.service.DataSetService;
import com.kingdee.shr.dataset.service.IDataPlatformService;
import com.kingdee.shr.dataset.service.SQLParsingEngineService;
import com.kingdee.shr.dataset.service.ShowLevelSQLParsingService;
import com.kingdee.shr.pageset.service.PageConfigService;
import com.kingdee.shr.pageset.service.WorkPFSolutionConfigService;
import java.util.HashMap;
import java.util.Map;

public class DataPlatformServiceFactory {
    private static Map<String, Class<?>> serviceClassMap = new HashMap();

    private DataPlatformServiceFactory() {
    }

    public static void regist(String serviceType, Class<?> serviceClass) {
        serviceClassMap.computeIfAbsent(serviceType, key -> serviceClass);
    }

    public static IDataPlatformService getPlateformService(String serviceType) throws EASBizException {
        Class<?> clz = serviceClassMap.get(serviceType);
        if (null == clz) {
            return null;
        }
        try {
            return (IDataPlatformService)clz.newInstance();
        }
        catch (InstantiationException e) {
            throw new DataplatformException(DataplatformException.CLASS_INIT_EXCEPTION, new Object[]{clz});
        }
        catch (IllegalAccessException e) {
            throw new DataplatformException(DataplatformException.CLASS_INIT_EXCEPTION, new Object[]{clz});
        }
    }

    static {
        serviceClassMap.put("/dataplateform/datasetData.do", DataQueryService.class);
        serviceClassMap.put("/dataplateform/datasetSQL.do", SQLParsingEngineService.class);
        serviceClassMap.put("/dataplateform/showLevelSQL.do", ShowLevelSQLParsingService.class);
        serviceClassMap.put("/dataplateform/page.do", PageConfigService.class);
        serviceClassMap.put("/dataplateform/dataSet.do", DataSetService.class);
        serviceClassMap.put("/dataplateform/card.do", CardService.class);
        serviceClassMap.put("/dataplateform/solution.do", WorkPFSolutionConfigService.class);
    }
}

