/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.java;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.SQLParseLevel;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.model.ParamValueItem;
import com.kingdee.shr.dataset.model.ParamsItem;
import com.kingdee.shr.dataset.model.SelectorItem;
import com.kingdee.shr.dataset.model.VariableItem;
import com.kingdee.shr.dataset.service.IJavaDataQueryService;
import com.kingdee.shr.dataset.service.util.SQLExcuteHelper;
import com.kingdee.util.DateTimeUtils;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class AbstractJavaDataQueryService
implements IJavaDataQueryService {
    private static Logger logger = Logger.getLogger(AbstractJavaDataQueryService.class);
    protected Map<String, Object> paramMap = new HashMap<String, Object>();
    protected Map<String, Object> variableMap = new HashMap<String, Object>();

    protected final ParamValueItem getParamValueItem(String paramName, JavaAPIParam param) {
        if (null != param.getRunParam() && !param.getRunParam().isEmpty()) {
            for (ParamValueItem e : param.getRunParam()) {
                if (!paramName.equals(e.getParamName())) continue;
                return e;
            }
        }
        return null;
    }

    protected final Object getParamValue(Context ctx, String paramName, JavaAPIParam param) throws EASBizException, BOSException {
        if (this.paramMap.containsKey(paramName)) {
            return this.paramMap.get(paramName);
        }
        ParamsItem p = SQLExcuteHelper.getSourceParamsItem(param.getDesignDataSetJava().getParams(), paramName);
        if (null == p) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{"param[" + paramName + "] not exits in DataSetConfig."});
        }
        ParamValueItem pv = this.getParamValueItem(paramName, param);
        Object value = p.getValue();
        if (null != pv) {
            value = pv.getValue();
        }
        if ("NUMBER".equals(p.getDataType()) || "INT".equals(p.getDataType())) {
            if (value instanceof Number) {
                this.paramMap.put(paramName, value);
                return value;
            }
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Number Type.", paramName, String.valueOf(String.valueOf(value)))});
        }
        if ("DATE".equals(p.getDataType()) || "TIMESTAMP".equals(p.getDataType()) || "TIME".equals(p.getDataType())) {
            if (value instanceof String) {
                String d = (String)value;
                try {
                    Timestamp dv = new Timestamp(DateTimeUtils.parseDate((String)d).getTime());
                    this.paramMap.put(paramName, dv);
                    return dv;
                }
                catch (ParseException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Date Type.", paramName, String.valueOf(String.valueOf(value)))});
                }
            }
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Date Type.", paramName, String.valueOf(String.valueOf(value)))});
        }
        if ("ENUM".equals(p.getDataType())) {
            if (value instanceof List) {
                List list = (List)value;
                String lv = SQLExcuteHelper.doCompareValueList(ctx, "ENUM", p.getSourceRef(), list);
                this.paramMap.put(paramName, lv);
                return lv;
            }
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Enum Type.", paramName, String.valueOf(value))});
        }
        if ("STRING".equals(p.getDataType())) {
            String sv = "";
            if (value instanceof Map) {
                Map temp = (Map)value;
                sv = (String)temp.get(ctx.getLocale().getDisplayName());
            } else {
                sv = String.valueOf(value);
            }
            this.paramMap.put(paramName, sv);
            return sv;
        }
        if ("BOOLEAN".equals(p.getDataType())) {
            int bValue = 0;
            if (value instanceof Boolean) {
                bValue = (Boolean)value != false ? 1 : 0;
            } else if (value instanceof String) {
                String temp = String.valueOf(value);
                if ("1".equals(temp)) {
                    bValue = 1;
                } else if ("0".equals(temp)) {
                    bValue = 0;
                } else {
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Boolean Type.", paramName, String.valueOf(value))});
                }
                this.paramMap.put(paramName, bValue);
            } else {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Boolean Type.", paramName, String.valueOf(value))});
            }
            this.paramMap.put(paramName, bValue);
            return bValue;
        }
        if ("F7".equals(p.getDataType())) {
            if (value instanceof List) {
                List list = (List)value;
                String fv = SQLExcuteHelper.doCompareValueList(ctx, "F7", p.getSourceRef(), list);
                this.paramMap.put(paramName, fv);
                return fv;
            }
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not F7 Type.", paramName, String.valueOf(value))});
        }
        if ("variable".equals(p.getDataType())) {
            if (value instanceof String) {
                VariableItem vi;
                String temp = String.valueOf(value);
                Object vv = SQLExcuteHelper.getVariableValue(ctx, temp, vi = VariableServiceFactory.getVariableItem(ctx, temp), param.getDesignDataSetJava().getParams(), param.getRunParam(), param.getPermItemId(), this.variableMap);
                if (null == vv) {
                    throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not variable Type.", paramName, String.valueOf(value))});
                }
                if (null != vi && 30 == vi.getType()) {
                    this.paramMap.put(paramName, vv);
                } else if (null != vi && 20 == vi.getType()) {
                    this.paramMap.put(paramName, vv);
                } else if (null != vi && 40 == vi.getType()) {
                    Map vvTemp = (Map)vv;
                    this.paramMap.put(MessageFormat.format("{0}{1}", paramName, "_###BEGIN###"), vvTemp.get("_###BEGIN###"));
                    this.paramMap.put(MessageFormat.format("{0}{1}", paramName, "_###END###"), vvTemp.get("_###END###"));
                    this.paramMap.put(paramName, vvTemp);
                } else {
                    this.paramMap.put(paramName, vv);
                }
                return vv;
            }
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not variable Type.", paramName, String.valueOf(value))});
        }
        return null;
    }

    protected final Object getSourceParamsItemValue(List<ParamsItem> params, List<ParamValueItem> runParams, String paramName) {
        return SQLExcuteHelper.getSourceParamsItemValue(params, runParams, paramName);
    }

    protected final boolean isDataSet(JavaAPIParam param) {
        return SQLParseLevel.DATASET.toString().equals(param.getSqlParseLevel());
    }

    protected final List<SelectorItem> getDimensionSelector(JavaAPIParam param) {
        if (this.isDataSet(param)) {
            return param.getDesignDataSetJava().getSelector().getDimension();
        }
        return param.getCardDimension();
    }

    protected final List<SelectorItem> getMeasureSelector(JavaAPIParam param) {
        if (this.isDataSet(param)) {
            return param.getDesignDataSetJava().getSelector().getMeasure();
        }
        return param.getCardMeasure();
    }
}

