/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.sql;

import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.data.model.designtime.type.DataType;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataset.model.CaseItem;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.service.sql.CaseSqlService;
import com.kingdee.shr.dataset.service.util.CheckHelper;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.log4j.Logger;

public class DateCaseSqlService
extends CaseSqlService {
    protected static Logger logger = Logger.getLogger(DateCaseSqlService.class);

    @Override
    protected String calCaseWhenStr(Context ctx, CaseItem item, String fieldName, SQLResult result) throws EASBizException {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((String)item.getSysVarible()) && !DataType.DateType.C_CUSTOM.toString().equals(item.getSysVarible())) {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("fieldName:{0} ,Value:{1}, is not Date Type.", fieldName, String.valueOf(item.getSysVarible()))});
        }
        Object valueOne = item.getValueOne();
        this.calDateCaseWhenSql(valueOne, item.getCompareSymbolOne(), fieldName, sb, result);
        if (!StringUtils.isEmpty((String)item.getCompareSymbolTwo())) {
            sb.append(" AND ");
            Object valueTwo = item.getValueTwo();
            this.calDateCaseWhenSql(valueTwo, item.getCompareSymbolTwo(), fieldName, sb, result);
        }
        return sb.toString();
    }

    private void calDateCaseWhenSql(Object value, String compareSymbol, String fieldName, StringBuilder sb, SQLResult result) throws EASBizException {
        CheckHelper.checkCompareSymbolByDataType(DataType.DATE.toString(), compareSymbol);
        if (value instanceof Date) {
            Date date = (Date)value;
            sb.append(fieldName).append(" ").append(compareSymbol).append("  ").append("{ts'").append(DateTimeUtils.format((Date)date)).append("'").append("}").append(" ");
        } else if (value instanceof String) {
            try {
                sb.append(fieldName).append(" ").append(compareSymbol).append("  ").append("{ts'").append(DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)((String)value)))).append("'").append("}").append(" ");
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("fieldName:{0} ,Value:{1}, is not Date Type.", fieldName, String.valueOf(value))});
            }
        } else {
            throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("fieldName:{0} ,Value:{1}, is not Date Type.", fieldName, String.valueOf(value))});
        }
    }
}

