/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.dataset.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.SqlTranslateException;
import com.kingdee.bos.sql.TransUtil;
import com.kingdee.bos.sql.formater.FormatOptions;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.json.JSONUtils;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.shr.common.util.SHREnumUtil;
import com.kingdee.shr.dataplatform.DataSetException;
import com.kingdee.shr.dataplatform.variable.VariableServiceFactory;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.ParamValueItem;
import com.kingdee.shr.dataset.model.ParamsItem;
import com.kingdee.shr.dataset.model.RuntimeSQLInfo;
import com.kingdee.shr.dataset.model.SQLResult;
import com.kingdee.shr.dataset.model.VariableItem;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SQLExcuteHelper {
    private static Logger logger = Logger.getLogger(SQLExcuteHelper.class);
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private Map<String, Object> variableMap = new HashMap<String, Object>();
    private Map<String, Object> innerVariableMap = new HashMap<String, Object>();
    private Map<String, Map<String, String>> enumConvert = new HashMap<String, Map<String, String>>();
    private Map<String, String> booleanConvert = new HashMap<String, String>();
    private Context ctx;
    private Map<String, Object> param;

    public SQLExcuteHelper(Context ctx, Map<String, Object> param) throws EASBizException, BOSException {
        this.ctx = ctx;
        this.param = param;
        this.init();
    }

    private void init() throws EASBizException, BOSException {
        this.booleanConvert.put("0", SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"no", (Context)this.ctx));
        this.booleanConvert.put("1", SHRServerResource.getString((String)"com.kingdee.shr.report.ReportResource", (String)"yes", (Context)this.ctx));
        SQLResult sqlResult = (SQLResult)this.param.get("sqlResult");
        if (null == sqlResult) {
            return;
        }
        List<ParamsItem> sourceParam = sqlResult.getSourceParam();
        List runParam = (List)this.param.get("runParam");
        this.verifyParam(runParam, sourceParam);
        this.innerVariableMap = sqlResult.getInnerParam();
    }

    private void verifyParam(List<ParamValueItem> runParam, List<ParamsItem> sourceParam) throws EASBizException, BOSException {
        if (null == sourceParam || sourceParam.isEmpty()) {
            return;
        }
        for (ParamsItem item : sourceParam) {
            Object v = this.getParamValue(runParam, item);
            if (null == v) {
                v = item.getValue();
            }
            this.setParamValue(item, v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParamValue(ParamsItem item, Object value) throws BOSException, EASBizException {
        String dataType = item.getDataType();
        String paramName = item.getParamName();
        if ("NUMBER".equals(dataType) || "INT".equals(dataType)) {
            if (!(value instanceof Number)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Number Type.", paramName, String.valueOf(String.valueOf(value)))});
            if ("INT".equals(dataType)) {
                if (value instanceof Integer) {
                    this.paramMap.put(paramName, (int)((Integer)value));
                    return;
                } else if (value instanceof Long) {
                    this.paramMap.put(paramName, ((Long)value).intValue());
                    return;
                } else if (value instanceof Double) {
                    this.paramMap.put(paramName, ((Double)value).intValue());
                    return;
                } else {
                    if (!(value instanceof Float)) return;
                    this.paramMap.put(paramName, ((Float)value).intValue());
                }
                return;
            } else {
                this.paramMap.put(paramName, value);
            }
            return;
        } else if ("DATE".equals(dataType) || "TIMESTAMP".equals(dataType) || "TIME".equals(dataType)) {
            if (!(value instanceof String)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Date Type.", paramName, String.valueOf(String.valueOf(value)))});
            String d = (String)value;
            try {
                if ("DATE".equals(dataType)) {
                    this.paramMap.put(paramName, new Date(DateTimeUtils.parseDate((String)d).getTime()));
                    return;
                }
                this.paramMap.put(paramName, new Timestamp(DateTimeUtils.parseDate((String)d).getTime()));
                return;
            }
            catch (ParseException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Date Type.", paramName, String.valueOf(String.valueOf(value)))});
            }
        } else if ("ENUM".equals(dataType)) {
            if (!(value instanceof List)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Enum Type.", paramName, String.valueOf(value))});
            List list = (List)value;
            this.paramMap.put(paramName, SQLExcuteHelper.doCompareValueList(this.ctx, item.getDataType(), item.getSourceRef(), list));
            return;
        } else if ("STRING".equals(dataType) || "customEnum".equals(dataType)) {
            if (value instanceof Map) {
                Map temp = (Map)value;
                this.paramMap.put(paramName, temp.get(this.ctx.getLocale().getDisplayName()));
                return;
            } else {
                this.paramMap.put(paramName, String.valueOf(value));
            }
            return;
        } else if ("BOOLEAN".equals(dataType)) {
            if (value instanceof Boolean) {
                int bValue = (Boolean)value != false ? 1 : 0;
                this.paramMap.put(paramName, bValue);
                return;
            } else {
                if (!(value instanceof String)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Boolean Type.", paramName, String.valueOf(value))});
                String temp = String.valueOf(value);
                int bValue = 0;
                if ("1".equals(temp)) {
                    bValue = 1;
                } else {
                    if (!"0".equals(temp)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not Boolean Type.", paramName, String.valueOf(value))});
                    bValue = 0;
                }
                this.paramMap.put(paramName, bValue);
            }
            return;
        } else if ("F7".equals(dataType)) {
            if (!(value instanceof List)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not F7 Type.", paramName, String.valueOf(value))});
            List list = (List)value;
            this.paramMap.put(paramName, SQLExcuteHelper.doCompareValueList(this.ctx, item.getDataType(), item.getSourceRef(), list));
            return;
        } else {
            String permItemID;
            List runParam;
            Object vv;
            if (!"variable".equals(dataType)) return;
            if (!(value instanceof String)) throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not variable Type.", paramName, String.valueOf(value))});
            String temp = String.valueOf(value);
            VariableItem vi = VariableServiceFactory.getVariableItem(this.ctx, temp);
            SQLResult sqlResult = (SQLResult)this.param.get("sqlResult");
            List<ParamsItem> sourceParam = null;
            if (null != sqlResult) {
                sourceParam = sqlResult.getSourceParam();
            }
            if (null == (vv = SQLExcuteHelper.getVariableValue(this.ctx, temp, vi, sourceParam, runParam = (List)this.param.get("runParam"), permItemID = (String)this.param.get("permItemId"), this.variableMap))) {
                throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not variable Type.", paramName, String.valueOf(value))});
            }
            if (null != vi && 30 == vi.getType()) {
                this.paramMap.put(paramName, vv);
                return;
            } else if (null != vi && 20 == vi.getType()) {
                this.paramMap.put(paramName, vv);
                return;
            } else if (null != vi && 40 == vi.getType()) {
                Map vvTemp = (Map)vv;
                this.paramMap.put(MessageFormat.format("{0}{1}", paramName, "_###BEGIN###"), vvTemp.get("_###BEGIN###"));
                this.paramMap.put(MessageFormat.format("{0}{1}", paramName, "_###END###"), vvTemp.get("_###END###"));
                return;
            } else {
                this.paramMap.put(paramName, vv);
            }
        }
    }

    public static String doCompareValueList(Context ctx, String dataType, String sourceRef, List tl) {
        StringBuilder tempSb = new StringBuilder();
        String enumType = null;
        if ("ENUM".equals(dataType)) {
            enumType = SHREnumUtil.getBizEnumByEnumsource((Context)ctx, (String)sourceRef);
        }
        int size = tl.size();
        for (int i = 0; i < size; ++i) {
            Map tempM = (Map)tl.get(i);
            if (i > 0) {
                tempSb.append(",");
            }
            Object tv = tempM.get("v");
            if ("ENUM".equals(dataType)) {
                if ("IntEnum".equals(enumType)) {
                    if (tv instanceof Integer) {
                        tempSb.append(tv);
                        continue;
                    }
                    if (tv instanceof Long) {
                        tempSb.append(((Long)tv).intValue());
                        continue;
                    }
                    if (tv instanceof Double) {
                        tempSb.append(((Double)tv).intValue());
                        continue;
                    }
                    if (tv instanceof Float) {
                        tempSb.append(((Float)tv).intValue());
                        continue;
                    }
                    if (tv instanceof BigDecimal) {
                        tempSb.append(((BigDecimal)tv).intValue());
                        continue;
                    }
                    tempSb.append(Integer.parseInt(String.valueOf(tv)));
                    continue;
                }
                if ("LongEnum".equals(enumType)) {
                    if (tv instanceof Integer) {
                        tempSb.append(((Integer)tv).longValue());
                        continue;
                    }
                    if (tv instanceof Long) {
                        tempSb.append(tv);
                        continue;
                    }
                    if (tv instanceof Double) {
                        tempSb.append(((Double)tv).longValue());
                        continue;
                    }
                    if (tv instanceof Float) {
                        tempSb.append(((Float)tv).longValue());
                        continue;
                    }
                    if (tv instanceof BigDecimal) {
                        tempSb.append(((BigDecimal)tv).longValue());
                        continue;
                    }
                    tempSb.append(Long.parseLong(String.valueOf(tv)));
                    continue;
                }
                if ("DoubleEnum".equals(enumType)) {
                    if (tv instanceof Integer) {
                        tempSb.append(((Integer)tv).doubleValue());
                        continue;
                    }
                    if (tv instanceof Long) {
                        tempSb.append(((Long)tv).doubleValue());
                        continue;
                    }
                    if (tv instanceof Double) {
                        tempSb.append(tv);
                        continue;
                    }
                    if (tv instanceof Float) {
                        tempSb.append(((Float)tv).doubleValue());
                        continue;
                    }
                    if (tv instanceof BigDecimal) {
                        tempSb.append(((BigDecimal)tv).doubleValue());
                        continue;
                    }
                    tempSb.append(Double.parseDouble(String.valueOf(tv)));
                    continue;
                }
                if ("FloatEnum".equals(enumType)) {
                    if (tv instanceof Integer) {
                        tempSb.append(((Integer)tv).floatValue());
                        continue;
                    }
                    if (tv instanceof Long) {
                        tempSb.append(((Long)tv).floatValue());
                        continue;
                    }
                    if (tv instanceof Double) {
                        tempSb.append(((Double)tv).floatValue());
                        continue;
                    }
                    if (tv instanceof Float) {
                        tempSb.append(tv);
                        continue;
                    }
                    if (tv instanceof BigDecimal) {
                        tempSb.append(((BigDecimal)tv).floatValue());
                        continue;
                    }
                    tempSb.append(Float.parseFloat(String.valueOf(tv)));
                    continue;
                }
                if ("StringEnum".equals(enumType) || "DynamicEnum".equals(enumType)) {
                    tempSb.append("'").append(tv).append("'");
                    continue;
                }
                tempSb.append("'").append(tv).append("'");
                continue;
            }
            if ("customEnum".equals(dataType)) {
                if (tempM.get("v") instanceof Number) {
                    tempSb.append(tv);
                    continue;
                }
                tempSb.append("'").append(tv).append("'");
                continue;
            }
            tempSb.append("'").append(tv).append("'");
        }
        return tempSb.toString();
    }

    private Object getParamValue(List<ParamValueItem> runParam, ParamsItem item) {
        if (null == runParam || runParam.isEmpty()) {
            return null;
        }
        for (ParamValueItem e : runParam) {
            String paramName = e.getParamName();
            if (!item.getParamName().equals(paramName)) continue;
            return e.getValue();
        }
        return null;
    }

    public RuntimeSQLInfo convertVariableAndParam(String sql) throws BOSException, EASBizException {
        StringBuilder sb = new StringBuilder();
        RuntimeSQLInfo info = new RuntimeSQLInfo();
        if (StringUtils.isEmpty((String)sql)) {
            info.setSql(sql);
            info.setParams(null);
            return info;
        }
        ArrayList<Object> valueList = new ArrayList<Object>();
        sql = sql.replaceFirst("\n", " ");
        String textEnd = sql = sql.replace("{@i18n_langue}", this.ctx.getLocale().getDisplayName());
        SQLResult sqlResult = (SQLResult)this.param.get("sqlResult");
        List<ParamsItem> sourceParam = null;
        if (null != sqlResult) {
            sourceParam = sqlResult.getSourceParam();
        }
        List runParam = (List)this.param.get("runParam");
        String permItemID = (String)this.param.get("permItemId");
        while (true) {
            int index;
            if ((index = textEnd.indexOf("{")) == -1) break;
            sb.append(textEnd.substring(0, index));
            String tempStr = textEnd.substring(index);
            int endIndex = tempStr.indexOf("}");
            String variablePlace = tempStr.substring(0, endIndex + 1);
            String pName = "";
            if (variablePlace.startsWith("{@")) {
                pName = variablePlace.replace("{@", "").replace("}", "");
                if (this.innerVariableMap.containsKey(pName)) {
                    sb.append(" ? ");
                    valueList.add(this.innerVariableMap.get(pName));
                } else {
                    String vName = SQLExcuteHelper.getVariableNumberByVariablePlace(pName);
                    VariableItem vi = VariableServiceFactory.getVariableItem(this.ctx, vName);
                    Object value = SQLExcuteHelper.getVariableValue(this.ctx, pName, vi, sourceParam, runParam, permItemID, this.variableMap);
                    if (null == value) {
                        throw new DataSetException(DataSetException.PARAMS_EXCEPTION, new Object[]{MessageFormat.format("paramName:{0} ,Value:{1}, is not variable Type.", pName, String.valueOf(value))});
                    }
                    if (null != vi && (30 == vi.getType() || 20 == vi.getType())) {
                        sb.append(value);
                    } else {
                        sb.append(" ? ");
                        valueList.add(value);
                    }
                }
            } else if (variablePlace.startsWith("{ts'") || variablePlace.startsWith("{ ts'")) {
                sb.append(" ").append(variablePlace).append(" ");
            } else {
                String prName = pName = variablePlace.replace("{", "").replace("}", "");
                if (pName.lastIndexOf("_###BEGIN###") != -1) {
                    prName = pName.replace("_###BEGIN###", "");
                } else if (pName.lastIndexOf("_###END###") != -1) {
                    prName = pName.replace("_###END###", "");
                }
                ParamsItem pi = this.getParamsItem(prName);
                if (null != pi && "F7".equals(pi.getDataType()) || "ENUM".equals(pi.getDataType())) {
                    sb.append(this.paramMap.get(pName));
                } else {
                    Object vv = this.paramMap.get(pName);
                    sb.append(" ? ");
                    valueList.add(vv);
                }
            }
            textEnd = tempStr.substring(endIndex + 1);
        }
        sb.append(textEnd);
        info.setSql(sb.toString());
        if (valueList.isEmpty()) {
            info.setParams(null);
        } else {
            int total = valueList.size();
            Object[] params = new Object[total];
            for (int i = 0; i < total; ++i) {
                params[i] = valueList.get(i);
            }
            info.setParams(params);
        }
        return info;
    }

    private static String getVariableNumberByVariablePlace(String variablePlace) {
        String vName = variablePlace;
        if (variablePlace.lastIndexOf("_###BEGIN###") != -1) {
            vName = variablePlace.replace("_###BEGIN###", "");
        } else if (variablePlace.lastIndexOf("_###END###") != -1) {
            vName = variablePlace.replace("_###END###", "");
        }
        int tempFuncParamsBeginIndex = vName.indexOf("(");
        int tempFuncParamsEndIndex = vName.indexOf(")");
        if (tempFuncParamsBeginIndex != -1 && tempFuncParamsEndIndex != -1 && tempFuncParamsEndIndex > tempFuncParamsBeginIndex) {
            vName = vName.substring(0, tempFuncParamsBeginIndex);
        }
        return vName;
    }

    private static String[] getFunctionVariableParamByVariablePlace(VariableItem vi, String variablePlace) throws EASBizException {
        String tempFuncParams;
        String[] variableFunctionParams = null;
        int tempFuncParamsBeginIndex = variablePlace.indexOf("(");
        int tempFuncParamsEndIndex = variablePlace.indexOf(")");
        if (tempFuncParamsBeginIndex != -1 && tempFuncParamsEndIndex != -1 && tempFuncParamsEndIndex > tempFuncParamsBeginIndex && !StringUtils.isEmpty((String)(tempFuncParams = variablePlace.substring(tempFuncParamsBeginIndex + 1, tempFuncParamsEndIndex)))) {
            variableFunctionParams = tempFuncParams.split(",");
        }
        return variableFunctionParams;
    }

    private static void setVariableParams(Context ctx, Map<String, Object> p, String variableName, List<ParamsItem> pList, List<ParamValueItem> runParam) throws BOSException, EASBizException {
        VariableItem vi = VariableServiceFactory.getVariableItem(ctx, variableName);
        HashMap content = null;
        if (!StringUtils.isEmpty((String)vi.getContent())) {
            content = JSONUtils.convertJsonToObject((Context)ctx, (String)vi.getContent());
        }
        if (null == content || content.isEmpty()) {
            return;
        }
        for (Map.Entry entry : content.entrySet()) {
            if (p.containsKey(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
            p.put((String)entry.getKey(), SQLExcuteHelper.getSourceParamsItemValue(pList, runParam, (String)entry.getValue()));
        }
    }

    private ParamsItem getParamsItem(String paramName) {
        if (this.param == null) {
            return null;
        }
        SQLResult sqlResult = (SQLResult)this.param.get("sqlResult");
        return SQLExcuteHelper.getSourceParamsItem(sqlResult.getSourceParam(), paramName);
    }

    public static Object getVariableValue(Context ctx, String variableName, VariableItem vi, List<ParamsItem> pList, List<ParamValueItem> runParam, String permItemID, Map<String, Object> variableMap) throws BOSException, EASBizException {
        Object vv = null;
        if (variableMap.containsKey(variableName)) {
            vv = variableMap.get(variableName);
        } else {
            Object tempValue;
            String temp = "";
            if (variableName.lastIndexOf("_###BEGIN###") != -1) {
                temp = "_###BEGIN###";
            } else if (variableName.lastIndexOf("_###END###") != -1) {
                temp = "_###END###";
            }
            String vName = SQLExcuteHelper.getVariableNumberByVariablePlace(variableName);
            String[] variableFunctionParams = null;
            if (70 == vi.getType()) {
                variableFunctionParams = SQLExcuteHelper.getFunctionVariableParamByVariablePlace(vi, variableName);
            }
            vv = tempValue = SQLExcuteHelper.getVariableValueFormSystem(ctx, vName, pList, runParam, permItemID, variableFunctionParams);
            if (null != vi && 30 == vi.getType()) {
                vv = DataValueTranslatorUtil.hashSet2String((Set)((Set)tempValue));
                variableMap.put(variableName, vv);
            } else if (null != vi && 20 == vi.getType()) {
                variableMap.put(variableName, vv);
            } else if (null != vi && 40 == vi.getType()) {
                Map vvTemp = (Map)vv;
                variableMap.put(MessageFormat.format("{0}{1}", vName, "_###BEGIN###"), vvTemp.get("_###BEGIN###"));
                variableMap.put(MessageFormat.format("{0}{1}", vName, "_###END###"), vvTemp.get("_###END###"));
                if (!StringUtils.isEmpty((String)temp)) {
                    vv = variableMap.get(variableName);
                }
            } else {
                variableMap.put(variableName, tempValue);
            }
        }
        return vv;
    }

    private static Object getVariableValueFormSystem(Context ctx, String variableName, List<ParamsItem> pList, List<ParamValueItem> runParam, String permItemID, String[] variableFunctionParams) throws BOSException, EASBizException {
        HashMap<String, Object> p = new HashMap<String, Object>();
        p.put("permItemId", permItemID);
        p.put("variableFunctionParams", variableFunctionParams);
        SQLExcuteHelper.setVariableParams(ctx, p, variableName, pList, runParam);
        return VariableServiceFactory.getSystemVariableResult(ctx, variableName, p);
    }

    public Map<String, Map<String, String>> getEnumConvert() {
        return this.enumConvert;
    }

    public Map<String, String> getBooleanConvert() {
        return this.booleanConvert;
    }

    public static String getTranslateDialectSQL(Context ctx, String sql) {
        try {
            return SQLExcuteHelper.getTranslateDialectSQL(SQLExcuteHelper.getDbType(ctx), sql);
        }
        catch (BOSException e) {
            logger.error((Object)("paging translate sql eroor: =" + sql));
            return sql;
        }
    }

    public static String getTranslateDialectSQL(int dbType, String sql) {
        if (sql.startsWith("/*dialect*/")) {
            return sql;
        }
        try {
            sql = TransUtil.translate((String)sql, (int)dbType, (FormatOptions)new FormatOptions());
        }
        catch (SqlTranslateException e) {
            logger.error((Object)("paging error sql is =" + sql));
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/*dialect*/").append(sql);
        return sb.toString();
    }

    private static int getDbType(Context ctx) throws BOSException {
        Connection cn = null;
        try {
            cn = EJBFactory.getConnection((Context)ctx);
            int n = KSqlUtil.getDbType((Connection)cn);
            return n;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    public static void queryTotal(Context ctx, RuntimeSQLInfo sqlInfo, DataResult dataResult) throws BOSException {
        if (null == sqlInfo || null == dataResult || StringUtils.isEmpty((String)sqlInfo.getSql())) {
            return;
        }
        StringBuilder totalSql = new StringBuilder();
        totalSql.append("SELECT COUNT(1) CC FROM (");
        totalSql.append(SQLExcuteHelper.removeOrderByForSQL(ctx, sqlInfo.getSql()));
        totalSql.append(") TEMP");
        String sql = SQLExcuteHelper.getTranslateDialectSQL(ctx, totalSql.toString());
        IRowSet rs = null;
        rs = null == sqlInfo.getParams() || sqlInfo.getParams().length <= 0 ? DbUtil.executeQuery((Context)ctx, (String)sql) : DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])sqlInfo.getParams());
        try {
            while (rs.next()) {
                dataResult.setTotal(rs.getInt("CC"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String removeOrderByForGroupSQL(Context ctx, String sql) {
        if (sql.toUpperCase(ctx.getLocale()).lastIndexOf("GROUP BY") != -1) {
            return SQLExcuteHelper.removeOrderByForSQL(ctx, sql);
        }
        return sql;
    }

    private static String removeOrderByForSQL(Context ctx, String sql) {
        StringBuilder resultSQL = new StringBuilder();
        String tempOrderBy = sql;
        tempOrderBy = tempOrderBy.replace(";", "");
        while (true) {
            int orderByIndex;
            if ((orderByIndex = tempOrderBy.toUpperCase(ctx.getLocale()).indexOf("ORDER BY")) == -1) {
                resultSQL.append(tempOrderBy);
                break;
            }
            resultSQL.append(tempOrderBy.substring(0, orderByIndex));
            tempOrderBy = tempOrderBy.substring(orderByIndex);
            int bracketIndex = tempOrderBy.indexOf(")");
            if (bracketIndex == -1) break;
            tempOrderBy = tempOrderBy.substring(bracketIndex);
        }
        return resultSQL.toString();
    }

    public static Object getSourceParamsItemValue(List<ParamsItem> pList, List<ParamValueItem> runParam, String paramName) {
        if (null == pList || pList.isEmpty()) {
            return null;
        }
        ParamsItem p = SQLExcuteHelper.getSourceParamsItem(pList, paramName);
        if (null == p || "variable".equals(p.getDataType())) {
            return null;
        }
        if (null != runParam && !runParam.isEmpty()) {
            for (ParamValueItem pv : runParam) {
                if (pv.isVariable() || !paramName.equals(pv.getParamName())) continue;
                return pv.getValue();
            }
        }
        return p.getValue();
    }

    public static ParamsItem getSourceParamsItem(List<ParamsItem> pList, String paramName) {
        if (null == pList || pList.isEmpty() || StringUtils.isEmpty((String)paramName)) {
            return null;
        }
        for (ParamsItem p : pList) {
            if (!paramName.equals(p.getParamName())) continue;
            return p;
        }
        return null;
    }
}

