/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.bs.ml.util.MLUtils;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.CodeCheckInfo;
import com.kingdee.shr.ml.ProjectCollection;
import com.kingdee.shr.ml.ProjectFactory;
import com.kingdee.shr.ml.ProjectInfo;
import com.kingdee.shr.ml.ShrMlBizException;
import com.kingdee.shr.ml.app.AbstractCodeCheckControllerBean;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.shr.ml.util.SvnClient;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class CodeCheckControllerBean
extends AbstractCodeCheckControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.CodeCheckControllerBean");
    private Properties projectMappingDomain;
    private Map<String, ProjectInfo> projectMap;
    private Set<String> excludeFileKeys;
    private Set<String> excludeFilePathKeys;
    private Set<String> excludeFiles;
    private Set<String> excludeFolders;

    private Properties getProjectMappingDomain() throws IOException {
        return SHRSyssettingUtil.getPropertiesFileByPath((String)SHRSyssettingUtil.getShrPropertiesPathByFileName((String)"PrjMappingDomain.properties"));
    }

    @Override
    protected void _check(Context ctx, String[] dPaths) throws BOSException, EASBizException {
        String[] projPaths;
        CoreBaseCollection coll = null;
        String _dPath_ = null;
        String unicode = "UTF-8";
        String projectName = null;
        String[] pp = null;
        this.initProjectInfo(ctx);
        String projectpaths = (String)this.projectMappingDomain.get("projectpath");
        if (StringUtils.isEmpty((String)projectpaths)) {
            return;
        }
        this.updateExcelude(ctx);
        this.svnUpdate();
        DbUtil.execute((Context)ctx, (String)"delete from T_SHR_CodeCheck");
        for (String dPath : projPaths = projectpaths.trim().split(";")) {
            File f;
            File[] subFiles;
            if (StringUtils.isEmpty((String)dPath)) continue;
            coll = new CoreBaseCollection();
            pp = (dPath = dPath.trim().replace("\n", "")).split(",");
            if (pp.length != 2) {
                throw new ShrMlBizException(ShrMlBizException.PROJECTPARAMERROR, new Object[]{dPath});
            }
            _dPath_ = pp[0];
            unicode = pp[1].toUpperCase();
            if (!"GBK".equalsIgnoreCase(unicode) && !"UTF-8".equalsIgnoreCase(unicode)) {
                throw new ShrMlBizException(ShrMlBizException.UNICODEERROR, new Object[]{_dPath_, unicode});
            }
            projectName = _dPath_.substring(_dPath_.lastIndexOf(File.separator) + 1);
            if (MLUtils.containChinese((String)projectName)) {
                logger.error((Object)MessageFormat.format("CodeCheckControllerBean _check error : project {0} contain chinese chars, skip.", projectName));
                continue;
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("projectName", (Object)projectName));
            if (this._exists(ctx, filter)) {
                this._delete(ctx, filter);
            }
            if (null == (subFiles = (f = new File(_dPath_)).listFiles()) || subFiles.length <= 0) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("project {0} bengin check. subFiles size {1}", projectName, subFiles.length));
            }
            int total = subFiles.length;
            for (int i = 0; i < total; ++i) {
                File file = subFiles[i];
                this.searchFile(ctx, file.getAbsolutePath(), projectName, coll, unicode);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)MessageFormat.format("project {0} end check.", projectName));
            }
            if (coll.size() <= 0) continue;
            this._saveBatchData(ctx, (IObjectCollection)coll);
        }
    }

    private void codeCheckExclude(Context ctx, String filePath, CoreBaseCollection collection) throws BOSException {
        String filePath0;
        Set<String> excludeSet;
        int excludeSetSize;
        int collectionSize = collection.size();
        if (collectionSize > 0 && (excludeSetSize = (excludeSet = this.getExcludeSet(ctx, filePath0 = filePath.replace("\\", "/"))).size()) > 0) {
            int i;
            CoreBaseCollection coll = new CoreBaseCollection();
            for (i = 0; i < collectionSize; ++i) {
                CodeCheckInfo info = (CodeCheckInfo)collection.get(i);
                String filePath1 = info.getFileFullPath().replace("\\", "/");
                String strHashCode = String.valueOf((filePath1 + info.getKey()).hashCode());
                if (!excludeSet.contains(strHashCode)) continue;
                coll.add((CoreBaseInfo)info);
            }
            if (!coll.isEmpty()) {
                int total = coll.size();
                for (i = 0; i < total; ++i) {
                    collection.remove(coll.get(i));
                }
            }
        }
    }

    private void updateExcelude(Context ctx) throws BOSException {
        String openKeySql = "SELECT FISFINISH FROM T_HR_HRINIT WHERE FKEY ='code_check_Excelude_update'";
        try {
            IRowSet rs0 = DbUtil.executeQuery((Context)ctx, (String)openKeySql);
            int openKeyValue = 0;
            if (rs0.next()) {
                openKeyValue = rs0.getInt("FISFINISH");
            } else {
                String insertsql = "insert into t_hr_hrinit(FID, FKey, FValue, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FHROrgUnitID, FControlUnitID, FIsFinish, FDescription) values (newbosid('4C6F2005'), N'code_check_Excelude_update', N'false', '00000000-0000-0000-0000-00000000000013B7DE7F', now(), '00000000-0000-0000-0000-00000000000013B7DE7F', now(), null, '00000000-0000-0000-0000-000000000000CCE7AED4', 0, N'\u786c\u7f16\u7801\u68c0\u6d4b\u6392\u9664')";
                DbUtil.execute((Context)ctx, (String)insertsql);
            }
            if (0 == openKeyValue) {
                String sql = "SELECT FID,FILEFULLPATH ,FUNIQUEKEY,FKEY  FROM T_SHR_CODECHECKEXCLUDE WHERE FILEFULLPATH like '%\\%'";
                String updateSQL = "UPDATE T_SHR_CODECHECKEXCLUDE SET FUNIQUEKEY = ?, FILEFULLPATH=?, FLASTUPDATEUSERID=?,FLASTUPDATETIME=NOW() WHERE FID = ?";
                String updateSQL0 = "UPDATE T_HR_HRINIT SET FISFINISH=1 WHERE FKEY ='code_check_Excelude_update'";
                PagingHelper pageHelper = new PagingHelper();
                int max = 10000;
                ArrayList<Object[]> paramsList = null;
                String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
                do {
                    String excuteSql = pageHelper.getPagingSqlNoOptmize(ctx, sql, 0, max);
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)excuteSql);
                    paramsList = new ArrayList<Object[]>();
                    while (rs.next()) {
                        String path = rs.getString("FILEFULLPATH").replace("\\", "/");
                        String key = rs.getString("FKEY");
                        String strHashCode = String.valueOf((path + key).hashCode());
                        String id = rs.getString("FID");
                        paramsList.add(new Object[]{strHashCode, path, userId, id});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramsList);
                } while (!paramsList.isEmpty());
                DbUtil.execute((Context)ctx, (String)updateSQL0);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Set<String> getExcludeSet(Context ctx, String filePath) throws BOSException {
        String sql = "SELECT FUNIQUEKEY  FROM T_SHR_CODECHECKEXCLUDE WHERE FILEFULLPATH = ?";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{filePath});
        HashSet<String> set = new HashSet<String>();
        try {
            while (rs.next()) {
                set.add(rs.getString("FUNIQUEKEY"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return set;
    }

    private void initExcludeFileKeys() {
        this.excludeFileKeys = new HashSet<String>();
        String str = (String)this.projectMappingDomain.get("excludeFileKeys");
        this.commonInit(this.excludeFileKeys, str);
    }

    private void commonInit(Set<String> set, String str) {
        if (!StringUtils.isEmpty((String)str)) {
            String[] strs;
            for (String key : strs = str.split(",")) {
                set.add(key);
            }
        }
    }

    private void initExcludeFilePathKeys() {
        this.excludeFilePathKeys = new HashSet<String>();
        String str = (String)this.projectMappingDomain.get("excludeFilePathKeys");
        this.commonInit(this.excludeFilePathKeys, str);
    }

    private List<String> getMessage(Context ctx, Map<String, List<Map<String, Object>>> aysDatas) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT t3.fbizdomainid, t3.name, t3.fnumber, t3.ftype, t3.fperson, t3.fbaserec FROM (").append(" SELECT distinct t0.fbizdomainid, t1.fname_").append(LocaleUtils.getShortCode((Context)ctx)).append(" name, t1.fnumber, t1.fsortcode,(case when t0.ftype='java' or t0.ftype='SQL' then 'BIZ' else 'WEB' end) ftype, fperson,fbaserec FROM T_SHR_CodePlan t0").append(" inner join T_SHR_BizDomain t1 on t0.fbizdomainid = t1.fid").append(" ) t3 order by t3.fsortcode asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String fbizdomainid = null;
        List<Map<String, Object>> listData = null;
        String type = null;
        String number = null;
        int personCount = 0;
        int baserecCount = 0;
        int workCount = 0;
        int weekDay = 0;
        StringBuilder bizMsg = new StringBuilder();
        StringBuilder webMsg = new StringBuilder();
        bizMsg.append("\u9886\u57df|\u7c7b\u578b|\u5168\u90e8\u603b\u91cf(java,SQL)|\u7d2f\u8ba1\u5b8c\u6210(java,SQL)|\u7d2f\u8ba1\u5b8c\u6210\u5360\u6bd4(java,SQL)|\u672c\u5468\u5b8c\u6210(java,SQL)|\u672c\u5468\u8ba1\u5212\u5b8c\u6210\n");
        webMsg.append("\u9886\u57df|\u7c7b\u578b|\u5168\u90e8\u603b\u91cf(js,others)|\u7d2f\u8ba1\u5b8c\u6210(js,others)|\u7d2f\u8ba1\u5b8c\u6210\u5360\u6bd4(js,others)|\u672c\u5468\u5b8c\u6210(js,others)|\u672c\u5468\u8ba1\u5212\u5b8c\u6210\n");
        try {
            while (rs.next()) {
                fbizdomainid = rs.getString("fbizdomainid");
                number = rs.getString("fnumber");
                personCount = rs.getInt("fperson");
                baserecCount = rs.getInt("fbaserec");
                listData = aysDatas.get(fbizdomainid);
                String datas = null;
                weekDay = DateTimeUtils.getWeekDay((Date)new Date()) - 1;
                if (weekDay < 1) {
                    weekDay = 0;
                }
                if (weekDay > 5) {
                    weekDay = 5;
                }
                workCount = personCount * baserecCount * weekDay;
                if ("WEB".equals(rs.getString("ftype"))) {
                    type = "\u524d\u7aef";
                    datas = this.calculateWEBData(listData, number);
                    webMsg.append(rs.getString("name")).append("|").append(type).append("|").append(datas).append("|").append(workCount).append("\n");
                    continue;
                }
                type = "\u540e\u7aef";
                datas = this.calculateBIZData(listData, number);
                bizMsg.append(rs.getString("name")).append("|").append(type).append("|").append(datas).append("|").append(workCount).append("\n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        ArrayList<String> msgs = new ArrayList<String>();
        msgs.add(bizMsg.toString());
        msgs.add(webMsg.toString());
        return msgs;
    }

    private String calculateBIZData(List<Map<String, Object>> listData, String number) {
        int javaAllctotal = 0;
        int javaAddFctotal = 0;
        int javaCurrFctotal = 0;
        int sqlAllctotal = 0;
        int sqlAddFctotal = 0;
        int sqlCurrFctotal = 0;
        StringBuffer s = new StringBuffer();
        for (Map<String, Object> each : listData) {
            if ("java".equals(each.get("type").toString())) {
                javaAllctotal = (Integer)each.get("allctotal");
                javaAddFctotal = (Integer)each.get("addFctotal");
                javaCurrFctotal = (Integer)each.get("currFctotal");
            }
            if (!"SQL".equals(each.get("type").toString())) continue;
            sqlAllctotal = (Integer)each.get("allctotal");
            sqlAddFctotal = (Integer)each.get("addFctotal");
            sqlCurrFctotal = (Integer)each.get("currFctotal");
        }
        s.append(javaAllctotal + sqlAllctotal).append("(").append(javaAllctotal).append(",").append(sqlAllctotal).append(")|");
        s.append(javaAddFctotal + sqlAddFctotal).append("(").append(javaAddFctotal).append(",").append(sqlAddFctotal).append(")|");
        double allTotalPercent = javaAllctotal + sqlAllctotal == 0 ? 0.0 : (double)(javaAddFctotal + sqlAddFctotal) * 1.0 / (double)(javaAllctotal + sqlAllctotal) * 100.0;
        double javaTotalPercent = javaAllctotal == 0 ? 0.0 : (double)javaAddFctotal * 1.0 / (double)javaAllctotal * 100.0;
        double sqlTotalPercent = sqlAllctotal == 0 ? 0.0 : (double)sqlAddFctotal * 1.0 / (double)sqlAllctotal * 100.0;
        s.append(Math.floor(allTotalPercent)).append("%(").append(Math.floor(javaTotalPercent)).append("%,").append(Math.floor(sqlTotalPercent)).append("%").append(")|");
        s.append(javaCurrFctotal + sqlCurrFctotal).append("(").append(javaCurrFctotal).append(",").append(sqlCurrFctotal).append(")");
        return s.toString();
    }

    private String calculateWEBData(List<Map<String, Object>> listData, String number) {
        int jsAllctotal = 0;
        int jsAddFctotal = 0;
        int jsCurrFctotal = 0;
        int othersAllctotal = 0;
        int othersAddFctotal = 0;
        int othersCurrFctotal = 0;
        StringBuffer s = new StringBuffer();
        for (Map<String, Object> each : listData) {
            if ("js".equals(each.get("type").toString())) {
                jsAllctotal = (Integer)each.get("allctotal");
                jsAddFctotal = (Integer)each.get("addFctotal");
                jsCurrFctotal = (Integer)each.get("currFctotal");
            }
            if (!"others".equals(each.get("type").toString())) continue;
            othersAllctotal = (Integer)each.get("allctotal");
            othersAddFctotal = (Integer)each.get("addFctotal");
            othersCurrFctotal = (Integer)each.get("currFctotal");
        }
        s.append(jsAllctotal + othersAllctotal).append("(").append(jsAllctotal).append(",").append(othersAllctotal).append(")|");
        s.append(jsAddFctotal + othersAddFctotal).append("(").append(jsAddFctotal).append(",").append(othersAddFctotal).append(")|");
        double allTotalPercent = jsAllctotal + othersAllctotal == 0 ? 0.0 : (double)(jsAddFctotal + othersAddFctotal) * 1.0 / (double)(jsAllctotal + othersAllctotal) * 100.0;
        double jsTotalPercent = jsAllctotal == 0 ? 0.0 : (double)jsAddFctotal * 1.0 / (double)jsAllctotal * 100.0;
        double othersTotalPercent = othersAllctotal == 0 ? 0.0 : (double)othersAddFctotal * 1.0 / (double)othersAllctotal * 100.0;
        s.append(Math.floor(allTotalPercent)).append("%(").append(Math.floor(jsTotalPercent)).append("%,").append(Math.floor(othersTotalPercent)).append("%)|");
        s.append(jsCurrFctotal + othersCurrFctotal).append("(").append(jsCurrFctotal).append(",").append(othersCurrFctotal).append(")");
        return s.toString();
    }

    private int getPeriodBatchNumber(Context ctx) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(1);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 1) {
            dayOfWeek = 7;
        }
        cal.add(5, cal.getFirstDayOfWeek() - dayOfWeek);
        Date mondayDate = cal.getTime();
        String weekBegin = sdf.format(mondayDate);
        StringBuilder sql = new StringBuilder();
        sql.append("select max(fbatchnumber) fbatchnumber from T_SHR_CodeCheckAys").append(" where FCreatime >= {ts'").append(weekBegin).append(" 00:00:00'}").append(" and FCreatime <= {ts'").append(weekBegin).append(" 23:59:59'}");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return rs.getInt("fbatchnumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return 0;
    }

    private void initProjectInfo(Context ctx) throws BOSException {
        try {
            this.projectMappingDomain = this.getProjectMappingDomain();
            this.initExcludeFileKeys();
            this.initExcludeFilePathKeys();
            this.initExcludeFolders();
            this.initExcludeFiles();
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        this.projectMap = new HashMap<String, ProjectInfo>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("type"));
        selector.add(new SelectorItemInfo("resPerson"));
        selector.add(new SelectorItemInfo("isValid"));
        selector.add(new SelectorItemInfo("projDomain.id"));
        selector.add(new SelectorItemInfo("projDomain.number"));
        selector.add(new SelectorItemInfo("projDomain.name"));
        selector.add(new SelectorItemInfo("projDomain.bizDomain.id"));
        selector.add(new SelectorItemInfo("projDomain.bizDomain.number"));
        selector.add(new SelectorItemInfo("projDomain.bizDomain.name"));
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(selector);
        ProjectCollection coll = ProjectFactory.getLocalInstance(ctx).getProjectCollection(view);
        if (null != coll && coll.size() > 0) {
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                this.projectMap.put(coll.get(i).getNumber(), coll.get(i));
            }
        }
    }

    private void generateCurrentData(Context ctx, int newPatchNumber) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO T_SHR_CodeCheckAys(FBatchNumber,FBizDomainID,FType,FCTotal,FSTotal,FCreatime,FID)").append(" SELECT ").append(newPatchNumber).append(", t1.fid,t0.ftype,(case when t0.ftype= 'java' or t0.ftype= 'SQL' then isnull(sum(cTotal),0) when t0.ftype= 'js' then isnull((select sum(1) from T_SHR_CodeCheck where ftype ='js'),0) else isnull((select sum(1) from T_SHR_CodeCheck where ftype not in ('java','SQL','js') ),0) end) cTotal,isnull(sum(sTotal),0) sTotal,now(),newbosid('10777C5D')").append(" FROM T_SHR_CodePlan t0").append(" left join T_SHR_BizDomain t1 on t0.fbizdomainid = t1.fid").append(" left join T_SHR_ProjDomain t2 on t2.fbizdomainid= t1.fid").append(" left join T_SHR_Project t3 on t3.fprojdomainid=t2.fid").append(" left join (").append(" SELECT fprojectid,(case when ftype ='java' or  ftype ='js' or ftype ='SQL' then  ftype else 'others' end) ftype,sum(1) cTotal,sum(case when ftype='SQL' and FsqlcontainMulti=1 then 1 else 0 end) sTotal").append(" FROM T_SHR_CodeCheck").append(" group by fprojectid,(case when ftype ='java' or  ftype ='js' or ftype ='SQL' then  ftype else 'others' end)").append(" ) t4 on t4.fprojectid = t3.fid and t0.ftype=t4.ftype").append(" group by t1.fid,t0.ftype");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private int getMaxPatchNumber(Context ctx) throws BOSException {
        int number = 0;
        String sql = "SELECT max(fbatchNumber) fbatchNumber FROM T_SHR_CodeCheckAys";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rs.next()) {
                number = rs.getInt("fbatchNumber");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return number;
    }

    private Map<String, List<Map<String, Object>>> statisticData(Context ctx, int patchNumber, int newPatchNumber) throws BOSException {
        StringBuilder sql = new StringBuilder();
        String fbizdomainid = null;
        sql.append("SELECT t3.fbizdomainid,t3.ftype,").append(" t3.fctotal allctotal,t3.fstotal allstotal,").append(" (t3.fctotal - t4.fctotal) addFctotal, (t3.fstotal-t4.fstotal) addFstotal, ").append(" (t5.fctotal - t4.fctotal) currFctotal, (t5.fstotal-t4.fstotal) currFstotal").append(" FROM (").append(" SELECT t0.fbizdomainid,t0.ftype,t0.fctotal,t0.fstotal FROM T_SHR_CodeCheckAys t0").append(" inner join T_SHR_BizDomain t1 on t0.fbizdomainid = t1.fid").append(" where t0.fbatchnumber= ? ) t3").append(" inner join (").append(" SELECT t0.fbizdomainid,t0.ftype,t0.fctotal,t0.fstotal FROM T_SHR_CodeCheckAys t0").append(" inner join T_SHR_BizDomain t1 on t0.fbizdomainid = t1.fid").append(" where t0.fbatchnumber= ? ) t4 on t3.fbizdomainid = t4.fbizdomainid and t3.ftype = t4.ftype").append(" inner join (").append(" SELECT t0.fbizdomainid,t0.ftype,t0.fctotal,t0.fstotal FROM T_SHR_CodeCheckAys t0").append(" inner join T_SHR_BizDomain t1 on t0.fbizdomainid = t1.fid").append(" where t0.fbatchnumber= ? ) t5 on t3.fbizdomainid = t5.fbizdomainid and t3.ftype= t5.ftype");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{1, newPatchNumber, patchNumber});
        HashMap<String, List<Map<String, Object>>> reuslt = new HashMap<String, List<Map<String, Object>>>();
        ArrayList list = null;
        HashMap<String, Object> obj = null;
        try {
            while (rs.next()) {
                fbizdomainid = rs.getString("fbizdomainid");
                list = (ArrayList)reuslt.get(fbizdomainid);
                if (list == null) {
                    list = new ArrayList();
                    reuslt.put(fbizdomainid, list);
                }
                obj = new HashMap<String, Object>();
                obj.put("type", rs.getString("ftype"));
                obj.put("allctotal", rs.getInt("allctotal"));
                obj.put("allstotal", rs.getInt("allstotal"));
                obj.put("addFctotal", rs.getInt("addFctotal"));
                obj.put("addFstotal", rs.getInt("addFstotal"));
                obj.put("currFctotal", rs.getInt("currFctotal"));
                obj.put("currFstotal", rs.getInt("currFstotal"));
                ((List)reuslt.get(fbizdomainid)).add(obj);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return reuslt;
    }

    private void initExcludeFolders() {
        this.excludeFolders = new HashSet<String>();
        String str = (String)this.projectMappingDomain.get("excludeFolders");
        this.commonInit(this.excludeFolders, str);
    }

    private void initExcludeFiles() {
        this.excludeFiles = new HashSet<String>();
        String str = (String)this.projectMappingDomain.get("excludeFiles");
        this.commonInit(this.excludeFiles, str);
    }

    private void searchFile(Context ctx, String path, String projectName, CoreBaseCollection coll, String unicode) throws EASBizException, BOSException {
        File file = new File(path);
        if (file.isDirectory() && this.excludeFolders.contains(file.getName())) {
            return;
        }
        if (file.isDirectory() && (file.listFiles() == null || file.listFiles().length <= 0)) {
            return;
        }
        if (file.isDirectory()) {
            int total = file.listFiles().length;
            for (int i = 0; i < total; ++i) {
                this.searchFile(ctx, file.listFiles()[i].getAbsolutePath(), projectName, coll, unicode);
            }
            return;
        }
        for (String key : this.excludeFileKeys) {
            if (file.getName().indexOf(key) == -1) continue;
            return;
        }
        for (String key : this.excludeFilePathKeys) {
            if (file.getAbsolutePath().indexOf(key) == -1) continue;
            return;
        }
        String type = file.getName().substring(file.getName().lastIndexOf(".") + 1).toLowerCase();
        if (this.excludeFiles.contains(type)) {
            return;
        }
        this.readToString(ctx, file.getAbsolutePath(), coll, projectName, type, unicode);
        String filePath = path.substring(path.indexOf(projectName));
        this.codeCheckExclude(ctx, filePath, coll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readToString(Context ctx, String path, CoreBaseCollection coll, String projectName, String type, String unicode) {
        FileInputStream in = null;
        InputStreamReader inReader = null;
        BufferedReader bufReader = null;
        try {
            in = new FileInputStream(new File(path));
            inReader = new InputStreamReader((InputStream)in, unicode);
            bufReader = new BufferedReader(inReader);
            StringBuilder content = new StringBuilder();
            String line = null;
            String str = "";
            while ((line = bufReader.readLine()) != null) {
                content.append(line);
                content.append("\n");
            }
            str = content.toString();
            if ("java".equalsIgnoreCase(type) || "js".equalsIgnoreCase(type) || "css".equalsIgnoreCase(type) || "jsp".equalsIgnoreCase(type) || "html".equalsIgnoreCase(type) || "htm".equalsIgnoreCase(type) || "tag".equalsIgnoreCase(type) || "ftl".equalsIgnoreCase(type)) {
                str = str.replaceAll("\\/\\/[\\s\\S]*?\\n", "\n");
                str = str.replaceAll("\\*/\\*", "*_*");
                str = str.replaceAll("\\/\\*{1,2}[\\s\\S]*?\\*\\/", "\n");
            }
            if ("html".equalsIgnoreCase(type) || "htm".equalsIgnoreCase(type) || "xml".equalsIgnoreCase(type) || "jsp".equalsIgnoreCase(type) || "ftl".equalsIgnoreCase(type) || "tag".equalsIgnoreCase(type)) {
                str = str.replaceAll("<!--[\\s\\S]*?-->", "\n");
                str = str.replaceAll("<%--[\\s\\S]*?--%>", "\n");
                str = str.replaceAll("&lt;%--[\\s\\S]*?--%&gt;", "\n");
            }
            if ("ftl".equalsIgnoreCase(type)) {
                str = str.replaceAll("<#--[\\s\\S]*?-->", "\n");
            }
            String[] arr = str.toString().split("\n");
            this.doSearch(ctx, arr, type, path, coll, projectName);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)e.getMessage());
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            if (null != inReader) {
                try {
                    inReader.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    private void doSearch(Context ctx, String[] arr, String type, String path, CoreBaseCollection coll, String projectName) {
        String originalValue = null;
        if (path.indexOf("zh_TW") > -1 || path.indexOf("zh_CN") > -1 || path.indexOf("en_US") > -1) {
            return;
        }
        if (path.endsWith("app.xml")) {
            return;
        }
        if (path.indexOf("shr_framework_web\\web\\WebContent\\webviews") > -1) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)MessageFormat.format("{0} checking ", path));
        }
        int total = arr.length;
        for (int i = 0; i < total; ++i) {
            if (StringUtils.isEmpty((String)arr[i]) || StringUtils.isEmpty((String)arr[i].trim())) continue;
            originalValue = arr[i].trim();
            String china = MutilanUtils.getChinese(originalValue);
            String _key_ = MessageFormat.format("{0}", arr[i].trim());
            String filePath = path.substring(path.indexOf(projectName));
            if ("commonplate\\web\\js\\shr\\ml\\commonMulResourceList.js".equals(filePath) && "\u7e41\u9ad4\u4e2d\u6587".equals(china)) continue;
            if (!StringUtils.isEmpty((String)china)) {
                coll.add((CoreBaseInfo)this.createModel(ctx, type, projectName, this.projectMap.get(projectName), false, filePath, china, _key_));
            }
            if (!"java".equalsIgnoreCase(type) || path.endsWith("LocaleUtils.java") || originalValue.toLowerCase().indexOf("_l2") <= 0 || originalValue.toLowerCase().indexOf("locale_l2") != -1) continue;
            coll.add((CoreBaseInfo)this.createModel(ctx, "SQL", projectName, this.projectMap.get(projectName), true, filePath, china, _key_));
        }
    }

    private CodeCheckInfo createModel(Context ctx, String type, String projectName, ProjectInfo project, boolean sqlContainMulti, String fileFullPath, String china, String key) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        UserInfo u = new UserInfo();
        u.setId(BOSUuid.read((String)HRFilterUtils.getCurrentUserId((Context)ctx)));
        CodeCheckInfo info = new CodeCheckInfo();
        info.setCreateTime(time);
        info.setLastUpdateTime(time);
        info.setCreator(u);
        info.setLastUpdateUser(u);
        info.setCU(HRFilterUtils.getCurrentCU((Context)ctx));
        if (null == project) {
            logger.error((Object)("project is null, projectName=" + projectName));
        }
        info.setType(type);
        info.setProjectName(projectName);
        info.setProject(project);
        info.setSqlContainMulti(sqlContainMulti);
        String fileFullPath0 = fileFullPath.replace("\\", "/");
        info.setFileFullPath(fileFullPath0);
        info.setContext(china);
        info.setKey(key);
        return info;
    }

    private void svnUpdate() throws BOSException {
        String updateItems = (String)this.projectMappingDomain.get("svn.updateItems");
        String path = (String)this.projectMappingDomain.get("svn.path");
        String updateDir = (String)this.projectMappingDomain.get("svn.updateDir");
        String svnUser = ((String)this.projectMappingDomain.get("svn.user")).trim();
        String svnPassword = ((String)this.projectMappingDomain.get("svn.password")).trim();
        String[] items = updateItems.split(",");
        if (StringUtils.isEmpty((String)updateItems) || StringUtils.isEmpty((String)path) || StringUtils.isEmpty((String)updateDir) || StringUtils.isEmpty((String)svnUser) || StringUtils.isEmpty((String)svnPassword)) {
            return;
        }
        SvnClient svnClient = null;
        for (String svnDir : items) {
            String svnPath = path + svnDir;
            String targetDir = updateDir + svnDir;
            try {
                svnClient = new SvnClient(svnPath, svnUser, svnPassword);
                svnClient.connectSVN();
                svnClient.doUpdate(targetDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

