/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.ml.ResourceType;
import com.kingdee.shr.ml.app.AbstractMLServiceControllerBean;
import com.kingdee.shr.ml.service.ISHRWebPageResourceParser;
import com.kingdee.shr.ml.service.impl.AbstractSHRWebPageResourceParser;
import com.kingdee.shr.ml.service.impl.FreemarkerResourceParser;
import com.kingdee.shr.ml.service.impl.JavaScriptResourceParser;
import com.kingdee.shr.ml.service.impl.JsPluginResourceParser;
import com.kingdee.shr.ml.service.impl.JspResourceParser;
import com.kingdee.shr.ml.service.impl.UIViewSHRWebPageResourceParser;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class MLServiceControllerBean
extends AbstractMLServiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.MLServiceControllerBean");

    @Override
    protected void _fetchData(Context ctx, Map params, ResourceType resourceType) throws BOSException, EASBizException {
        ISHRWebPageResourceParser helper = this.getResourceParser(ctx, resourceType, params);
        helper.parse();
    }

    private ISHRWebPageResourceParser getResourceParser(Context ctx, ResourceType resourceType, Map params) throws BOSException {
        AbstractSHRWebPageResourceParser helper = null;
        if (ResourceType.UIView.equals((Object)resourceType)) {
            helper = new UIViewSHRWebPageResourceParser(ctx, params, resourceType);
        } else if (ResourceType.FTL.equals((Object)resourceType)) {
            helper = new FreemarkerResourceParser(ctx, params, resourceType);
        } else if (ResourceType.JS.equals((Object)resourceType)) {
            helper = new JavaScriptResourceParser(ctx, params, resourceType);
        } else if (ResourceType.JSP.equals((Object)resourceType)) {
            helper = new JspResourceParser(ctx, params, resourceType);
        } else if (ResourceType.JSPLUGIN.equals((Object)resourceType)) {
            helper = new JsPluginResourceParser(ctx, params, resourceType);
        }
        return helper;
    }

    @Override
    protected Object _convert(Context ctx, ResourceType resourceType, Map params) throws BOSException, EASBizException {
        ISHRWebPageResourceParser helper = this.getResourceParser(ctx, resourceType, params);
        if (null == helper) {
            return null;
        }
        return helper.convert();
    }

    @Override
    protected Map _getSHRResource(Context ctx, String pkg, String fileName) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)pkg) || StringUtils.isEmpty((String)fileName)) {
            return Collections.EMPTY_MAP;
        }
        String sql = "SELECT FKEY, FRES2 FROM T_SHR_SHRRESOURCE WHERE FPACKAGENAME = ? AND FILENAME = ?";
        HashMap<String, String> result = new HashMap<String, String>();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pkg, fileName});
        try {
            while (rs.next()) {
                result.put(rs.getString("FKEY"), rs.getString("FRES2"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _applyCommonFetchToUIFetch(Context ctx, String pkg, String fileName, String lang) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder("select teas.FCONTENT,tres.FRES,FMD5CODE  from T_RES_EASResource as tres inner join ");
        sql.append("T_RES_EASMultiLanRes as teas on tres.fid = teas.FPARENTID    where   teas.FLANGUAGEID = ? and");
        sql.append(" FMD5CODE in (SELECT t1.FMD5 from  T_RES_UIMultiLan as t  inner join  T_RES_UIResource ");
        sql.append("as t1 on t.FRESID   = t1.fid where t1.FPackage=? and  t1.FFILENAME =? and t.FLANGUAGE =? and ");
        sql.append("t.FMLRES2 is null)");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{lang, pkg, fileName, lang});
        String updateSql = "update T_RES_UIMultiLan  set FMLRES =?,FMLRES2=? where FCNMD5 =? and FLANGUAGE=?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        try {
            while (rs.next()) {
                String FMD5 = rs.getString("FMD5CODE");
                String FCONTENT = rs.getString("FCONTENT");
                Object[] param = new Object[]{FCONTENT, FCONTENT, FMD5, lang};
                paramsList.add(param);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.executeBatch((Context)ctx, (String)updateSql, paramsList);
    }
}

