/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.ml.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.bs.ml.MetaDataTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.util.SHRSyssettingUtil;
import com.kingdee.shr.ml.SHRResourceFactory;
import com.kingdee.shr.ml.SHRResourceInfo;
import com.kingdee.shr.ml.WebCodeCheckCollection;
import com.kingdee.shr.ml.WebCodeCheckFactory;
import com.kingdee.shr.ml.WebCodeCheckInfo;
import com.kingdee.shr.ml.app.AbstractWebCodeCheckControllerBean;
import com.kingdee.shr.ml.util.MutilanUtils;
import com.kingdee.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class WebCodeCheckControllerBean
extends AbstractWebCodeCheckControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.ml.app.WebCodeCheckControllerBean");
    private static Pattern pat = Pattern.compile("<script.*src=\"(.*?)\"");
    public static final String SHR_WEB_WAR_NAME = "shr_web.war";
    public static final String EAS_EAR_ROOT = SHRSyssettingUtil.getEasWebWarPath();
    public static final String PACKAGE_NAME = "com\\kingdee\\shr\\shrwebjs";
    public static final String GLOBAL_MUL_OBJ = "jsBizMultLan";
    public static final String SONG_TI = "\u5b8b\u4f53";
    public static final String YA_HEI = "\u5fae\u8f6f\u96c5\u9ed1";

    @Override
    protected List _getUIViewTreeList(Context ctx) throws BOSException {
        HashMap<String, Integer> uiviewMap = new HashMap<String, Integer>();
        ArrayList list = new ArrayList();
        try {
            String selectSQL = "select  uiviewtree.fnumber number, uiviewtree.fname_l2 name, count(*) count from s_bs_uiview uiview inner join s_bs_uiviewtree uiviewtree on uiview.ftreeid = uiviewtree.fid  group by uiviewtree.fname_l2, uiviewtree.fnumber order by uiviewtree.fnumber";
            String updateSQL = "update T_SHR_WebCodeProcess set ftotal = ? where fnumber = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String number = rs.getString("number");
                String name = rs.getString("name");
                int count = rs.getInt("count");
                map.put("number", number);
                map.put("name", name);
                map.put("count", count);
                uiviewMap.put(number, count);
                list.add(map);
                paramsList.add(new Object[]{count, number});
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSQL, paramsList);
            paramsList.clear();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    protected Map _replaceWebCodeTask(Context ctx) throws BOSException {
        Map<Object, Object> map = new HashMap();
        map = this.replaceWebCodeTask(ctx);
        return map;
    }

    @Override
    public Map<String, Object> replaceWebCodeTask(Context ctx) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String selectSQL = "select fnumber, fullpath, fuipk, filename, fres from t_shr_webCodeCheck where fkey is null order by fnumber, fuipk, fullpath, filename, fres";
        String updateSQL = "update t_shr_webCodeCheck set fkey = ? where fnumber = ? and fuipk =? and filename = ? and fres = ? ";
        ArrayList<Object[]> checkParamsList = new ArrayList<Object[]>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        String fileFullPath = "";
        String refUipk = "";
        String ruleKeyCode = "";
        ArrayList<String> resList = new ArrayList<String>();
        HashSet<String> filePathSet = new HashSet<String>();
        int cursor = 0;
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                String fullpath = rs.getString("fullpath");
                String uipk = rs.getString("fuipk");
                String filename = rs.getString("filename");
                String res = rs.getString("fres");
                if (!(refUipk.equals(uipk) && fileFullPath.equals(fullpath) || StringUtils.isEmpty((String)fileFullPath) || StringUtils.isEmpty((String)refUipk) || resList.size() <= 0)) {
                    if (!filePathSet.contains(fileFullPath)) {
                        filePathSet.add(fileFullPath);
                        this.autoReplace(fileFullPath, resList, ruleKeyCode);
                    }
                    DbUtil.executeBatch((Context)ctx, (String)updateSQL, checkParamsList);
                    resList.clear();
                    cursor = 0;
                    checkParamsList.clear();
                }
                fileFullPath = fullpath;
                refUipk = uipk;
                ruleKeyCode = number + "_" + filename.substring(0, filename.lastIndexOf(".")) + "_i18n";
                if (resList.contains(res)) continue;
                resList.add(res);
                checkParamsList.add(new Object[]{ruleKeyCode + "_" + cursor, number, uipk, filename, res});
                ++cursor;
            }
            if (!StringUtils.isEmpty((String)fileFullPath) && !StringUtils.isEmpty((String)refUipk) && resList.size() > 0) {
                if (!filePathSet.contains(fileFullPath)) {
                    this.autoReplace(fileFullPath, resList, ruleKeyCode);
                }
                DbUtil.executeBatch((Context)ctx, (String)updateSQL, checkParamsList);
                resList.clear();
                checkParamsList.clear();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoReplace(String filePath, List<String> resList, String ruleKeyCode) {
        File file = new File(filePath);
        Long fileLength = file.length();
        byte[] fileContext = new byte[fileLength.intValue()];
        FileInputStream in = null;
        PrintWriter out = null;
        int cursor = 0;
        try {
            in = new FileInputStream(filePath);
            in.read(fileContext);
            String str = new String(fileContext, "utf-8");
            for (int i = 0; i < resList.size(); ++i) {
                String res = resList.get(i);
                str = str.replace("'" + res + "'", "jsBizMultLan." + ruleKeyCode + "_" + cursor);
                ++cursor;
            }
            out = new PrintWriter(filePath);
            out.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected Map _storageWebCodeTask(Context ctx) throws BOSException {
        Map<Object, Object> map = new HashMap();
        map = this.storageWebCodeTask(ctx);
        return map;
    }

    @Override
    public Map<String, Object> storageWebCodeTask(Context ctx) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String oql = "where key is not null";
        WebCodeCheckCollection cols = WebCodeCheckFactory.getLocalInstance(ctx).getWebCodeCheckCollection(oql);
        if (cols != null && cols.size() > 0) {
            CoreBaseCollection col = new CoreBaseCollection();
            for (int i = 0; i < cols.size(); ++i) {
                WebCodeCheckInfo info = cols.get(i);
                SHRResourceInfo srcInfo = new SHRResourceInfo();
                srcInfo.setPackageName(PACKAGE_NAME);
                srcInfo.setFileName(info.getUipk());
                srcInfo.setMetaType(MetaDataTypeEnum.ui);
                srcInfo.setKey(info.getKey());
                srcInfo.setProject(info.getProject());
                srcInfo.setRes(info.getRes().substring(1, info.getRes().length() - 1).trim());
                srcInfo.setRes2(info.getRes().substring(1, info.getRes().length() - 1).trim());
                col.add((CoreBaseInfo)srcInfo);
                if (col.size() % 500 != 0) continue;
                try {
                    SHRResourceFactory.getLocalInstance(ctx).saveBatchData(col);
                    col.clear();
                    continue;
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
            }
            try {
                SHRResourceFactory.getLocalInstance(ctx).saveBatchData(col);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _checkCodeTask(Context ctx, String viewUipk) throws BOSException {
        String uipkStr = this.handleViewUipk(viewUipk);
        StringBuilder sb = new StringBuilder();
        sb.append("select  uiviewtree.fnumber number, uiviewtree.fname_l2 name, uiview.fid fid, uiview.fcontent content,ext.FContent extContent , uiview.fuipk uipk, uiview.fvardefine vardefine");
        sb.append(" from s_bs_uiview uiview");
        sb.append(" left join s_bs_uiviewtree uiviewtree on uiview.ftreeid = uiviewtree.fid");
        sb.append(" left join s_bs_uiviewext ext on uiview.FID = ext.fparentid");
        sb.append(" where uiview.fuipk in (").append(uipkStr).append(") order by uiviewtree.fnumber,  uiview.fuipk");
        String selectParentSQL = "select * from t_shr_webcodecheck where fullpath = ? and fuipk = (select max(fuipk) from  (select count(fuipk) count, fuipk from t_shr_webcodecheck where fullpath = ? group by fuipk) r where r.count = (select max(count) from (select count(fuipk) count, fuipk from t_shr_webcodecheck where fullpath = ? group by fuipk) t ))";
        HashMap<String, String> map = new HashMap<String, String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        CoreBaseCollection cols = new CoreBaseCollection();
        RandomAccessFile br = null;
        try {
            while (rs.next()) {
                String num = rs.getString("number");
                String name = rs.getString("name");
                String standardContent = rs.getString("content");
                String extContent = rs.getString("extContent");
                String uipk = rs.getString("uipk");
                String vardefine = rs.getString("vardefine");
                String appCode = "";
                if (!StringUtils.isEmpty((String)vardefine)) {
                    if (vardefine.indexOf(";") == -1) {
                        if (vardefine.startsWith("appCode")) {
                            appCode = vardefine.split("=")[1];
                        }
                    } else {
                        String[] tt;
                        for (String strs : tt = vardefine.split(";")) {
                            if (!strs.startsWith("appCode")) continue;
                            appCode = strs.split("=")[1];
                        }
                    }
                }
                String content = standardContent;
                if (!StringUtils.isEmpty((String)extContent)) {
                    content = extContent;
                }
                if (StringUtils.isEmpty((String)content)) continue;
                String fullPath = "";
                String mFullPath = "";
                Matcher mat = pat.matcher(new String(content.getBytes("8859_1"), "utf8"));
                HashSet<String> resSet = null;
                while (mat.find()) {
                    resSet = new HashSet<String>();
                    fullPath = mat.group(1);
                    if (fullPath.indexOf("${appPath}") >= 0) {
                        fullPath = fullPath.replace("${appPath}", EAS_EAR_ROOT + File.separator + SHR_WEB_WAR_NAME + File.separator + "addon");
                        if (!StringUtils.isEmpty((String)vardefine)) {
                            fullPath = fullPath.replace("${appCode}", appCode);
                        }
                    } else {
                        fullPath = EAS_EAR_ROOT + File.separator + SHR_WEB_WAR_NAME + File.separator + fullPath;
                    }
                    fullPath = fullPath.replaceAll("/", "\\\\");
                    mFullPath = fullPath.substring(fullPath.indexOf(SHR_WEB_WAR_NAME));
                    String fileName = fullPath.substring(fullPath.lastIndexOf("\\") + 1);
                    WebCodeCheckCollection collection = this.getWebCodeCheckCollection(ctx, "where fullpath like '%" + mFullPath + "%' and uipk = '" + uipk + "'");
                    if (collection.size() > 0) {
                        IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)selectParentSQL, (Object[])new Object[]{fullPath, fullPath, fullPath});
                        while (iRowSet.next()) {
                            String key1 = iRowSet.getString("fkey");
                            boolean existRec = false;
                            for (int i = 0; i < collection.size(); ++i) {
                                WebCodeCheckInfo webCodeCheckinfo = collection.get(i);
                                String existKey = webCodeCheckinfo.getString("key");
                                if (!existKey.equals(key1)) continue;
                                existRec = true;
                                break;
                            }
                            if (existRec) continue;
                            String res1 = iRowSet.getString("fres");
                            WebCodeCheckInfo info = new WebCodeCheckInfo();
                            info.setId(BOSUuid.create((String)"4516CC64"));
                            info.setProject(appCode);
                            info.setNumber(num);
                            info.setFullpath(fullPath);
                            info.setType(name);
                            info.setUipk(uipk);
                            info.setFilename(fileName);
                            info.setKey(key1);
                            info.setRes(res1);
                            cols.add((CoreBaseInfo)info);
                        }
                    }
                    if (cols.size() % 100 == 0) {
                        try {
                            WebCodeCheckFactory.getLocalInstance(ctx).saveBatchData(cols);
                            cols.clear();
                        }
                        catch (Exception e) {
                            map.put("error", e.getMessage());
                            e.printStackTrace();
                        }
                    }
                    try {
                        br = new RandomAccessFile(fullPath, "rw");
                        MutilanUtils.resetAnalysisLineFlag();
                        String str = null;
                        while ((str = br.readLine()) != null) {
                            String lineStr = new String(str.getBytes("8859_1"), "utf8");
                            String pattern = "('(.*[\u4e00-\u9fa5]+.*)')";
                            Pattern pat1 = Pattern.compile(pattern);
                            Matcher mat1 = pat1.matcher(MutilanUtils.analysisLine(lineStr));
                            while (mat1.find()) {
                                String res = mat1.group(2);
                                if (res.indexOf(SONG_TI) >= 0 || res.indexOf(YA_HEI) >= 0) continue;
                                if (!resSet.contains(res)) {
                                    WebCodeCheckInfo info = new WebCodeCheckInfo();
                                    info.setId(BOSUuid.create((String)"4516CC64"));
                                    info.setProject(appCode);
                                    info.setNumber(num);
                                    info.setFullpath(fullPath);
                                    info.setType(name);
                                    info.setUipk(uipk);
                                    info.setFilename(fileName);
                                    info.setKey(null);
                                    info.setRes(res);
                                    cols.add((CoreBaseInfo)info);
                                    resSet.add(res);
                                }
                                if (cols.size() % 100 != 0) continue;
                                try {
                                    WebCodeCheckFactory.getLocalInstance(ctx).saveBatchData(cols);
                                    cols.clear();
                                }
                                catch (Exception e) {
                                    map.put("error", e.getMessage());
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    finally {
                        if (br == null) continue;
                        br.close();
                    }
                }
            }
            if (cols.size() > 0) {
                try {
                    WebCodeCheckFactory.getLocalInstance(ctx).saveBatchData(cols);
                    cols.clear();
                }
                catch (Exception e) {
                    map.put("error", e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (SQLException e) {
            map.put("error", e.getMessage());
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            map.put("error", e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            map.put("error", e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    map.put("error", e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        return map;
    }

    private String handleViewUipk(String viewUipk) {
        String uipkStr = "";
        if (!StringUtils.isEmpty((String)viewUipk)) {
            String[] uipkArr;
            for (String uipk : uipkArr = viewUipk.split(",")) {
                uipkStr = uipkStr + "'" + uipk + "',";
            }
            uipkStr = uipkStr.substring(0, uipkStr.length() - 1);
        }
        return uipkStr;
    }

    @Override
    protected Map _replaceCodeTask(Context ctx, String viewUipk) throws BOSException {
        String uipkStr = this.handleViewUipk(viewUipk);
        HashMap<String, String> map = new HashMap<String, String>();
        String selectSQL = "select fnumber, fullpath, fuipk, filename, fres from t_shr_webCodeCheck where fkey is null and fuipk in (" + uipkStr + ") order by fnumber, fuipk, fullpath, filename, fres";
        String updateSQL = "update t_shr_webCodeCheck set fkey = ? where fnumber = ? and fuipk =? and filename = ? and fres = ? ";
        ArrayList<Object[]> checkParamsList = new ArrayList<Object[]>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
        String fileFullPath = "";
        String ruleKeyCode = "";
        ArrayList<String> resList = new ArrayList<String>();
        HashSet<String> filePathSet = new HashSet<String>();
        int cursor = 0;
        try {
            while (rs.next()) {
                String number = rs.getString("fnumber");
                String fullpath = rs.getString("fullpath");
                String uipk = rs.getString("fuipk");
                String filename = rs.getString("filename");
                String res = rs.getString("fres");
                if (!fileFullPath.equals(fullpath) && !StringUtils.isEmpty((String)fileFullPath) && resList.size() > 0) {
                    if (!filePathSet.contains(fileFullPath)) {
                        filePathSet.add(fileFullPath);
                        this.autoReplace(fileFullPath, resList, ruleKeyCode);
                    }
                    DbUtil.executeBatch((Context)ctx, (String)updateSQL, checkParamsList);
                    resList.clear();
                    cursor = 0;
                    checkParamsList.clear();
                }
                fileFullPath = fullpath;
                ruleKeyCode = number + "_" + filename.substring(0, filename.lastIndexOf(".")) + "_" + System.currentTimeMillis() / 1000L / 60L + "_i18n";
                if (resList.contains(res)) continue;
                resList.add(res);
                checkParamsList.add(new Object[]{ruleKeyCode + "_" + cursor, number, uipk, filename, res});
                ++cursor;
            }
            if (!StringUtils.isEmpty((String)fileFullPath) && resList.size() > 0) {
                if (!filePathSet.contains(fileFullPath)) {
                    this.autoReplace(fileFullPath, resList, ruleKeyCode);
                }
                DbUtil.executeBatch((Context)ctx, (String)updateSQL, checkParamsList);
                resList.clear();
                checkParamsList.clear();
            }
        }
        catch (SQLException e) {
            map.put("error", e.getMessage());
            e.printStackTrace();
        }
        return map;
    }

    @Override
    protected Map _storageCodeTask(Context ctx, String viewUipk) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String uipkStr = this.handleViewUipk(viewUipk);
        String deleteSQL = "delete from t_shr_shrresource where filename in (" + uipkStr + ") and fpackagename = '" + PACKAGE_NAME + "'";
        DbUtil.execute((Context)ctx, (String)deleteSQL);
        String oql = "where key is not null and uipk = (" + uipkStr + ")";
        WebCodeCheckCollection cols = WebCodeCheckFactory.getLocalInstance(ctx).getWebCodeCheckCollection(oql);
        if (cols != null && cols.size() > 0) {
            CoreBaseCollection col = new CoreBaseCollection();
            ArrayList<String> keyList = new ArrayList<String>();
            for (int i = 0; i < cols.size(); ++i) {
                WebCodeCheckInfo info = cols.get(i);
                SHRResourceInfo srcInfo = new SHRResourceInfo();
                srcInfo.setPackageName(PACKAGE_NAME);
                srcInfo.setFileName(info.getUipk());
                srcInfo.setMetaType(MetaDataTypeEnum.ui);
                srcInfo.setKey(info.getKey());
                srcInfo.setProject(info.getProject());
                srcInfo.setRes(info.getRes().trim());
                srcInfo.setRes2(info.getRes().trim());
                String key = PACKAGE_NAME + info.getUipk() + info.getKey();
                if (!keyList.contains(key)) {
                    col.add((CoreBaseInfo)srcInfo);
                    keyList.add(key);
                }
                if (col.size() % 500 != 0) continue;
                try {
                    SHRResourceFactory.getLocalInstance(ctx).saveBatchData(col);
                    col.clear();
                    continue;
                }
                catch (EASBizException e) {
                    map.put("error", e.getMessage());
                    e.printStackTrace();
                }
            }
            try {
                SHRResourceFactory.getLocalInstance(ctx).saveBatchData(col);
            }
            catch (EASBizException e) {
                map.put("error", e.getMessage());
                e.printStackTrace();
            }
        }
        return map;
    }
}

