/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.base.service;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.bireport.bimanager.ws.paramCtx.util.Strings;
import com.kingdee.shr.base.syssetting.CloudHubMessageFacadeFactory;
import com.kingdee.shr.base.syssetting.cloud.http.HttpResultVo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfEmailConfigInfo;
import com.kingdee.shr.perfweb.base.serviceImpl.SendUrgeMessageService;
import com.kingdee.shr.perfweb.bean.MsgConfigBean;
import com.kingdee.shr.perfweb.bean.ReMsgBean;
import com.kingdee.shr.perfweb.util.GetEntityInfoUtils;
import com.kingdee.shr.perfweb.util.NoticeUtils;
import com.kingdee.shr.perfweb.utils.CurrentUserUtil;
import com.kingdee.shr.perfweb.utils.EmailUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendMsgCallable
implements Runnable {
    private static Logger logger = LoggerFactory.getLogger(SendMsgCallable.class);
    public static ExecutorService msgThreadPool = Executors.newFixedThreadPool(10);
    private Context ctx;
    private Collection<ReMsgBean> msgColl;

    public SendMsgCallable(Context ctx, Collection<ReMsgBean> msgColl) {
        this.ctx = ctx;
        this.msgColl = msgColl;
    }

    @Override
    public void run() {
        logger.info("[perfweb]:SendMessageService:msg consume start!");
        PerfEmailConfigInfo perfEmailConfInfo = GetEntityInfoUtils.getAndUpdateCurrentUsePerfEmailConfigInfo(this.ctx);
        boolean isEmailNetwork = false;
        if (null != perfEmailConfInfo && !Strings.isEmpty((String)perfEmailConfInfo.getEmailServer()) && !Strings.isEmpty((String)perfEmailConfInfo.getPort())) {
            isEmailNetwork = EmailUtils.judgeUrlIsReachable(perfEmailConfInfo.getEmailServer(), Integer.parseInt(perfEmailConfInfo.getPort()));
        }
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (ReMsgBean msgBean : this.msgColl) {
            try {
                MsgConfigBean config;
                if (msgBean == null || msgBean.getConfig() == null || (config = msgBean.getConfig()) == null) continue;
                if (config.isYzjType()) {
                    try {
                        String personId = msgBean.getReceiver().getId().toString();
                        UserCollection userColl = CurrentUserUtil.getUserCollByPersonId(this.ctx, personId);
                        HttpResultVo httpResultVo = (HttpResultVo)CloudHubMessageFacadeFactory.getLocalInstance((Context)this.ctx).sendTextMessageToUser(msgBean.getYzjContent(), userColl, "perfwebNotice", false);
                    }
                    catch (Exception e) {
                        logger.error("[perfweb]:SendMessageService:send yzjMessage err! ", (Throwable)e);
                    }
                }
                if (config.isEmailType() && isEmailNetwork) {
                    boolean emailFlag = false;
                    try {
                        emailFlag = SendUrgeMessageService.sendEmailService(this.ctx, msgBean.getReceiver().getEmail(), msgBean.getEmailTitle(), msgBean.getEmailContent(), perfEmailConfInfo);
                        logger.info("[perfweb]:SendMessageService:send emailMessage " + emailFlag + "!");
                    }
                    catch (Exception e) {
                        logger.error("[perfweb]:SendMessageService:send emailMessage " + emailFlag, (Throwable)e);
                    }
                }
                if (config.isSmsType()) {
                    boolean smsFlag = false;
                    try {
                        HashMap<String, Object> otherParams = new HashMap<String, Object>();
                        otherParams.put("evaObjId", msgBean.get("evaObjId"));
                        otherParams.put("hrOrgUnitId", msgBean.get("hrOrgUnitId"));
                        smsFlag = SendUrgeMessageService.sendSMSService(this.ctx, msgBean.getReceiver().getCell(), config.getPhoneContent(), config.getSmsTemplateCode(), otherParams);
                        logger.info("[perfweb]:SendMessageService:send smsMessage " + smsFlag + "!");
                    }
                    catch (Exception e) {
                        logger.error("[perfweb]:SendMessageService:send smsMessage " + smsFlag, (Throwable)e);
                    }
                }
                if (!config.isSysType()) continue;
                NoticeUtils.sendNoticesToPortal(this.ctx, msgBean, "100", coreColl);
            }
            catch (Exception e) {
                logger.error("[perfweb]:SendMessageService:msg consume err!", (Throwable)e);
            }
        }
        try {
            if (!coreColl.isEmpty()) {
                BMCMessageFactory.getLocalInstance((Context)this.ctx).saveBatchData(coreColl);
                NoticeUtils.expireMessage(this.ctx, coreColl);
            }
        }
        catch (Exception e) {
            logger.error("[perfweb]:SendMessageService:save sysMessage err!", (Throwable)e);
        }
        logger.info("[perfweb]:SendMessageService:msg consume end!");
    }
}

