/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.bean;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileCheckStatement {
    private static Logger logger = LoggerFactory.getLogger(FileCheckStatement.class);
    public Set<String> checks = new HashSet<String>();

    public abstract String ifFail(String var1) throws IOException;

    public boolean checkFile(File file) throws IOException {
        return this.checkFile(file.getName(), this.fileConvertToByteArray(file));
    }

    public abstract boolean checkFile(String var1, byte[] var2) throws IOException;

    public FileCheckStatement(Set<String> checks) {
        this.checks = checks;
    }

    public FileCheckStatement() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] fileConvertToByteArray(File file) throws IOException {
        byte[] data = null;
        FileInputStream fis = null;
        ByteArrayOutputStream baos = null;
        try {
            int len;
            fis = new FileInputStream(file);
            baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[10240];
            while ((len = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            data = baos.toByteArray();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        finally {
            if (null != fis) {
                fis.close();
            }
            if (null != baos) {
                baos.close();
            }
        }
        return data;
    }
}

