/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.common;

import com.kingdee.shr.perfweb.formulaplatform.common.DataTable;
import com.kingdee.shr.perfweb.formulaplatform.common.StringUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonMethod {
    static Logger logger = LoggerFactory.getLogger(CommonMethod.class);

    public static int ResultSet_indexOf(ResultSet rs, String sColName) throws Exception {
        for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            if (!rs.getMetaData().getColumnName(i).equalsIgnoreCase(sColName)) continue;
            return i;
        }
        return -1;
    }

    public static List convertResultSetToList(ResultSet rs) throws Exception {
        int i;
        ArrayList<String[]> listReturn = new ArrayList<String[]>();
        String[] ssRow = new String[rs.getMetaData().getColumnCount()];
        for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
            ssRow[i - 1] = rs.getMetaData().getColumnName(i).toString();
        }
        listReturn.add(ssRow);
        while (rs.next()) {
            ssRow = new String[rs.getMetaData().getColumnCount()];
            for (i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                ssRow[i - 1] = rs.getString(i);
            }
            listReturn.add(ssRow);
        }
        return listReturn;
    }

    public static DataTable convertResultSetToDataTable(ResultSet rs) throws Exception {
        return CommonMethod.convertResultSetToDataTable(rs, false);
    }

    public static DataTable convertResultSetToDataTable(ResultSet rs, boolean bLimitRows) throws Exception {
        logger.debug("Entering convertResultSetToDataTable()");
        if (rs == null) {
            logger.error("convertResultSetToDataTable:parse error\uff0crs is null");
            throw new Exception("convertResultSetToDataTable:convertResultSetToDataTable:parse error\uff0crs is null");
        }
        DataTable dtReturn = new DataTable();
        try {
            ResultSetMetaData rsma = rs.getMetaData();
            int iColCount = rsma.getColumnCount();
            String[] ssRow = new String[iColCount];
            String[] ssColType = new String[iColCount];
            for (int i = 1; i <= iColCount; ++i) {
                ssRow[i - 1] = rsma.getColumnName(i).toString();
                ssColType[i - 1] = rsma.getColumnTypeName(i);
            }
            dtReturn.add(ssRow);
            int iRowCount = 0;
            while (rs.next()) {
                if (bLimitRows && iRowCount == 1000) {
                    logger.error("convertResultSetToDataTable:from ResultSet to DataTable has more data, only parse 1000 item\uff01");
                    break;
                }
                ssRow = new String[iColCount];
                for (int i = 1; i <= iColCount; ++i) {
                    String sColName = ssColType[i - 1];
                    if (sColName.equals("BLOB")) {
                        Blob blob = rs.getBlob(i);
                        if (blob == null) continue;
                        ssRow[i - 1] = blob.toString();
                        continue;
                    }
                    if (sColName.equals("CLOB")) {
                        Clob clob = rs.getClob(i);
                        if (clob == null) continue;
                        ssRow[i - 1] = clob.getSubString(1L, (int)clob.length());
                        continue;
                    }
                    if (sColName.equals("DATE") || sColName.equals("TIMESTAMP")) {
                        Timestamp dd = rs.getTimestamp(i);
                        if (dd != null) {
                            ssRow[i - 1] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(dd);
                            continue;
                        }
                        ssRow[i - 1] = "";
                        continue;
                    }
                    Object obj = rs.getObject(i);
                    ssRow[i - 1] = obj != null ? obj.toString() : "";
                }
                dtReturn.add(ssRow);
                ++iRowCount;
            }
            String s = "convertResultSetToDataTable:dt rows count:" + iRowCount + ";dt columns count:" + iColCount;
            if (bLimitRows) {
                s = s + "(listGrid)";
            }
            logger.debug(s);
            DataTable dataTable = dtReturn;
            return dataTable;
        }
        catch (Exception e) {
            logger.error("convertResultSetToDataTable:" + e.getMessage(), (Throwable)e);
            throw new Exception("convertResultSetToDataTable:" + e.getMessage());
        }
        finally {
            logger.debug("Leaving convertResultSetToDataTable()");
        }
    }

    public static String convertToHtml(String str) {
        str = str.replaceAll("\"", "&#34;");
        str = str.replaceAll("'", "&#39;");
        return str;
    }

    public static String unConvertToHtml(String str) {
        str = str.replaceAll("&#34;", "\"");
        str = str.replaceAll("&#39;", "'");
        return str;
    }

    public static String convertToPage(String str) {
        str = CommonMethod.convertToHtml(StringUtils.convertNull(str));
        return str;
    }

    public static String paddingLeft(String str, int length, String padChar) {
        String s = "";
        for (int i = 0; i < length; ++i) {
            s = s + padChar;
        }
        str = s + str;
        return str.substring(str.length() - length);
    }

    public static String getErrorHtml(String errSource, String errReason, String errMessage) {
        String sError = "<DIV errorSource='" + CommonMethod.convertToHtml(errSource) + "' reason='" + CommonMethod.convertToHtml(errReason) + "'>" + CommonMethod.convertToHtml(errMessage) + "</DIV>";
        return sError;
    }

    public static String getRandomGUID() {
        MessageDigest md5 = null;
        StringBuffer sbValueBeforeMD5 = new StringBuffer();
        String valueBeforeMD5 = "";
        String valueAfterMD5 = "";
        String s_id = null;
        SecureRandom mySecureRand = new SecureRandom();
        long secureInitializer = mySecureRand.nextLong();
        Random myRand = new Random(secureInitializer);
        try {
            s_id = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException e) {
            logger.error("UnknownHostException: ", (Throwable)e);
        }
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Error: ", (Throwable)e);
        }
        if (md5 == null) {
            if (logger.isDebugEnabled()) {
                logger.error("[PERFWEB]it is failed to get md5");
            }
            return null;
        }
        try {
            long time = System.currentTimeMillis();
            long rand = 0L;
            rand = mySecureRand.nextLong();
            sbValueBeforeMD5.append(s_id);
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(time));
            sbValueBeforeMD5.append(":");
            sbValueBeforeMD5.append(Long.toString(rand));
            valueBeforeMD5 = sbValueBeforeMD5.toString();
            md5.update(valueBeforeMD5.getBytes());
            byte[] array = md5.digest();
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < array.length; ++j) {
                int b = array[j] & 0xFF;
                if (b < 16) {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(b));
            }
            valueAfterMD5 = sb.toString();
        }
        catch (Exception e) {
            logger.error("Error: ", (Throwable)e);
        }
        return valueAfterMD5.substring(0, 16);
    }
}

