/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.formulaplatform.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.xml.impl.IStateManager;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueCollection;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.baseconfig.QueryConfigCollection;
import com.kingdee.shr.baseconfig.QueryConfigFactory;
import com.kingdee.shr.compensation.util.CmpStrUtil;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalItemDataType;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemCollection;
import com.kingdee.shr.perfweb.app.base.formulaplatform.CalcuItemFactory;
import com.kingdee.shr.perfweb.app.base.formulaplatform.PlatformCalFormulaCollection;
import com.kingdee.shr.perfweb.app.base.formulaplatform.PlatformCalFormulaFactory;
import com.kingdee.shr.perfweb.app.base.formulaplatform.PlatformCalFormulaInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfwebFormulaResource;
import com.kingdee.shr.perfweb.formulaplatform.common.FunUtils;
import com.kingdee.shr.perfweb.formulaplatform.common.PlatformCalculateFun;
import com.kingdee.shr.perfweb.formulaplatform.data.ColumnAttributes;
import com.kingdee.shr.perfweb.formulaplatform.data.DataRow;
import com.kingdee.shr.perfweb.formulaplatform.data.DataSet;
import com.kingdee.shr.perfweb.formulaplatform.data.DataTable;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.util.StringUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformCalExecutor
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(PlatformCalExecutor.class);
    private final String mainTableItemKey = "fid";
    private final String mainTableForeignKey = "FPERSONID";
    private String mainTableName = "T_EVA_IndicatorTarget";
    private final String mainTableEvaObjKey = "FEvaObjID";
    private Context ctx;
    private PlatformCalculateFun calObj;
    private DataSet dataSet;
    private Map<String, Object> changeSqlMap = new HashMap<String, Object>();
    private boolean isExecuteFinished = false;
    private static final FunUtils util = new FunUtils();
    private double ext_finishedPer = 0.0;

    public Map<String, Object> getChangeSqlList() {
        return this.changeSqlMap;
    }

    public PlatformCalExecutor() {
    }

    public PlatformCalExecutor(int precision, String mainTableName, Context ctx, String calMessage, PlatformCalculateFun calObj, DataSet dataSet) {
        this.mainTableName = mainTableName;
        this.ctx = ctx;
        this.calObj = calObj;
        this.dataSet = dataSet;
    }

    public boolean isExecuteFinished() {
        return this.isExecuteFinished;
    }

    @Override
    public void run() {
        try {
            this.changeSqlMap = this.doExecute();
            this.isExecuteFinished = true;
        }
        catch (Exception e) {
            this.changeSqlMap.put("errMsg", e.getMessage());
            this.changeSqlMap.put("changeSqlList", new ArrayList());
            logger.error("Exception: ", (Throwable)e);
            this.isExecuteFinished = true;
        }
    }

    public Map<String, BizEnumValueCollection> getEnumProperty() {
        HashMap<String, BizEnumValueCollection> map = new HashMap<String, BizEnumValueCollection>();
        QueryConfigCollection coll = null;
        try {
            coll = QueryConfigFactory.getLocalInstance((Context)this.ctx).getQueryConfigCollection("select structure.* where scheme='ZgHM3E3Pd0mD41sLWYZ8w5odxk8='");
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        for (int i = 0; i < coll.size(); ++i) {
            String entityName;
            if (null == coll.get(i).getStructure() || CmpStrUtil.isEmpty((String)(entityName = coll.get(i).getStructure().getEntityName()))) continue;
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            if (entityInfo == null || entityInfo.getProperties() == null) {
                logger.error("----enumEntity not found----" + entityName);
                continue;
            }
            PropertyCollection properties = entityInfo.getProperties();
            for (int k = 0; k < properties.size(); ++k) {
                String dataType;
                PropertyInfo propertyInfo = properties.get(k);
                IStateManager stateManager = propertyInfo.getStateManager();
                if (null == stateManager.getStateValue("dataType") || !"Enum".equalsIgnoreCase(dataType = stateManager.getStateValue("dataType").toString())) continue;
                String dataRef = stateManager.getStateValue("metadataRef").toString();
                BizEnumInfo enumInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEnum((IMetaDataPK)MetaDataPK.create((String)dataRef));
                BizEnumValueCollection enumValueColl = enumInfo.getEnumValue();
                map.put(entityInfo.getTable().getName().toUpperCase() + "_" + propertyInfo.getMappingField().getName().toUpperCase(), enumValueColl);
            }
        }
        return map;
    }

    private Map<String, Object> doExecute() throws Exception {
        String caltableid = null;
        String personid = null;
        DataTable mainTable = this.dataSet.getTables(this.mainTableName);
        HashMap<String, Object> paras = new HashMap<String, Object>();
        ArrayList<String> changeSqlList = new ArrayList<String>();
        HashMap<String, Object> changeSqlMap = new HashMap<String, Object>();
        String errMsg = "";
        String attName = "";
        String columnName = "";
        changeSqlMap.put("errMsg", errMsg);
        changeSqlMap.put("changeSqlList", new ArrayList());
        int rowCount = mainTable.rowCount();
        List<DataRow> datas = mainTable.datas;
        String evaObjID = "";
        int datasLen = datas.size();
        for (int i = 0; i < datasLen; ++i) {
            int index = datas.get(i).getColumns("FPERSONID").getIndex();
            evaObjID = (String)datas.get(i).getDatarow().get(index);
        }
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(this.ctx);
        HashMap<String, String> personMap = new HashMap<String, String>();
        StringBuffer str = new StringBuffer();
        str.append("select evaObj.FPersonID as personId, evaObj.FName").append(mlFlag).append(" as personName,evaObj.FID ");
        str.append("from T_EVA_PerfEvaObject evaObj ");
        str.append("inner join T_BD_Person person on evaObj.FPersonID = person.Fid where evaObj.FID='" + evaObjID + "'");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)str.toString());
        while (rowSet.next()) {
            personMap.put(rowSet.getString("FID"), rowSet.getString("personName"));
        }
        Map<String, BizEnumValueCollection> enumMap = this.getEnumProperty();
        long l1 = System.currentTimeMillis();
        long rwSum = 0L;
        long dsSum = 0L;
        long calSum = 0L;
        int size = datas.size();
        for (int index = 0; index < size; ++index) {
            ColumnAttributes att;
            paras.clear();
            DataRow mtDataRow = mainTable.getRows(index);
            if (mtDataRow == null) continue;
            long rw1 = System.currentTimeMillis();
            for (int loop = 0; loop < mtDataRow.columnCount(); ++loop) {
                att = mtDataRow.getColumns(loop);
                if (att.getName().equalsIgnoreCase("fid")) {
                    caltableid = (String)mtDataRow.getValue(loop);
                }
                if (att.getName().equalsIgnoreCase("FPERSONID")) {
                    personid = (String)mtDataRow.getValue(loop);
                }
                if (att.isVar()) {
                    paras.put(att.getName().toUpperCase(), mtDataRow.getValue(loop));
                    continue;
                }
                if (att.getName().contains(".")) continue;
                paras.put((this.mainTableName + "_" + att.getName()).toUpperCase(), mtDataRow.getValue(loop));
            }
            long rw2 = System.currentTimeMillis();
            rwSum += rw2 - rw1;
            long ds1 = System.currentTimeMillis();
            for (int loop = 0; loop < this.dataSet.tableCount(); ++loop) {
                DataRow dataRow;
                DataTable tb = this.dataSet.getTables(loop);
                String tableName = tb.tablename.split("~")[0].toUpperCase();
                String tbAndNum = tb.tablename.indexOf("~") != -1 ? tb.tablename.replace("~", "_") : tb.tablename;
                if (this.mainTableName.equals(tbAndNum)) {
                    tbAndNum = tb.tablename + "_ind";
                }
                if (null == (dataRow = tb.getDataRow(caltableid))) continue;
                for (int i = 0; i < dataRow.columnCount(); ++i) {
                    att = dataRow.getColumns(i);
                    Object value = dataRow.getValue(i);
                    columnName = (att.getName().contains(".") ? att.getName().split("\\.")[att.getName().split("\\.").length - 1] : att.getName()).toUpperCase();
                    if (enumMap.containsKey(tableName + "_" + columnName) && null != value) {
                        BizEnumValueCollection enumValueColl = enumMap.get(tableName + "_" + columnName);
                        for (int k = 0; k < enumValueColl.size(); ++k) {
                            if (enumValueColl.get(k) == null || !value.toString().equals(enumValueColl.get(k).getValue())) continue;
                            value = enumValueColl.get(k).getAlias();
                        }
                    }
                    if (this.calObj.getType().equals("test")) {
                        paras.put((tbAndNum + "_" + att.getName()).toUpperCase(), value);
                        continue;
                    }
                    columnName = attName = att.getName();
                    if (attName.split("\\.").length > 1) {
                        columnName = attName.split("\\.")[1];
                    }
                    paras.put((tbAndNum + "_" + columnName).toUpperCase(), value);
                }
            }
            long ds2 = System.currentTimeMillis();
            dsSum += ds2 - ds1;
            long cal1 = System.currentTimeMillis();
            try {
                this.calObj.setParamMap(paras);
                logger.info("\u3010PERFWEB]-real do execute mehtod calculate ...");
                this.calObj.getClass().getMethod("calculate", HashMap.class).invoke((Object)this.calObj, paras);
                logger.info("\u3010PERFWEB]-end do execute mehtod calculate ...");
            }
            catch (Exception e) {
                this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        logger.error("Exception: ", e);
                    }
                });
                String calFormulaName = null == e.getMessage() ? e.getCause().toString() : e.getMessage();
                calFormulaName = calFormulaName.substring(calFormulaName.indexOf("{") + 1, calFormulaName.indexOf("}"));
                errMsg = null != personid ? SHRPerfWebResourceUtil.getRes("com.kingdee.shr.perfweb.app.resource.SHRPerfwebFormulaResource", SHRPerfwebFormulaResource.FORMULADATACALCUMSG.name(), this.ctx, new Object[]{personMap.get(personid), calFormulaName}) : SHRPerfWebResourceUtil.getRes("com.kingdee.shr.perfweb.app.resource.SHRPerfwebFormulaResource", SHRPerfwebFormulaResource.CALCUERRORMSG.name(), this.ctx) + e;
                changeSqlMap.put("errMsg", errMsg);
                logger.error("Exception: ", (Throwable)e);
            }
            String changeSql = this.getChangeSql(mtDataRow, paras);
            if (changeSql != null && changeSql.length() > 0) {
                changeSqlList.add(changeSql);
                changeSqlMap.put("changeSqlList", changeSqlList);
            }
            this.ext_finishedPer = 50.0 / (double)rowCount * (double)index;
            long cal2 = System.currentTimeMillis();
            calSum += cal2 - cal1;
        }
        long l2 = System.currentTimeMillis();
        logger.info("-----------calculate assemble takes time :" + (l2 - l1) + " ms");
        logger.info("-----------assemble calcute params takes time : " + rwSum + " ms");
        logger.info("-----------fill other table takes time :" + dsSum + " ms");
        logger.info("-----------caculate takes time :" + calSum + " ms");
        return changeSqlMap;
    }

    public String getChangeSql(DataRow rw, Map<String, Object> paras) throws BOSException {
        int size = rw.columnCount();
        rw.getValue("fid");
        String evaObjID = (String)rw.getValue("FPERSONID");
        String scoringFormula = this.calObj.getFormulaID();
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("UPDATE " + this.mainTableName + " SET ");
        HashSet<String> set = new HashSet<String>();
        HashMap<String, CalItemDataType> calItemMap = new HashMap<String, CalItemDataType>(4);
        CalcuItemCollection calItemColl = CalcuItemFactory.getLocalInstance((Context)this.ctx).getCalcuItemCollection();
        PlatformCalFormulaCollection collection = PlatformCalFormulaFactory.getLocalInstance((Context)this.ctx).getPlatformCalFormulaCollection("where id='" + scoringFormula + "' and isCal = 1");
        for (int i = 0; i < collection.size(); ++i) {
            PlatformCalFormulaInfo calFormulaInfo = collection.get(i);
            set.add(calFormulaInfo.getCalItem().toUpperCase());
            for (int j = 0; j < calItemColl.size(); ++j) {
                if (!calFormulaInfo.getCalItem().equalsIgnoreCase(calItemColl.get(j).getFieldName())) continue;
                calItemMap.put(calFormulaInfo.getCalItem().toUpperCase(), calItemColl.get(j).getDataType());
            }
        }
        for (int index = 0; index < size; ++index) {
            String key = rw.getColumns(index).getName().toUpperCase();
            String paraName = (this.mainTableName + "_" + key).toUpperCase();
            Object orgValue = rw.getValue(index);
            Object calValue = paraName.equalsIgnoreCase("T_EVA_INDICATORTARGET_FSCORE") ? paras.get("T_EVA_INDICATORTARGET_IND_FSCORE") : (paraName.equalsIgnoreCase("T_EVA_INDICATORTARGET_FGRADE") ? paras.get("T_EVA_INDICATORTARGET_IND_FGRADE") : paras.get(paraName));
            if (null == orgValue && !set.contains(key)) {
                calValue = null;
            }
            if (key.contains(".") || !set.contains(key)) continue;
            if (((CalItemDataType)calItemMap.get(key)).getValue().equals("0")) {
                updateSql.append(key + "=").append(calValue);
                continue;
            }
            updateSql.append(key + "='").append(calValue).append("'");
        }
        updateSql.append(" WHERE FEvaObjID = '" + evaObjID + "'");
        if (paras.get("T_EVA_INDICATORTARGET_FID") != null) {
            updateSql.append(" and FID='" + paras.get("T_EVA_INDICATORTARGET_FID").toString() + "';");
        } else {
            updateSql.append(";");
        }
        return updateSql.toString();
    }

    private String getDoubleByScienNotation(Object obj, String cmpItemDataDot) {
        if (null == obj) {
            return null;
        }
        Double res = FunUtils.toBigDecimal(obj).doubleValue();
        DecimalFormat df = new DecimalFormat(cmpItemDataDot);
        return df.format(res);
    }

    public boolean isEqual(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if ((a == null || StringUtils.isEmpty((String)a.toString())) && (b == null || StringUtils.isEmpty((String)b.toString()))) {
            return true;
        }
        if (a instanceof String) {
            return ((String)a).equals(b);
        }
        if (b instanceof String) {
            return ((String)b).equals(a);
        }
        if (a instanceof Double) {
            return ((Double)a).equals(b);
        }
        if (b instanceof Double) {
            return ((Double)b).equals(a);
        }
        if (a instanceof Number && a != null && b != null && ((Number)a).doubleValue() == ((Number)b).doubleValue()) {
            return true;
        }
        return a == b;
    }

    public double getExt_finishedPer() {
        return this.ext_finishedPer;
    }
}

