/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.jdbc;

import com.kingdee.shr.perfweb.jdbc.IDynamicTagHandler;
import com.kingdee.shr.perfweb.jdbc.exception.SqlMapNoIdIdentifedException;
import com.kingdee.shr.perfweb.jdbc.exception.SqlMapParameterMissExcpetion;
import com.kingdee.shr.perfweb.jdbc.exception.SqlMapUncorrectParameterTypeException;
import com.kingdee.shr.perfweb.jdbc.utils.ClassUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectNode
implements Cloneable {
    private static Logger logger = LoggerFactory.getLogger(SelectNode.class);
    private String parameterClass;
    private String resultClass;
    private String resultMap;
    private Object parameterObj;
    private Element domElement;
    private String namespace;
    private String id;
    private List<IDynamicTagHandler> handlers = new ArrayList<IDynamicTagHandler>();

    public SelectNode deepClone() {
        SelectNode node = null;
        try {
            node = (SelectNode)super.clone();
            node.domElement = (Element)this.domElement.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.error("CloneNotSupportedException: ", (Throwable)e);
        }
        if (node == null) {
            return null;
        }
        node.parameterObj = this.parameterObj;
        return node;
    }

    public SelectNode(Element e, Object obj, String namespace, String parameterClass, String id, List<IDynamicTagHandler> handlers) {
        this.domElement = e;
        this.namespace = namespace;
        this.parameterClass = parameterClass;
        this.parameterObj = obj;
        this.id = id;
        this.handlers = handlers;
    }

    public SelectNode(Element e, Object obj, String namespace, String parameterClass, String id) {
        this.domElement = e;
        this.namespace = namespace;
        this.parameterClass = parameterClass;
        this.parameterObj = obj;
        this.id = id;
    }

    public SelectNode(Element e, Object obj, String namespace, String parameterClass) {
        this.domElement = e;
        this.namespace = namespace;
        this.parameterClass = parameterClass;
        this.parameterObj = obj;
    }

    public String getParsedString(Object obj) throws Exception {
        this.parameterObj = obj;
        return this.getParsedString();
    }

    private String getParsedString() throws Exception {
        if (this.id == null) {
            if (this.namespace != null) {
                throw new SqlMapNoIdIdentifedException(this.namespace);
            }
            throw new SqlMapNoIdIdentifedException();
        }
        String sqlId = this.domElement.attributeValue("sqlId");
        sqlId = sqlId != null ? sqlId : "unknown sqlId";
        sqlId = this.namespace != null ? this.namespace + "." + sqlId : sqlId;
        String parameterClass = this.domElement.attributeValue("parameterClass");
        Class<?> clazz = null;
        if (parameterClass != null) {
            clazz = Class.forName(parameterClass);
            if (this.parameterObj != null && !this.parameterObj.getClass().isAssignableFrom(clazz)) {
                throw new SqlMapUncorrectParameterTypeException(sqlId);
            }
        }
        Iterator children = this.domElement.elementIterator();
        while (children.hasNext()) {
            Element el = (Element)children.next();
            SelectNode dynamic = new SelectNode(el, this.parameterObj, this.namespace, this.parameterClass, this.id);
            dynamic.setResultMap(this.getResultMap());
            dynamic.setHandlers(this.handlers);
            dynamic.execute();
        }
        String textString = this.domElement.getStringValue();
        textString = textString.replace("\n", " ");
        textString = textString.replace("\r", " ");
        textString = textString.replace("\t", " ");
        textString = this.replaceInnerMap(textString, this.domElement, this.parameterObj);
        return textString;
    }

    private void execute() throws Exception {
        String tag = this.domElement.getName();
        String property = this.domElement.attributeValue("property");
        String value = ClassUtil.getFieldValue(this.parameterObj, property);
        if (tag.equalsIgnoreCase("isnotempty") && (value == null || value.isEmpty())) {
            this.domElement.setText("");
        }
        for (IDynamicTagHandler handler : this.handlers) {
            if (!tag.equalsIgnoreCase(handler.getTagName())) continue;
            HashMap<String, String> attrs = new HashMap<String, String>();
            Iterator it = this.domElement.attributeIterator();
            while (it.hasNext()) {
                Attribute attr = (Attribute)it.next();
                attrs.put(attr.getName(), attr.getData().toString());
            }
            this.domElement.setText(handler.getInnerText(this.domElement, attrs, this.parameterObj));
        }
        Iterator children = this.domElement.elementIterator();
        while (children.hasNext()) {
            Element el = (Element)children.next();
            SelectNode dynamic = new SelectNode(el, this.parameterObj, this.namespace, this.parameterClass, this.id);
            dynamic.setResultMap(this.getResultMap());
            dynamic.setHandlers(this.handlers);
            dynamic.execute();
        }
        String textString = this.domElement.getTextTrim();
        textString = textString.replace("\n", " ");
        textString = textString.replace("\r", " ");
        textString = textString.replace("\t", " ");
        textString = this.replaceInnerMap(textString, this.domElement, this.parameterObj);
        this.domElement.setText(textString);
    }

    private String replaceInnerMap(String text, Element el, Object ob) throws Exception {
        StringBuffer buffer = new StringBuffer();
        String prepend = el.attributeValue("prepend") != null ? el.attributeValue("prepend") : "";
        List<String> params = this.getInnerParameters(text);
        for (String p : params) {
            String fieldValue = "";
            if (ob != null && ob instanceof HashMap) {
                if (p.contains(".")) {
                    String[] args = p.split("\\.");
                    if (args.length == 2) {
                        Object obj = ((Map)ob).get(args[0]);
                        String field = args[1].toString();
                        fieldValue = ClassUtil.getFieldValue(obj, field);
                    }
                } else {
                    fieldValue = ClassUtil.getFieldValue(ob, p);
                }
            } else {
                if (this.parameterClass != null && ob == null) {
                    throw new SqlMapParameterMissExcpetion(this.getUri());
                }
                fieldValue = ClassUtil.getFieldValue(ob, p);
            }
            if (fieldValue == null) {
                text = text.replaceAll("#" + p + "#", "null");
                continue;
            }
            text = text.replaceAll("#" + p + "#", "'" + fieldValue + "'");
        }
        if (text != null && text.length() > 0) {
            buffer.append(" ");
            buffer.append(prepend);
            buffer.append(" ");
            buffer.append(text);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    private List<String> getInnerParameters(String textString) {
        ArrayList<String> result = new ArrayList<String>();
        String self = textString;
        String[] args = self.split("#");
        for (int i = 0; i < args.length; ++i) {
            if (!self.contains("#" + args[i] + "#")) continue;
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public Object getParameterObj() {
        return this.parameterObj;
    }

    public void setParameterObj(Object parameterObj) {
        this.parameterObj = parameterObj;
    }

    public Element getDomElement() {
        return this.domElement;
    }

    public void setDomElement(Element domElement) {
        this.domElement = domElement;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getUri() {
        if (this.namespace != null) {
            return this.namespace + "." + this.id;
        }
        return this.id;
    }

    public String getResultClass() {
        return this.resultClass;
    }

    public void setResultClass(String resultClass) {
        this.resultClass = resultClass;
    }

    public List<IDynamicTagHandler> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(List<IDynamicTagHandler> handlers) {
        this.handlers = handlers;
    }

    public void setHandler(IDynamicTagHandler handler) {
        this.handlers.add(handler);
    }

    public String getResultMap() {
        return this.resultMap;
    }

    public void setResultMap(String resultMap) {
        this.resultMap = resultMap;
    }
}

