/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.job;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.service.job.core.JobDef;
import com.kingdee.bos.service.job.core.Wrapper;
import com.kingdee.bos.service.job.wrapper.FunctionWrapper;
import com.kingdee.bos.service.job.wrapper.MethodWrapper;
import com.kingdee.bos.workflow.define.KpdlParser;
import com.kingdee.bos.workflow.define.ScheduleDef;
import com.kingdee.bos.workflow.define.ScheduleType;
import com.kingdee.shr.perfweb.multiEvalution.commontask.utils.PerfwebBackTransactionJobUtils;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfwebJobUtils {
    private static Logger logger = LoggerFactory.getLogger(PerfwebJobUtils.class);

    private OperationInfo getOperation(FunctionObjectInfo function, String operationName) {
        OperationCollection operCol = function.getOperation();
        OperationInfo oper = null;
        if (operCol != null) {
            int length = operCol.size();
            for (int i = 0; i < length; ++i) {
                if (!StringUtils.equalsIgnoreCase((String)operCol.get(i).getName(), (String)operationName)) continue;
                oper = operCol.get(i);
                break;
            }
        }
        return oper;
    }

    protected String getSchedule(Date date) {
        Date dt = date;
        ScheduleDef define = new ScheduleDef(null);
        define.setType(ScheduleType.ONETIME);
        define.setBeginTime(dt);
        define.setEndTime(dt);
        define.setUseCalendar(false);
        define.setInstructionType(1);
        define.setDefine(this.getScheduleDate(dt));
        String scheduleXML = KpdlParser.scheduleToString((ScheduleDef)define);
        return scheduleXML;
    }

    private String getScheduleDate(Date date) {
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        int day = DateTimeUtils.getDay((Date)date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        String value = second + " " + minute + " " + hour + " " + day + " " + month + " ? " + year;
        return value;
    }

    public String createJobDefCoreProcessV2(Context ctx, String jobTitle, Map jobContext, String functionName, String operationName) throws BOSException {
        FunctionWrapper.Parameter[] params = this.jobContextToParameter(ctx, jobContext, functionName, operationName);
        FunctionWrapper wrapper = new FunctionWrapper(functionName, operationName, params);
        JobDef jobDef = PerfwebBackTransactionJobUtils.createJobDef(ctx, null, jobTitle, null, null, null, true, (Wrapper)wrapper);
        String jobProcessDefID = PerfwebBackTransactionJobUtils.saveJobDef(ctx, jobDef);
        return jobProcessDefID;
    }

    public FunctionWrapper.Parameter[] jobContextToParameter(Context ctx, Map jobContext, String functionName, String operationName) {
        OperationInfo operation = this.getOperation(MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getFunction((IMetaDataPK)new MetaDataPK(functionName)), operationName);
        ParameterCollection coll = null;
        coll = operation.getEntityMethodRef() == null ? operation.getFacadeMethodRef().getParameters() : operation.getEntityMethodRef().getParameters();
        int size = coll.size();
        FunctionWrapper.Parameter[] params = new FunctionWrapper.Parameter[size];
        for (int i = 0; i < size; ++i) {
            String name = coll.get(i).getName();
            String value = jobContext.get(name) == null ? "" : jobContext.get(name).toString();
            String type = coll.get(i).getDataType().toUpperCase();
            params[i] = new FunctionWrapper.Parameter(name, "", type, "", value, "");
        }
        return params;
    }

    public int createDynaJob(Context ctx, Map<String, Object> param) throws BOSException {
        String jobTitle = (String)param.get("jobTitle");
        String operationName = (String)param.get("operationName");
        String functionName = (String)param.get("functionName");
        return this.createProcess(ctx, jobTitle, param, functionName, operationName);
    }

    public int createProcess(Context ctx, String jobTitle, Map jobContext, String functionName, String operationName) throws BOSException {
        String jobProcessDefID = this.createJobDefCoreProcessV2(ctx, jobTitle, jobContext, functionName, operationName);
        PerfwebBackTransactionJobUtils.createJobInstance(ctx, jobProcessDefID);
        return 0;
    }

    public static String createJobDefCoreProcessCore(Context ctx, String jobTitle, Object[] params, String className, String methodName) throws BOSException {
        Class<?> clazz = null;
        String jobProcessDefID = null;
        try {
            clazz = Class.forName(className.trim());
            MethodWrapper wrapper = new MethodWrapper(clazz, methodName, params);
            JobDef jobDef = PerfwebBackTransactionJobUtils.createJobDef(ctx, null, jobTitle, null, null, null, true, (Wrapper)wrapper);
            jobProcessDefID = PerfwebBackTransactionJobUtils.saveJobDef(ctx, jobDef);
        }
        catch (Exception e) {
            logger.error("\u3010PERFWEB\u3011-create perfweb job error\uff01", (Throwable)e);
        }
        return jobProcessDefID;
    }

    public static void createJobinstImmediateRun(Context ctx, String jobTitle, String className, String methodName, Object[] params) throws BOSException {
        String jobProcessDefID = PerfwebJobUtils.createJobDefCoreProcessCore(ctx, jobTitle, params, className, methodName);
        PerfwebBackTransactionJobUtils.createJobInstance(ctx, jobProcessDefID);
    }
}

