/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.exception.biz.WfBizException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalrule.IPerformanceRule;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleCollection;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleFactory;
import com.kingdee.shr.perfweb.app.base.evalrule.PerformanceRuleInfo;
import com.kingdee.shr.perfweb.app.base.perfmancescore.IPerfScorLevelDefine;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineCollection;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineFactory;
import com.kingdee.shr.perfweb.app.base.perfmancescore.PerfScorLevelDefineInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.OsfUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import com.kingdee.shr.perfweb.utils.CommonPageHelper;
import com.kingdee.shr.perfweb.utils.CommonSQLUtil;
import com.kingdee.shr.perfweb.utils.ICustomDataProcessor;
import com.kingdee.shr.perfweb.utils.PermitUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyOngoingAssessmentService
implements IHRMsfService,
ICustomDataProcessor {
    private static Logger logger = LoggerFactory.getLogger(MyOngoingAssessmentService.class);

    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        OsfUtils.requirePagingParams(ctx, map, result);
        if (result != null && result.size() > 0) {
            return result;
        }
        Object paramOrgID = map.get("belongOrgID");
        Object paramPerfPlanID = map.get("perfPlanID");
        Object paramPerfPeriodID = map.get("perfPeriodID");
        StringBuffer orgSb = null;
        if (paramOrgID != null) {
            ArrayList<String> orgList = PermitUtil.getInterSectionOrg(PermitUtil.getCurrentUserOwnOrg(ctx), PermitUtil.getCurAndSubOrg(ctx, String.valueOf(paramOrgID)));
            orgSb = new StringBuffer();
            for (String orgId : orgList) {
                orgSb.append(",'").append(orgId).append("'");
            }
            orgSb.append(")");
        }
        String mlFlag = SHRPerfWebResourceUtil.getMlFlag(ctx);
        StringBuffer perfPlanSb = new StringBuffer("select a.FPeriodID, ").append("count(a.FPeriodID) FPeriodCount, ").append("max(a.FCreateTime) FCreateTime, ").append("min(b.FName" + mlFlag + ") FPeriodName, ").append("min(a.FNodeHandlerID) FNodeHandlerID, ").append("min(b.FEvaPeriodStatus) FEvaPeriodStatus, ").append("max(b.FPEndDate) FPEndDate, ").append("max(b.FPStartDate) FPStartDate, ").append("min(c.FName" + mlFlag + ") FPlanName, ").append("min(c.FPerfRuleID) FPerfRuleID, ").append("replace(tochar(min(b.FPStartDate),'yyyy-mm-dd'),'-','.')||'-'||replace(tochar(min(b.FPEndDate),'yyyy-mm-dd'),'-','.') FPeriodDate ").append("from T_EVA_GradeTaskNodeInst a ").append("left join T_EVA_PerfPeriod b ").append("on a.FPeriodID = b.FID ").append("left join T_EVA_PerfPlan c ").append("on b.FPerfPlan = c.FID ").append("where a.FNodeHandlerID ='" + personId + "' ").append(" and a.FTaskStatus !='0'").append(" and c.FPStatus = 1").append(" and c.FVisible = 1");
        if (orgSb != null) {
            perfPlanSb.append(" and c.FBelongOrgID in '" + orgSb + "' ");
        }
        if (paramPerfPlanID != null) {
            perfPlanSb.append(" and b.FPerfPlan = '" + paramPerfPlanID + "' ");
        }
        if (paramPerfPeriodID != null) {
            perfPlanSb.append(" and a.FPeriodID = '" + paramPerfPeriodID + "' ");
        }
        perfPlanSb.append(" group by a.FPeriodID ");
        Map<Object, Object> dataMap = new HashMap();
        try {
            int rows = (Integer)map.get("rows");
            int page = (Integer)map.get("page");
            dataMap = CommonPageHelper.getPageCallbackData(ctx, perfPlanSb.toString(), rows, page, "FEvaPeriodStatus desc, FPEndDate desc, FPStartDate desc, FCreateTime desc", this, null);
            result.put("resultFlag", "success");
            result.put("data", dataMap);
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            result.put("resultFlag", "failure");
            result.put("errorDes", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.GETDATAERR, ctx));
            return result;
        }
        return result;
    }

    @Override
    public int getTotalCount(Context ctx, String sql) throws WfBizException {
        int totalCount = 0;
        try {
            String countSql = "select count(1) from (" + sql + ") as A";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)countSql);
            totalCount = CommonSQLUtil.getTotalCount(rowSet);
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
        }
        return totalCount;
    }

    @Override
    public List<?> formatResultData(Context ctx, IRowSet rs, String type) throws WfBizException {
        return this.getMyOngoingAsmtListObjects(ctx, rs);
    }

    private List<Map<String, Object>> getMyOngoingAsmtListObjects(Context ctx, IRowSet rs) throws WfBizException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        StringBuffer periodIdsBuffer = new StringBuffer();
        try {
            if (rs != null && rs.size() > 0) {
                HashMap<String, Integer> periodTotalsMap = new HashMap<String, Integer>();
                HashMap<String, String> perfRuleMap = new HashMap<String, String>();
                HashSet<String> perfRuleIDs = new HashSet<String>();
                String nodeHandlerId = "";
                while (rs.next()) {
                    String periodDate;
                    nodeHandlerId = rs.getString("FNodeHandlerID");
                    LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                    String periodID = rs.getString("FPeriodID");
                    String planName = rs.getString("FPlanName");
                    String perfRuleID = rs.getString("FPerfRuleID");
                    perfRuleMap.put(periodID, perfRuleID);
                    perfRuleIDs.add(perfRuleID);
                    if (StringUtils.isEmpty((CharSequence)planName)) {
                        planName = "";
                    }
                    if (StringUtils.isEmpty((CharSequence)(periodDate = rs.getString("FPeriodDate")))) {
                        periodDate = "";
                    }
                    int n = rs.getInt("FPeriodCount");
                    map.put("periodID", periodID);
                    map.put("perfRuleID", perfRuleID);
                    map.put("planName", rs.getString("FPlanName"));
                    map.put("periodDate", rs.getString("FPeriodName"));
                    map.put("periodCount", n);
                    map.put("evaPeriodStatus", rs.getString("FEvaPeriodStatus"));
                    periodIdsBuffer.append("'").append(periodID).append("',");
                    periodTotalsMap.put(periodID, n);
                    list.add(map);
                }
                periodIdsBuffer.setLength(periodIdsBuffer.length() - 1);
                StringBuffer sqlBuffer2 = new StringBuffer();
                sqlBuffer2.append("select ").append("FPeriodID, ").append("FNodeGrade, ").append("count(FNodeGrade) FNodeGradeCount ").append("from T_EVA_GradeTaskNodeInst ").append("where ").append(" FNodeGrade is not null ").append(" and FTaskStatus !='0'").append(" and FPeriodID in (").append(periodIdsBuffer.toString()).append(" ) ").append(" and FNodeHandlerID = ? ").append("group by FPeriodID, FNodeGrade ").append("order by FPeriodID ");
                IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer2.toString(), (Object[])new Object[]{nodeHandlerId});
                HashMap<String, HashMap<String, NodeGradeInfo>> periodMap = new HashMap<String, HashMap<String, NodeGradeInfo>>();
                while (rowset.next()) {
                    String periodID = rowset.getString("FPeriodID");
                    String nodeGrade = rowset.getString("FNodeGrade");
                    int n = rowset.getInt("FNodeGradeCount");
                    NodeGradeInfo nodeGradeInfo = new NodeGradeInfo();
                    nodeGradeInfo.setPeriodID(periodID);
                    nodeGradeInfo.setNodeGrade(nodeGrade);
                    nodeGradeInfo.setNodeGradeCount(n);
                    int periodTotals = (Integer)periodTotalsMap.get(periodID);
                    double nodePercent = new BigDecimal(n * 100).divide(new BigDecimal(periodTotals), 2, 4).doubleValue();
                    nodeGradeInfo.setNodeGradePercent(nodePercent);
                    HashMap<String, NodeGradeInfo> nodeGrades = (HashMap<String, NodeGradeInfo>)periodMap.get(periodID);
                    if (nodeGrades == null || nodeGrades.size() == 0) {
                        nodeGrades = new HashMap<String, NodeGradeInfo>();
                    }
                    nodeGrades.put(nodeGrade, nodeGradeInfo);
                    periodMap.put(periodID, nodeGrades);
                }
                Map<String, List<PerfScorLevelDefineInfo>> scoLevelDefMap = this.getScoreLevelDefineByPeriodIds(ctx, perfRuleIDs);
                for (Map map : list) {
                    String periodID = (String)map.get("periodID");
                    String perfRuleID = (String)map.get("perfRuleID");
                    if (StringUtils.isEmpty((CharSequence)periodID) || StringUtils.isEmpty((CharSequence)perfRuleID)) continue;
                    int periodCount = (Integer)map.get("periodCount");
                    Map nodeGradeMap = (Map)periodMap.get(periodID);
                    int nodeGradeTotalCount = 0;
                    if (scoLevelDefMap != null && scoLevelDefMap.size() > 0) {
                        ArrayList<NodeGradeInfo> nodeGradeInfos = new ArrayList<NodeGradeInfo>();
                        List<PerfScorLevelDefineInfo> scorLevelDefineInfos = scoLevelDefMap.get(perfRuleID);
                        if (scorLevelDefineInfos != null && scorLevelDefineInfos.size() > 0) {
                            for (PerfScorLevelDefineInfo defineInfo : scorLevelDefineInfos) {
                                String scoreLevel = defineInfo.getPerfLevelName();
                                NodeGradeInfo nodeGradeInfo = null;
                                if (nodeGradeMap != null && nodeGradeMap.size() > 0 && (nodeGradeInfo = (NodeGradeInfo)nodeGradeMap.get(scoreLevel)) != null) {
                                    nodeGradeTotalCount += nodeGradeInfo.getNodeGradeCount();
                                }
                                if (nodeGradeInfo == null) {
                                    nodeGradeInfo = new NodeGradeInfo();
                                    nodeGradeInfo.setNodeGradeCount(0);
                                    nodeGradeInfo.setNodeGradePercent(0.0);
                                    nodeGradeInfo.setPeriodID(periodID);
                                    nodeGradeInfo.setNodeGrade(defineInfo.getPerfLevelName());
                                }
                                nodeGradeInfo.setShowNumber(defineInfo.getShowNumber());
                                nodeGradeInfos.add(nodeGradeInfo);
                            }
                            Collections.sort(nodeGradeInfos, new Comparator<NodeGradeInfo>(){

                                @Override
                                public int compare(NodeGradeInfo o1, NodeGradeInfo o2) {
                                    return Integer.valueOf(o1.getShowNumber()).compareTo(o2.getShowNumber());
                                }
                            });
                        }
                        map.put("nodeGrades", nodeGradeInfos);
                    }
                    map.put("unScoredeCount", periodCount - nodeGradeTotalCount);
                }
            }
        }
        catch (SQLException e) {
            logger.error("SQLException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        return list;
    }

    private Map<String, List<PerfScorLevelDefineInfo>> getScoreLevelDefineByPeriodIds(Context ctx, Set<String> perfRuleIDs) throws WfBizException {
        HashMap<String, List<PerfScorLevelDefineInfo>> resultMap = new HashMap<String, List<PerfScorLevelDefineInfo>>();
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", perfRuleIDs, CompareType.INCLUDE));
            EntityViewInfo evi = new EntityViewInfo();
            evi.setFilter(filter);
            IPerformanceRule iperfRule = PerformanceRuleFactory.getLocalInstance((Context)ctx);
            PerformanceRuleCollection ruleCollection = iperfRule.getPerformanceRuleCollection(evi);
            HashMap<String, String> perfRateMap = new HashMap<String, String>();
            HashSet<String> perfRates = new HashSet<String>();
            if (ruleCollection != null && ruleCollection.size() > 0) {
                for (int i = 0; i < ruleCollection.size(); ++i) {
                    PerformanceRuleInfo performanceRule = ruleCollection.get(i);
                    String perfRate = performanceRule.getPerfRate().getId().toString();
                    perfRateMap.put(performanceRule.getId().toString(), perfRate);
                    perfRates.add(perfRate);
                }
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("perfScoreLevel", perfRates, CompareType.INCLUDE));
                filter.getFilterItems().sort("showNumber");
                evi.setFilter(filter);
                IPerfScorLevelDefine iPerfScorLevelDefine = PerfScorLevelDefineFactory.getLocalInstance((Context)ctx);
                PerfScorLevelDefineCollection scorLevelDefCollection = iPerfScorLevelDefine.getPerfScorLevelDefineCollection(evi);
                HashMap<String, ArrayList<PerfScorLevelDefineInfo>> scoreDefineMap = new HashMap<String, ArrayList<PerfScorLevelDefineInfo>>();
                if (scorLevelDefCollection != null && scorLevelDefCollection.size() > 0) {
                    ArrayList<PerfScorLevelDefineInfo> scoreDefines = null;
                    for (int j = 0; j < scorLevelDefCollection.size(); ++j) {
                        PerfScorLevelDefineInfo perfScorLevelDefine = scorLevelDefCollection.get(j);
                        String key = perfScorLevelDefine.getPerfScoreLevel().getId().toString();
                        scoreDefines = (ArrayList<PerfScorLevelDefineInfo>)scoreDefineMap.get(key);
                        if (scoreDefines == null || scoreDefines.size() == 0) {
                            scoreDefines = new ArrayList<PerfScorLevelDefineInfo>();
                        }
                        scoreDefines.add(perfScorLevelDefine);
                        scoreDefineMap.put(key, scoreDefines);
                    }
                    if (scoreDefineMap != null && scoreDefineMap.size() > 0) {
                        for (Map.Entry entry : perfRateMap.entrySet()) {
                            resultMap.put((String)entry.getKey(), (List<PerfScorLevelDefineInfo>)scoreDefineMap.get(entry.getValue()));
                        }
                    }
                }
            }
        }
        catch (BOSException e) {
            logger.error("BOSException: ", (Throwable)e);
            throw new WfBizException(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.EXECUTESQLERR, ctx));
        }
        return resultMap;
    }

    public static class NodeGradeInfo
    implements Serializable {
        private String periodID;
        private String nodeGrade;
        private int showNumber;
        private int nodeGradeCount;
        private double nodeGradePercent;

        public String getPeriodID() {
            return this.periodID;
        }

        public void setPeriodID(String periodID) {
            this.periodID = periodID;
        }

        public String getNodeGrade() {
            return this.nodeGrade;
        }

        public void setNodeGrade(String nodeGrade) {
            this.nodeGrade = nodeGrade;
        }

        public int getShowNumber() {
            return this.showNumber;
        }

        public void setShowNumber(int showNumber) {
            this.showNumber = showNumber;
        }

        public int getNodeGradeCount() {
            return this.nodeGradeCount;
        }

        public void setNodeGradeCount(int nodeGradeCount) {
            this.nodeGradeCount = nodeGradeCount;
        }

        public double getNodeGradePercent() {
            return this.nodeGradePercent;
        }

        public void setNodeGradePercent(double nodeGradePercent) {
            this.nodeGradePercent = nodeGradePercent;
        }
    }
}

