/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.base.syssetting.app.filter.HRFilterUtils;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryCollection;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryFactory;
import com.kingdee.shr.perfweb.app.base.evalplan.EvaResultSummaryInfo;
import com.kingdee.shr.perfweb.app.base.evalplan.PerfPeriodInfo;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfPeriodInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import com.kingdee.shr.perfweb.util.PerfPortalTodoUtil;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyPerfPortalService
implements IHRMsfService {
    private static Logger logger = LoggerFactory.getLogger((String)MyPerfPortalService.class.getName());

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String personId = HRFilterUtils.getCurrentPersonId((Context)ctx);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        int totalCount = 0;
        try {
            HashMap<String, Object> initData = new HashMap<String, Object>();
            totalCount = PerfPortalTodoUtil.setTodoPermissionAndCount(ctx, initData);
            totalCount += PerfPortalTodoUtil.setAxvTodoPermissionAndCount(ctx, initData);
        }
        catch (EASBizException e) {
            logger.error("get todo count data eas err", (Throwable)e);
        }
        resultMap.put("myEvaTotalCount", totalCount);
        try {
            this.getEvaResult(ctx, resultMap, personId);
        }
        catch (BOSException e) {
            logger.error("get getEvaResult data eas err", (Throwable)e);
        }
        return resultMap;
    }

    public void getEvaResult(Context ctx, Map<String, Object> resultMap, String personId) throws BOSException {
        HashMap<String, Object> evaResultMap = new HashMap<String, Object>();
        EvaResultSummaryCollection resultColl = EvaResultSummaryFactory.getLocalInstance((Context)ctx).getEvaResultSummaryCollection("select  *,period.name,period.year,period.perfPlan.name,multiPeriod.name,multiPeriod.year,multiPeriod.multiPerfplan.name where person='" + personId + "' and billState='3' order by periodYear desc, periodType, periodTime desc");
        if (resultColl != null && resultColl.size() > 0) {
            EvaResultSummaryInfo info = resultColl.get(0);
            evaResultMap.put("lastSumScore", new BigDecimal(info.getLastSumScore()).setScale(2, RoundingMode.HALF_UP));
            evaResultMap.put("lastGradeLevel", info.getLastGradeLevel());
            String evaResultShowControll = PerfConfigUtils.getConfigByNumber(ctx, "Perf600");
            if ("1".equals(evaResultShowControll)) {
                evaResultMap.put("lastSumScore", "");
            } else if ("2".equals(evaResultShowControll)) {
                evaResultMap.put("lastGradeLevel", new BigDecimal(info.getLastSumScore()).setScale(2, RoundingMode.HALF_UP));
            }
            String periodName = "";
            String year = "";
            if (info.getIsImportByHand().equals((Object)YesOrNoEnum.NO)) {
                String perfModel = info.getPerfModel().getId().toString();
                MultiPerfPeriodInfo multiPerfPeriodInfo = info.getMultiPeriod();
                PerfPeriodInfo period = info.getPeriod();
                if (perfModel.equals("pER9PCMLSzypG7wVLbGZqqtdChg=")) {
                    if (multiPerfPeriodInfo != null && multiPerfPeriodInfo.getMultiPerfplan() != null) {
                        evaResultMap.put("planName", info.getMultiPeriod().getMultiPerfplan().getName());
                        periodName = info.getMultiPeriod().getName();
                        year = multiPerfPeriodInfo.getYear();
                    } else {
                        evaResultMap.put("planName", info.getEvaPlanName());
                        periodName = info.getPeriodName();
                        year = info.getPeriodYear();
                    }
                } else if (period != null) {
                    evaResultMap.put("planName", info.getPeriod().getPerfPlan().getName());
                    periodName = info.getPeriod().getName();
                    year = period.getYear();
                } else {
                    evaResultMap.put("planName", info.getEvaPlanName());
                    periodName = info.getPeriodName();
                    year = info.getPeriodYear();
                }
            } else {
                if (info.isHistoryImport()) {
                    evaResultMap.put("planName", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.HISTORYIMPORT, ctx));
                } else {
                    evaResultMap.put("planName", SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.IMPORTBYHAND, ctx));
                }
                year = info.getPeriodYear();
            }
            String showTime = "";
            showTime = year != null && info.getPeriodType() != null ? this.getPeriodTime(ctx, info.getPeriodType().getValue(), year, String.valueOf(info.getPeriodTime())) : periodName;
            evaResultMap.put("showTime", showTime);
        }
        resultMap.put("evaResult", evaResultMap);
    }

    protected String getPeriodTime(Context ctx, Integer periodType, String year, String time) {
        String timeStr = null;
        if (periodType == 100) {
            timeStr = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARWITHPREFIX, ctx, new Object[]{year});
            return timeStr;
        }
        if (periodType == 200) {
            if (time.equals("1")) {
                timeStr = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.FIRSTHALFOFTHEYEAR, ctx, new Object[]{year});
                return timeStr;
            }
            timeStr = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.LATTERHALFOFTHEYEAR, ctx, new Object[]{year});
            return timeStr;
        }
        if (periodType == 300) {
            timeStr = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.YEARANDQUARTER2, ctx, new Object[]{year, time});
            return timeStr;
        }
        if (periodType == 400) {
            String[] yearWithMonths = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MONTHS, ctx, new Object[]{year}).split(",");
            timeStr = yearWithMonths[Integer.valueOf(time) - 1];
            return timeStr;
        }
        return timeStr;
    }
}

