/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.model;

import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.shr.perfweb.app.common.YesOrNoEnum;
import com.kingdee.shr.perfweb.osf.model.FieldType;
import com.kingdee.shr.perfweb.osf.model.Option;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Transient;

public class SimpleFieldInfo
implements Serializable {
    private String fieldName;
    private String showName;
    private boolean hidden;
    @Transient
    private DataType dataType;
    private FieldType fieldType;
    private List<Option> options;
    private int maxLength;
    private boolean required;
    private boolean defaultDisplay;
    private String dataSource;

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getShowName() {
        return this.showName;
    }

    public void setShowName(String showName) {
        this.showName = showName;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
        this.setFieldTypeByDataType();
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public List<Option> getOptions() {
        return this.options;
    }

    public void setOptions(List<Option> options) {
        this.options = options;
    }

    private void setFieldTypeByDataType() {
        DataType dataType = this.getDataType();
        HashSet<DataType> numberSet = new HashSet<DataType>();
        numberSet.add(DataType.SHORT);
        numberSet.add(DataType.INTEGER);
        numberSet.add(DataType.LONG);
        numberSet.add(DataType.FLOAT);
        numberSet.add(DataType.DOUBLE);
        numberSet.add(DataType.DECIMAL);
        HashSet<DataType> dateSet = new HashSet<DataType>();
        dateSet.add(DataType.DATE);
        HashSet<DataType> timeSet = new HashSet<DataType>();
        timeSet.add(DataType.TIME);
        HashSet<DataType> timeStampSet = new HashSet<DataType>();
        timeStampSet.add(DataType.TIMESTAMP);
        HashSet<DataType> textSet = new HashSet<DataType>();
        textSet.add(DataType.CHAR);
        textSet.add(DataType.STRING);
        textSet.add(DataType.OBJECTPK);
        textSet.add(DataType.BYTE);
        textSet.add(DataType.BYTEARRAY);
        textSet.add(DataType.UUID);
        textSet.add(DataType.BOSUUID);
        textSet.add(DataType.OBJECTVALUE);
        HashSet longTextSet = new HashSet();
        HashSet<DataType> f7Set = new HashSet<DataType>();
        f7Set.add(DataType.OBJECTCOLLECTION);
        HashSet<DataType> booleanSet = new HashSet<DataType>();
        booleanSet.add(DataType.BOOLEAN);
        HashSet<DataType> selectSet = new HashSet<DataType>();
        selectSet.add(DataType.ENUM);
        if (numberSet.contains(dataType)) {
            this.setFieldType(FieldType.Number);
        } else if (dateSet.contains(dataType)) {
            this.setFieldType(FieldType.Date);
        } else if (timeSet.contains(dataType)) {
            this.setFieldType(FieldType.Time);
        } else if (timeStampSet.contains(dataType)) {
            this.setFieldType(FieldType.TimeStamp);
        } else if (textSet.contains(dataType)) {
            this.setFieldType(FieldType.Text);
        } else if (longTextSet.contains(dataType)) {
            this.setFieldType(FieldType.LongText);
        } else if (f7Set.contains(dataType)) {
            this.setFieldType(FieldType.F7);
        } else if (booleanSet.contains(dataType)) {
            Option option1 = new Option("0", YesOrNoEnum.NO.getAlias());
            Option option2 = new Option("1", YesOrNoEnum.YES.getAlias());
            this.setOptions(Arrays.asList(option1, option2));
            this.setFieldType(FieldType.Boolean);
        } else if (selectSet.contains(dataType)) {
            this.setFieldType(FieldType.Select);
        } else {
            this.setFieldType(FieldType.Unknown);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isDefaultDisplay() {
        return this.defaultDisplay;
    }

    public void setDefaultDisplay(boolean defaultDisplay) {
        this.defaultDisplay = defaultDisplay;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }
}

