/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.osf.quescloud;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.perfweb.app.exception.SHRPerfWebBizException;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.IMultiPerfRelationReport;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationReportCollection;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationReportFactory;
import com.kingdee.shr.perfweb.app.multiEvalution.multiPerfPlan.MultiPerfRelationReportInfo;
import com.kingdee.shr.perfweb.app.resource.SHRPerfWebResource;
import com.kingdee.shr.perfweb.util.NoticeUtils;
import com.kingdee.shr.perfweb.util.SHRPerfWebResourceUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuesSendPortalNoticeService
implements IHRMsfService {
    public Object process(Context ctx, Map map) throws EASBizException, BOSException {
        Object noticeDatas = map.get("noticeDatas");
        if (noticeDatas == null) {
            throw new SHRPerfWebBizException(SHRPerfWebBizException.PARAMREQUIRED);
        }
        Gson gson = new Gson();
        List noticeDataList = (List)gson.fromJson(String.valueOf(noticeDatas), new TypeToken<List<NoticeInfo>>(){}.getType());
        HashMap<String, NoticeInfo> noticeInfoMap = new HashMap<String, NoticeInfo>();
        for (NoticeInfo noticeInfo : noticeDataList) {
            noticeInfoMap.put(noticeInfo.getEvaObjId(), noticeInfo);
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("perfEvaObj", noticeInfoMap.keySet(), CompareType.INCLUDE));
        SelectorItemCollection selectorItemCollection = new SelectorItemCollection();
        selectorItemCollection.add(new SelectorItemInfo("perfEvaObj.*"));
        selectorItemCollection.add(new SelectorItemInfo("person.*"));
        selectorItemCollection.add(new SelectorItemInfo("*"));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filterInfo);
        evi.setSelector(selectorItemCollection);
        IMultiPerfRelationReport iMultiPerfRelationReport = MultiPerfRelationReportFactory.getLocalInstance((Context)ctx);
        MultiPerfRelationReportCollection reportCollection = iMultiPerfRelationReport.getMultiPerfRelationReportCollection(evi);
        if (reportCollection != null && reportCollection.size() > 0) {
            String title = SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIEVALUATETITLENOTICE, ctx);
            for (int i = 0; i < reportCollection.size(); ++i) {
                MultiPerfRelationReportInfo relationReportInfo = reportCollection.get(i);
                NoticeInfo noticeInfo = (NoticeInfo)noticeInfoMap.get(relationReportInfo.getPerfEvaObj().getId().toString());
                PersonInfo personInfo = relationReportInfo.getPerson();
                if (personInfo == null) continue;
                StringBuffer body = new StringBuffer(SHRPerfWebResourceUtil.getRes(SHRPerfWebResource.MULTIEVALUATENOTICE5, ctx, new Object[]{noticeInfo.getAccount(), noticeInfo.getPasswd(), noticeInfo.getUrl(), relationReportInfo.getPerfEvaObj().getName()}));
                HashMap<String, String> source = new HashMap<String, String>();
                source.put("templateTitle", title);
                source.put("templateContent", body.toString());
                Map<String, Map<String, String>> stringMapMap = SHRPerfWebResourceUtil.copyMultiLanValue(source, source.keySet());
                NoticeUtils.sendNoticeToPortal(ctx, stringMapMap, personInfo.getName(), personInfo.getId().toString(), null, "", "100");
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("resultFlag", "success");
        return result;
    }

    public static class NoticeInfo
    implements Serializable {
        private String evaObjId;
        private String account;
        private String passwd;
        private String url;

        public String getEvaObjId() {
            return this.evaObjId;
        }

        public void setEvaObjId(String evaObjId) {
            this.evaObjId = evaObjId;
        }

        public String getAccount() {
            return this.account;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public String getPasswd() {
            return this.passwd;
        }

        public void setPasswd(String passwd) {
            this.passwd = passwd;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

