/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static Logger logger = LoggerFactory.getLogger(ExcelUtil.class);

    public static List<XSSFSheet> getSheets(byte[] b) {
        ArrayList<XSSFSheet> sheets = new ArrayList<XSSFSheet>();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(b);
            XSSFWorkbook wb = new XSSFWorkbook((InputStream)is);
            int numberOfSheets = wb.getNumberOfSheets();
            for (int i = 0; i < numberOfSheets; ++i) {
                XSSFSheet sheetAt = wb.getSheetAt(i);
                if (sheetAt == null) continue;
                sheets.add(sheetAt);
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        return sheets;
    }

    public static List<XSSFCell> getCell(byte[] b) {
        ArrayList<XSSFCell> cells = new ArrayList<XSSFCell>();
        try {
            List<XSSFSheet> sheets = ExcelUtil.getSheets(b);
            for (XSSFSheet sheet : sheets) {
                for (int rowNum = 0; rowNum <= sheet.getLastRowNum(); ++rowNum) {
                    XSSFRow row = sheet.getRow(rowNum);
                    if (row == null) continue;
                    for (int cellNum = 0; cellNum <= row.getLastCellNum(); ++cellNum) {
                        XSSFCell cell = row.getCell(cellNum);
                        if (cell == null) continue;
                        cells.add(cell);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return cells;
    }
}

