/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.perfweb.util;

import com.google.common.collect.Sets;
import com.kingdee.bos.Context;
import com.kingdee.shr.perfweb.bean.FileCheckStatement;
import com.kingdee.shr.perfweb.util.PerfConfigUtils;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSecUtil {
    private static Logger logger = LoggerFactory.getLogger(FileSecUtil.class);
    public static Set<String> whites = Sets.newHashSet((Object[])new String[]{"doc", "docx", "xlsx", "xls", "jpg", "jpeg", "png", "jpeg", "pdf", "zip"});
    public static int maxFileSize = 0xA00000;

    public static void checkFileBase(Context ctx, String fileName, String suffix, int fileSize, boolean fileNameIncludeSuffix) throws IOException {
        if (fileNameIncludeSuffix && fileName.contains(".")) {
            suffix = FileSecUtil.getSuffixByName(fileName);
        }
        if (StringUtils.isNotBlank((CharSequence)suffix)) {
            FileSecUtil.checkFileSuffix(ctx, suffix, true);
        }
        FileSecUtil.checkFileSize(ctx, fileSize);
        FileSecUtil.checkFileName(ctx, fileName, fileNameIncludeSuffix);
    }

    public static void checkFileSuffix(Context ctx, String suffix, boolean isSuffix) throws IOException {
        suffix = suffix.trim();
        if (!isSuffix && suffix.contains(".")) {
            suffix = suffix.substring(suffix.lastIndexOf(".") + 1, suffix.length());
            suffix = suffix.toLowerCase(Locale.ENGLISH);
        }
        if (!whites.contains(suffix)) {
            throw new IllegalArgumentException("PERFWEB_F_0021");
        }
    }

    public static void checkFileSuffix(Context ctx, File file) throws IOException {
        String fileName = file.getName();
        FileSecUtil.checkFileSuffix(ctx, fileName, false);
    }

    public static void checkFileSize(Context ctx, int fileSize) throws IOException {
        String uploadAttachSize = PerfConfigUtils.getConfigByName(ctx, "uploadAttachSize");
        try {
            int i = Double.valueOf(uploadAttachSize).intValue();
            if (i > 0) {
                maxFileSize = i * 1024 * 1024;
            }
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        if (fileSize > maxFileSize) {
            throw new IllegalArgumentException("PERFWEB_F_0022");
        }
    }

    public static void checkFileSize(Context ctx, File file) throws IOException {
    }

    public static void checkFileName(Context ctx, String fileName, boolean includeSuffix) throws PatternSyntaxException, IOException {
        Matcher m;
        String regEx = "['<>%\"\\/\u2018\u2019]";
        Pattern p = Pattern.compile(regEx);
        fileName = fileName.trim();
        if (includeSuffix && fileName.contains(".")) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        if ((m = p.matcher(fileName)).find()) {
            throw new IllegalArgumentException("PERFWEB_F_0023");
        }
    }

    public static void checkFileContent(Context ctx, File file, Set<FileCheckStatement> fileCheckStatements) throws IOException {
        String fileName = file.getName().trim();
        String suffix = "";
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".")) {
            suffix = FileSecUtil.getSuffixByName(fileName);
        }
        for (FileCheckStatement fileCheckStatement : fileCheckStatements) {
            if (!fileCheckStatement.checks.contains(suffix)) continue;
            fileCheckStatement.checkFile(file);
        }
    }

    public static void checkFileContent(Context ctx, String fileName, byte[] content, Set<FileCheckStatement> fileCheckStatements) throws IOException {
        String suffixByName = FileSecUtil.getSuffixByName(fileName);
        for (FileCheckStatement fileCheckStatement : fileCheckStatements) {
            if (!fileCheckStatement.checks.contains(suffixByName)) continue;
            fileCheckStatement.checkFile(fileName, content);
        }
    }

    public static String getSuffixByName(String fileName) {
        String suffix = "";
        if (StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".")) {
            suffix = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
            suffix = suffix.toLowerCase(Locale.ENGLISH);
        }
        return suffix;
    }
}

